/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.ext;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdScalarDeserializer;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.spi.FileSystemProvider;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;

public class NioPathDeserializer
extends StdScalarDeserializer<Path> {
    private static final long serialVersionUID = 1L;
    private static final boolean areWindowsFilePathsSupported;

    public NioPathDeserializer() {
        super(Path.class);
    }

    @Override
    public Path deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        URI uRI;
        if (!jsonParser.hasToken(JsonToken.VALUE_STRING)) {
            return (Path)deserializationContext.handleUnexpectedToken(Path.class, jsonParser);
        }
        String string = jsonParser.getText();
        if (string.indexOf(58) < 0) {
            return Paths.get(string, new String[0]);
        }
        if (areWindowsFilePathsSupported && string.length() >= 2 && Character.isLetter(string.charAt(0)) && string.charAt(1) == ':') {
            return Paths.get(string, new String[0]);
        }
        try {
            uRI = new URI(string);
        }
        catch (URISyntaxException uRISyntaxException) {
            return (Path)deserializationContext.handleInstantiationProblem(this.handledType(), string, uRISyntaxException);
        }
        try {
            return Paths.get(uRI);
        }
        catch (FileSystemNotFoundException fileSystemNotFoundException) {
            try {
                String string2 = uRI.getScheme();
                for (FileSystemProvider fileSystemProvider : ServiceLoader.load(FileSystemProvider.class)) {
                    if (!fileSystemProvider.getScheme().equalsIgnoreCase(string2)) continue;
                    return fileSystemProvider.getPath(uRI);
                }
                return (Path)deserializationContext.handleInstantiationProblem(this.handledType(), string, fileSystemNotFoundException);
            }
            catch (ServiceConfigurationError serviceConfigurationError) {
                serviceConfigurationError.addSuppressed(fileSystemNotFoundException);
                return (Path)deserializationContext.handleInstantiationProblem(this.handledType(), string, serviceConfigurationError);
            }
        }
        catch (Exception exception) {
            return (Path)deserializationContext.handleInstantiationProblem(this.handledType(), string, exception);
        }
    }

    static {
        boolean bl2 = false;
        for (File file : File.listRoots()) {
            String string = file.getPath();
            if (string.length() < 2 || !Character.isLetter(string.charAt(0)) || string.charAt(1) != ':') continue;
            bl2 = true;
            break;
        }
        areWindowsFilePathsSupported = bl2;
    }
}

