/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.core.io.doubleparser;

import com.fasterxml.jackson.core.io.doubleparser.AbstractFloatValueParser;
import com.fasterxml.jackson.core.io.doubleparser.FastDoubleSwar;

abstract class AbstractJavaFloatingPointBitsFromCharArray
extends AbstractFloatValueParser {
    private static final boolean CONDITIONAL_COMPILATION_PARSE_EIGHT_HEX_DIGITS = true;

    AbstractJavaFloatingPointBitsFromCharArray() {
    }

    private static int skipWhitespace(char[] cArray, int n2, int n3) {
        while (n2 < n3 && cArray[n2] <= ' ') {
            ++n2;
        }
        return n2;
    }

    abstract long nan();

    abstract long negativeInfinity();

    private long parseDecFloatLiteral(char[] cArray, int n2, int n3, int n4, boolean bl2, boolean bl3) {
        int n5;
        boolean bl4;
        int n6;
        int n7;
        long l2 = 0L;
        int n8 = n2;
        int n9 = -1;
        boolean bl5 = false;
        char c2 = '\u0000';
        int n10 = Math.min(n4 - 4, 0x40000000);
        while (n2 < n4) {
            c2 = cArray[n2];
            if (FastDoubleSwar.isDigit(c2)) {
                l2 = 10L * l2 + (long)c2 - 48L;
            } else {
                if (c2 != '.') break;
                bl5 |= n9 >= 0;
                n9 = n2;
                while (n2 < n10 && (n7 = FastDoubleSwar.tryToParseFourDigits(cArray, n2 + 1)) >= 0) {
                    l2 = 10000L * l2 + (long)n7;
                    n2 += 4;
                }
            }
            ++n2;
        }
        int n11 = n2;
        if (n9 < 0) {
            n7 = n11 - n8;
            n9 = n11;
            n6 = 0;
        } else {
            n7 = n11 - n8 - 1;
            n6 = n9 - n11 + 1;
        }
        int n12 = 0;
        if ((c2 | 0x20) == 101) {
            boolean bl6 = bl4 = (c2 = AbstractJavaFloatingPointBitsFromCharArray.charAt(cArray, ++n2, n4)) == '-';
            if (bl4 || c2 == '+') {
                c2 = AbstractJavaFloatingPointBitsFromCharArray.charAt(cArray, ++n2, n4);
            }
            bl5 |= !FastDoubleSwar.isDigit(c2);
            do {
                if (n12 >= 1024) continue;
                n12 = 10 * n12 + c2 - 48;
            } while (FastDoubleSwar.isDigit(c2 = AbstractJavaFloatingPointBitsFromCharArray.charAt(cArray, ++n2, n4)));
            if (bl4) {
                n12 = -n12;
            }
            n6 += n12;
        }
        if ((c2 | 0x22) == 102) {
            ++n2;
        }
        n2 = AbstractJavaFloatingPointBitsFromCharArray.skipWhitespace(cArray, n2, n4);
        if (bl5 || n2 < n4 || !bl3 && n7 == 0) {
            throw new NumberFormatException("illegal syntax");
        }
        int n13 = 0;
        if (n7 > 19) {
            l2 = 0L;
            for (n2 = n8; n2 < n11; ++n2) {
                c2 = cArray[n2];
                if (c2 == '.') {
                    ++n13;
                    continue;
                }
                if (Long.compareUnsigned(l2, 1000000000000000000L) >= 0) break;
                l2 = 10L * l2 + (long)c2 - 48L;
            }
            bl4 = n2 < n11;
            n5 = n9 - n2 + n13 + n12;
        } else {
            bl4 = false;
            n5 = 0;
        }
        return this.valueOfFloatLiteral(cArray, n3, n4, bl2, l2, n6, bl4, n5);
    }

    public long parseFloatingPointLiteral(char[] cArray, int n2, int n3) {
        boolean bl2;
        boolean bl3;
        int n4 = AbstractJavaFloatingPointBitsFromCharArray.checkBounds(cArray.length, n2, n3);
        int n5 = AbstractJavaFloatingPointBitsFromCharArray.skipWhitespace(cArray, n2, n4);
        if (n5 == n4) {
            throw new NumberFormatException("illegal syntax");
        }
        char c2 = cArray[n5];
        boolean bl4 = bl3 = c2 == '-';
        if ((bl3 || c2 == '+') && (c2 = AbstractJavaFloatingPointBitsFromCharArray.charAt(cArray, ++n5, n4)) == '\u0000') {
            throw new NumberFormatException("illegal syntax");
        }
        if (c2 >= 'I') {
            return this.parseNaNOrInfinity(cArray, n5, n4, bl3);
        }
        boolean bl5 = bl2 = c2 == '0';
        if (bl2 && ((c2 = AbstractJavaFloatingPointBitsFromCharArray.charAt(cArray, ++n5, n4)) | 0x20) == 120) {
            return this.parseHexFloatLiteral(cArray, n5 + 1, n2, n4, bl3);
        }
        return this.parseDecFloatLiteral(cArray, n5, n2, n4, bl3, bl2);
    }

    private long parseHexFloatLiteral(char[] cArray, int n2, int n3, int n4, boolean bl2) {
        boolean bl3;
        boolean bl4;
        int n5;
        int n6;
        long l2 = 0L;
        int n7 = 0;
        int n8 = n2;
        int n9 = -1;
        boolean bl5 = false;
        char c2 = '\u0000';
        while (n2 < n4) {
            c2 = cArray[n2];
            n6 = AbstractJavaFloatingPointBitsFromCharArray.lookupHex(c2);
            if (n6 >= 0) {
                l2 = l2 << 4 | (long)n6;
            } else {
                long l3;
                if (n6 != -4) break;
                bl5 |= n9 >= 0;
                n9 = n2;
                while (n2 < n4 - 8 && (l3 = this.tryToParseEightHexDigits(cArray, n2 + 1)) >= 0L) {
                    l2 = (l2 << 32) + l3;
                    n2 += 8;
                }
            }
            ++n2;
        }
        n6 = n2;
        if (n9 < 0) {
            n5 = n6 - n8;
            n9 = n6;
        } else {
            n5 = n6 - n8 - 1;
            n7 = Math.min(n9 - n2 + 1, 1024) * 4;
        }
        int n10 = 0;
        boolean bl6 = bl4 = (c2 | 0x20) == 112;
        if (bl4) {
            boolean bl7 = bl3 = (c2 = AbstractJavaFloatingPointBitsFromCharArray.charAt(cArray, ++n2, n4)) == '-';
            if (bl3 || c2 == '+') {
                c2 = AbstractJavaFloatingPointBitsFromCharArray.charAt(cArray, ++n2, n4);
            }
            bl5 |= !FastDoubleSwar.isDigit(c2);
            do {
                if (n10 >= 1024) continue;
                n10 = 10 * n10 + c2 - 48;
            } while (FastDoubleSwar.isDigit(c2 = AbstractJavaFloatingPointBitsFromCharArray.charAt(cArray, ++n2, n4)));
            if (bl3) {
                n10 = -n10;
            }
            n7 += n10;
        }
        if ((c2 | 0x22) == 102) {
            ++n2;
        }
        n2 = AbstractJavaFloatingPointBitsFromCharArray.skipWhitespace(cArray, n2, n4);
        if (bl5 || n2 < n4 || n5 == 0 || !bl4) {
            throw new NumberFormatException("illegal syntax");
        }
        int n11 = 0;
        if (n5 > 16) {
            l2 = 0L;
            for (n2 = n8; n2 < n6; ++n2) {
                c2 = cArray[n2];
                int n12 = AbstractJavaFloatingPointBitsFromCharArray.lookupHex(c2);
                if (n12 >= 0) {
                    if (Long.compareUnsigned(l2, 1000000000000000000L) >= 0) break;
                    l2 = l2 << 4 | (long)n12;
                    continue;
                }
                ++n11;
            }
            bl3 = n2 < n6;
        } else {
            bl3 = false;
        }
        return this.valueOfHexLiteral(cArray, n3, n4, bl2, l2, n7, bl3, (n9 - n2 + n11) * 4 + n10);
    }

    private long parseNaNOrInfinity(char[] cArray, int n2, int n3, boolean bl2) {
        if (cArray[n2] == 'N') {
            if (n2 + 2 < n3 && cArray[n2 + 1] == 'a' && cArray[n2 + 2] == 'N' && (n2 = AbstractJavaFloatingPointBitsFromCharArray.skipWhitespace(cArray, n2 + 3, n3)) == n3) {
                return this.nan();
            }
        } else if (n2 + 7 < n3 && cArray[n2] == 'I' && cArray[n2 + 1] == 'n' && cArray[n2 + 2] == 'f' && cArray[n2 + 3] == 'i' && cArray[n2 + 4] == 'n' && cArray[n2 + 5] == 'i' && cArray[n2 + 6] == 't' && cArray[n2 + 7] == 'y' && (n2 = AbstractJavaFloatingPointBitsFromCharArray.skipWhitespace(cArray, n2 + 8, n3)) == n3) {
            return bl2 ? this.negativeInfinity() : this.positiveInfinity();
        }
        throw new NumberFormatException("illegal syntax");
    }

    abstract long positiveInfinity();

    private long tryToParseEightHexDigits(char[] cArray, int n2) {
        return FastDoubleSwar.tryToParseEightHexDigits(cArray, n2);
    }

    abstract long valueOfFloatLiteral(char[] var1, int var2, int var3, boolean var4, long var5, int var7, boolean var8, int var9);

    abstract long valueOfHexLiteral(char[] var1, int var2, int var3, boolean var4, long var5, int var7, boolean var8, int var9);
}

