/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.core;

import com.fasterxml.jackson.core.ErrorReportConfiguration;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.StreamReadConstraints;
import com.fasterxml.jackson.core.StreamReadFeature;
import com.fasterxml.jackson.core.StreamWriteConstraints;
import com.fasterxml.jackson.core.StreamWriteFeature;
import com.fasterxml.jackson.core.io.InputDecorator;
import com.fasterxml.jackson.core.io.OutputDecorator;
import com.fasterxml.jackson.core.json.JsonReadFeature;
import com.fasterxml.jackson.core.json.JsonWriteFeature;
import com.fasterxml.jackson.core.util.BufferRecycler;
import com.fasterxml.jackson.core.util.JsonGeneratorDecorator;
import com.fasterxml.jackson.core.util.JsonRecyclerPools;
import com.fasterxml.jackson.core.util.RecyclerPool;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public abstract class TSFBuilder<F extends JsonFactory, B extends TSFBuilder<F, B>> {
    protected static final int DEFAULT_FACTORY_FEATURE_FLAGS = JsonFactory.Feature.collectDefaults();
    protected static final int DEFAULT_PARSER_FEATURE_FLAGS = JsonParser.Feature.collectDefaults();
    protected static final int DEFAULT_GENERATOR_FEATURE_FLAGS = JsonGenerator.Feature.collectDefaults();
    protected int _factoryFeatures;
    protected int _streamReadFeatures;
    protected int _streamWriteFeatures;
    protected RecyclerPool<BufferRecycler> _recyclerPool = JsonRecyclerPools.defaultPool();
    protected InputDecorator _inputDecorator;
    protected OutputDecorator _outputDecorator;
    protected StreamReadConstraints _streamReadConstraints;
    protected StreamWriteConstraints _streamWriteConstraints;
    protected ErrorReportConfiguration _errorReportConfiguration;
    protected List<JsonGeneratorDecorator> _generatorDecorators;

    protected TSFBuilder() {
        this(DEFAULT_FACTORY_FEATURE_FLAGS, DEFAULT_PARSER_FEATURE_FLAGS, DEFAULT_GENERATOR_FEATURE_FLAGS);
    }

    protected TSFBuilder(JsonFactory jsonFactory) {
        this(jsonFactory._factoryFeatures, jsonFactory._parserFeatures, jsonFactory._generatorFeatures);
        this._inputDecorator = jsonFactory._inputDecorator;
        this._outputDecorator = jsonFactory._outputDecorator;
        this._streamReadConstraints = jsonFactory._streamReadConstraints;
        this._streamWriteConstraints = jsonFactory._streamWriteConstraints;
        this._errorReportConfiguration = jsonFactory._errorReportConfiguration;
        this._generatorDecorators = TSFBuilder._copy(jsonFactory._generatorDecorators);
    }

    protected TSFBuilder(int n2, int n3, int n4) {
        this._factoryFeatures = n2;
        this._streamReadFeatures = n3;
        this._streamWriteFeatures = n4;
        this._inputDecorator = null;
        this._outputDecorator = null;
        this._streamReadConstraints = StreamReadConstraints.defaults();
        this._streamWriteConstraints = StreamWriteConstraints.defaults();
        this._errorReportConfiguration = ErrorReportConfiguration.defaults();
        this._generatorDecorators = null;
    }

    protected static <T> List<T> _copy(List<T> list) {
        if (list == null) {
            return list;
        }
        return new ArrayList<T>(list);
    }

    public int factoryFeaturesMask() {
        return this._factoryFeatures;
    }

    public int streamReadFeatures() {
        return this._streamReadFeatures;
    }

    public int streamWriteFeatures() {
        return this._streamWriteFeatures;
    }

    public RecyclerPool<BufferRecycler> recyclerPool() {
        return this._recyclerPool;
    }

    public InputDecorator inputDecorator() {
        return this._inputDecorator;
    }

    public OutputDecorator outputDecorator() {
        return this._outputDecorator;
    }

    public B enable(JsonFactory.Feature feature) {
        this._factoryFeatures |= feature.getMask();
        return this._this();
    }

    public B disable(JsonFactory.Feature feature) {
        this._factoryFeatures &= ~feature.getMask();
        return this._this();
    }

    public B configure(JsonFactory.Feature feature, boolean bl2) {
        return bl2 ? this.enable(feature) : this.disable(feature);
    }

    public B enable(StreamReadFeature streamReadFeature) {
        this._streamReadFeatures |= streamReadFeature.mappedFeature().getMask();
        return this._this();
    }

    public B enable(StreamReadFeature streamReadFeature, StreamReadFeature ... streamReadFeatureArray) {
        this._streamReadFeatures |= streamReadFeature.mappedFeature().getMask();
        for (StreamReadFeature streamReadFeature2 : streamReadFeatureArray) {
            this._streamReadFeatures |= streamReadFeature2.mappedFeature().getMask();
        }
        return this._this();
    }

    public B disable(StreamReadFeature streamReadFeature) {
        this._streamReadFeatures &= ~streamReadFeature.mappedFeature().getMask();
        return this._this();
    }

    public B disable(StreamReadFeature streamReadFeature, StreamReadFeature ... streamReadFeatureArray) {
        this._streamReadFeatures &= ~streamReadFeature.mappedFeature().getMask();
        for (StreamReadFeature streamReadFeature2 : streamReadFeatureArray) {
            this._streamReadFeatures &= ~streamReadFeature2.mappedFeature().getMask();
        }
        return this._this();
    }

    public B configure(StreamReadFeature streamReadFeature, boolean bl2) {
        return bl2 ? this.enable(streamReadFeature) : this.disable(streamReadFeature);
    }

    public B enable(StreamWriteFeature streamWriteFeature) {
        this._streamWriteFeatures |= streamWriteFeature.mappedFeature().getMask();
        return this._this();
    }

    public B enable(StreamWriteFeature streamWriteFeature, StreamWriteFeature ... streamWriteFeatureArray) {
        this._streamWriteFeatures |= streamWriteFeature.mappedFeature().getMask();
        for (StreamWriteFeature streamWriteFeature2 : streamWriteFeatureArray) {
            this._streamWriteFeatures |= streamWriteFeature2.mappedFeature().getMask();
        }
        return this._this();
    }

    public B disable(StreamWriteFeature streamWriteFeature) {
        this._streamWriteFeatures &= ~streamWriteFeature.mappedFeature().getMask();
        return this._this();
    }

    public B disable(StreamWriteFeature streamWriteFeature, StreamWriteFeature ... streamWriteFeatureArray) {
        this._streamWriteFeatures &= ~streamWriteFeature.mappedFeature().getMask();
        for (StreamWriteFeature streamWriteFeature2 : streamWriteFeatureArray) {
            this._streamWriteFeatures &= ~streamWriteFeature2.mappedFeature().getMask();
        }
        return this._this();
    }

    public B configure(StreamWriteFeature streamWriteFeature, boolean bl2) {
        return bl2 ? this.enable(streamWriteFeature) : this.disable(streamWriteFeature);
    }

    public B enable(JsonReadFeature jsonReadFeature) {
        return this._failNonJSON(jsonReadFeature);
    }

    public B enable(JsonReadFeature jsonReadFeature, JsonReadFeature ... jsonReadFeatureArray) {
        return this._failNonJSON(jsonReadFeature);
    }

    public B disable(JsonReadFeature jsonReadFeature) {
        return this._failNonJSON(jsonReadFeature);
    }

    public B disable(JsonReadFeature jsonReadFeature, JsonReadFeature ... jsonReadFeatureArray) {
        return this._failNonJSON(jsonReadFeature);
    }

    public B configure(JsonReadFeature jsonReadFeature, boolean bl2) {
        return this._failNonJSON(jsonReadFeature);
    }

    private B _failNonJSON(Object object) {
        throw new IllegalArgumentException("Feature " + object.getClass().getName() + "#" + object.toString() + " not supported for non-JSON backend");
    }

    public B enable(JsonWriteFeature jsonWriteFeature) {
        return this._failNonJSON(jsonWriteFeature);
    }

    public B enable(JsonWriteFeature jsonWriteFeature, JsonWriteFeature ... jsonWriteFeatureArray) {
        return this._failNonJSON(jsonWriteFeature);
    }

    public B disable(JsonWriteFeature jsonWriteFeature) {
        return this._failNonJSON(jsonWriteFeature);
    }

    public B disable(JsonWriteFeature jsonWriteFeature, JsonWriteFeature ... jsonWriteFeatureArray) {
        return this._failNonJSON(jsonWriteFeature);
    }

    public B configure(JsonWriteFeature jsonWriteFeature, boolean bl2) {
        return this._failNonJSON(jsonWriteFeature);
    }

    public B recyclerPool(RecyclerPool<BufferRecycler> recyclerPool) {
        this._recyclerPool = Objects.requireNonNull(recyclerPool);
        return this._this();
    }

    public B inputDecorator(InputDecorator inputDecorator) {
        this._inputDecorator = inputDecorator;
        return this._this();
    }

    public B outputDecorator(OutputDecorator outputDecorator) {
        this._outputDecorator = outputDecorator;
        return this._this();
    }

    public B addDecorator(JsonGeneratorDecorator jsonGeneratorDecorator) {
        if (this._generatorDecorators == null) {
            this._generatorDecorators = new ArrayList<JsonGeneratorDecorator>();
        }
        this._generatorDecorators.add(jsonGeneratorDecorator);
        return this._this();
    }

    public B streamReadConstraints(StreamReadConstraints streamReadConstraints) {
        this._streamReadConstraints = Objects.requireNonNull(streamReadConstraints);
        return this._this();
    }

    public B streamWriteConstraints(StreamWriteConstraints streamWriteConstraints) {
        this._streamWriteConstraints = Objects.requireNonNull(streamWriteConstraints);
        return this._this();
    }

    public B errorReportConfiguration(ErrorReportConfiguration errorReportConfiguration) {
        this._errorReportConfiguration = Objects.requireNonNull(errorReportConfiguration);
        return this._this();
    }

    public abstract F build();

    protected final B _this() {
        return (B)this;
    }

    protected void _legacyEnable(JsonParser.Feature feature) {
        if (feature != null) {
            this._streamReadFeatures |= feature.getMask();
        }
    }

    protected void _legacyDisable(JsonParser.Feature feature) {
        if (feature != null) {
            this._streamReadFeatures &= ~feature.getMask();
        }
    }

    protected void _legacyEnable(JsonGenerator.Feature feature) {
        if (feature != null) {
            this._streamWriteFeatures |= feature.getMask();
        }
    }

    protected void _legacyDisable(JsonGenerator.Feature feature) {
        if (feature != null) {
            this._streamWriteFeatures &= ~feature.getMask();
        }
    }
}

