/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.core;

import com.fasterxml.jackson.core.exc.StreamConstraintsException;
import java.io.Serializable;

public class StreamReadConstraints
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int DEFAULT_MAX_DEPTH = 1000;
    public static final long DEFAULT_MAX_DOC_LEN = -1L;
    public static final int DEFAULT_MAX_NUM_LEN = 1000;
    public static final int DEFAULT_MAX_STRING_LEN = 20000000;
    public static final int DEFAULT_MAX_NAME_LEN = 50000;
    private static final int MAX_BIGINT_SCALE_MAGNITUDE = 100000;
    protected final int _maxNestingDepth;
    protected final long _maxDocLen;
    protected final int _maxNumLen;
    protected final int _maxStringLen;
    protected final int _maxNameLen;
    private static StreamReadConstraints DEFAULT = new StreamReadConstraints(1000, -1L, 1000, 20000000, 50000);

    public static void overrideDefaultStreamReadConstraints(StreamReadConstraints streamReadConstraints) {
        DEFAULT = streamReadConstraints == null ? new StreamReadConstraints(1000, -1L, 1000, 20000000) : streamReadConstraints;
    }

    @Deprecated
    protected StreamReadConstraints(int n2, long l2, int n3, int n4) {
        this(n2, -1L, n3, n4, 50000);
    }

    protected StreamReadConstraints(int n2, long l2, int n3, int n4, int n5) {
        this._maxNestingDepth = n2;
        this._maxDocLen = l2;
        this._maxNumLen = n3;
        this._maxStringLen = n4;
        this._maxNameLen = n5;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static StreamReadConstraints defaults() {
        return DEFAULT;
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    public int getMaxNestingDepth() {
        return this._maxNestingDepth;
    }

    public long getMaxDocumentLength() {
        return this._maxDocLen;
    }

    public boolean hasMaxDocumentLength() {
        return this._maxDocLen > 0L;
    }

    public int getMaxNumberLength() {
        return this._maxNumLen;
    }

    public int getMaxStringLength() {
        return this._maxStringLen;
    }

    public int getMaxNameLength() {
        return this._maxNameLen;
    }

    public void validateNestingDepth(int n2) throws StreamConstraintsException {
        if (n2 > this._maxNestingDepth) {
            throw this._constructException("Document nesting depth (%d) exceeds the maximum allowed (%d, from %s)", n2, this._maxNestingDepth, this._constrainRef("getMaxNestingDepth"));
        }
    }

    public void validateDocumentLength(long l2) throws StreamConstraintsException {
        if (l2 > this._maxDocLen && this._maxDocLen > 0L) {
            throw this._constructException("Document length (%d) exceeds the maximum allowed (%d, from %s)", l2, this._maxDocLen, this._constrainRef("getMaxDocumentLength"));
        }
    }

    public void validateFPLength(int n2) throws StreamConstraintsException {
        if (n2 > this._maxNumLen) {
            throw this._constructException("Number value length (%d) exceeds the maximum allowed (%d, from %s)", n2, this._maxNumLen, this._constrainRef("getMaxNumberLength"));
        }
    }

    public void validateIntegerLength(int n2) throws StreamConstraintsException {
        if (n2 > this._maxNumLen) {
            throw this._constructException("Number value length (%d) exceeds the maximum allowed (%d, from %s)", n2, this._maxNumLen, this._constrainRef("getMaxNumberLength"));
        }
    }

    public void validateStringLength(int n2) throws StreamConstraintsException {
        if (n2 > this._maxStringLen) {
            throw this._constructException("String value length (%d) exceeds the maximum allowed (%d, from %s)", n2, this._maxStringLen, this._constrainRef("getMaxStringLength"));
        }
    }

    public void validateNameLength(int n2) throws StreamConstraintsException {
        if (n2 > this._maxNameLen) {
            throw this._constructException("Name length (%d) exceeds the maximum allowed (%d, from %s)", n2, this._maxNameLen, this._constrainRef("getMaxNameLength"));
        }
    }

    public void validateBigIntegerScale(int n2) throws StreamConstraintsException {
        int n3 = Math.abs(n2);
        int n4 = 100000;
        if (n3 > 100000) {
            throw this._constructException("BigDecimal scale (%d) magnitude exceeds the maximum allowed (%d)", n2, 100000);
        }
    }

    protected StreamConstraintsException _constructException(String string, Object ... objectArray) throws StreamConstraintsException {
        throw new StreamConstraintsException(String.format(string, objectArray));
    }

    protected String _constrainRef(String string) {
        return "`StreamReadConstraints." + string + "()`";
    }

    public static final class Builder {
        private long maxDocLen;
        private int maxNestingDepth;
        private int maxNumLen;
        private int maxStringLen;
        private int maxNameLen;

        public Builder maxNestingDepth(int n2) {
            if (n2 < 0) {
                throw new IllegalArgumentException("Cannot set maxNestingDepth to a negative value");
            }
            this.maxNestingDepth = n2;
            return this;
        }

        public Builder maxDocumentLength(long l2) {
            if (l2 <= 0L) {
                l2 = -1L;
            }
            this.maxDocLen = l2;
            return this;
        }

        public Builder maxNumberLength(int n2) {
            if (n2 < 0) {
                throw new IllegalArgumentException("Cannot set maxNumberLength to a negative value");
            }
            this.maxNumLen = n2;
            return this;
        }

        public Builder maxStringLength(int n2) {
            if (n2 < 0) {
                throw new IllegalArgumentException("Cannot set maxStringLen to a negative value");
            }
            this.maxStringLen = n2;
            return this;
        }

        public Builder maxNameLength(int n2) {
            if (n2 < 0) {
                throw new IllegalArgumentException("Cannot set maxNameLen to a negative value");
            }
            this.maxNameLen = n2;
            return this;
        }

        Builder() {
            this(1000, -1L, 1000, 20000000, 50000);
        }

        Builder(int n2, long l2, int n3, int n4, int n5) {
            this.maxNestingDepth = n2;
            this.maxDocLen = l2;
            this.maxNumLen = n3;
            this.maxStringLen = n4;
            this.maxNameLen = n5;
        }

        Builder(StreamReadConstraints streamReadConstraints) {
            this.maxNestingDepth = streamReadConstraints._maxNestingDepth;
            this.maxDocLen = streamReadConstraints._maxDocLen;
            this.maxNumLen = streamReadConstraints._maxNumLen;
            this.maxStringLen = streamReadConstraints._maxStringLen;
            this.maxNameLen = streamReadConstraints._maxNameLen;
        }

        public StreamReadConstraints build() {
            return new StreamReadConstraints(this.maxNestingDepth, this.maxDocLen, this.maxNumLen, this.maxStringLen, this.maxNameLen);
        }
    }
}

