/*
 * Decompiled with CFR 0.152.
 */
package ar.com.hjg.pngj.chunks;

import ar.com.hjg.pngj.PngHelperInternal;
import ar.com.hjg.pngj.PngjBadCrcException;
import ar.com.hjg.pngj.PngjException;
import ar.com.hjg.pngj.PngjOutputException;
import ar.com.hjg.pngj.chunks.ChunkHelper;
import java.io.ByteArrayInputStream;
import java.io.OutputStream;
import java.util.zip.CRC32;

public class ChunkRaw {
    public final int len;
    public final byte[] idbytes;
    public final String id;
    public byte[] data = null;
    private long offset = 0L;
    public byte[] crcval = new byte[4];
    private CRC32 crcengine;

    public ChunkRaw(int n2, String string, boolean bl2) {
        this.len = n2;
        this.id = string;
        this.idbytes = ChunkHelper.toBytes(string);
        for (int i2 = 0; i2 < 4; ++i2) {
            if (this.idbytes[i2] >= 65 && this.idbytes[i2] <= 122 && (this.idbytes[i2] <= 90 || this.idbytes[i2] >= 97)) continue;
            throw new PngjException("Bad id chunk: must be ascii letters " + string);
        }
        if (bl2) {
            this.allocData();
        }
    }

    public ChunkRaw(int n2, byte[] byArray, boolean bl2) {
        this(n2, ChunkHelper.toString(byArray), bl2);
    }

    public void allocData() {
        if (this.data == null || this.data.length < this.len) {
            this.data = new byte[this.len];
        }
    }

    private void computeCrcForWriting() {
        this.crcengine = new CRC32();
        this.crcengine.update(this.idbytes, 0, 4);
        if (this.len > 0) {
            this.crcengine.update(this.data, 0, this.len);
        }
        PngHelperInternal.writeInt4tobytes((int)this.crcengine.getValue(), this.crcval, 0);
    }

    public void writeChunk(OutputStream outputStream) {
        this.writeChunkHeader(outputStream);
        if (this.len > 0) {
            if (this.data == null) {
                throw new PngjOutputException("cannot write chunk, raw chunk data is null [" + this.id + "]");
            }
            PngHelperInternal.writeBytes(outputStream, this.data, 0, this.len);
        }
        this.computeCrcForWriting();
        this.writeChunkCrc(outputStream);
    }

    public void writeChunkHeader(OutputStream outputStream) {
        if (this.idbytes.length != 4) {
            throw new PngjOutputException("bad chunkid [" + this.id + "]");
        }
        PngHelperInternal.writeInt4(outputStream, this.len);
        PngHelperInternal.writeBytes(outputStream, this.idbytes);
    }

    public void writeChunkCrc(OutputStream outputStream) {
        PngHelperInternal.writeBytes(outputStream, this.crcval, 0, 4);
    }

    public void checkCrc() {
        int n2;
        int n3 = (int)this.crcengine.getValue();
        if (n3 != (n2 = PngHelperInternal.readInt4fromBytes(this.crcval, 0))) {
            throw new PngjBadCrcException("chunk: " + this.toString() + " expected=" + n2 + " read=" + n3);
        }
    }

    public void updateCrc(byte[] byArray, int n2, int n3) {
        if (this.crcengine == null) {
            this.crcengine = new CRC32();
        }
        this.crcengine.update(byArray, n2, n3);
    }

    ByteArrayInputStream getAsByteStream() {
        return new ByteArrayInputStream(this.data);
    }

    public long getOffset() {
        return this.offset;
    }

    public void setOffset(long l2) {
        this.offset = l2;
    }

    public String toString() {
        return "chunkid=" + ChunkHelper.toString(this.idbytes) + " len=" + this.len;
    }

    public int hashCode() {
        int n2 = 31;
        int n3 = 1;
        n3 = 31 * n3 + (this.id == null ? 0 : this.id.hashCode());
        n3 = 31 * n3 + (int)(this.offset ^ this.offset >>> 32);
        return n3;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ChunkRaw chunkRaw = (ChunkRaw)object;
        if (this.id == null ? chunkRaw.id != null : !this.id.equals(chunkRaw.id)) {
            return false;
        }
        return this.offset == chunkRaw.offset;
    }
}

