/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.gui.views.teachrepeat.state;

import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import lombok.Generated;
import us.hebi.gui.lib.bfy;
import us.hebi.gui.lib.bhm;
import us.hebi.gui.lib.bie;
import us.hebi.gui.views.teachrepeat.state.ForwardKinematicsSampler$CartesianConsumer;
import us.hebi.gui.views.teachrepeat.state.ForwardKinematicsSampler$CartesianConsumerFloat;
import us.hebi.gui.views.teachrepeat.state.TrajectorySampler;

public class ForwardKinematicsSampler {
    protected double[] time = new double[0];
    protected double[] x = new double[0];
    protected double[] y = new double[0];
    protected double[] z = new double[0];
    private final bfy T = bfy.d();
    int numSamples = 0;
    private final ObjectProperty<bhm> forwardKinematics = new SimpleObjectProperty();
    protected final TrajectorySampler jointSampler;

    public static ForwardKinematicsSampler createContinuous(int n2) {
        return new ForwardKinematicsSampler(TrajectorySampler.createContinuous(n2));
    }

    public static ForwardKinematicsSampler createKeyFrame() {
        return new ForwardKinematicsSampler(TrajectorySampler.createKeyFrame());
    }

    private ForwardKinematicsSampler(TrajectorySampler trajectorySampler) {
        this.jointSampler = trajectorySampler;
    }

    public int getNumSamples() {
        return this.numSamples;
    }

    public void forEachCartesianSample(ForwardKinematicsSampler$CartesianConsumer forwardKinematicsSampler$CartesianConsumer) {
        for (int i2 = 0; i2 < this.numSamples; ++i2) {
            forwardKinematicsSampler$CartesianConsumer.accept(i2, this.time[i2], this.x[i2], this.y[i2], this.z[i2]);
        }
    }

    public void forEachCartesianSampleScaled(double d2, ForwardKinematicsSampler$CartesianConsumerFloat forwardKinematicsSampler$CartesianConsumerFloat) {
        for (int i2 = 0; i2 < this.numSamples; ++i2) {
            forwardKinematicsSampler$CartesianConsumerFloat.accept(i2, this.time[i2], (float)(this.x[i2] * d2), (float)(this.y[i2] * d2), (float)(this.z[i2] * d2));
        }
    }

    public void clear() {
        this.numSamples = 0;
        this.jointSampler.clear();
    }

    public void setTrajectory(bie bie2) {
        this.jointSampler.setTrajectory(bie2);
        bhm bhm2 = (bhm)this.forwardKinematics.get();
        if (this.jointSampler.getNumJoints() != bhm2.c.numJoints) {
            this.numSamples = 0;
            return;
        }
        this.numSamples = this.jointSampler.getNumSamples();
        if (this.time.length < this.numSamples) {
            this.time = new double[this.numSamples];
            this.x = new double[this.numSamples];
            this.y = new double[this.numSamples];
            this.z = new double[this.numSamples];
        }
        this.jointSampler.forEachGroupSample((n2, d2, dArray, dArray2, dArray3) -> {
            bhm2.a(dArray, this.T);
            this.time[n2] = d2;
            this.x[n2] = this.T.ea;
            this.y[n2] = this.T.ec;
            this.z[n2] = this.T.eg;
        });
    }

    public ObjectProperty<bhm> forwardKinematicsProperty() {
        return this.forwardKinematics;
    }

    @Generated
    public double[] getTime() {
        return this.time;
    }

    @Generated
    public double[] getX() {
        return this.x;
    }

    @Generated
    public double[] getY() {
        return this.y;
    }

    @Generated
    public double[] getZ() {
        return this.z;
    }

    @Generated
    public TrajectorySampler getJointSampler() {
        return this.jointSampler;
    }
}

