/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.gui.views.teachrepeat;

import io.fair_acc.chartfx.XYChart;
import io.fair_acc.chartfx.plugins.XValueIndicator;
import io.fair_acc.chartfx.renderer.Renderer;
import io.fair_acc.chartfx.ui.css.DataSetNode;
import io.fair_acc.dataset.DataSet;
import io.fair_acc.dataset.utils.DataSetStyleBuilder;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ListView;
import javafx.scene.control.ScrollPane;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.stage.Window;
import javax.inject.Inject;
import lombok.Generated;
import us.hebi.gui.lib.ae;
import us.hebi.gui.lib.aqy;
import us.hebi.gui.lib.ave;
import us.hebi.gui.lib.avf;
import us.hebi.gui.lib.avh;
import us.hebi.gui.lib.avl;
import us.hebi.gui.lib.avs;
import us.hebi.gui.lib.avy;
import us.hebi.gui.lib.ayn;
import us.hebi.gui.lib.azj;
import us.hebi.gui.lib.azk;
import us.hebi.gui.lib.azr;
import us.hebi.gui.lib.bak;
import us.hebi.gui.lib.bcn;
import us.hebi.gui.lib.bdc;
import us.hebi.gui.lib.bfd;
import us.hebi.gui.lib.bfw;
import us.hebi.gui.lib.bfx;
import us.hebi.gui.lib.bfy;
import us.hebi.gui.lib.bgg;
import us.hebi.gui.lib.bhm;
import us.hebi.gui.lib.bhs;
import us.hebi.gui.lib.bht;
import us.hebi.gui.lib.bhv;
import us.hebi.gui.lib.bhw;
import us.hebi.gui.lib.bhx;
import us.hebi.gui.lib.bhy;
import us.hebi.gui.lib.bia;
import us.hebi.gui.lib.bip;
import us.hebi.gui.lib.bix;
import us.hebi.gui.lib.blm;
import us.hebi.gui.lib.kq;
import us.hebi.gui.views.scope.assets.Asset;
import us.hebi.gui.views.teachrepeat.state.ForwardKinematicsSampler;
import us.hebi.gui.views.teachrepeat.state.PickableWaypoints3D;
import us.hebi.gui.views.teachrepeat.state.TrajectorySampler;
import us.hebi.gui.views.teachrepeat.state.UpdatableGroupTrajectory;
import us.hebi.gui.views.teachrepeat.state.Waypoint;
import us.hebi.gui.views.teachrepeat.state.WaypointDataSet;
import us.hebi.gui.views.teachrepeat.state.WaypointDataSetRenderer;
import us.hebi.gui.views.teachrepeat.state.WaypointList;

public class TeachRepeatPresenter
extends bcn {
    @FXML
    Pane root;
    @FXML
    Pane menuPane;
    @FXML
    ScrollPane waypointPane;
    @FXML
    ListView<Waypoint> waypointListView;
    @FXML
    Pane pane3d;
    @FXML
    Pane pane2d;
    @FXML
    Pane ikPane;
    @FXML
    private Button ikIncreaseX;
    @FXML
    private Button ikDecreaseX;
    @FXML
    private Button ikIncreaseY;
    @FXML
    private Button ikDecreaseY;
    @FXML
    private Button ikIncreaseZ;
    @FXML
    private Button ikDecreaseZ;
    final avl xyzLine = new avl().a(true);
    final PickableWaypoints3D xyzWaypoints = new PickableWaypoints3D();
    XYChart jointPosChart;
    private static final double LINEAR_INTERP_DISTANCE = ((aqy)aqy.a).e(25.0);
    List<XValueIndicator> timeIndicators = new ArrayList<XValueIndicator>();
    ObjectProperty<Waypoint> selectedWaypoint = new SimpleObjectProperty((Object)Waypoint.newMove(0));
    public DoubleProperty selectedTime = new SimpleDoubleProperty(0.0);
    @Inject
    ave robotModel;
    @Inject
    ayn fileChooser;
    @Inject
    WaypointList waypoints;
    @Inject
    UpdatableGroupTrajectory groupTrajectory;
    static final int maxSamples2d = 1000;
    final ForwardKinematicsSampler cartesianSamplesCont = ForwardKinematicsSampler.createContinuous(1000);
    final ForwardKinematicsSampler cartesianSamplesKey = ForwardKinematicsSampler.createKeyFrame();
    final azj colorIndex = new azj();
    final double len = 100.0;
    final Node worldFrame = avs.a(100.0, 3.0, 10);
    final Node cubeWorld = new avh(2000.0).a();
    final avy worldScene = new avy(new Node[0]);

    @FXML
    public void selectHrdf(ActionEvent actionEvent) {
        Window window;
        File file;
        if (bdc.aG()) {
            Asset.loadCommonAssets();
        }
        if ((file = this.fileChooser.b(window = bdc.a(actionEvent))) == null) {
            return;
        }
        File file2 = file;
        this.robotModel.h.set((Object)file2);
    }

    public void updateCharts2d() {
        int n2 = this.waypoints.getNumJoints();
        Renderer renderer = (Renderer)this.jointPosChart.getRenderers().get(0);
        String string = DataSetStyleBuilder.instance().setMarkerSize(4.0).build();
        Renderer renderer2 = (Renderer)this.jointPosChart.getRenderers().get(1);
        renderer2.setShowInLegend(false);
        if (n2 != renderer.getDatasets().size()) {
            renderer.getDatasets().clear();
            renderer2.getDatasets().clear();
            for (int i2 = 0; i2 < n2; ++i2) {
                bfd bfd2 = new bfd(this, i2);
                DataSetNode dataSetNode = renderer.addDataSet(bfd2.setStyle(string));
                renderer2.addDataSet(new bak(bfd2.getName())).visibleProperty().bind((ObservableValue)dataSetNode.visibleProperty());
            }
        }
        Object object = renderer.getDatasets().iterator();
        while (object.hasNext()) {
            ((WaypointDataSet)((DataSet)object.next())).setWaypoints((List<Waypoint>)this.waypoints.getList(), this.groupTrajectory);
        }
        if (!this.groupTrajectory.isValid()) {
            return;
        }
        object = this.cartesianSamplesCont.getJointSampler();
        for (int i3 = 0; i3 < n2; ++i3) {
            ((bak)renderer2.getDatasets().get(i3)).b(((TrajectorySampler)object).getTime(), ((TrajectorySampler)object).getJointPosition(i3), ((TrajectorySampler)object).getNumSamples());
        }
    }

    public void updateLine3d() {
        if (!this.groupTrajectory.isValid()) {
            return;
        }
        this.colorIndex.t = 0;
        Color color = (Color)azj.a(this.colorIndex.t++).get();
        this.xyzLine.setColor(color);
        this.xyzLine.aR();
        this.cartesianSamplesCont.forEachCartesianSampleScaled(1000.0, (n2, d2, f2, f3, f4) -> {
            if (n2 == 0) {
                this.xyzLine.b(f2, f3, f4);
                this.xyzLine.aS();
                return;
            }
            this.xyzLine.c(f2, f3, f4);
        });
        this.xyzLine.aT();
    }

    public void updateRobotPosition() {
        if (this.groupTrajectory.isValid()) {
            double[] dArray;
            double[] dArray2;
            double d2 = this.selectedTime.get();
            double[] dArray3 = dArray2 = (dArray = this.groupTrajectory.getState(d2).getPosition());
            avf avf2 = (avf)this.robotModel.l.get();
            for (int i2 = 0; i2 < Math.min(dArray3.length, avf2.N.size()); ++i2) {
                avf2.b(i2, dArray3[i2]);
            }
        }
    }

    public void updateTimeIndicators() {
    }

    protected void onUpdate(List<Waypoint> list) {
        this.groupTrajectory.setWaypoints(list);
        if (this.groupTrajectory.isValid()) {
            this.cartesianSamplesKey.setTrajectory(this.groupTrajectory);
            this.cartesianSamplesCont.setTrajectory(this.groupTrajectory);
        } else {
            this.cartesianSamplesKey.clear();
            this.cartesianSamplesCont.clear();
        }
        this.updateCharts2d();
        this.xyzWaypoints.update(this.cartesianSamplesKey);
        this.updateLine3d();
        this.updateRobotPosition();
    }

    @Override
    public void initializeFx() {
        this.worldScene.a(this.pane3d);
        this.worldScene.a.a.setTranslateZ(-800.0);
        this.worldScene.f.getChildren().add(1, (Object)this.robotModel.b);
        this.worldScene.f.getChildren().setAll((Object[])new Node[]{this.robotModel.b, this.xyzWaypoints, this.xyzLine.e, this.worldFrame, this.cubeWorld});
        this.pane3d.visibleProperty().bind((ObservableValue)this.robotModel.cV);
        this.pane3d.managedProperty().bind((ObservableValue)this.pane3d.visibleProperty());
        this.ikPane.visibleProperty().bind((ObservableValue)this.robotModel.cV.and((ObservableBooleanValue)this.selectedWaypoint.isNotNull()));
        this.ikPane.managedProperty().bind((ObservableValue)this.ikPane.visibleProperty());
        this.xyzWaypoints.pickedIndexProperty().bind((ObservableValue)this.waypointListView.getSelectionModel().selectedIndexProperty());
        this.worldScene.f.setOnMouseClicked(this.xyzWaypoints.getPickHandler(n2 -> this.waypointListView.getSelectionModel().select(n2)));
        this.cartesianSamplesCont.forwardKinematicsProperty().bind(this.robotModel.j);
        this.cartesianSamplesKey.forwardKinematicsProperty().bind(this.robotModel.j);
        this.waypoints.addOnUpdate(this::onUpdate);
        this.selectedTime.addListener(observable -> this.updateRobotPosition());
        this.robotModel.j.addListener((observableValue, bhm2, bhm3) -> this.waypoints.setDirty());
        this.waypoints.numWaypointsProperty().addListener(observable -> this.updateTimeIndicators());
        this.jointPosChart = azk.a(-1.0, 1.0, "rad/s");
        this.pane2d.getChildren().setAll((Object[])new Node[]{this.jointPosChart});
        bdc.c(this.jointPosChart);
        this.waypoints.add(Waypoint.newMove(6).setTime(0.0).setPositions(1.39582300186157, 1.08106410503387, 1.65824282169342, 7.68387192884554, 2.54659485816956, 9.45026928583254));
        this.waypoints.add(Waypoint.newMove(6).setTime(1.0).setPositions(0.316830635070801, 1.1332973241806, 1.34299612045288, 8.07372874418368, 0.685708403587341, 9.29459578195681));
        this.waypoints.add(Waypoint.newStop(6).setTime(2.0).setPositions(1.07498550415039, 1.01677846908569, 1.89047479629517, 6.96188486019243, 2.57030248641968, 9.301078144704));
        this.waypoints.add(Waypoint.newMove(6).setTime(3.0).setPositions(1.02414417266846, 1.59279942512512, 1.49439251422882, 5.47959715524782, 3.01673936843872, 9.03658038774599));
        this.waypointListView.setItems(this.waypoints.getList());
        this.selectedWaypoint.addListener((observableValue, waypoint, waypoint2) -> this.selectedTime.set(waypoint2 == null ? 0.0 : waypoint2.time));
        this.selectedWaypoint.bind((ObservableValue)this.waypointListView.getSelectionModel().selectedItemProperty());
        this.jointPosChart.getRenderers().setAll((Object[])new Renderer[]{new WaypointDataSetRenderer(), azk.a()});
        this.jointPosChart.getPlugins().add((Object)new azr());
        XValueIndicator xValueIndicator = new XValueIndicator(this.jointPosChart.getXAxis(), 1.0);
        this.jointPosChart.getPlugins().add((Object)xValueIndicator);
        xValueIndicator.valueProperty().bindBidirectional((Property)this.selectedTime);
    }

    public void interpolateLinear() {
        blm.b(this.robotModel.d.get() == 6, (Object)"Not valid 6 DoF");
        bhm bhm2 = (bhm)this.robotModel.j.get();
        bhv bhv2 = (bhv)this.robotModel.k.get();
        bfw bfw2 = new bfw();
        bfw bfw3 = new bfw();
        bfw bfw4 = new bfw();
        double[] dArray = null;
        double[] dArray2 = null;
        double[] dArray3 = null;
        double[] dArray4 = null;
        bfy bfy2 = bfy.d();
        bfy.d();
        bfy bfy3 = bfy.d();
        bfy bfy4 = bfy.d();
        bfy.d();
        ArrayList<Waypoint> arrayList = new ArrayList<Waypoint>();
        for (int i2 = 1; i2 < this.waypoints.getNumWaypoints(); ++i2) {
            Waypoint waypoint = (Waypoint)this.waypoints.getList().get(i2 - 1);
            Waypoint waypoint2 = (Waypoint)this.waypoints.getList().get(i2);
            dArray = waypoint.getPositions(dArray);
            dArray2 = waypoint2.getPositions(dArray2);
            if (dArray3 == null) {
                dArray3 = (double[])dArray.clone();
            }
            if (dArray4 == null) {
                dArray4 = (double[])dArray.clone();
            }
            bhm2.a(dArray, bfy2).a(bfw2);
            bhm2.a(dArray2, bfy3).a(bfw3);
            double d2 = bfy3.ea - bfy2.ea;
            double d3 = bfy3.ec - bfy2.ec;
            double d4 = bfy3.eg - bfy2.eg;
            double d5 = waypoint2.getTime() - waypoint.getTime();
            double d6 = d2;
            double d7 = d3;
            double d8 = d4;
            int n2 = (int)Math.floor(Math.sqrt(d6 * d6 + d7 * d7 + d8 * d8) / LINEAR_INTERP_DISTANCE);
            d3 /= (double)n2;
            d4 /= (double)n2;
            d5 /= (double)n2;
            blm.b(Double.isFinite(d2 /= (double)n2), (Object)"can't work with non finite waypoints");
            if (!arrayList.contains(waypoint)) {
                arrayList.add(waypoint);
            }
            for (int i3 = 1; i3 < n2; ++i3) {
                int n3;
                bfy4.a(bfx.a(bfw2, bfw3, bfw4, (double)i3 / (double)n2));
                bfy4.a(bfy2.ea + (double)i3 * d2, bfy2.ec + (double)i3 * d3, bfy2.eg + (double)i3 * d4);
                for (int i4 = 0; i4 < dArray.length; ++i4) {
                    dArray3[i4] = dArray[i4] + (double)i3 * (dArray2[i4] - dArray[i4]) / (double)n2;
                }
                bhv bhv3 = bhv2;
                bhv2.bD = false;
                bhv3.bE = false;
                bhv3.bF = false;
                bhv3.bG = false;
                bhv3.bH = false;
                bhv3.a.Q = bht.R;
                Object object = bhv2.a;
                ae.a(true, "max iterations must be greater than zero");
                ((bhx)object).aQ = 25;
                Object object2 = bfy4;
                bhv3 = bhv2;
                Object object3 = object2;
                object = bhv3;
                Object object4 = object3;
                Object object5 = bhv3.a;
                Object object6 = object4;
                ae.a(bix.b(0.0 + ((bfy)object6).u + ((bfy)object6).v + ((bfy)object6).dZ + ((bfy)object6).w + ((bfy)object6).x + ((bfy)object6).eb + ((bfy)object6).ed + ((bfy)object6).ee + ((bfy)object6).ef), "SO3 target may not contain NaN or Inf");
                ((bhy)object5).S.c((bfy)object4);
                ((bhv)object).bG = true;
                double d9 = ((bfy)object2).eg;
                double d10 = ((bfy)object2).ec;
                double d11 = ((bfy)object2).ea;
                object = bhv3;
                double d12 = d9;
                double d13 = d10;
                double d14 = d11;
                Object object7 = ((bhv)object).a;
                ae.a(!Double.isInfinite(d14) && !Double.isInfinite(d13) && !Double.isInfinite(d12), "Xyz objective may not contain Inf values");
                ((bia)object7).eq = d14;
                ((bia)object7).er = d13;
                ((bia)object7).es = d12;
                ((bhv)object).bE = true;
                object2 = dArray3;
                bhv3 = bhv2;
                ae.a(((Object)object2).length == bhv3.d.numJoints, "length must match DOF");
                object4 = object2;
                object5 = bhv3.d;
                object3 = bhv3.a;
                bhv3.a.Q = (double[])object4;
                int n4 = ((Object)object4).length;
                ((bht)object3).f = bip.a(((bht)object3).f, n4);
                for (n3 = 0; n3 < n4; ++n3) {
                    boolean[] blArray = ((bht)object3).f;
                    int n5 = n3;
                    blArray[n3] = switch (((bgg)object5).a[n5].a().ordinal()) {
                        case 3, 4, 5 -> true;
                        default -> false;
                    };
                }
                for (int i5 = 0; i5 < ((Object)object2).length; ++i5) {
                    if (!(Math.abs((double)object2[i5]) < 1.0E-6)) continue;
                    object2[i5] = 1.0E-6;
                }
                bhv3.bH = true;
                object = dArray4;
                object2 = dArray3;
                bhv3 = bhv2;
                object6 = object;
                object4 = object2;
                object5 = bhv3.a;
                object3 = bhv3.a;
                ae.a(((Object)object4).length == object5.f(), "Dimension mismatch");
                ae.a(((Object)object6).length == object5.f(), "Dimension mismatch");
                Object object8 = object5;
                Object object9 = object3;
                Object object10 = object8;
                bhs bhs2 = ((bhx)object9).a;
                ((bhx)object9).a.a = (kq)ae.b(object10);
                bhs2.Z = object10.f();
                bhs2.aa = object10.g();
                bhs2.c = bip.a(bhs2.c, bhs2.aa);
                bhs2.d = bip.a(bhs2.d, bhs2.aa);
                ((bhx)object9).a.a((bhw)object8, ((bhx)object9).a);
                object8 = object4;
                ((bhx)object3).a.a((double[])object8, bhx.en, bhx.eo);
                n3 = 0;
                int n6 = ((bhx)object3).aQ;
                for (int i6 = 0; i6 < n6; ++i6) {
                    boolean bl2;
                    block16: {
                        object9 = ((bhx)object3).a;
                        for (int i7 = 0; i7 < 10000; ++i7) {
                            bl2 = object9.f();
                            if (!bl2 && object9.i()) {
                                continue;
                            }
                            break block16;
                        }
                        throw new RuntimeException("After 10,000 iterations it failed to take a step! Probably a bug.");
                    }
                    boolean bl3 = bl2;
                    n3 = bl3 ? 1 : 0;
                    if (bl3) break;
                }
                if (n3 == 0) {
                    System.err.println("Warning: IK solution did not converge within allowed iterations.");
                }
                double[] dArray5 = ((bhx)object3).a.b();
                object7 = dArray5;
                System.arraycopy(dArray5, 0, object6, 0, ((Object)object7).length);
                if (n3 != 0 && bix.b(dArray4)) {
                    arrayList.add(Waypoint.newMove(waypoint.getNumJoints()).setTime(waypoint.getTime() + (double)i3 * d5).setPositions(dArray4));
                    continue;
                }
                System.err.println("Found no solution. Ignoring intermediate point");
            }
            if (arrayList.contains(waypoint2)) continue;
            arrayList.add(waypoint2);
        }
        this.waypoints.getList().setAll(arrayList);
        this.waypoints.setDirty();
        TeachRepeatPresenter teachRepeatPresenter = this;
        teachRepeatPresenter.onUpdate((List<Waypoint>)teachRepeatPresenter.waypoints.getList());
    }

    @Generated
    public String toString() {
        return "TeachRepeatPresenter(root=" + String.valueOf(this.root) + ", menuPane=" + String.valueOf(this.menuPane) + ", waypointPane=" + String.valueOf(this.waypointPane) + ", waypointListView=" + String.valueOf(this.waypointListView) + ", pane3d=" + String.valueOf(this.pane3d) + ", pane2d=" + String.valueOf(this.pane2d) + ", ikPane=" + String.valueOf(this.ikPane) + ", ikIncreaseX=" + String.valueOf(this.ikIncreaseX) + ", ikDecreaseX=" + String.valueOf(this.ikDecreaseX) + ", ikIncreaseY=" + String.valueOf(this.ikIncreaseY) + ", ikDecreaseY=" + String.valueOf(this.ikDecreaseY) + ", ikIncreaseZ=" + String.valueOf(this.ikIncreaseZ) + ", ikDecreaseZ=" + String.valueOf(this.ikDecreaseZ) + ", xyzLine=" + String.valueOf(this.xyzLine) + ", xyzWaypoints=" + String.valueOf((Object)this.xyzWaypoints) + ", jointPosChart=" + String.valueOf(this.jointPosChart) + ", timeIndicators=" + String.valueOf(this.timeIndicators) + ", selectedWaypoint=" + String.valueOf(this.selectedWaypoint) + ", selectedTime=" + String.valueOf(this.selectedTime) + ", robotModel=" + String.valueOf(this.robotModel) + ", fileChooser=" + String.valueOf(this.fileChooser) + ", waypoints=" + String.valueOf(this.waypoints) + ", groupTrajectory=" + String.valueOf(this.groupTrajectory) + ", cartesianSamplesCont=" + String.valueOf(this.cartesianSamplesCont) + ", cartesianSamplesKey=" + String.valueOf(this.cartesianSamplesKey) + ", colorIndex=" + String.valueOf(this.colorIndex) + ", len=" + this.len + ", worldFrame=" + String.valueOf(this.worldFrame) + ", cubeWorld=" + String.valueOf(this.cubeWorld) + ", worldScene=" + String.valueOf(this.worldScene) + ")";
    }

    private static /* synthetic */ void lambda$updateTimeIndicators$1(Waypoint waypoint, ObservableValue observableValue, Number number, Number number2) {
        if (number2 != null) {
            waypoint.setTime(number2.doubleValue());
        }
    }
}

