/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.gui.views.scope.components;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Button;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javax.inject.Inject;
import us.hebi.gui.controls.Css;
import us.hebi.gui.controls.buttons.HActionButton;
import us.hebi.gui.lib.aum;
import us.hebi.gui.lib.awg;
import us.hebi.gui.lib.axk;
import us.hebi.gui.lib.azg;
import us.hebi.gui.lib.baq;
import us.hebi.gui.lib.baw;
import us.hebi.gui.lib.bax;
import us.hebi.gui.lib.bdc;

public class MonitoringCustomController {
    @FXML
    private Parent root;
    @FXML
    private GridPane gridPane;
    @FXML
    private Button reloadFilesBtn;
    private static final int NUM_COLS = 4;
    @Inject
    azg plottingService;
    @Inject
    axk selectorService;
    @Inject
    bax customChartDirectory;

    private List<Node> createButtonsFromCustomXml() {
        ArrayList<Node> arrayList = new ArrayList<Node>();
        this.customChartDirectory.forEachXml(bba2 -> {
            HActionButton hActionButton = Css.addClass(new HActionButton(), "btn-PlotButton");
            hActionButton.setText(bba2.getTitle());
            Supplier<baq> supplier = baw.a(bba2);
            hActionButton.setOnAction(this.plottingService.a((List<aum>)this.selectorService.getSelectedModules(), bba2.getTitle(), supplier));
            arrayList.add((Node)hActionButton);
        }, (path, string) -> {
            HActionButton hActionButton = Css.addClass(new HActionButton(), "btn-PlotButton");
            hActionButton.pseudoClassStateChanged(Css.CLASS_INVALID, true);
            hActionButton.setText(path.getFileName().toString());
            hActionButton.setOnAction(actionEvent -> awg.a(string, bdc.a(actionEvent)));
            arrayList.add((Node)hActionButton);
        });
        return arrayList;
    }

    private void layoutButtonsOnGrid(List<Node> list) {
        int n2 = 0;
        this.gridPane.getChildren().clear();
        for (Node node : list) {
            this.gridPane.add(node, MonitoringCustomController.getRow(n2), MonitoringCustomController.getCol(n2));
            GridPane.setHgrow((Node)node, (Priority)Priority.ALWAYS);
            GridPane.setVgrow((Node)node, (Priority)Priority.ALWAYS);
            ++n2;
        }
    }

    private void reloadFilesAsync() {
        this.reloadFilesBtn.setDisable(true);
        this.gridPane.getChildren().clear();
        ((CompletableFuture)CompletableFuture.supplyAsync(this::createButtonsFromCustomXml).thenAcceptAsync(this::layoutButtonsOnGrid, bdc.b)).thenRun(() -> this.reloadFilesBtn.setDisable(false));
    }

    @FXML
    void initialize() {
        this.gridPane.disableProperty().bind((ObservableValue)this.selectorService.selectionEmpty());
        this.customChartDirectory.selectedDirectoryProperty().addListener(observable -> this.reloadFilesAsync());
        this.reloadFilesBtn.setOnAction(actionEvent -> this.reloadFilesAsync());
        this.reloadFilesAsync();
    }

    private static int getRow(int n2) {
        return n2 % 4;
    }

    private static int getCol(int n2) {
        return n2 / 4;
    }
}

