/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.gui.views.maps.hrdf;

import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import lombok.Generated;
import us.hebi.gui.lib.bdc;
import us.hebi.gui.lib.ccc;
import us.hebi.gui.lib.cdo;
import us.hebi.gui.lib.cdp;
import us.hebi.gui.views.maps.hrdf.DirectoryUpdateService;
import us.hebi.gui.views.maps.hrdf.RobotSource;

public class RobotSourceLoader
extends DirectoryUpdateService {
    final ObservableList<RobotSource> sources = FXCollections.observableArrayList();

    public RobotSourceLoader() {
        super("robots");
    }

    public void forceReload() {
        this.sources.clear();
        this.onDirectoryUpdate();
    }

    @Override
    protected void onDirectoryUpdate() {
        CompletableFuture.supplyAsync(this::loadSourceFiles, this.executor).thenAcceptAsync(arg_0 -> this.sources.setAll(arg_0), bdc.b);
    }

    private List<RobotSource> loadSourceFiles() {
        ArrayList<RobotSource> arrayList;
        block11: {
            DirectoryStream<Path> directoryStream = Files.newDirectoryStream(this.getDirectoryPath(), "*.json");
            try {
                ArrayList<RobotSource> arrayList2 = new ArrayList<RobotSource>();
                for (Path path : directoryStream) {
                    if (Files.size(path) <= 0L) continue;
                    cdp cdp2 = cdo.a(Files.readAllBytes(path));
                    try {
                        ccc ccc2 = ccc.a(cdp2);
                        if (ccc2.g.ar() <= 0) continue;
                        arrayList2.add(new RobotSource(ccc2));
                    }
                    catch (IOException iOException) {
                        System.err.println(String.valueOf(path) + " could not be parsed: " + iOException.getMessage());
                    }
                }
                arrayList = arrayList2;
                if (directoryStream == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (directoryStream != null) {
                        try {
                            directoryStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException iOException) {
                    bdc.b(() -> this.notificationService.f(iOException));
                    return Collections.emptyList();
                }
            }
            directoryStream.close();
        }
        return arrayList;
    }

    @Generated
    public ObservableList<RobotSource> getSources() {
        return this.sources;
    }
}

