/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.gui.views.logviewer.state;

import io.fair_acc.chartfx.Chart;
import io.fair_acc.chartfx.XYChart;
import io.fair_acc.chartfx.axes.Axis;
import io.fair_acc.chartfx.axes.spi.CategoryAxis;
import io.fair_acc.chartfx.plugins.AbstractSingleValueIndicator;
import io.fair_acc.chartfx.plugins.ChartPlugin;
import io.fair_acc.chartfx.plugins.XValueIndicator;
import io.fair_acc.chartfx.renderer.LineStyle;
import io.fair_acc.chartfx.renderer.Renderer;
import io.fair_acc.chartfx.renderer.spi.BasicDataSetRenderer;
import io.fair_acc.chartfx.renderer.spi.ErrorDataSetRenderer;
import io.fair_acc.chartfx.ui.css.DataSetNode;
import io.fair_acc.dataset.DataSet;
import io.fair_acc.dataset.spi.AbstractDataSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.IntToDoubleFunction;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.control.TreeItem;
import lombok.Generated;
import org.HdrHistogram.PackedDoubleHistogram;
import us.hebi.gui.lib.azf;
import us.hebi.gui.lib.azk;
import us.hebi.gui.lib.azm;
import us.hebi.gui.lib.azz;
import us.hebi.gui.lib.bae;
import us.hebi.gui.lib.bak;
import us.hebi.gui.lib.bat;
import us.hebi.gui.lib.beh;
import us.hebi.gui.lib.bei;
import us.hebi.gui.lib.bej;
import us.hebi.gui.lib.bek;
import us.hebi.gui.lib.blm;
import us.hebi.gui.lib.cec;
import us.hebi.gui.lib.jc;
import us.hebi.gui.lib.jd;
import us.hebi.gui.views.logviewer.state.ChartCategory;
import us.hebi.gui.views.logviewer.state.NamedChart;
import us.hebi.gui.views.logviewer.state.VisibilityState;

public class ChartList {
    final XYChart sharedTimeChart;
    DoubleProperty indicatorTime;
    jc time;
    bat traceType;
    PackedDoubleHistogram tmpHistogram;
    jc tmpSortValues;
    private static final boolean DISABLE_USER_RANGE = true;
    final List<NamedChart> charts;
    public final VisibilityState visibilityState;

    public ChartList() {
        Optional<XValueIndicator> optional;
        block1: {
            XYChart xYChart = azk.a(0.0, 0.0, "");
            azm azm2 = new azm(xYChart.getXAxis(), "", xYChart);
            xYChart.getPlugins().add((Object)azm2);
            this.sharedTimeChart = xYChart;
            for (ChartPlugin chartPlugin : this.sharedTimeChart.getPlugins()) {
                if (!(chartPlugin instanceof XValueIndicator)) continue;
                optional = Optional.of((XValueIndicator)chartPlugin);
                break block1;
            }
            optional = Optional.empty();
        }
        this.indicatorTime = optional.map(AbstractSingleValueIndicator::valueProperty).orElseThrow();
        this.traceType = bat.a;
        this.tmpHistogram = new PackedDoubleHistogram(2);
        this.tmpSortValues = new jc(0);
        this.charts = new ArrayList<NamedChart>();
        this.visibilityState = new VisibilityState();
    }

    public ChartList clear() {
        this.charts.clear();
        return this;
    }

    public ChartList addXyzCommandChart(Supplier<String> supplier, String string, String string2, double d2, double d3, jc[] jcArray, jc[] jcArray2) {
        bat bat2 = this.traceType;
        try {
            this.setTraceType(bat.a);
            ChartList chartList = this;
            Renderer renderer = chartList.toXyzRenderer(n2 -> this.time, jcArray2);
            this.setTraceType(bat.b);
            ChartList chartList2 = this;
            Renderer renderer2 = chartList2.toXyzRenderer(n2 -> this.time, jcArray).setShowInLegend(false);
            for (int i2 = 0; i2 < jcArray.length; ++i2) {
                DataSetNode dataSetNode = (DataSetNode)renderer.getDatasetNodes().get(i2);
                ((DataSetNode)renderer2.getDatasetNodes().get(i2)).visibleProperty().bind((ObservableValue)dataSetNode.visibleProperty());
            }
            ChartList chartList3 = this;
            ChartList chartList4 = chartList3.addChart(chartList3.newTimeChart(supplier, this::applyXyzVisibility, string, string2, d2, d3, renderer, renderer2));
            return chartList4;
        }
        finally {
            this.setTraceType(bat2);
        }
    }

    public ChartList addXyzErrorChart(Supplier<String> supplier, String string, String string2, double d2, double d3, jc[] jcArray, jc[] jcArray2) {
        blm.b(this.time, (Object)"time must be set");
        Renderer renderer = azk.a();
        for (int i2 = 0; i2 < jcArray2.length; ++i2) {
            renderer.getDatasets().add((Object)new azz("", this.time, jcArray[i2], jcArray2[i2]).addStyleClasses(new String[]{this.traceType.D(), azf.b(i2)}));
        }
        ChartList chartList = this;
        return chartList.addChart(chartList.newTimeChart(supplier, this::applyXyzVisibility, string, string2, d2, d3, renderer));
    }

    public ChartList addXyzChart(Supplier<String> supplier, String string, String string2, double d2, double d3, jc[] jcArray) {
        ChartList chartList = this;
        Renderer[] rendererArray = new Renderer[1];
        ChartList chartList2 = this;
        rendererArray[0] = chartList2.toXyzRenderer(n2 -> this.time, jcArray);
        return chartList.addChart(chartList.newTimeChart(supplier, this::applyXyzVisibility, string, string2, d2, d3, rendererArray));
    }

    public ChartList addCommandChart(Supplier<String> supplier, String string, String string2, double d2, double d3, jc[] jcArray, jc[] jcArray2) {
        bat bat2 = this.traceType;
        try {
            this.setTraceType(bat.a);
            Renderer renderer = this.toDeviceRenderer(jcArray2);
            this.setTraceType(bat.b);
            Renderer renderer2 = this.toDeviceRenderer(jcArray).setShowInLegend(false);
            for (int i2 = 0; i2 < jcArray.length; ++i2) {
                DataSetNode dataSetNode = (DataSetNode)renderer.getDatasetNodes().get(i2);
                dataSetNode.getStyleClass().add((Object)"feedback");
                DataSetNode dataSetNode2 = (DataSetNode)renderer2.getDatasetNodes().get(i2);
                dataSetNode2.getStyleClass().add((Object)"command");
                dataSetNode2.visibleProperty().bind((ObservableValue)dataSetNode.visibleProperty());
            }
            ChartList chartList = this;
            ChartList chartList2 = chartList.addChart(chartList.newTimeChart(supplier, this::applyDeviceVisibility, string, string2, d2, d3, renderer, renderer2));
            return chartList2;
        }
        finally {
            this.setTraceType(bat2);
        }
    }

    public ChartList addPhaseChart(Supplier<String> supplier, String string, String string2, double d2, double d3, jc[] jcArray, jc[] jcArray2, jc[] jcArray3) {
        ChartList chartList = this;
        Renderer renderer = chartList.toDeviceRenderer((int n2) -> this.time, jcArray);
        ChartList chartList2 = this;
        Renderer renderer2 = chartList2.toDeviceRenderer((int n2) -> this.time, jcArray2).setShowInLegend(false);
        ChartList chartList3 = this;
        Renderer renderer3 = chartList3.toDeviceRenderer((int n2) -> this.time, jcArray3).setShowInLegend(false);
        for (int i2 = 0; i2 < jcArray.length; ++i2) {
            DataSetNode dataSetNode = (DataSetNode)renderer.getDatasetNodes().get(i2);
            DataSetNode dataSetNode2 = (DataSetNode)renderer2.getDatasetNodes().get(i2);
            DataSetNode dataSetNode3 = (DataSetNode)renderer3.getDatasetNodes().get(i2);
            dataSetNode2.visibleProperty().bind((ObservableValue)dataSetNode.visibleProperty());
            dataSetNode3.visibleProperty().bind((ObservableValue)dataSetNode.visibleProperty());
        }
        ChartList chartList4 = this;
        return chartList4.addChart(chartList4.newTimeChart(supplier, this::applyDeviceVisibility, string, string2, d2, d3, renderer, renderer2, renderer3));
    }

    public ChartList addQuaternionTraces(Supplier<String> supplier, String string, jc[] jcArray) {
        return this.addTimeTraces(supplier, string, "quaternion", -1.0, 1.0, jcArray, (Renderer renderer) -> {
            ChartList.updateDataSet(renderer, 0, "W", "color-primary");
            ChartList.updateDataSet(renderer, 1, "X", "color-red");
            ChartList.updateDataSet(renderer, 2, "Y", "color-green");
            ChartList.updateDataSet(renderer, 3, "Z", "color-blue");
        });
    }

    private static void updateDataSet(Renderer renderer, int n2, String string, String ... stringArray) {
        DataSetNode dataSetNode = (DataSetNode)renderer.getDatasetNodes().get(n2);
        ((AbstractDataSet)dataSetNode.getDataSet()).setName(string);
        dataSetNode.getStyleClass().addAll((Object[])stringArray);
    }

    public ChartList addErrorChart(Supplier<String> supplier, String string, String string2, double d2, double d3, jc[] jcArray, jc[] jcArray2) {
        blm.b(this.time, (Object)"time must be set");
        Renderer renderer = azk.a();
        for (int i2 = 0; i2 < jcArray2.length; ++i2) {
            renderer.addDataSet(new azz("", this.time, jcArray[i2], jcArray2[i2]).addStyleClasses(new String[]{"error", this.traceType.D()}));
        }
        ChartList chartList = this;
        return chartList.addChart(chartList.newTimeChart(supplier, this::applyDeviceVisibility, string, string2, d2, d3, renderer));
    }

    public ChartList addDeviceChart(Supplier<String> supplier, String string, String string2, double d2, double d3, jc[] jcArray) {
        ChartList chartList = this;
        return chartList.addChart(chartList.newTimeChart(supplier, this::applyDeviceVisibility, string, string2, d2, d3, this.toDeviceRenderer(jcArray)));
    }

    public ChartList addDeviceXY(Supplier<String> supplier, String string, Axis axis, jc[] jcArray, Axis axis2, jc[] jcArray2) {
        XYChart xYChart = azk.a(new XYChart(axis, axis2));
        Renderer renderer = this.toDeviceRenderer((int n2) -> jcArray[n2], jcArray2);
        return this.addChart(new beh(this, supplier, string, xYChart, renderer));
    }

    public void applyDeviceVisibility(Renderer renderer) {
        int n2 = 0;
        for (DataSetNode dataSetNode : renderer.getDatasetNodes()) {
            ((AbstractDataSet)dataSetNode.getDataSet()).setName(this.visibilityState.getDeviceName(n2));
            BooleanProperty booleanProperty = this.visibilityState.deviceVisibilityProperty(n2);
            booleanProperty.unbind();
            dataSetNode.setVisible(booleanProperty.get());
            booleanProperty.bind((ObservableValue)dataSetNode.visibleProperty());
            ++n2;
        }
    }

    private void applyXyzVisibility(Renderer renderer) {
        int n2 = 0;
        for (DataSetNode dataSetNode : renderer.getDatasetNodes()) {
            ((AbstractDataSet)dataSetNode.getDataSet()).setName(this.visibilityState.getXyzName(n2));
            BooleanProperty booleanProperty = this.visibilityState.xyzVisibilityProperty(n2);
            booleanProperty.unbind();
            dataSetNode.setVisible(booleanProperty.get());
            booleanProperty.bind((ObservableValue)dataSetNode.visibleProperty());
            ++n2;
        }
    }

    public ChartList addSingleTrace(Supplier<String> supplier, String string, String string2, double d2, double d3, jc jc2) {
        return this.addTimeTraces(supplier, string, string2, d2, d3, jc2, (Renderer renderer) -> azk.a(renderer, 0, string, new String[0]));
    }

    public ChartList addStandaloneTimeTrace(Supplier<String> supplier, String string, jc jc2, jc jc3) {
        XYChart xYChart = azk.a(Double.NaN, Double.NaN, null);
        Consumer<Renderer> consumer = renderer -> {};
        DataSet[] dataSetArray = new DataSet[1];
        dataSetArray[0] = new bak(string, jc2::size, jc2::a, jc3::a);
        BasicDataSetRenderer basicDataSetRenderer = new BasicDataSetRenderer(dataSetArray);
        return this.addChart(ChartList.newChart(xYChart, supplier, consumer, string, null, Double.NaN, Double.NaN, basicDataSetRenderer));
    }

    public ChartList addCombinedUserStates(Supplier<String> supplier, String string, jc[] jcArray) {
        XYChart xYChart = azk.a(Double.NaN, Double.NaN, null);
        Consumer<Renderer> consumer = renderer -> {};
        BasicDataSetRenderer basicDataSetRenderer = new BasicDataSetRenderer(new DataSet[0]);
        for (int i2 = 1; i2 < jcArray.length; ++i2) {
            jc jc2 = jcArray[0];
            jc jc3 = jcArray[i2];
            basicDataSetRenderer.addDataSet(new bak("State " + i2, jc2::size, jc2::a, jc3::a));
        }
        return this.addChart(ChartList.newChart(xYChart, supplier, consumer, string, null, Double.NaN, Double.NaN, basicDataSetRenderer));
    }

    public ChartList addTimeTraces(Supplier<String> supplier, String string, String string2, double d2, double d3, jc jc2, Consumer<Renderer> consumer) {
        ChartList chartList = this;
        return chartList.addChart(chartList.newTimeChart(supplier, consumer, string, string2, d2, d3, this.toDeviceRenderer(jc2)));
    }

    public ChartList addTimeTraces(Supplier<String> supplier, String string, String string2, double d2, double d3, jc[] jcArray, Consumer<Renderer> consumer) {
        ChartList chartList = this;
        return chartList.addChart(chartList.newTimeChart(supplier, consumer, string, string2, d2, d3, this.toDeviceRenderer(jcArray)));
    }

    public ChartList addMedianBarChart(Supplier<String> supplier, String string, Axis axis, jc[] jcArray) {
        double[] dArray = Stream.of(jcArray).mapToDouble(this::getMedian).toArray();
        return this.addIndexBarChart(supplier, string, axis, n2 -> dArray[n2], jcArray.length);
    }

    private double getMedian(jc jc2) {
        if (jc2.size() == 0) {
            return Double.NaN;
        }
        jc jc3 = this.tmpSortValues;
        this.tmpSortValues.S = 0;
        jc jc4 = jc2;
        jc jc5 = this.tmpSortValues;
        boolean bl2 = false;
        jd jd2 = jc4.a();
        while (jd2.hasNext()) {
            double d2 = jd2.c();
            jc5.c(d2);
            bl2 = true;
        }
        jc5 = this.tmpSortValues;
        Arrays.sort(jc5.b, 0, jc5.S);
        return this.tmpSortValues.a(this.tmpSortValues.size() / 2);
    }

    public ChartList addIndexBarChart(Supplier<String> supplier, String string, Axis axis, IntToDoubleFunction intToDoubleFunction, int n3) {
        if (n3 <= 1) {
            return this;
        }
        ObservableList observableList = FXCollections.observableArrayList();
        for (int i2 = 0; i2 < n3; ++i2) {
            observableList.add((Object)String.valueOf(i2 + 1));
        }
        CategoryAxis categoryAxis = new CategoryAxis("Index", (ObservableList<String>)observableList);
        categoryAxis.setUnit(null);
        XYChart xYChart = azk.a(new XYChart(categoryAxis, axis));
        xYChart.setLegendVisible(false);
        ErrorDataSetRenderer errorDataSetRenderer = new ErrorDataSetRenderer();
        errorDataSetRenderer.setPolyLineStyle(LineStyle.HISTOGRAM_FILLED);
        xYChart.getRenderers().setAll((Object[])new Renderer[]{errorDataSetRenderer});
        errorDataSetRenderer.addDataSet(new bak(string, () -> n3, n2 -> n2, intToDoubleFunction));
        xYChart.getGridRenderer().getHorizontalMajorGrid().visibleProperty().set(false);
        xYChart.getGridRenderer().getVerticalMajorGrid().visibleProperty().set(true);
        return this.addCustomChart(supplier, string, visibilityState -> xYChart);
    }

    public ChartList addAsHistogram(Supplier<String> supplier, String string, String string2, jc[] jcArray) {
        return this.addAsHistogram(supplier, string, string2, jcArray, this::applyDeviceVisibility);
    }

    public ChartList addAsHistogram(Supplier<String> supplier, String string, String string2, jc[] jcArray, Consumer<Renderer> consumer) {
        Renderer renderer = azk.a();
        for (int i2 = 0; i2 < jcArray.length; ++i2) {
            renderer.getDatasets().add((Object)bae.a(jcArray[i2], this.tmpHistogram).addStyleClasses(new String[]{"trace-solid"}));
        }
        ChartList chartList = this;
        return chartList.addChart(chartList.newPercentileChart(supplier, consumer, string, string2, Double.NaN, Double.NaN, renderer));
    }

    private Renderer toDeviceRenderer(jc ... jcArray) {
        blm.b(this.time, (Object)"time must be set");
        ChartList chartList = this;
        return chartList.toDeviceRenderer((int n2) -> this.time, jcArray);
    }

    private Renderer toDeviceRenderer(IntFunction<jc> intFunction, jc[] jcArray) {
        Renderer renderer = azk.a();
        for (int i2 = 0; i2 < jcArray.length; ++i2) {
            renderer.getDatasets().add((Object)new bak("", intFunction.apply(i2), jcArray[i2]).addStyleClasses(new String[]{this.traceType.D()}));
        }
        return renderer;
    }

    private Renderer toXyzRenderer(IntFunction<jc> intFunction, jc[] jcArray) {
        blm.a(jcArray.length == 3, "Expected xyz data");
        Renderer renderer = azk.a();
        for (int i2 = 0; i2 < jcArray.length; ++i2) {
            renderer.getDatasets().add((Object)new bak("", intFunction.apply(i2), jcArray[i2]).addStyleClasses(new String[]{azf.b(i2), this.traceType.D()}));
        }
        return renderer;
    }

    public ChartList setTraceType(bat bat2) {
        this.traceType = blm.b(bat2);
        return this;
    }

    public ChartList setTime(jc jc2) {
        this.time = jc2;
        return this;
    }

    public List<TreeItem<NamedChart>> createHierarchy() {
        Stream<String> stream = Stream.of(ChartCategory.values()).map(ChartCategory::get);
        Stream<String> stream2 = this.charts.stream().map(NamedChart::getCategory);
        return Stream.concat(stream, stream2).distinct().map(this::newCategory).filter(treeItem -> treeItem.getChildren().size() > 0).toList();
    }

    private TreeItem<NamedChart> newCategory(String string) {
        TreeItem treeItem = new TreeItem((Object)new bei(this, string));
        treeItem.setExpanded(true);
        this.charts.stream().filter(namedChart -> cec.a(string, namedChart.getCategory())).forEach(namedChart -> treeItem.getChildren().add((Object)new TreeItem(namedChart)));
        return treeItem;
    }

    public List<NamedChart> getCharts() {
        return this.charts;
    }

    public ChartList addChart(NamedChart namedChart) {
        this.charts.add(namedChart);
        return this;
    }

    public ChartList addCustomChart(Supplier<String> supplier, String string, Function<VisibilityState, Chart> function) {
        return this.addChart(new bej(this, supplier, string, function));
    }

    private NamedChart newTimeChart(Supplier<String> supplier, Consumer<Renderer> consumer, String string, String string2, double d2, double d3, Renderer ... rendererArray) {
        if (this.isUserRangeDisabled(supplier, string)) {
            d3 = Double.NaN;
            d2 = Double.NaN;
        }
        return ChartList.newChart(this.sharedTimeChart != null ? this.sharedTimeChart : azk.a(d2, d3, string2), supplier, consumer, string, string2, d2, d3, rendererArray);
    }

    private NamedChart newPercentileChart(Supplier<String> supplier, Consumer<Renderer> consumer, String string, String string2, double d2, double d3, Renderer ... rendererArray) {
        if (this.isUserRangeDisabled(supplier, string)) {
            d3 = Double.NaN;
            d2 = Double.NaN;
        }
        return ChartList.newChart(azk.a(), supplier, consumer, string, string2, d2, d3, rendererArray);
    }

    private static NamedChart newChart(XYChart xYChart, Supplier<String> supplier, Consumer<Renderer> consumer, String string, String string2, double d2, double d3, Renderer ... rendererArray) {
        Renderer[] rendererArray2 = rendererArray;
        int n2 = rendererArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            rendererArray2[i2].getAxes().setAll(xYChart.getAxes());
        }
        return new bek(supplier, string, xYChart, consumer, rendererArray, string2, d2, d3);
    }

    private boolean isUserRangeDisabled(Supplier<String> supplier, String string) {
        return supplier != ChartCategory.Network;
    }

    @Generated
    public DoubleProperty getIndicatorTime() {
        return this.indicatorTime;
    }

    @Generated
    public VisibilityState getVisibilityState() {
        return this.visibilityState;
    }
}

