/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.gui.views.bootloader;

import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.ResourceBundle;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.binding.DoubleBinding;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;
import javafx.concurrent.Worker;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ChoiceBox;
import javafx.scene.control.Dialog;
import javafx.scene.control.DialogPane;
import javafx.scene.control.RadioButton;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.control.ToolBar;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.layout.VBox;
import javafx.util.Callback;
import javafx.util.Duration;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.controlsfx.control.Notifications;
import org.controlsfx.control.TaskProgressView;
import us.hebi.gui.lib.ac;
import us.hebi.gui.lib.ae;
import us.hebi.gui.lib.ahg;
import us.hebi.gui.lib.ait;
import us.hebi.gui.lib.akt;
import us.hebi.gui.lib.amw;
import us.hebi.gui.lib.apo;
import us.hebi.gui.lib.arx;
import us.hebi.gui.lib.ary;
import us.hebi.gui.lib.atl;
import us.hebi.gui.lib.att;
import us.hebi.gui.lib.atv;
import us.hebi.gui.lib.aty;
import us.hebi.gui.lib.aua;
import us.hebi.gui.lib.aud;
import us.hebi.gui.lib.aui;
import us.hebi.gui.lib.aum;
import us.hebi.gui.lib.awg;
import us.hebi.gui.lib.awi;
import us.hebi.gui.lib.awk;
import us.hebi.gui.lib.axb;
import us.hebi.gui.lib.axh;
import us.hebi.gui.lib.axj;
import us.hebi.gui.lib.axk;
import us.hebi.gui.lib.axs;
import us.hebi.gui.lib.axu;
import us.hebi.gui.lib.az;
import us.hebi.gui.lib.bdc;
import us.hebi.gui.lib.bdy;
import us.hebi.gui.lib.bfn;
import us.hebi.gui.lib.bfo;
import us.hebi.gui.lib.bfp;
import us.hebi.gui.lib.bsz;
import us.hebi.gui.lib.bun;
import us.hebi.gui.lib.xv;
import us.hebi.gui.lib.xx;

public class BootloaderPresenter {
    @FXML
    private ResourceBundle resources;
    @FXML
    private URL location;
    @FXML
    private ToolBar topBar;
    @FXML
    private Button loginButton;
    @FXML
    private Button bootButton;
    @FXML
    private Button calibrateCurrentButton;
    @FXML
    private Button programRawButton;
    @FXML
    private Button programEncryptingButton;
    @FXML
    private Button showMacAddressesButton;
    @FXML
    private Button setBootloaderParametersButton;
    @FXML
    private Button setApplicationParametersButton;
    @FXML
    private Button fullUpdateButton;
    @FXML
    private Button updateApplicationButton;
    @FXML
    private Button updateBootloaderButton;
    @FXML
    private Button updateBootloaderLoaderButton;
    @FXML
    private Button eraseApplicationButton;
    @FXML
    private Button stopButton;
    @FXML
    private Button calibratePositionButton;
    @FXML
    private Button calibrateEffortButton;
    @FXML
    private Button setDatabaseValueButton;
    @FXML
    private Button eraseDatabaseButton;
    @FXML
    private Button resetButton;
    @FXML
    private Button saveApplicationButton;
    @FXML
    private Button saveBootloaderButton;
    @FXML
    private Button saveAllPartitionsButton;
    @FXML
    private Button saveDatabaseButton;
    @FXML
    private TaskProgressView<Task<?>> taskProgressView;
    @FXML
    private VBox buttonVBox;
    @FXML
    public TreeView<String> typeTree;
    @FXML
    private TreeView<aum> moduleTree;
    @FXML
    private RadioButton viewSelectorFamilyName;
    @FXML
    private ChoiceBox<String> interfaceChoiceBox;
    @FXML
    private TextField hwType;
    @FXML
    private TextField hwEceType;
    @FXML
    private TextField hwEceRevision;
    @FXML
    private TextField hwSerial;
    @FXML
    private TextField fwType;
    @FXML
    private TextField fwRevision;
    @FXML
    private TextField ethMacAddress;
    @FXML
    private TextField ethIpAddress;
    @FXML
    private TextField ethNetmask;
    @FXML
    private TextField ethGateway;
    @FXML
    private TextField fwMode;
    @FXML
    private TextField hwRevision;
    @FXML
    private TextField hwSpringConstant;
    private static final String DATABASE_MESSAGE = "Clearing the database will wipe any existing calibration data and requires an appropriate physical setup. Continuing may render the device unusable. Are you sure that you want to proceed?";
    private static final String CALIBRATION_MESSAGE = "Calibrating will wipe any existing calibration data and requires an appropriate physical setup.Are you sure that you want to proceed?";
    int dbAddress = 28672;
    Float floatVal = null;
    Integer intVal = null;
    @Inject
    awi authenticationService;
    @Inject
    axj lookupService;
    @Inject
    axk selector;
    @Inject
    axh interfaceChoiceService;
    @Inject
    axu simpleCategoryTree;
    @Inject
    public axs filteredFlatModuleTree;
    @Inject
    axb commandService;
    akt command;
    @Inject
    ary moduleTreeCellFactory;
    @Inject
    awk bootloaderService;

    @FXML
    void refreshInterfaces(ActionEvent actionEvent) {
        this.interfaceChoiceService.refreshInterfaces();
    }

    @FXML
    void reset(ActionEvent actionEvent) {
        ((amw)this.command).clear();
        this.command.setResetFlag();
        this.selector.getSelectedAddresses().forEach(ahg2 -> this.commandService.a((ahg)ahg2, this.command));
    }

    @FXML
    void stopBoot(ActionEvent actionEvent) {
        ((amw)this.command).clear();
        this.command.setStayInBootloaderFlag();
        this.selector.getSelectedAddresses().forEach(ahg2 -> this.commandService.a((ahg)ahg2, this.command));
    }

    @FXML
    void boot(ActionEvent actionEvent) {
        ((amw)this.command).clear();
        this.command.setBootFlag();
        this.selector.getSelectedAddresses().forEach(ahg2 -> this.commandService.a((ahg)ahg2, this.command));
    }

    @FXML
    void setBootloaderHardwareParameters(ActionEvent actionEvent) {
        this.bootloaderService.setBootloaderHardwareParameters((List<aum>)this.selector.getSelectedModules(), this.authenticationService.cW.get());
    }

    @FXML
    void setApplicationHardwareParameters(ActionEvent actionEvent) {
        this.bootloaderService.setApplicationHardwareParameters((List<aum>)this.selector.getSelectedModules());
    }

    @FXML
    void programApplication(ActionEvent actionEvent) {
        this.bootloaderService.programApplicationMultiple((List<aum>)this.selector.getSelectedModules(), this.programRawButton.getScene().getWindow());
    }

    @FXML
    void programEncryptingFirmware(ActionEvent actionEvent) {
        this.bootloaderService.programEncryptingFirmwareMultiple((List<aum>)this.selector.getSelectedModules(), this.programEncryptingButton.getScene().getWindow());
    }

    @FXML
    void doFullUpdate(ActionEvent actionEvent) {
        this.bootloaderService.doFullUpdate(this.selector.getSingleSelection());
    }

    @FXML
    void updateApplication(ActionEvent actionEvent) {
        this.bootloaderService.updateFirmwareMultiple((List<aum>)this.selector.getSelectedModules(), bfn.d);
    }

    @FXML
    void updateBootloader(ActionEvent actionEvent) {
        this.bootloaderService.updateFirmwareMultiple((List<aum>)this.selector.getSelectedModules(), bfn.e);
    }

    @FXML
    void updateBootloaderLoader(ActionEvent actionEvent) {
        this.bootloaderService.updateFirmwareMultiple((List<aum>)this.selector.getSelectedModules(), bfn.f);
    }

    @FXML
    void eraseApplication(ActionEvent actionEvent) {
        for (aum aum2 : this.selector.getSelectedModules()) {
            this.bootloaderService.erasePartition(Optional.ofNullable(aum2), bsz.d);
        }
    }

    @FXML
    void eraseDatabase(ActionEvent actionEvent) {
        if (!awg.a(CALIBRATION_MESSAGE, bdc.a(actionEvent))) {
            return;
        }
        for (aum aum2 : this.selector.getSelectedModules()) {
            this.bootloaderService.erasePartition(Optional.ofNullable(aum2), bsz.e);
        }
    }

    @FXML
    void saveAllPartitions(ActionEvent actionEvent) {
        this.bootloaderService.saveToFile(this.selector.getSingleSelection(), bsz.c, this.saveAllPartitionsButton.getScene().getWindow());
    }

    @FXML
    void saveBootloader(ActionEvent actionEvent) {
        this.bootloaderService.saveToFile(this.selector.getSingleSelection(), bsz.f, this.saveBootloaderButton.getScene().getWindow());
    }

    @FXML
    void saveApplication(ActionEvent actionEvent) {
        this.bootloaderService.saveToFile(this.selector.getSingleSelection(), bsz.d, this.saveApplicationButton.getScene().getWindow());
    }

    @FXML
    void saveDatabase(ActionEvent actionEvent) {
        this.bootloaderService.saveToFile(this.selector.getSingleSelection(), bsz.e, this.saveDatabaseButton.getScene().getWindow());
    }

    @FXML
    void calibrateCurrent(ActionEvent actionEvent) {
        if (!awg.a(CALIBRATION_MESSAGE, bdc.a(actionEvent))) {
            return;
        }
        System.out.println("continue");
        this.selector.getSelectedAddresses().forEach(ahg2 -> {
            ((amw)this.command).clear();
            ((amw)this.command).getRootMessage().a().e().d(true);
            this.commandService.a((ahg)ahg2, this.command);
        });
    }

    @FXML
    void calibratePosition(ActionEvent actionEvent) {
        if (!awg.a(CALIBRATION_MESSAGE, bdc.a(actionEvent))) {
            return;
        }
        this.selector.getSelectedAddresses().forEach(ahg2 -> {
            ((amw)this.command).clear();
            ((amw)this.command).getRootMessage().a().e().a(true);
            this.commandService.a((ahg)ahg2, this.command);
        });
    }

    @FXML
    void calibrateEffort(ActionEvent actionEvent) {
        if (!awg.a(CALIBRATION_MESSAGE, bdc.a(actionEvent))) {
            return;
        }
        this.selector.getSelectedAddresses().forEach(ahg2 -> {
            ((amw)this.command).clear();
            ((amw)this.command).getRootMessage().a().e().b(true);
            this.commandService.a((ahg)ahg2, this.command);
        });
    }

    @FXML
    void showMacAddresses(ActionEvent actionEvent) {
        aum aum22;
        Object object = "";
        for (aum aum22 : this.selector.getSelectedModules()) {
            object = (String)object + aum22.c().toString() + "\n";
        }
        Iterator iterator = new TextArea((String)object);
        aum22 = new Dialog();
        aum22.setTitle("Mac Address");
        DialogPane dialogPane = aum22.getDialogPane();
        dialogPane.setContent((Node)iterator);
        dialogPane.getButtonTypes().addAll((Object[])new ButtonType[]{ButtonType.OK});
        aum22.show();
    }

    @FXML
    void showLoginDialog(ActionEvent actionEvent) {
        bfo bfo2 = this.authenticationService.authClient;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("approval_prompt", "force");
        bfo2.a = bfo2.a.getAuthorizationUrlWithPKCE(hashMap);
        bfo2.webViewer.showDocument(bfo2.a.getAuthorizationUrl());
    }

    @FXML
    void setDatabaseValue(ActionEvent actionEvent) {
        Optional optional = arx.a("Set Database Value", az.a("Address", "FloatValue", "IntValue"), az.a("0x" + Integer.toHexString(this.dbAddress), this.floatVal == null ? "" : this.floatVal.toString(), this.intVal == null ? "" : this.intVal.toString())).showAndWait();
        if (!optional.isPresent()) {
            return;
        }
        List list = (List)optional.get();
        try {
            boolean bl2 = !ac.a((String)list.get(1));
            boolean bl3 = !ac.a((String)list.get(2));
            ae.a(!ac.a((String)list.get(0)), "Address must not be empty");
            ae.a(bl2 || bl3, "Expected a value field to be set.");
            ae.a(!bl2 || !bl3, "Expected only one value field to be set.");
            this.dbAddress = Integer.decode((String)list.get(0));
            this.floatVal = bl2 ? Float.valueOf(Float.parseFloat((String)list.get(1))) : null;
            this.intVal = bl3 ? Integer.decode((String)list.get(2)) : null;
            ((amw)this.command).clear();
            bun bun2 = ((amw)this.command).getRootMessage().d().d();
            bun2.b(this.dbAddress);
            if (bl2) {
                bun2.a(this.floatVal.floatValue());
            }
            if (bl3) {
                bun2.a(this.intVal);
            }
            this.selector.getSelectedAddresses().forEach(ahg2 -> this.commandService.a((ahg)ahg2, this.command));
            return;
        }
        catch (Exception exception) {
            Alert alert = new Alert(Alert.AlertType.ERROR);
            alert.setTitle("Error");
            alert.setHeaderText(null);
            alert.setContentText(exception.getMessage());
            alert.showAndWait();
            return;
        }
    }

    @FXML
    void initialize() {
        assert (this.bootButton != null) : "fx:id=\"bootButton\" was not injected: check your FXML file 'bootloader.fxml'.";
        assert (this.calibrateCurrentButton != null) : "fx:id=\"calibrateCurrentButton\" was not injected: check your FXML file 'bootloader.fxml'.";
        assert (this.taskProgressView != null) : "fx:id=\"taskProgressView\" was not injected: check your FXML file 'bootloader.fxml'.";
        assert (this.moduleTree != null) : "fx:id=\"moduleTree\" was not injected: check your FXML file 'bootloader.fxml'.";
        assert (this.typeTree != null) : "fx:id=\"typeTree\" was not injected: check your FXML file 'bootloader.fxml'.";
        assert (this.programRawButton != null) : "fx:id=\"programButton\" was not injected: check your FXML file 'bootloader.fxml'.";
        assert (this.programEncryptingButton != null) : "fx:id=\"programButton\" was not injected: check your FXML file 'bootloader.fxml'.";
        assert (this.updateApplicationButton != null) : "fx:id=\"programButton\" was not injected: check your FXML file 'bootloader.fxml'.";
        assert (this.eraseApplicationButton != null) : "fx:id=\"eraseApplicationButton\" was not injected: check your FXML file 'bootloader.fxml'.";
        assert (this.stopButton != null) : "fx:id=\"stopButton\" was not injected: check your FXML file 'bootloader.fxml'.";
        assert (this.calibratePositionButton != null) : "fx:id=\"calibratePositionButton\" was not injected: check your FXML file 'bootloader.fxml'.";
        assert (this.eraseDatabaseButton != null) : "fx:id=\"eraseDatabaseButton\" was not injected: check your FXML file 'bootloader.fxml'.";
        assert (this.resetButton != null) : "fx:id=\"resetButton\" was not injected: check your FXML file 'bootloader.fxml'.";
        assert (this.saveAllPartitionsButton != null) : "fx:id=\"saveAllPartitionsButton\" was not injected: check your FXML file 'bootloader.fxml'.";
        assert (this.saveApplicationButton != null) : "fx:id=\"saveApplicationButton\" was not injected: check your FXML file 'bootloader.fxml'.";
        assert (this.saveBootloaderButton != null) : "fx:id=\"saveBootloaderButton\" was not injected: check your FXML file 'bootloader.fxml'.";
        assert (this.saveDatabaseButton != null) : "fx:id=\"saveDatabaseButton\" was not injected: check your FXML file 'bootloader.fxml'.";
        this.typeTree.setRoot(this.simpleCategoryTree.getCategoryTree());
        this.typeTree.setShowRoot(false);
        this.typeTree.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        this.moduleTreeCellFactory.d.bind((ObservableValue)this.viewSelectorFamilyName.selectedProperty());
        this.moduleTree.setCellFactory((Callback)this.moduleTreeCellFactory);
        this.moduleTree.setRoot(this.filteredFlatModuleTree.getModuleTree());
        this.moduleTree.setShowRoot(false);
        this.moduleTree.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        this.selector.setDataSource((ObservableList<TreeItem<aum>>)this.moduleTree.getSelectionModel().getSelectedItems());
        this.typeTree.getSelectionModel().getSelectedItems().addListener((ListChangeListener)new bdy(this));
        BooleanBinding booleanBinding = Bindings.createBooleanBinding(() -> !this.taskProgressView.getTasks().isEmpty(), (Observable[])new Observable[]{this.taskProgressView.getTasks()});
        this.taskProgressView.visibleProperty().bind((ObservableValue)booleanBinding);
        this.bootloaderService.setTaskList(this.taskProgressView.getTasks());
        this.taskProgressView.getTasks().addListener(change -> {
            while (change.next()) {
                if (!change.wasRemoved()) continue;
                block5: for (Task task : change.getRemoved()) {
                    if (task.getState() != Worker.State.FAILED) {
                        apo.i("hebi.bootloader.showSuccessNotifications");
                    }
                    Notifications notifications = Notifications.create().position(Pos.BOTTOM_RIGHT).hideAfter(Duration.INDEFINITE).owner(this.taskProgressView).title(task.getTitle()).text(task.getMessage());
                    switch (task.getState()) {
                        case FAILED: {
                            notifications.showError();
                            continue block5;
                        }
                        case CANCELLED: {
                            notifications.showWarning();
                            continue block5;
                        }
                    }
                    notifications.showInformation();
                }
            }
        });
        BooleanBinding booleanBinding2 = booleanBinding.or((ObservableBooleanValue)this.selector.selectionEmpty());
        BooleanBinding booleanBinding3 = booleanBinding.or((ObservableBooleanValue)this.selector.selectionSingle().not());
        BooleanBinding booleanBinding4 = this.authenticationService.cW.not();
        bdc.a((ObservableBooleanValue)booleanBinding2, new Node[]{this.bootButton, this.stopButton, this.updateApplicationButton, this.updateBootloaderButton, this.showMacAddressesButton, this.programRawButton, this.eraseApplicationButton, this.resetButton, this.calibrateCurrentButton, this.calibratePositionButton, this.calibrateEffortButton});
        bdc.a((ObservableBooleanValue)booleanBinding3, new Node[]{this.fullUpdateButton});
        bdc.a((ObservableBooleanValue)booleanBinding4.or((ObservableBooleanValue)booleanBinding2), new Node[]{this.updateBootloaderLoaderButton, this.programEncryptingButton, this.eraseDatabaseButton, this.setDatabaseValueButton, this.setBootloaderParametersButton, this.saveAllPartitionsButton, this.saveApplicationButton, this.saveDatabaseButton, this.saveBootloaderButton});
        bfp.a();
        if (!bfp.aI()) {
            this.topBar.getItems().remove((Object)this.loginButton);
            this.buttonVBox.getChildren().removeAll((Object[])new Node[]{this.programEncryptingButton, this.setBootloaderParametersButton, this.saveAllPartitionsButton, this.saveApplicationButton, this.saveDatabaseButton, this.saveBootloaderButton});
        }
        this.setBootloaderParametersButton.textProperty().bind((ObservableValue)Bindings.when((ObservableBooleanValue)this.authenticationService.cW).then("Set Key / Info (BL)").otherwise("Set Info (BL)"));
        this.interfaceChoiceService.init(this.interfaceChoiceBox);
        this.selector.addSingleSelectionChangeListener(this::bindToModule);
        this.bindToModule(axk.EMPTY_DEVICE);
    }

    private void bindToModule(aum aum2) {
        if (aum2 == null) {
            System.out.println("can't bind to null module");
            return;
        }
        aua aua2 = aum2.getInfo();
        Object object = aua2;
        att att2 = aua2.a;
        object = aua2;
        aty aty2 = ((aua)object).a;
        object = aua2;
        aui aui2 = ((aua)object).a;
        object = aua2;
        atl atl2 = ((aua)object).a;
        object = aua2;
        aud cfr_ignored_0 = ((aua)object).a;
        object = aua2;
        atv cfr_ignored_1 = ((aua)object).a;
        object = aty2;
        this.hwType.visibleProperty().bind((ObservableValue)((aty)object).q.isNotEmpty());
        object = aty2;
        this.hwType.textProperty().bind((ObservableValue)((aty)object).q);
        object = aty2;
        this.hwRevision.visibleProperty().bind((ObservableValue)((aty)object).p.isNotEmpty());
        object = aty2;
        this.hwRevision.textProperty().bind((ObservableValue)((aty)object).p);
        object = aty2;
        this.hwEceType.visibleProperty().bind((ObservableValue)((aty)object).o.isNotEmpty());
        object = aty2;
        this.hwEceType.textProperty().bind((ObservableValue)((aty)object).o);
        object = aty2;
        this.hwEceRevision.visibleProperty().bind((ObservableValue)((aty)object).n.isNotEmpty());
        object = aty2;
        this.hwEceRevision.textProperty().bind((ObservableValue)((aty)object).n);
        object = aty2;
        this.hwSerial.visibleProperty().bind((ObservableValue)((aty)object).r.isNotEmpty());
        object = aty2;
        this.hwSerial.textProperty().bind((ObservableValue)((aty)object).r);
        atl atl3 = atl2;
        object = atl3;
        object = atl2;
        DoubleBinding doubleBinding = atl3.h.divide((ObservableNumberValue)((atl)object).f).multiply(-1);
        this.hwSpringConstant.textProperty().bind((ObservableValue)doubleBinding.asString("%.3f"));
        object = att2;
        this.fwType.visibleProperty().bind((ObservableValue)((att)object).m.isNotEmpty());
        object = att2;
        this.fwType.textProperty().bind((ObservableValue)((att)object).m);
        object = att2;
        this.fwRevision.visibleProperty().bind((ObservableValue)((att)object).l.isNotEmpty());
        object = att2;
        this.fwRevision.textProperty().bind((ObservableValue)((att)object).l);
        object = att2;
        this.fwMode.visibleProperty().bind((ObservableValue)((att)object).u.isNotEqualTo((Object)ait.a));
        object = att2;
        this.fwMode.textProperty().bind((ObservableValue)((att)object).u.asString());
        object = aui2;
        this.ethMacAddress.visibleProperty().bind((ObservableValue)((aui)object).C.isNotEqualTo(xx.a));
        object = aui2;
        this.ethMacAddress.textProperty().bind((ObservableValue)((aui)object).C.asString());
        object = aui2;
        this.ethIpAddress.visibleProperty().bind((ObservableValue)((aui)object).z.isNotEqualTo((Object)xv.a));
        Observable[] observableArray = new Observable[2];
        object = aui2;
        observableArray[0] = ((aui)object).z;
        object = aui2;
        observableArray[1] = ((aui)object).A;
        this.ethIpAddress.textProperty().bind((ObservableValue)Bindings.createStringBinding(() -> {
            String string = aui2.b().toString();
            switch (aui2.a()) {
                case b: {
                    return string + " (dhcp)";
                }
                case c: {
                    return string + " (static)";
                }
            }
            return string;
        }, (Observable[])observableArray));
        object = aui2;
        this.ethNetmask.visibleProperty().bind((ObservableValue)((aui)object).E.isNotEqualTo((Object)xv.a));
        object = aui2;
        this.ethNetmask.textProperty().bind((ObservableValue)((aui)object).E.asString());
        object = aui2;
        this.ethGateway.visibleProperty().bind((ObservableValue)((aui)object).B.isNotEqualTo((Object)xv.a));
        object = aui2;
        this.ethGateway.textProperty().bind((ObservableValue)((aui)object).B.asString());
        BooleanBinding booleanBinding = this.selector.selectionMultiple().not();
        this.authenticationService.cW.not();
        object = att2;
        BooleanBinding booleanBinding2 = ((att)object).u.isNotEqualTo((Object)ait.b);
        object = att2;
        BooleanBinding booleanBinding3 = ((att)object).u.isNotEqualTo((Object)ait.c);
        bdc.a((ObservableBooleanValue)booleanBinding2.and((ObservableBooleanValue)booleanBinding), new Node[]{this.setBootloaderParametersButton});
        bdc.a((ObservableBooleanValue)booleanBinding3.and((ObservableBooleanValue)booleanBinding), new Node[]{this.setApplicationParametersButton});
    }

    @PostConstruct
    public void postConstruct() {
        this.lookupService.setFrequency(5.0);
        BootloaderPresenter bootloaderPresenter = this;
        this.command = bootloaderPresenter.commandService.b();
    }
}

