/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.gui.controls;

import atlantafx.base.controls.CustomTextField;
import com.jfoenix.controls.JFXButton;
import de.jensd.fx.glyphs.fontawesome.FontAwesomeIcon;
import de.jensd.fx.glyphs.fontawesome.FontAwesomeIconView;
import java.text.DecimalFormat;
import java.util.function.DoubleSupplier;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.binding.ObjectBinding;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableStringValue;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.HBox;
import javafx.scene.text.Text;
import lombok.Generated;
import lombok.Lombok;
import us.hebi.gui.controls.Css;
import us.hebi.gui.controls.Observables;
import us.hebi.gui.controls.TextFieldUtil;
import us.hebi.gui.controls.TextUtil;

public class HDoubleInputField
extends HBox {
    private final BooleanProperty allowInf = new SimpleBooleanProperty(false);
    private final DoubleProperty tolerance = new SimpleDoubleProperty(0.001);
    private final StringProperty format = new SimpleStringProperty("#0.###");
    private final ObjectBinding<DecimalFormat> decimalFormat = TextUtil.createDecimalFormat((ObservableStringValue)this.format);
    private final DoubleProperty feedbackValue = new SimpleDoubleProperty(Double.NaN);
    private final DoubleProperty inputValue = new SimpleDoubleProperty(Double.NaN);
    private final BooleanProperty inputValid = new SimpleBooleanProperty(false);
    Text title = new Text();
    CustomTextField textInput = new CustomTextField();
    StringProperty text = this.textInput.textProperty();
    BooleanProperty showTarget = new SimpleBooleanProperty(false);
    DoubleSupplier targetSupplier = this::getFeedbackValue;
    Text valueField = new Text();
    Button targetButton = null;
    private final BooleanBinding inputDifferent = Bindings.createBooleanBinding(() -> !TextUtil.isNullOrBlank(this.textInput.getText()) && Math.abs(this.getFeedbackValue() - this.getInputValue()) > this.getTolerance(), (Observable[])new Observable[]{this.textInput.textProperty(), this.feedbackValue, this.inputValue, this.tolerance});

    public HDoubleInputField() {
        this.valueField.textProperty().bind((ObservableValue)TextUtil.asFormattedString((ReadOnlyDoubleProperty)this.feedbackValue, this.format));
        BooleanBinding booleanBinding = Bindings.createBooleanBinding(() -> Double.isNaN(this.getFeedbackValue()), (Observable[])new Observable[]{this.feedbackValue});
        this.valueField.visibleProperty().bind((ObservableValue)booleanBinding.not());
        this.textInput.disableProperty().bind((ObservableValue)booleanBinding);
        this.textInput.setPrefWidth(90.0);
        this.textInput.setPrefHeight(25.0);
        this.title.setWrappingWidth(100.0);
        this.valueField.setWrappingWidth(50.0);
        this.setSpacing(5.0);
        this.setAlignment(Pos.CENTER_LEFT);
        TextFieldUtil.setupClearButtonField(this.textInput);
        this.textInput.textProperty().addListener((observableValue, string, string2) -> this.setInputValue(TextUtil.parseDouble(string2)));
        this.inputValid.bind((ObservableValue)Bindings.createBooleanBinding(() -> {
            double d2 = this.getInputValue();
            if (Double.isNaN(d2)) {
                return false;
            }
            if (Double.isInfinite(d2)) {
                return this.isAllowInf();
            }
            return true;
        }, (Observable[])new Observable[]{this.inputValue, this.allowInf}));
        this.showTarget.addListener((observableValue, bl2, bl3) -> {
            if (bl3.booleanValue() && this.targetButton == null) {
                this.targetButton = new JFXButton();
                this.targetButton.setTooltip(new Tooltip("Populate field with current feedback value"));
                FontAwesomeIconView fontAwesomeIconView = new FontAwesomeIconView(FontAwesomeIcon.CROSSHAIRS);
                this.targetButton.setGraphic((Node)fontAwesomeIconView);
                this.targetButton.setOnAction(actionEvent -> this.textInput.setText(((DecimalFormat)this.decimalFormat.get()).format(this.targetSupplier.getAsDouble())));
                this.targetButton.disableProperty().bind((ObservableValue)booleanBinding);
                Css.addClass(this.targetButton, "sw-Button_Edit");
                Css.addClass(fontAwesomeIconView, "sw-Icon_Grey");
                this.getChildren().add(1, (Object)this.targetButton);
                this.targetButton.managedProperty().bind((ObservableValue)this.targetButton.visibleProperty());
            } else {
                this.targetButton.setVisible(bl3.booleanValue());
            }
            this.title.setWrappingWidth(bl3 != false ? 85.0 : 100.0);
        });
        Observables.runOnChange(() -> {
            if (TextUtil.isNullOrBlank(this.textInput.getText())) {
                this.pseudoClassStateChanged(Css.CLASS_ERROR, false);
                this.pseudoClassStateChanged(Css.CLASS_WARNING, false);
            } else if (!this.isInputValid()) {
                this.pseudoClassStateChanged(Css.CLASS_ERROR, true);
                this.pseudoClassStateChanged(Css.CLASS_WARNING, false);
            } else if (this.isInputDifferent().booleanValue()) {
                this.pseudoClassStateChanged(Css.CLASS_ERROR, false);
                this.pseudoClassStateChanged(Css.CLASS_WARNING, true);
            } else {
                this.pseudoClassStateChanged(Css.CLASS_ERROR, false);
                this.pseudoClassStateChanged(Css.CLASS_WARNING, false);
            }
        }, new ObservableValue[]{this.textInput.textProperty(), this.inputValid, this.inputDifferent});
        Css.addClass(this.title, "field-name");
        Css.addClass(this.textInput, "text-input");
        Css.addClass(this.valueField, "feedback-text");
        this.getChildren().addAll((Object[])new Node[]{this.title, this.textInput, this.valueField});
        Css.addClass(this, "double-input-field");
    }

    public void setTextNullable(Number number) {
        if (number != null) {
            this.setText(String.valueOf(number));
        }
    }

    public String getTitle() {
        return this.title.getText();
    }

    public StringProperty titleProperty() {
        return this.title.textProperty();
    }

    public void setTitle(String string) {
        this.title.setText(string);
    }

    public boolean isAllowInf() {
        return this.allowInf.get();
    }

    public BooleanProperty allowInfProperty() {
        return this.allowInf;
    }

    public void setAllowInf(boolean bl2) {
        this.allowInf.set(bl2);
    }

    public double getTolerance() {
        return this.tolerance.get();
    }

    public DoubleProperty toleranceProperty() {
        return this.tolerance;
    }

    public void setTolerance(double d2) {
        this.tolerance.set(d2);
    }

    public String getFormat() {
        return (String)this.format.get();
    }

    public StringProperty formatProperty() {
        return this.format;
    }

    public void setFormat(String string) {
        this.format.set((Object)string);
    }

    public double getFeedbackValue() {
        return this.feedbackValue.get();
    }

    public DoubleProperty feedbackValueProperty() {
        return this.feedbackValue;
    }

    public void setFeedbackValue(double d2) {
        this.feedbackValue.set(d2);
    }

    public Tooltip getTooltip() {
        return this.textInput.getTooltip();
    }

    public ObjectProperty<Tooltip> tooltipProperty() {
        return this.textInput.tooltipProperty();
    }

    public void setTooltip(Tooltip tooltip) {
        this.textInput.setTooltip(tooltip);
    }

    public String getText() {
        return (String)this.text.get();
    }

    public StringProperty textProperty() {
        return this.text;
    }

    public void setText(String string) {
        this.text.set((Object)string);
    }

    public boolean getShowTarget() {
        return this.showTarget.get();
    }

    public BooleanProperty showTargetProperty() {
        return this.showTarget;
    }

    public void setShowTarget(boolean bl2) {
        this.showTarget.set(bl2);
    }

    public boolean isInputValid() {
        return this.inputValid.get();
    }

    public ReadOnlyBooleanProperty inputValidProperty() {
        return this.inputValid;
    }

    public Button getTargetButton() {
        Lombok.checkNotNull((Object)this.targetButton, (String)"Target button is not initialized");
        return this.targetButton;
    }

    public double getInputValue() {
        return this.inputValue.get();
    }

    public DoubleProperty inputValueProperty() {
        return this.inputValue;
    }

    public void setInputValue(double d2) {
        this.inputValue.set(d2);
    }

    public Boolean isInputDifferent() {
        return this.inputDifferent.get();
    }

    public BooleanBinding inputDifferentProperty() {
        return this.inputDifferent;
    }

    @Generated
    public CustomTextField getTextInput() {
        return this.textInput;
    }

    @Generated
    public void setTargetSupplier(DoubleSupplier doubleSupplier) {
        this.targetSupplier = doubleSupplier;
    }
}

