/*
 * Decompiled with CFR 0.152.
 */
package org.controlsfx.glyphfont;

import java.util.Collection;
import java.util.Optional;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.ObservableList;
import javafx.scene.control.Label;
import javafx.scene.paint.Color;
import javafx.scene.paint.CycleMethod;
import javafx.scene.paint.LinearGradient;
import javafx.scene.paint.Paint;
import javafx.scene.paint.Stop;
import javafx.scene.text.Font;
import org.controlsfx.glyphfont.GlyphFont;
import org.controlsfx.glyphfont.GlyphFontRegistry;
import org.controlsfx.tools.Duplicatable;

public class Glyph
extends Label
implements Duplicatable<Glyph> {
    public static final String DEFAULT_CSS_CLASS = "glyph-font";
    public static final String STYLE_GRADIENT = "gradient";
    public static final String STYLE_HOVER_EFFECT = "hover-effect";
    private final ObjectProperty<Object> icon = new SimpleObjectProperty();

    public static Glyph create(String string) {
        String[] stringArray = string.split("\\|");
        return new Glyph(stringArray[0], stringArray[1]);
    }

    public Glyph() {
        this.getStyleClass().add((Object)DEFAULT_CSS_CLASS);
        this.icon.addListener(observable -> this.updateIcon());
        this.fontProperty().addListener(observable -> this.updateIcon());
    }

    public Glyph(String string, char c2) {
        this();
        this.setFontFamily(string);
        this.setTextUnicode(c2);
    }

    public Glyph(String string, Object object) {
        this();
        this.setFontFamily(string);
        this.setIcon(object);
    }

    public Glyph fontFamily(String string) {
        this.setFontFamily(string);
        return this;
    }

    public Glyph color(Color color) {
        this.setColor(color);
        return this;
    }

    public Glyph size(double d2) {
        this.setFontSize(d2);
        return this;
    }

    public Glyph sizeFactor(int n2) {
        Optional.ofNullable(GlyphFontRegistry.font(this.getFont().getFamily())).ifPresent(glyphFont -> this.setFontSize(glyphFont.getDefaultSize() * (double)(n2 < 1 ? 1 : n2)));
        return this;
    }

    public Glyph useHoverEffect() {
        this.getStyleClass().add((Object)STYLE_HOVER_EFFECT);
        return this;
    }

    public Glyph useGradientEffect() {
        if (this.getTextFill() instanceof Color) {
            Color color = (Color)this.getTextFill();
            Stop[] stopArray = new Stop[]{new Stop(0.0, Color.BLACK), new Stop(1.0, color)};
            LinearGradient linearGradient = new LinearGradient(0.0, 0.0, 1.0, 0.0, true, CycleMethod.NO_CYCLE, stopArray);
            this.setTextFill((Paint)linearGradient);
        }
        this.getStyleClass().add((Object)STYLE_GRADIENT);
        return this;
    }

    @Override
    public Glyph duplicate() {
        final Paint paint = this.getTextFill();
        final Object object = this.getIcon();
        final ObservableList observableList = this.getStyleClass();
        return new Glyph(){
            {
                this.setIcon(object);
                this.setTextFill(paint);
                this.getStyleClass().addAll((Collection)observableList);
            }
        }.fontFamily(this.getFontFamily()).size(this.getFontSize());
    }

    public String getUserAgentStylesheet() {
        return Glyph.class.getResource("glyphfont.css").toExternalForm();
    }

    public void setFontFamily(String string) {
        if (!this.getFont().getFamily().equals(string)) {
            Optional.ofNullable(GlyphFontRegistry.font(string)).ifPresent(glyphFont -> {
                glyphFont.ensureFontIsLoaded();
                Font font = Font.font((String)string, (double)glyphFont.getDefaultSize());
                this.setFont(font);
            });
        }
    }

    public String getFontFamily() {
        return this.getFont().getFamily();
    }

    public void setFontSize(double d2) {
        Font font = Font.font((String)this.getFont().getFamily(), (double)d2);
        this.setFont(font);
    }

    public double getFontSize() {
        return this.getFont().getSize();
    }

    public void setColor(Color color) {
        this.setTextFill((Paint)color);
    }

    public ObjectProperty<Object> iconProperty() {
        return this.icon;
    }

    public void setIcon(Object object) {
        this.icon.set(object);
    }

    public Object getIcon() {
        return this.icon.get();
    }

    private void updateIcon() {
        Object object = this.getIcon();
        if (object != null) {
            if (object instanceof Character) {
                this.setTextUnicode(((Character)object).charValue());
            } else {
                GlyphFont glyphFont = GlyphFontRegistry.font(this.getFontFamily());
                if (glyphFont != null) {
                    String string = object.toString();
                    Character c2 = glyphFont.getCharacter(string);
                    if (c2 != null) {
                        this.setTextUnicode(c2.charValue());
                    } else {
                        this.setText(string);
                    }
                }
            }
        }
    }

    private void setTextUnicode(char c2) {
        this.setText(String.valueOf(c2));
    }
}

