/*
 * Decompiled with CFR 0.152.
 */
package org.agrona.io;

import java.io.OutputStream;
import java.util.Objects;
import org.agrona.MutableDirectBuffer;

public class ExpandableDirectBufferOutputStream
extends OutputStream {
    private MutableDirectBuffer buffer;
    private int offset;
    private int position;

    public ExpandableDirectBufferOutputStream() {
    }

    public ExpandableDirectBufferOutputStream(MutableDirectBuffer mutableDirectBuffer) {
        this.wrap(mutableDirectBuffer, 0);
    }

    public ExpandableDirectBufferOutputStream(MutableDirectBuffer mutableDirectBuffer, int n2) {
        this.wrap(mutableDirectBuffer, n2);
    }

    public void wrap(MutableDirectBuffer mutableDirectBuffer) {
        this.wrap(mutableDirectBuffer, 0);
    }

    public void wrap(MutableDirectBuffer mutableDirectBuffer, int n2) {
        Objects.requireNonNull(mutableDirectBuffer, "Buffer must not be null");
        if (!mutableDirectBuffer.isExpandable()) {
            throw new IllegalStateException("buffer must be expandable.");
        }
        this.buffer = mutableDirectBuffer;
        this.offset = n2;
        this.position = 0;
    }

    public int position() {
        return this.position;
    }

    public int offset() {
        return this.offset;
    }

    public MutableDirectBuffer buffer() {
        return this.buffer;
    }

    @Override
    public void write(int n2) {
        this.buffer.putByte(this.offset + this.position, (byte)n2);
        ++this.position;
    }

    @Override
    public void write(byte[] byArray, int n2, int n3) {
        this.buffer.putBytes(this.offset + this.position, byArray, n2, n3);
        this.position += n3;
    }

    @Override
    public void close() {
    }
}

