/*
 * Decompiled with CFR 0.152.
 */
package org.agrona.concurrent;

import java.util.Collection;
import java.util.function.Consumer;
import org.agrona.UnsafeAccess;
import org.agrona.concurrent.AbstractConcurrentArrayQueue;

public class OneToOneConcurrentArrayQueue<E>
extends AbstractConcurrentArrayQueue<E> {
    public OneToOneConcurrentArrayQueue(int n2) {
        super(n2);
    }

    @Override
    public boolean offer(E e2) {
        if (null == e2) {
            throw new NullPointerException("Null is not a valid element");
        }
        long l2 = this.tail;
        long l3 = this.headCache;
        int n2 = this.capacity;
        long l4 = l3 + (long)n2;
        if (l2 >= l4) {
            l3 = this.head;
            l4 = l3 + (long)n2;
            if (l2 >= l4) {
                return false;
            }
            this.headCache = l3;
        }
        long l5 = OneToOneConcurrentArrayQueue.sequenceToBufferOffset(l2, n2 - 1);
        UnsafeAccess.UNSAFE.putOrderedObject(this.buffer, l5, e2);
        UnsafeAccess.UNSAFE.putOrderedLong(this, TAIL_OFFSET, l2 + 1L);
        return true;
    }

    @Override
    public E poll() {
        Object[] objectArray = this.buffer;
        long l2 = this.head;
        long l3 = OneToOneConcurrentArrayQueue.sequenceToBufferOffset(l2, this.capacity - 1);
        Object object = UnsafeAccess.UNSAFE.getObjectVolatile(objectArray, l3);
        if (null != object) {
            UnsafeAccess.UNSAFE.putOrderedObject(objectArray, l3, null);
            UnsafeAccess.UNSAFE.putOrderedLong(this, HEAD_OFFSET, l2 + 1L);
        }
        return (E)object;
    }

    @Override
    public int drain(Consumer<E> consumer) {
        return this.drain(consumer, (int)(this.tail - this.head));
    }

    @Override
    public int drain(Consumer<E> consumer, int n2) {
        long l2;
        Object object;
        long l3;
        Object[] objectArray = this.buffer;
        long l4 = this.capacity - 1;
        long l5 = l3 = this.head;
        long l6 = l5 + (long)n2;
        while (l5 < l6 && null != (object = UnsafeAccess.UNSAFE.getObjectVolatile(objectArray, l2 = OneToOneConcurrentArrayQueue.sequenceToBufferOffset(l5, l4)))) {
            UnsafeAccess.UNSAFE.putOrderedObject(objectArray, l2, null);
            UnsafeAccess.UNSAFE.putOrderedLong(this, HEAD_OFFSET, ++l5);
            consumer.accept(object);
        }
        return (int)(l5 - l3);
    }

    @Override
    public int drainTo(Collection<? super E> collection, int n2) {
        long l2;
        Object object;
        int n3;
        Object[] objectArray = this.buffer;
        long l3 = this.capacity - 1;
        long l4 = this.head;
        for (n3 = 0; n3 < n2 && null != (object = UnsafeAccess.UNSAFE.getObjectVolatile(objectArray, l2 = OneToOneConcurrentArrayQueue.sequenceToBufferOffset(l4, l3))); ++n3) {
            UnsafeAccess.UNSAFE.putOrderedObject(objectArray, l2, null);
            UnsafeAccess.UNSAFE.putOrderedLong(this, HEAD_OFFSET, ++l4);
            collection.add(object);
        }
        return n3;
    }
}

