/*
 * Decompiled with CFR 0.152.
 */
package org.agrona.collections;

import java.util.AbstractQueue;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Consumer;
import java.util.function.LongConsumer;
import org.agrona.BitUtil;

public class LongArrayQueue
extends AbstractQueue<Long> {
    public static final long DEFAULT_NULL_VALUE = Long.MIN_VALUE;
    public static final int MIN_CAPACITY = 8;
    private final boolean shouldAvoidAllocation;
    private int head;
    private int tail;
    private final long nullValue;
    private long[] elements;
    private LongIterator iterator;

    public LongArrayQueue() {
        this(8, Long.MIN_VALUE, true);
    }

    public LongArrayQueue(long l2) {
        this(8, l2, true);
    }

    public LongArrayQueue(int n2, long l2) {
        this(n2, l2, true);
    }

    public LongArrayQueue(int n2, long l2, boolean bl2) {
        this.nullValue = l2;
        this.shouldAvoidAllocation = bl2;
        if (n2 < 8) {
            throw new IllegalArgumentException("initial capacity < MIN_INITIAL_CAPACITY : " + n2);
        }
        int n3 = BitUtil.findNextPositivePowerOfTwo(n2);
        if (n3 < 8) {
            throw new IllegalArgumentException("invalid initial capacity: " + n2);
        }
        this.elements = new long[n3];
        Arrays.fill(this.elements, l2);
    }

    public long nullValue() {
        return this.nullValue;
    }

    public int capacity() {
        return this.elements.length;
    }

    @Override
    public int size() {
        return this.tail - this.head & this.elements.length - 1;
    }

    @Override
    public boolean isEmpty() {
        return this.head == this.tail;
    }

    @Override
    public void clear() {
        if (this.head != this.tail) {
            Arrays.fill(this.elements, this.nullValue);
            this.head = 0;
            this.tail = 0;
        }
    }

    @Override
    public boolean offer(Long l2) {
        return this.offerLong(l2);
    }

    public boolean offerLong(long l2) {
        if (this.nullValue == l2) {
            throw new NullPointerException();
        }
        this.elements[this.tail] = l2;
        this.tail = this.tail + 1 & this.elements.length - 1;
        if (this.tail == this.head) {
            this.increaseCapacity();
        }
        return true;
    }

    @Override
    public boolean add(Long l2) {
        return this.offerLong(l2);
    }

    public boolean addLong(long l2) {
        return this.offerLong(l2);
    }

    @Override
    public Long peek() {
        long l2 = this.elements[this.head];
        return l2 == this.nullValue ? null : Long.valueOf(l2);
    }

    public long peekLong() {
        return this.elements[this.head];
    }

    @Override
    public Long poll() {
        long l2 = this.pollLong();
        return l2 == this.nullValue ? null : Long.valueOf(l2);
    }

    public long pollLong() {
        long l2 = this.elements[this.head];
        if (this.nullValue == l2) {
            return this.nullValue;
        }
        this.elements[this.head] = this.nullValue;
        this.head = this.head + 1 & this.elements.length - 1;
        return l2;
    }

    @Override
    public Long remove() {
        long l2 = this.pollLong();
        if (this.nullValue == l2) {
            throw new NoSuchElementException();
        }
        return l2;
    }

    @Override
    public Long element() {
        long l2 = this.elements[this.head];
        if (this.nullValue == l2) {
            throw new NoSuchElementException();
        }
        return l2;
    }

    public long elementLong() {
        long l2 = this.elements[this.head];
        if (this.nullValue == l2) {
            throw new NoSuchElementException();
        }
        return l2;
    }

    public long removeLong() {
        long l2 = this.pollLong();
        if (this.nullValue == l2) {
            throw new NoSuchElementException();
        }
        return l2;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('[');
        int n2 = this.head;
        while (n2 != this.tail) {
            stringBuilder.append(this.elements[n2]).append(", ");
            n2 = n2 + 1 & this.elements.length - 1;
        }
        if (stringBuilder.length() > 1) {
            stringBuilder.setLength(stringBuilder.length() - 2);
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    @Override
    public void forEach(Consumer<? super Long> consumer) {
        int n2 = this.head;
        while (n2 != this.tail) {
            consumer.accept((Long)this.elements[n2]);
            n2 = n2 + 1 & this.elements.length - 1;
        }
    }

    public void forEachLong(LongConsumer longConsumer) {
        int n2 = this.head;
        while (n2 != this.tail) {
            longConsumer.accept(this.elements[n2]);
            n2 = n2 + 1 & this.elements.length - 1;
        }
    }

    public LongIterator iterator() {
        LongIterator longIterator = this.iterator;
        if (null == longIterator) {
            longIterator = new LongIterator();
            if (this.shouldAvoidAllocation) {
                this.iterator = longIterator;
            }
        }
        return longIterator.reset();
    }

    private void increaseCapacity() {
        int n2 = this.head;
        int n3 = this.elements.length;
        int n4 = n3 - n2;
        int n5 = n3 << 1;
        if (n5 < 8) {
            throw new IllegalStateException("max capacity reached");
        }
        long[] lArray = new long[n5];
        Arrays.fill(lArray, n3, n5, this.nullValue);
        System.arraycopy(this.elements, n2, lArray, 0, n4);
        System.arraycopy(this.elements, 0, lArray, n4, n2);
        this.elements = lArray;
        this.head = 0;
        this.tail = n3;
    }

    public final class LongIterator
    implements Iterator<Long> {
        private int index;

        LongIterator reset() {
            this.index = LongArrayQueue.this.head;
            return this;
        }

        @Override
        public boolean hasNext() {
            return this.index != LongArrayQueue.this.tail;
        }

        @Override
        public Long next() {
            return this.nextValue();
        }

        public long nextValue() {
            if (this.index == LongArrayQueue.this.tail) {
                throw new NoSuchElementException();
            }
            long l2 = LongArrayQueue.this.elements[this.index];
            this.index = this.index + 1 & LongArrayQueue.this.elements.length - 1;
            return l2;
        }
    }
}

