/*
 * Decompiled with CFR 0.152.
 */
package org.agrona;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.net.URI;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import org.agrona.AsciiEncoding;
import org.agrona.PropertyAction;

public final class SystemUtil {
    public static final long PID_NOT_FOUND = 0L;
    public static final String NULL_PROPERTY_VALUE = "@null";
    private static final String SUN_PID_PROP_NAME = "sun.java.launcher.pid";
    private static final long MAX_G_VALUE = 0x1FFFFFFFFL;
    private static final long MAX_M_VALUE = 0x7FFFFFFFFFFL;
    private static final long MAX_K_VALUE = 9007199254739968L;
    private static final String OS_NAME = System.getProperty("os.name").toLowerCase();
    private static final String OS_ARCH = System.getProperty("os.arch", "unknown");
    private static final long PID = ProcessHandle.current().pid();

    private SystemUtil() {
    }

    public static String osName() {
        return OS_NAME;
    }

    public static String osArch() {
        return OS_ARCH;
    }

    public static long getPid() {
        return PID;
    }

    public static boolean isWindows() {
        return OS_NAME.startsWith("win");
    }

    public static boolean isLinux() {
        return OS_NAME.contains("linux");
    }

    public static boolean isX64Arch() {
        return SystemUtil.isX64Arch(OS_ARCH);
    }

    public static boolean isDebuggerAttached() {
        RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
        for (String string : runtimeMXBean.getInputArguments()) {
            if (!string.contains("-agentlib:jdwp")) continue;
            return true;
        }
        return false;
    }

    public static String tmpDirName() {
        Object object = System.getProperty("java.io.tmpdir");
        if (!((String)object).endsWith(File.separator)) {
            object = (String)object + File.separator;
        }
        return object;
    }

    public static String threadDump() {
        StringBuilder stringBuilder = new StringBuilder();
        SystemUtil.threadDump(stringBuilder);
        return stringBuilder.toString();
    }

    public static void threadDump(StringBuilder stringBuilder) {
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        for (ThreadInfo threadInfo : threadMXBean.getThreadInfo(threadMXBean.getAllThreadIds(), Integer.MAX_VALUE)) {
            if (null == threadInfo) continue;
            stringBuilder.append('\"').append(threadInfo.getThreadName()).append("\": ").append((Object)threadInfo.getThreadState());
            for (StackTraceElement stackTraceElement : threadInfo.getStackTrace()) {
                stringBuilder.append("\n    at ").append(stackTraceElement.toString());
            }
            stringBuilder.append("\n\n");
        }
    }

    public static void loadPropertiesFile(String string) {
        SystemUtil.loadPropertiesFile(PropertyAction.REPLACE, string);
    }

    public static void loadPropertiesFile(PropertyAction propertyAction, String string) {
        InputStream inputStream;
        Object object;
        URL uRL = ClassLoader.getSystemClassLoader().getResource(string);
        if (null != uRL) {
            try {
                object = uRL.openStream();
                try {
                    SystemUtil.loadProperties(propertyAction, (InputStream)object);
                }
                finally {
                    if (object != null) {
                        ((InputStream)object).close();
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (((File)(object = new File(string))).exists()) {
            try {
                inputStream = Files.newInputStream(((File)object).toPath(), new OpenOption[0]);
                try {
                    SystemUtil.loadProperties(propertyAction, inputStream);
                }
                finally {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            inputStream = new URI(string).toURL().openStream();
            try {
                SystemUtil.loadProperties(propertyAction, inputStream);
            }
            finally {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void loadPropertiesFiles(String ... stringArray) {
        SystemUtil.loadPropertiesFiles(PropertyAction.REPLACE, stringArray);
    }

    public static void loadPropertiesFiles(PropertyAction propertyAction, String ... stringArray) {
        for (String string : stringArray) {
            SystemUtil.loadPropertiesFile(propertyAction, string);
        }
    }

    public static String getProperty(String string) {
        String string2 = System.getProperty(string);
        return NULL_PROPERTY_VALUE.equals(string2) ? null : string2;
    }

    public static String getProperty(String string, String string2) {
        String string3 = System.getProperty(string);
        if (NULL_PROPERTY_VALUE.equals(string3)) {
            return null;
        }
        return null == string3 ? string2 : string3;
    }

    public static int getSizeAsInt(String string, int n2) {
        String string2 = System.getProperty(string);
        if (string2 != null) {
            long l2 = SystemUtil.parseSize(string, string2);
            if (l2 < 0L || l2 > Integer.MAX_VALUE) {
                throw new NumberFormatException(string + " must positive and less than Integer.MAX_VALUE: " + l2);
            }
            return (int)l2;
        }
        return n2;
    }

    public static long getSizeAsLong(String string, long l2) {
        String string2 = System.getProperty(string);
        if (string2 != null) {
            long l3 = SystemUtil.parseSize(string, string2);
            if (l3 < 0L) {
                throw new NumberFormatException(string + " must be positive: " + l3);
            }
            return l3;
        }
        return l2;
    }

    public static long parseSize(String string, String string2) {
        int n2 = string2.length() - 1;
        char c2 = string2.charAt(n2);
        if (Character.isDigit(c2)) {
            return Long.parseLong(string2);
        }
        long l2 = AsciiEncoding.parseLongAscii(string2, 0, n2);
        switch (c2) {
            case 'K': 
            case 'k': {
                if (l2 > 9007199254739968L) {
                    throw new NumberFormatException(string + " would overflow a long: " + string2);
                }
                return l2 * 1024L;
            }
            case 'M': 
            case 'm': {
                if (l2 > 0x7FFFFFFFFFFL) {
                    throw new NumberFormatException(string + " would overflow a long: " + string2);
                }
                return l2 * 1024L * 1024L;
            }
            case 'G': 
            case 'g': {
                if (l2 > 0x1FFFFFFFFL) {
                    throw new NumberFormatException(string + " would overflow a long: " + string2);
                }
                return l2 * 1024L * 1024L * 1024L;
            }
        }
        throw new NumberFormatException(string + ": " + string2 + " should end with: k, m, or g.");
    }

    public static long getDurationInNanos(String string, long l2) {
        String string2 = System.getProperty(string);
        if (string2 != null) {
            long l3 = SystemUtil.parseDuration(string, string2);
            if (l3 < 0L) {
                throw new NumberFormatException(string + " must be positive: " + l3);
            }
            return l3;
        }
        return l2;
    }

    public static long parseDuration(String string, String string2) {
        char c2 = string2.charAt(string2.length() - 1);
        if (Character.isDigit(c2)) {
            return Long.parseLong(string2);
        }
        if (c2 != 's' && c2 != 'S') {
            throw new NumberFormatException(string + ": " + string2 + " should end with: s, ms, us, or ns.");
        }
        char c3 = string2.charAt(string2.length() - 2);
        if (Character.isDigit(c3)) {
            long l2 = AsciiEncoding.parseLongAscii(string2, 0, string2.length() - 1);
            return TimeUnit.SECONDS.toNanos(l2);
        }
        long l3 = AsciiEncoding.parseLongAscii(string2, 0, string2.length() - 2);
        switch (c3) {
            case 'N': 
            case 'n': {
                return l3;
            }
            case 'U': 
            case 'u': {
                return TimeUnit.MICROSECONDS.toNanos(l3);
            }
            case 'M': 
            case 'm': {
                return TimeUnit.MILLISECONDS.toNanos(l3);
            }
        }
        throw new NumberFormatException(string + ": " + string2 + " should end with: s, ms, us, or ns.");
    }

    static boolean isX64Arch(String string) {
        return string.equals("amd64") || string.equals("x86_64") || string.equals("x64");
    }

    private static void loadProperties(PropertyAction propertyAction, InputStream inputStream) throws IOException {
        Properties properties = System.getProperties();
        Properties properties2 = new Properties();
        properties2.load(inputStream);
        properties2.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(object, object2) -> {
            switch (propertyAction) {
                case PRESERVE: {
                    if (properties.containsKey(object)) break;
                    properties.setProperty((String)object, (String)object2);
                    break;
                }
                default: {
                    properties.setProperty((String)object, (String)object2);
                }
            }
        }));
    }
}

