/*
 * Decompiled with CFR 0.152.
 */
package org.agrona;

import java.io.File;
import java.io.IOException;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.IntConsumer;
import org.agrona.BufferUtil;
import org.agrona.IoUtil;
import org.agrona.LangUtil;
import org.agrona.concurrent.EpochClock;
import org.agrona.concurrent.UnsafeBuffer;

public class MarkFile
implements AutoCloseable {
    private final int versionFieldOffset;
    private final int timestampFieldOffset;
    private final File parentDir;
    private final File markFile;
    private final MappedByteBuffer mappedBuffer;
    private final UnsafeBuffer buffer;
    private final AtomicBoolean isClosed = new AtomicBoolean();

    public MarkFile(File file, String string, boolean bl2, boolean bl3, int n2, int n3, int n4, long l2, EpochClock epochClock, IntConsumer intConsumer, Consumer<String> consumer) {
        MarkFile.validateOffsets(n2, n3);
        MarkFile.ensureDirectoryExists(file, string, bl2, bl3, n2, n3, l2, epochClock, intConsumer, consumer);
        this.parentDir = file;
        this.markFile = new File(file, string);
        this.mappedBuffer = IoUtil.mapNewFile(this.markFile, n4);
        this.buffer = new UnsafeBuffer(this.mappedBuffer);
        this.versionFieldOffset = n2;
        this.timestampFieldOffset = n3;
    }

    public MarkFile(File file, boolean bl2, int n2, int n3, int n4, long l2, EpochClock epochClock, IntConsumer intConsumer, Consumer<String> consumer) {
        MarkFile.validateOffsets(n2, n3);
        this.parentDir = file.getParentFile();
        this.markFile = file;
        this.mappedBuffer = MarkFile.mapNewOrExistingMarkFile(file, bl2, n2, n3, n4, l2, epochClock, intConsumer, consumer);
        this.buffer = new UnsafeBuffer(this.mappedBuffer);
        this.versionFieldOffset = n2;
        this.timestampFieldOffset = n3;
    }

    public MarkFile(File file, String string, int n2, int n3, long l2, EpochClock epochClock, IntConsumer intConsumer, Consumer<String> consumer) {
        MarkFile.validateOffsets(n2, n3);
        this.parentDir = file;
        this.markFile = new File(file, string);
        this.mappedBuffer = MarkFile.mapExistingMarkFile(this.markFile, n2, n3, l2, epochClock, intConsumer, consumer);
        this.buffer = new UnsafeBuffer(this.mappedBuffer);
        this.versionFieldOffset = n2;
        this.timestampFieldOffset = n3;
    }

    public MarkFile(MappedByteBuffer mappedByteBuffer, int n2, int n3) {
        MarkFile.validateOffsets(n2, n3);
        this.parentDir = null;
        this.markFile = null;
        this.mappedBuffer = mappedByteBuffer;
        this.buffer = new UnsafeBuffer(mappedByteBuffer);
        this.versionFieldOffset = n2;
        this.timestampFieldOffset = n3;
    }

    public MarkFile(UnsafeBuffer unsafeBuffer, int n2, int n3) {
        MarkFile.validateOffsets(n2, n3);
        this.parentDir = null;
        this.markFile = null;
        this.mappedBuffer = null;
        this.buffer = unsafeBuffer;
        this.versionFieldOffset = n2;
        this.timestampFieldOffset = n3;
    }

    public boolean isClosed() {
        return this.isClosed.get();
    }

    @Override
    public void close() {
        if (this.isClosed.compareAndSet(false, true)) {
            BufferUtil.free(this.mappedBuffer);
        }
    }

    public void signalReady(int n2) {
        this.buffer.putIntOrdered(this.versionFieldOffset, n2);
    }

    public int versionVolatile() {
        return this.buffer.getIntVolatile(this.versionFieldOffset);
    }

    public int versionWeak() {
        return this.buffer.getInt(this.versionFieldOffset);
    }

    public void timestampOrdered(long l2) {
        this.buffer.putLongOrdered(this.timestampFieldOffset, l2);
    }

    public long timestampVolatile() {
        return this.buffer.getLongVolatile(this.timestampFieldOffset);
    }

    public long timestampWeak() {
        return this.buffer.getLong(this.timestampFieldOffset);
    }

    public void deleteDirectory(boolean bl2) {
        IoUtil.delete(this.parentDir, bl2);
    }

    public File parentDirectory() {
        return this.parentDir;
    }

    public File markFile() {
        return this.markFile;
    }

    public MappedByteBuffer mappedByteBuffer() {
        return this.mappedBuffer;
    }

    public UnsafeBuffer buffer() {
        return this.buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void ensureDirectoryExists(File file, String string, boolean bl2, boolean bl3, int n2, int n3, long l2, EpochClock epochClock, IntConsumer intConsumer, Consumer<String> consumer) {
        File file2 = new File(file, string);
        if (file.isDirectory()) {
            if (bl2 && null != consumer) {
                consumer.accept("WARNING: " + file + " already exists.");
            }
            if (!bl3) {
                int n4 = Math.min(n2, n3);
                int n5 = Math.max(n2, n3) + 8 - n4;
                MappedByteBuffer mappedByteBuffer = MarkFile.mapExistingFile(file2, consumer, n4, n5);
                try {
                    if (MarkFile.isActive(mappedByteBuffer, epochClock, l2, n2, n3, intConsumer, consumer)) {
                        throw new IllegalStateException("active Mark file detected");
                    }
                }
                finally {
                    BufferUtil.free(mappedByteBuffer);
                }
            }
            IoUtil.delete(file, false);
        }
        IoUtil.ensureDirectoryExists(file, file.toString());
    }

    public static MappedByteBuffer waitForFileMapping(Consumer<String> consumer, File file, long l2, EpochClock epochClock) {
        MappedByteBuffer mappedByteBuffer;
        block12: {
            long l3;
            FileChannel fileChannel;
            while (true) {
                fileChannel = FileChannel.open(file.toPath(), StandardOpenOption.READ, StandardOpenOption.WRITE);
                l3 = fileChannel.size();
                if (l3 >= 12L) break;
                if (epochClock.time() > l2) {
                    throw new IllegalStateException("Mark file is created but not populated");
                }
                fileChannel.close();
                MarkFile.sleep(16L);
                if (fileChannel == null) continue;
                fileChannel.close();
            }
            try {
                if (null != consumer) {
                    consumer.accept("INFO: Mark file exists: " + file);
                }
                mappedByteBuffer = fileChannel.map(FileChannel.MapMode.READ_WRITE, 0L, l3);
                if (fileChannel == null) break block12;
            }
            catch (Throwable throwable) {
                try {
                    if (fileChannel != null) {
                        try {
                            fileChannel.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException iOException) {
                    throw new IllegalStateException("cannot open mark file", iOException);
                }
            }
            fileChannel.close();
        }
        return mappedByteBuffer;
    }

    public static MappedByteBuffer mapExistingMarkFile(File file, int n2, int n3, long l2, EpochClock epochClock, IntConsumer intConsumer, Consumer<String> consumer) {
        long l3 = epochClock.time() + l2;
        while (!file.exists() || file.length() < (long)(n3 + 8)) {
            if (epochClock.time() > l3) {
                throw new IllegalStateException("Mark file not created: " + file.getName());
            }
            MarkFile.sleep(16L);
        }
        MappedByteBuffer mappedByteBuffer = MarkFile.waitForFileMapping(consumer, file, l3, epochClock);
        if (mappedByteBuffer.capacity() < n3 + 8) {
            throw new IllegalStateException("Mark file mapping is to small: capacity=" + mappedByteBuffer.capacity());
        }
        try {
            int n4;
            UnsafeBuffer unsafeBuffer = new UnsafeBuffer(mappedByteBuffer);
            while (0 == (n4 = unsafeBuffer.getIntVolatile(n2))) {
                if (epochClock.time() > l3) {
                    throw new IllegalStateException("Mark file is created but not initialised");
                }
                MarkFile.sleep(1L);
            }
            intConsumer.accept(n4);
            while (0L == unsafeBuffer.getLongVolatile(n3)) {
                if (epochClock.time() > l3) {
                    throw new IllegalStateException("no non-zero timestamp detected");
                }
                MarkFile.sleep(1L);
            }
        }
        catch (Exception exception) {
            BufferUtil.free(mappedByteBuffer);
            LangUtil.rethrowUnchecked(exception);
        }
        return mappedByteBuffer;
    }

    public static MappedByteBuffer mapNewOrExistingMarkFile(File file, boolean bl2, int n2, int n3, long l2, long l3, EpochClock epochClock, IntConsumer intConsumer, Consumer<String> consumer) {
        MappedByteBuffer mappedByteBuffer = null;
        try (FileChannel fileChannel = FileChannel.open(file.toPath(), StandardOpenOption.CREATE, StandardOpenOption.READ, StandardOpenOption.WRITE, StandardOpenOption.SPARSE);){
            mappedByteBuffer = fileChannel.map(FileChannel.MapMode.READ_WRITE, 0L, l2);
            UnsafeBuffer unsafeBuffer = new UnsafeBuffer(mappedByteBuffer);
            if (bl2) {
                if (unsafeBuffer.capacity() < n3 + 8) {
                    throw new IllegalStateException("active MarkFile too short capacity=" + unsafeBuffer.capacity() + " < " + (n3 + 8));
                }
                int n4 = unsafeBuffer.getIntVolatile(n2);
                if (null != consumer) {
                    consumer.accept("INFO: Mark file exists: " + file);
                }
                intConsumer.accept(n4);
                long l4 = unsafeBuffer.getLongVolatile(n3);
                long l5 = epochClock.time() - l4;
                if (null != consumer) {
                    consumer.accept("INFO: heartbeat timestampMs=" + l4 + " ageMs=" + l5);
                }
                if (l5 < l3) {
                    throw new IllegalStateException("active Mark file detected");
                }
            }
        }
        catch (Exception exception) {
            if (null != mappedByteBuffer) {
                BufferUtil.free(mappedByteBuffer);
            }
            throw new RuntimeException(exception);
        }
        return mappedByteBuffer;
    }

    public static MappedByteBuffer mapExistingFile(File file, Consumer<String> consumer, long l2, long l3) {
        if (file.exists()) {
            if (null != consumer) {
                consumer.accept("INFO: Mark file exists: " + file);
            }
            return IoUtil.mapExistingFile(file, file.toString(), l2, l3);
        }
        return null;
    }

    public static boolean isActive(MappedByteBuffer mappedByteBuffer, EpochClock epochClock, long l2, int n2, int n3, IntConsumer intConsumer, Consumer<String> consumer) {
        int n4;
        if (null == mappedByteBuffer) {
            return false;
        }
        UnsafeBuffer unsafeBuffer = new UnsafeBuffer(mappedByteBuffer);
        long l3 = epochClock.time() + l2;
        while (0 == (n4 = unsafeBuffer.getIntVolatile(n2))) {
            if (epochClock.time() > l3) {
                throw new IllegalStateException("Mark file is created but not initialised");
            }
            MarkFile.sleep(1L);
        }
        intConsumer.accept(n4);
        long l4 = unsafeBuffer.getLongVolatile(n3);
        long l5 = epochClock.time();
        long l6 = l5 - l4;
        if (null != consumer) {
            consumer.accept("INFO: heartbeat timestampMs=" + l4 + " ageMs=" + l6);
        }
        return l6 <= l2;
    }

    public static void ensureMarkFileLink(File file, File file2, String string) {
        String string2;
        String string3;
        try {
            string3 = file.getCanonicalPath();
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("failed to resolve canonical path for archiveDir=" + file);
        }
        try {
            string2 = file2.getParentFile().getCanonicalPath();
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("failed to resolve canonical path for markFile parent dir of " + file2);
        }
        Path path = new File(string3, string).toPath();
        if (string3.equals(string2)) {
            try {
                Files.deleteIfExists(path);
            }
            catch (IOException iOException) {
                throw new RuntimeException("failed to remove old link file", iOException);
            }
        }
        try {
            Files.write(path, string2.getBytes(StandardCharsets.US_ASCII), StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
        }
        catch (IOException iOException) {
            throw new RuntimeException("failed to create link for mark file directory", iOException);
        }
    }

    protected static void sleep(long l2) {
        try {
            Thread.sleep(l2);
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
    }

    private static void validateOffsets(int n2, int n3) {
        if (n2 + 4 > n3) {
            throw new IllegalArgumentException("version field must precede the timestamp field");
        }
    }
}

