/*
 * Decompiled with CFR 0.152.
 */
package org.HdrHistogram;

import java.nio.ByteBuffer;
import java.util.zip.DataFormatException;
import org.HdrHistogram.AbstractHistogram;
import org.HdrHistogram.ConcurrentDoubleHistogram;
import org.HdrHistogram.DoubleHistogram;
import org.HdrHistogram.PackedConcurrentHistogram;

public class PackedConcurrentDoubleHistogram
extends ConcurrentDoubleHistogram {
    public PackedConcurrentDoubleHistogram(int n2) {
        this(2L, n2);
        this.setAutoResize(true);
    }

    public PackedConcurrentDoubleHistogram(long l2, int n2) {
        this(l2, n2, PackedConcurrentHistogram.class);
    }

    public PackedConcurrentDoubleHistogram(DoubleHistogram doubleHistogram) {
        super(doubleHistogram);
    }

    PackedConcurrentDoubleHistogram(long l2, int n2, Class<? extends AbstractHistogram> clazz) {
        super(l2, n2, clazz);
    }

    PackedConcurrentDoubleHistogram(long l2, int n2, Class<? extends AbstractHistogram> clazz, AbstractHistogram abstractHistogram) {
        super(l2, n2, clazz, abstractHistogram);
    }

    public static PackedConcurrentDoubleHistogram decodeFromByteBuffer(ByteBuffer byteBuffer, long l2) {
        try {
            int n2 = byteBuffer.getInt();
            if (!PackedConcurrentDoubleHistogram.isNonCompressedDoubleHistogramCookie(n2)) {
                throw new IllegalArgumentException("The buffer does not contain a DoubleHistogram");
            }
            PackedConcurrentDoubleHistogram packedConcurrentDoubleHistogram = PackedConcurrentDoubleHistogram.constructHistogramFromBuffer(n2, byteBuffer, PackedConcurrentDoubleHistogram.class, PackedConcurrentHistogram.class, l2);
            return packedConcurrentDoubleHistogram;
        }
        catch (DataFormatException dataFormatException) {
            throw new RuntimeException(dataFormatException);
        }
    }

    public static PackedConcurrentDoubleHistogram decodeFromCompressedByteBuffer(ByteBuffer byteBuffer, long l2) throws DataFormatException {
        int n2 = byteBuffer.getInt();
        if (!PackedConcurrentDoubleHistogram.isCompressedDoubleHistogramCookie(n2)) {
            throw new IllegalArgumentException("The buffer does not contain a compressed DoubleHistogram");
        }
        PackedConcurrentDoubleHistogram packedConcurrentDoubleHistogram = PackedConcurrentDoubleHistogram.constructHistogramFromBuffer(n2, byteBuffer, PackedConcurrentDoubleHistogram.class, PackedConcurrentHistogram.class, l2);
        return packedConcurrentDoubleHistogram;
    }
}

