/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.http2;

import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import okhttp3.internal.Util;
import okhttp3.internal.http2.ErrorCode;
import okhttp3.internal.http2.Header;
import okhttp3.internal.http2.Hpack;
import okhttp3.internal.http2.Http2;
import okhttp3.internal.http2.Settings;
import okio.Buffer;
import okio.BufferedSink;

final class Http2Writer
implements Closeable {
    private static final Logger logger = Logger.getLogger(Http2.class.getName());
    private final BufferedSink sink;
    private final boolean client;
    private final Buffer hpackBuffer;
    private int maxFrameSize;
    private boolean closed;
    final Hpack.Writer hpackWriter;

    Http2Writer(BufferedSink bufferedSink, boolean bl2) {
        this.sink = bufferedSink;
        this.client = bl2;
        this.hpackBuffer = new Buffer();
        this.hpackWriter = new Hpack.Writer(this.hpackBuffer);
        this.maxFrameSize = 16384;
    }

    public synchronized void connectionPreface() throws IOException {
        if (this.closed) {
            throw new IOException("closed");
        }
        if (!this.client) {
            return;
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(Util.format(">> CONNECTION %s", Http2.CONNECTION_PREFACE.hex()));
        }
        this.sink.write(Http2.CONNECTION_PREFACE.toByteArray());
        this.sink.flush();
    }

    public synchronized void applyAndAckSettings(Settings settings) throws IOException {
        if (this.closed) {
            throw new IOException("closed");
        }
        this.maxFrameSize = settings.getMaxFrameSize(this.maxFrameSize);
        if (settings.getHeaderTableSize() != -1) {
            this.hpackWriter.setHeaderTableSizeSetting(settings.getHeaderTableSize());
        }
        int n2 = 0;
        byte by2 = 4;
        byte by3 = 1;
        int n3 = 0;
        this.frameHeader(n3, n2, by2, by3);
        this.sink.flush();
    }

    public synchronized void pushPromise(int n2, int n3, List<Header> list) throws IOException {
        if (this.closed) {
            throw new IOException("closed");
        }
        this.hpackWriter.writeHeaders(list);
        long l2 = this.hpackBuffer.size();
        int n4 = (int)Math.min((long)(this.maxFrameSize - 4), l2);
        byte by2 = 5;
        byte by3 = l2 == (long)n4 ? (byte)4 : 0;
        this.frameHeader(n2, n4 + 4, by2, by3);
        this.sink.writeInt(n3 & Integer.MAX_VALUE);
        this.sink.write(this.hpackBuffer, (long)n4);
        if (l2 > (long)n4) {
            this.writeContinuationFrames(n2, l2 - (long)n4);
        }
    }

    public synchronized void flush() throws IOException {
        if (this.closed) {
            throw new IOException("closed");
        }
        this.sink.flush();
    }

    public synchronized void synStream(boolean bl2, int n2, int n3, List<Header> list) throws IOException {
        if (this.closed) {
            throw new IOException("closed");
        }
        this.headers(bl2, n2, list);
    }

    public synchronized void synReply(boolean bl2, int n2, List<Header> list) throws IOException {
        if (this.closed) {
            throw new IOException("closed");
        }
        this.headers(bl2, n2, list);
    }

    public synchronized void headers(int n2, List<Header> list) throws IOException {
        if (this.closed) {
            throw new IOException("closed");
        }
        this.headers(false, n2, list);
    }

    public synchronized void rstStream(int n2, ErrorCode errorCode) throws IOException {
        if (this.closed) {
            throw new IOException("closed");
        }
        if (errorCode.httpCode == -1) {
            throw new IllegalArgumentException();
        }
        int n3 = 4;
        byte by2 = 3;
        byte by3 = 0;
        this.frameHeader(n2, n3, by2, by3);
        this.sink.writeInt(errorCode.httpCode);
        this.sink.flush();
    }

    public int maxDataLength() {
        return this.maxFrameSize;
    }

    public synchronized void data(boolean bl2, int n2, Buffer buffer, int n3) throws IOException {
        if (this.closed) {
            throw new IOException("closed");
        }
        byte by2 = 0;
        if (bl2) {
            by2 = (byte)(by2 | 1);
        }
        this.dataFrame(n2, by2, buffer, n3);
    }

    void dataFrame(int n2, byte by2, Buffer buffer, int n3) throws IOException {
        byte by3 = 0;
        this.frameHeader(n2, n3, by3, by2);
        if (n3 > 0) {
            this.sink.write(buffer, (long)n3);
        }
    }

    public synchronized void settings(Settings settings) throws IOException {
        if (this.closed) {
            throw new IOException("closed");
        }
        int n2 = settings.size() * 6;
        byte by2 = 4;
        byte by3 = 0;
        int n3 = 0;
        this.frameHeader(n3, n2, by2, by3);
        for (int i2 = 0; i2 < 10; ++i2) {
            if (!settings.isSet(i2)) continue;
            int n4 = i2;
            if (n4 == 4) {
                n4 = 3;
            } else if (n4 == 7) {
                n4 = 4;
            }
            this.sink.writeShort(n4);
            this.sink.writeInt(settings.get(i2));
        }
        this.sink.flush();
    }

    public synchronized void ping(boolean bl2, int n2, int n3) throws IOException {
        if (this.closed) {
            throw new IOException("closed");
        }
        int n4 = 8;
        byte by2 = 6;
        byte by3 = bl2 ? (byte)1 : 0;
        int n5 = 0;
        this.frameHeader(n5, n4, by2, by3);
        this.sink.writeInt(n2);
        this.sink.writeInt(n3);
        this.sink.flush();
    }

    public synchronized void goAway(int n2, ErrorCode errorCode, byte[] byArray) throws IOException {
        if (this.closed) {
            throw new IOException("closed");
        }
        if (errorCode.httpCode == -1) {
            throw Http2.illegalArgument("errorCode.httpCode == -1", new Object[0]);
        }
        int n3 = 8 + byArray.length;
        byte by2 = 7;
        byte by3 = 0;
        int n4 = 0;
        this.frameHeader(n4, n3, by2, by3);
        this.sink.writeInt(n2);
        this.sink.writeInt(errorCode.httpCode);
        if (byArray.length > 0) {
            this.sink.write(byArray);
        }
        this.sink.flush();
    }

    public synchronized void windowUpdate(int n2, long l2) throws IOException {
        if (this.closed) {
            throw new IOException("closed");
        }
        if (l2 == 0L || l2 > Integer.MAX_VALUE) {
            throw Http2.illegalArgument("windowSizeIncrement == 0 || windowSizeIncrement > 0x7fffffffL: %s", l2);
        }
        int n3 = 4;
        byte by2 = 8;
        byte by3 = 0;
        this.frameHeader(n2, n3, by2, by3);
        this.sink.writeInt((int)l2);
        this.sink.flush();
    }

    public void frameHeader(int n2, int n3, byte by2, byte by3) throws IOException {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(Http2.frameLog(false, n2, n3, by2, by3));
        }
        if (n3 > this.maxFrameSize) {
            throw Http2.illegalArgument("FRAME_SIZE_ERROR length > %d: %d", this.maxFrameSize, n3);
        }
        if ((n2 & Integer.MIN_VALUE) != 0) {
            throw Http2.illegalArgument("reserved bit set: %s", n2);
        }
        Http2Writer.writeMedium(this.sink, n3);
        this.sink.writeByte(by2 & 0xFF);
        this.sink.writeByte(by3 & 0xFF);
        this.sink.writeInt(n2 & Integer.MAX_VALUE);
    }

    @Override
    public synchronized void close() throws IOException {
        this.closed = true;
        this.sink.close();
    }

    private static void writeMedium(BufferedSink bufferedSink, int n2) throws IOException {
        bufferedSink.writeByte(n2 >>> 16 & 0xFF);
        bufferedSink.writeByte(n2 >>> 8 & 0xFF);
        bufferedSink.writeByte(n2 & 0xFF);
    }

    private void writeContinuationFrames(int n2, long l2) throws IOException {
        while (l2 > 0L) {
            int n3;
            this.frameHeader(n2, n3, (byte)9, (l2 -= (long)(n3 = (int)Math.min((long)this.maxFrameSize, l2))) == 0L ? (byte)4 : 0);
            this.sink.write(this.hpackBuffer, (long)n3);
        }
    }

    void headers(boolean bl2, int n2, List<Header> list) throws IOException {
        byte by2;
        if (this.closed) {
            throw new IOException("closed");
        }
        this.hpackWriter.writeHeaders(list);
        long l2 = this.hpackBuffer.size();
        int n3 = (int)Math.min((long)this.maxFrameSize, l2);
        byte by3 = 1;
        byte by4 = by2 = l2 == (long)n3 ? (byte)4 : 0;
        if (bl2) {
            by2 = (byte)(by2 | 1);
        }
        this.frameHeader(n2, n3, by3, by2);
        this.sink.write(this.hpackBuffer, (long)n3);
        if (l2 > (long)n3) {
            this.writeContinuationFrames(n2, l2 - (long)n3);
        }
    }
}

