/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.connection;

import java.io.IOException;
import java.lang.ref.Reference;
import java.net.ConnectException;
import java.net.ProtocolException;
import java.net.Proxy;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownServiceException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import okhttp3.Address;
import okhttp3.Call;
import okhttp3.CertificatePinner;
import okhttp3.Connection;
import okhttp3.ConnectionPool;
import okhttp3.ConnectionSpec;
import okhttp3.EventListener;
import okhttp3.Handshake;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.Route;
import okhttp3.internal.Internal;
import okhttp3.internal.Util;
import okhttp3.internal.Version;
import okhttp3.internal.connection.ConnectionSpecSelector;
import okhttp3.internal.connection.RouteException;
import okhttp3.internal.connection.StreamAllocation;
import okhttp3.internal.http.HttpCodec;
import okhttp3.internal.http.HttpHeaders;
import okhttp3.internal.http1.Http1Codec;
import okhttp3.internal.http2.ErrorCode;
import okhttp3.internal.http2.Http2Codec;
import okhttp3.internal.http2.Http2Connection;
import okhttp3.internal.http2.Http2Stream;
import okhttp3.internal.platform.Platform;
import okhttp3.internal.tls.OkHostnameVerifier;
import okhttp3.internal.ws.RealWebSocket;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.Okio;
import okio.Source;

public final class RealConnection
extends Http2Connection.Listener
implements Connection {
    private static final String NPE_THROW_WITH_NULL = "throw with null exception";
    private static final int MAX_TUNNEL_ATTEMPTS = 21;
    private final ConnectionPool connectionPool;
    private final Route route;
    private Socket rawSocket;
    private Socket socket;
    private Handshake handshake;
    private Protocol protocol;
    private Http2Connection http2Connection;
    private BufferedSource source;
    private BufferedSink sink;
    public boolean noNewStreams;
    public int successCount;
    public int allocationLimit = 1;
    public final List<Reference<StreamAllocation>> allocations = new ArrayList<Reference<StreamAllocation>>();
    public long idleAtNanos = Long.MAX_VALUE;

    public RealConnection(ConnectionPool connectionPool, Route route) {
        this.connectionPool = connectionPool;
        this.route = route;
    }

    public static RealConnection testConnection(ConnectionPool connectionPool, Route route, Socket socket, long l2) {
        RealConnection realConnection = new RealConnection(connectionPool, route);
        realConnection.socket = socket;
        realConnection.idleAtNanos = l2;
        return realConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(int n2, int n3, int n4, int n5, boolean bl2, Call call, EventListener eventListener) {
        Object object;
        if (this.protocol != null) {
            throw new IllegalStateException("already connected");
        }
        RouteException routeException = null;
        List<ConnectionSpec> list = this.route.address().connectionSpecs();
        ConnectionSpecSelector connectionSpecSelector = new ConnectionSpecSelector(list);
        if (this.route.address().sslSocketFactory() == null) {
            if (!list.contains(ConnectionSpec.CLEARTEXT)) {
                throw new RouteException(new UnknownServiceException("CLEARTEXT communication not enabled for client"));
            }
            object = this.route.address().url().host();
            if (!Platform.get().isCleartextTrafficPermitted((String)object)) {
                throw new RouteException(new UnknownServiceException("CLEARTEXT communication to " + (String)object + " not permitted by network security policy"));
            }
        }
        while (true) {
            try {
                if (this.route.requiresTunnel()) {
                    this.connectTunnel(n2, n3, n4, call, eventListener);
                    if (this.rawSocket == null) {
                        break;
                    }
                } else {
                    this.connectSocket(n2, n3, call, eventListener);
                }
                this.establishProtocol(connectionSpecSelector, n5, call, eventListener);
                eventListener.connectEnd(call, this.route.socketAddress(), this.route.proxy(), this.protocol);
            }
            catch (IOException iOException) {
                Util.closeQuietly(this.socket);
                Util.closeQuietly(this.rawSocket);
                this.socket = null;
                this.rawSocket = null;
                this.source = null;
                this.sink = null;
                this.handshake = null;
                this.protocol = null;
                this.http2Connection = null;
                eventListener.connectFailed(call, this.route.socketAddress(), this.route.proxy(), null, iOException);
                if (routeException == null) {
                    routeException = new RouteException(iOException);
                    continue;
                }
                routeException.addConnectException(iOException);
                if (bl2 && connectionSpecSelector.connectionFailed(iOException)) continue;
                throw routeException;
            }
            break;
        }
        if (this.route.requiresTunnel() && this.rawSocket == null) {
            object = new ProtocolException("Too many tunnel connections attempted: 21");
            throw new RouteException((IOException)object);
        }
        if (this.http2Connection != null) {
            object = this.connectionPool;
            synchronized (object) {
                this.allocationLimit = this.http2Connection.maxConcurrentStreams();
            }
        }
    }

    private void connectTunnel(int n2, int n3, int n4, Call call, EventListener eventListener) throws IOException {
        Request request = this.createTunnelRequest();
        HttpUrl httpUrl = request.url();
        for (int i2 = 0; i2 < 21; ++i2) {
            this.connectSocket(n2, n3, call, eventListener);
            request = this.createTunnel(n3, n4, request, httpUrl);
            if (request == null) break;
            Util.closeQuietly(this.rawSocket);
            this.rawSocket = null;
            this.sink = null;
            this.source = null;
            eventListener.connectEnd(call, this.route.socketAddress(), this.route.proxy(), null);
        }
    }

    private void connectSocket(int n2, int n3, Call call, EventListener eventListener) throws IOException {
        block4: {
            Proxy proxy = this.route.proxy();
            Address address = this.route.address();
            this.rawSocket = proxy.type() == Proxy.Type.DIRECT || proxy.type() == Proxy.Type.HTTP ? address.socketFactory().createSocket() : new Socket(proxy);
            eventListener.connectStart(call, this.route.socketAddress(), proxy);
            this.rawSocket.setSoTimeout(n3);
            try {
                Platform.get().connectSocket(this.rawSocket, this.route.socketAddress(), n2);
            }
            catch (ConnectException connectException) {
                ConnectException connectException2 = new ConnectException("Failed to connect to " + this.route.socketAddress());
                connectException2.initCause(connectException);
                throw connectException2;
            }
            try {
                this.source = Okio.buffer(Okio.source(this.rawSocket));
                this.sink = Okio.buffer(Okio.sink(this.rawSocket));
            }
            catch (NullPointerException nullPointerException) {
                if (!NPE_THROW_WITH_NULL.equals(nullPointerException.getMessage())) break block4;
                throw new IOException(nullPointerException);
            }
        }
    }

    private void establishProtocol(ConnectionSpecSelector connectionSpecSelector, int n2, Call call, EventListener eventListener) throws IOException {
        if (this.route.address().sslSocketFactory() == null) {
            this.protocol = Protocol.HTTP_1_1;
            this.socket = this.rawSocket;
            return;
        }
        eventListener.secureConnectStart(call);
        this.connectTls(connectionSpecSelector);
        eventListener.secureConnectEnd(call, this.handshake);
        if (this.protocol == Protocol.HTTP_2) {
            this.socket.setSoTimeout(0);
            this.http2Connection = new Http2Connection.Builder(true).socket(this.socket, this.route.address().url().host(), this.source, this.sink).listener(this).pingIntervalMillis(n2).build();
            this.http2Connection.start();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void connectTls(ConnectionSpecSelector connectionSpecSelector) throws IOException {
        Address address = this.route.address();
        SSLSocketFactory sSLSocketFactory = address.sslSocketFactory();
        boolean bl2 = false;
        SSLSocket sSLSocket = null;
        try {
            sSLSocket = (SSLSocket)sSLSocketFactory.createSocket(this.rawSocket, address.url().host(), address.url().port(), true);
            ConnectionSpec connectionSpec = connectionSpecSelector.configureSecureSocket(sSLSocket);
            if (connectionSpec.supportsTlsExtensions()) {
                Platform.get().configureTlsExtensions(sSLSocket, address.url().host(), address.protocols());
            }
            sSLSocket.startHandshake();
            SSLSession sSLSession = sSLSocket.getSession();
            if (!this.isValid(sSLSession)) {
                throw new IOException("a valid ssl session was not established");
            }
            Handshake handshake = Handshake.get(sSLSession);
            if (!address.hostnameVerifier().verify(address.url().host(), sSLSession)) {
                X509Certificate x509Certificate = (X509Certificate)handshake.peerCertificates().get(0);
                throw new SSLPeerUnverifiedException("Hostname " + address.url().host() + " not verified:\n    certificate: " + CertificatePinner.pin(x509Certificate) + "\n    DN: " + x509Certificate.getSubjectDN().getName() + "\n    subjectAltNames: " + OkHostnameVerifier.allSubjectAltNames(x509Certificate));
            }
            address.certificatePinner().check(address.url().host(), handshake.peerCertificates());
            String string = connectionSpec.supportsTlsExtensions() ? Platform.get().getSelectedProtocol(sSLSocket) : null;
            this.socket = sSLSocket;
            this.source = Okio.buffer(Okio.source(this.socket));
            this.sink = Okio.buffer(Okio.sink(this.socket));
            this.handshake = handshake;
            this.protocol = string != null ? Protocol.get(string) : Protocol.HTTP_1_1;
            bl2 = true;
            if (sSLSocket != null) {
                Platform.get().afterHandshake(sSLSocket);
            }
            if (bl2) return;
        }
        catch (AssertionError assertionError) {
            try {
                if (!Util.isAndroidGetsocknameError(assertionError)) throw assertionError;
                throw new IOException((Throwable)((Object)assertionError));
            }
            catch (Throwable throwable) {
                if (sSLSocket != null) {
                    Platform.get().afterHandshake(sSLSocket);
                }
                if (bl2) throw throwable;
                Util.closeQuietly(sSLSocket);
                throw throwable;
            }
        }
        Util.closeQuietly(sSLSocket);
        return;
    }

    private boolean isValid(SSLSession sSLSession) {
        return !"NONE".equals(sSLSession.getProtocol()) && !"SSL_NULL_WITH_NULL_NULL".equals(sSLSession.getCipherSuite());
    }

    private Request createTunnel(int n2, int n3, Request request, HttpUrl httpUrl) throws IOException {
        Response response;
        String string = "CONNECT " + Util.hostHeader(httpUrl, true) + " HTTP/1.1";
        block4: while (true) {
            Http1Codec http1Codec = new Http1Codec(null, null, this.source, this.sink);
            this.source.timeout().timeout(n2, TimeUnit.MILLISECONDS);
            this.sink.timeout().timeout(n3, TimeUnit.MILLISECONDS);
            http1Codec.writeRequest(request.headers(), string);
            http1Codec.finishRequest();
            response = http1Codec.readResponseHeaders(false).request(request).build();
            long l2 = HttpHeaders.contentLength(response);
            if (l2 == -1L) {
                l2 = 0L;
            }
            Source source = http1Codec.newFixedLengthSource(l2);
            Util.skipAll(source, Integer.MAX_VALUE, TimeUnit.MILLISECONDS);
            source.close();
            switch (response.code()) {
                case 200: {
                    if (!this.source.buffer().exhausted() || !this.sink.buffer().exhausted()) {
                        throw new IOException("TLS tunnel buffered too many bytes!");
                    }
                    return null;
                }
                case 407: {
                    request = this.route.address().proxyAuthenticator().authenticate(this.route, response);
                    if (request != null) continue block4;
                    throw new IOException("Failed to authenticate with proxy");
                    if (!"close".equalsIgnoreCase(response.header("Connection"))) continue block4;
                    return request;
                }
            }
            break;
        }
        throw new IOException("Unexpected response code for CONNECT: " + response.code());
    }

    private Request createTunnelRequest() {
        return new Request.Builder().url(this.route.address().url()).header("Host", Util.hostHeader(this.route.address().url(), true)).header("Proxy-Connection", "Keep-Alive").header("User-Agent", Version.userAgent()).build();
    }

    public boolean isEligible(Address address, @Nullable Route route) {
        if (this.allocations.size() >= this.allocationLimit || this.noNewStreams) {
            return false;
        }
        if (!Internal.instance.equalsNonHost(this.route.address(), address)) {
            return false;
        }
        if (address.url().host().equals(this.route().address().url().host())) {
            return true;
        }
        if (this.http2Connection == null) {
            return false;
        }
        if (route == null) {
            return false;
        }
        if (route.proxy().type() != Proxy.Type.DIRECT) {
            return false;
        }
        if (this.route.proxy().type() != Proxy.Type.DIRECT) {
            return false;
        }
        if (!this.route.socketAddress().equals(route.socketAddress())) {
            return false;
        }
        if (route.address().hostnameVerifier() != OkHostnameVerifier.INSTANCE) {
            return false;
        }
        if (!this.supportsUrl(address.url())) {
            return false;
        }
        try {
            address.certificatePinner().check(address.url().host(), this.handshake().peerCertificates());
        }
        catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
            return false;
        }
        return true;
    }

    public boolean supportsUrl(HttpUrl httpUrl) {
        if (httpUrl.port() != this.route.address().url().port()) {
            return false;
        }
        if (!httpUrl.host().equals(this.route.address().url().host())) {
            return this.handshake != null && OkHostnameVerifier.INSTANCE.verify(httpUrl.host(), (X509Certificate)this.handshake.peerCertificates().get(0));
        }
        return true;
    }

    public HttpCodec newCodec(OkHttpClient okHttpClient, Interceptor.Chain chain, StreamAllocation streamAllocation) throws SocketException {
        if (this.http2Connection != null) {
            return new Http2Codec(okHttpClient, chain, streamAllocation, this.http2Connection);
        }
        this.socket.setSoTimeout(chain.readTimeoutMillis());
        this.source.timeout().timeout(chain.readTimeoutMillis(), TimeUnit.MILLISECONDS);
        this.sink.timeout().timeout(chain.writeTimeoutMillis(), TimeUnit.MILLISECONDS);
        return new Http1Codec(okHttpClient, streamAllocation, this.source, this.sink);
    }

    public RealWebSocket.Streams newWebSocketStreams(final StreamAllocation streamAllocation) {
        return new RealWebSocket.Streams(true, this.source, this.sink){

            @Override
            public void close() throws IOException {
                streamAllocation.streamFinished(true, streamAllocation.codec(), -1L, null);
            }
        };
    }

    @Override
    public Route route() {
        return this.route;
    }

    public void cancel() {
        Util.closeQuietly(this.rawSocket);
    }

    @Override
    public Socket socket() {
        return this.socket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isHealthy(boolean bl2) {
        if (this.socket.isClosed()) return false;
        if (this.socket.isInputShutdown()) return false;
        if (this.socket.isOutputShutdown()) {
            return false;
        }
        if (this.http2Connection != null) {
            if (this.http2Connection.isShutdown()) return false;
            return true;
        }
        if (!bl2) return true;
        try {
            int n2 = this.socket.getSoTimeout();
            try {
                this.socket.setSoTimeout(1);
                if (this.source.exhausted()) {
                    boolean bl3 = false;
                    return bl3;
                }
                boolean bl4 = true;
                return bl4;
            }
            finally {
                this.socket.setSoTimeout(n2);
            }
        }
        catch (SocketTimeoutException socketTimeoutException) {
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    @Override
    public void onStream(Http2Stream http2Stream) throws IOException {
        http2Stream.close(ErrorCode.REFUSED_STREAM);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onSettings(Http2Connection http2Connection) {
        ConnectionPool connectionPool = this.connectionPool;
        synchronized (connectionPool) {
            this.allocationLimit = http2Connection.maxConcurrentStreams();
        }
    }

    @Override
    public Handshake handshake() {
        return this.handshake;
    }

    public boolean isMultiplexed() {
        return this.http2Connection != null;
    }

    @Override
    public Protocol protocol() {
        return this.protocol;
    }

    public String toString() {
        return "Connection{" + this.route.address().url().host() + ":" + this.route.address().url().port() + ", proxy=" + this.route.proxy() + " hostAddress=" + this.route.socketAddress() + " cipherSuite=" + (this.handshake != null ? this.handshake.cipherSuite() : "none") + " protocol=" + (Object)((Object)this.protocol) + '}';
    }
}

