/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.bind;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.GetPropertyAction;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBContextFactory;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Messages;
import javax.xml.bind.ServiceLoaderUtil;

class ContextFinder {
    private static final String PLATFORM_DEFAULT_FACTORY_CLASS = "com.sun.xml.internal.bind.v2.ContextFactory";
    private static final String JAXB_CONTEXT_FACTORY_DEPRECATED = "javax.xml.bind.context.factory";
    private static final Logger logger = Logger.getLogger("javax.xml.bind");
    private static ServiceLoaderUtil.ExceptionHandler<JAXBException> EXCEPTION_HANDLER;

    ContextFinder() {
    }

    private static Throwable handleInvocationTargetException(InvocationTargetException invocationTargetException) throws JAXBException {
        Throwable throwable = invocationTargetException.getTargetException();
        if (throwable != null) {
            if (throwable instanceof JAXBException) {
                throw (JAXBException)throwable;
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            return throwable;
        }
        return invocationTargetException;
    }

    private static JAXBException handleClassCastException(Class clazz, Class clazz2) {
        URL uRL = ContextFinder.which(clazz2);
        return new JAXBException(Messages.format("JAXBContext.IllegalCast", ContextFinder.getClassClassLoader(clazz).getResource("javax/xml/bind/JAXBContext.class"), uRL));
    }

    static JAXBContext newInstance(String string, String string2, ClassLoader classLoader, Map map) throws JAXBException {
        try {
            Class clazz = ServiceLoaderUtil.safeLoadClass(string2, PLATFORM_DEFAULT_FACTORY_CLASS, classLoader);
            return ContextFinder.newInstance(string, clazz, classLoader, map);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new JAXBException(Messages.format("ContextFinder.DefaultProviderNotFound"), classNotFoundException);
        }
        catch (RuntimeException | JAXBException exception) {
            throw exception;
        }
        catch (Exception exception) {
            throw new JAXBException(Messages.format("ContextFinder.CouldNotInstantiate", string2, exception), exception);
        }
    }

    static JAXBContext newInstance(String string, Class clazz, ClassLoader classLoader, Map map) throws JAXBException {
        try {
            Object object;
            Method method;
            Object object2 = null;
            try {
                method = clazz.getMethod("createContext", String.class, ClassLoader.class, Map.class);
                object = ContextFinder.instantiateProviderIfNecessary(clazz);
                object2 = method.invoke(object, string, classLoader, map);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            if (object2 == null) {
                method = clazz.getMethod("createContext", String.class, ClassLoader.class);
                object = ContextFinder.instantiateProviderIfNecessary(clazz);
                object2 = method.invoke(object, string, classLoader);
            }
            if (!(object2 instanceof JAXBContext)) {
                throw ContextFinder.handleClassCastException(object2.getClass(), JAXBContext.class);
            }
            return (JAXBContext)object2;
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = ContextFinder.handleInvocationTargetException(invocationTargetException);
            throw new JAXBException(Messages.format("ContextFinder.CouldNotInstantiate", clazz, throwable), throwable);
        }
        catch (Exception exception) {
            throw new JAXBException(Messages.format("ContextFinder.CouldNotInstantiate", clazz, exception), exception);
        }
    }

    private static Object instantiateProviderIfNecessary(final Class<?> clazz) throws JAXBException {
        try {
            if (JAXBContextFactory.class.isAssignableFrom(clazz)) {
                return AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                    @Override
                    public Object run() throws Exception {
                        return clazz.newInstance();
                    }
                });
            }
            return null;
        }
        catch (PrivilegedActionException privilegedActionException) {
            Throwable throwable = privilegedActionException.getCause() == null ? privilegedActionException : privilegedActionException.getCause();
            throw new JAXBException(Messages.format("ContextFinder.CouldNotInstantiate", clazz, throwable), throwable);
        }
    }

    static JAXBContext newInstance(Class[] classArray, Map map, String string) throws JAXBException {
        Class clazz;
        try {
            clazz = ServiceLoaderUtil.safeLoadClass(string, PLATFORM_DEFAULT_FACTORY_CLASS, ContextFinder.getContextClassLoader());
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new JAXBException(Messages.format("ContextFinder.DefaultProviderNotFound"), classNotFoundException);
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "loaded {0} from {1}", new Object[]{string, ContextFinder.which(clazz)});
        }
        return ContextFinder.newInstance(classArray, map, clazz);
    }

    static JAXBContext newInstance(Class[] classArray, Map map, Class clazz) throws JAXBException {
        try {
            Method method = clazz.getMethod("createContext", Class[].class, Map.class);
            Object object = ContextFinder.instantiateProviderIfNecessary(clazz);
            Object object2 = method.invoke(object, classArray, map);
            if (!(object2 instanceof JAXBContext)) {
                throw ContextFinder.handleClassCastException(object2.getClass(), JAXBContext.class);
            }
            return (JAXBContext)object2;
        }
        catch (IllegalAccessException | NoSuchMethodException reflectiveOperationException) {
            throw new JAXBException(reflectiveOperationException);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = ContextFinder.handleInvocationTargetException(invocationTargetException);
            throw new JAXBException(throwable);
        }
    }

    static JAXBContext find(String string, String string2, ClassLoader classLoader, Map map) throws JAXBException {
        String string3;
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ":");
        if (!stringTokenizer.hasMoreTokens()) {
            throw new JAXBException(Messages.format("ContextFinder.NoPackageInContextPath"));
        }
        logger.fine("Searching jaxb.properties");
        while (stringTokenizer.hasMoreTokens()) {
            string3 = ContextFinder.classNameFromPackageProperties(classLoader, stringTokenizer.nextToken(":").replace('.', '/'), string, JAXB_CONTEXT_FACTORY_DEPRECATED);
            if (string3 == null) continue;
            return ContextFinder.newInstance(string2, string3, classLoader, map);
        }
        string3 = ContextFinder.classNameFromSystemProperties();
        if (string3 != null) {
            return ContextFinder.newInstance(string2, string3, classLoader, map);
        }
        JAXBContextFactory jAXBContextFactory = ServiceLoaderUtil.firstByServiceLoader(JAXBContextFactory.class, logger, EXCEPTION_HANDLER);
        if (jAXBContextFactory != null) {
            return jAXBContextFactory.createContext(string2, classLoader, map);
        }
        string3 = ContextFinder.firstByServiceLoaderDeprecated(JAXBContext.class, classLoader);
        if (string3 != null) {
            return ContextFinder.newInstance(string2, string3, classLoader, map);
        }
        Class clazz = (Class)ServiceLoaderUtil.lookupUsingOSGiServiceLoader("javax.xml.bind.JAXBContext", logger);
        if (clazz != null) {
            return ContextFinder.newInstance(string2, clazz, classLoader, map);
        }
        logger.fine("Trying to create the platform default provider");
        return ContextFinder.newInstance(string2, PLATFORM_DEFAULT_FACTORY_CLASS, classLoader, map);
    }

    static JAXBContext find(Class<?>[] classArray, Map<String, ?> map) throws JAXBException {
        logger.fine("Searching jaxb.properties");
        for (Class<?> clazz : classArray) {
            if (clazz.getPackage() == null) continue;
            String string = ContextFinder.classNameFromPackageProperties(ContextFinder.getClassClassLoader(clazz), clazz.getPackage().getName().replace('.', '/'), "javax.xml.bind.JAXBContextFactory", JAXB_CONTEXT_FACTORY_DEPRECATED);
            if (string == null) continue;
            return ContextFinder.newInstance((Class[])classArray, map, string);
        }
        String string = ContextFinder.classNameFromSystemProperties();
        if (string != null) {
            return ContextFinder.newInstance((Class[])classArray, map, string);
        }
        JAXBContextFactory jAXBContextFactory = ServiceLoaderUtil.firstByServiceLoader(JAXBContextFactory.class, logger, EXCEPTION_HANDLER);
        if (jAXBContextFactory != null) {
            return jAXBContextFactory.createContext(classArray, map);
        }
        String string2 = ContextFinder.firstByServiceLoaderDeprecated(JAXBContext.class, ContextFinder.getContextClassLoader());
        if (string2 != null) {
            return ContextFinder.newInstance((Class[])classArray, map, string2);
        }
        logger.fine("Trying to create the platform default provider");
        Class clazz = (Class)ServiceLoaderUtil.lookupUsingOSGiServiceLoader("javax.xml.bind.JAXBContext", logger);
        if (clazz != null) {
            return ContextFinder.newInstance((Class[])classArray, map, clazz);
        }
        logger.fine("Trying to create the platform default provider");
        return ContextFinder.newInstance((Class[])classArray, map, PLATFORM_DEFAULT_FACTORY_CLASS);
    }

    private static String classNameFromPackageProperties(ClassLoader classLoader, String string, String ... stringArray) throws JAXBException {
        String string2 = string + "/jaxb.properties";
        logger.log(Level.FINE, "Trying to locate {0}", string2);
        Properties properties = ContextFinder.loadJAXBProperties(classLoader, string2);
        if (properties != null) {
            for (String string3 : stringArray) {
                if (!properties.containsKey(string3)) continue;
                return properties.getProperty(string3);
            }
            throw new JAXBException(Messages.format("ContextFinder.MissingProperty", string, stringArray[0]));
        }
        return null;
    }

    private static String classNameFromSystemProperties() throws JAXBException {
        String string = ContextFinder.getSystemProperty("javax.xml.bind.JAXBContextFactory");
        if (string != null) {
            return string;
        }
        string = ContextFinder.getDeprecatedSystemProperty(JAXB_CONTEXT_FACTORY_DEPRECATED);
        if (string != null) {
            return string;
        }
        string = ContextFinder.getDeprecatedSystemProperty(JAXBContext.class.getName());
        if (string != null) {
            return string;
        }
        return null;
    }

    private static String getDeprecatedSystemProperty(String string) {
        String string2 = ContextFinder.getSystemProperty(string);
        if (string2 != null) {
            logger.log(Level.WARNING, "Using non-standard property: {0}. Property {1} should be used instead.", new Object[]{string, "javax.xml.bind.JAXBContextFactory"});
        }
        return string2;
    }

    private static String getSystemProperty(String string) {
        logger.log(Level.FINE, "Checking system property {0}", string);
        String string2 = AccessController.doPrivileged(new GetPropertyAction(string));
        if (string2 != null) {
            logger.log(Level.FINE, "  found {0}", string2);
        } else {
            logger.log(Level.FINE, "  not found");
        }
        return string2;
    }

    private static Properties loadJAXBProperties(ClassLoader classLoader, String string) throws JAXBException {
        Properties properties = null;
        try {
            URL uRL = classLoader == null ? ClassLoader.getSystemResource(string) : classLoader.getResource(string);
            if (uRL != null) {
                logger.log(Level.FINE, "loading props from {0}", uRL);
                properties = new Properties();
                InputStream inputStream = uRL.openStream();
                properties.load(inputStream);
                inputStream.close();
            }
        }
        catch (IOException iOException) {
            logger.log(Level.FINE, "Unable to load " + string, iOException);
            throw new JAXBException(iOException.toString(), iOException);
        }
        return properties;
    }

    static URL which(Class clazz, ClassLoader classLoader) {
        String string = clazz.getName().replace('.', '/') + ".class";
        if (classLoader == null) {
            classLoader = ContextFinder.getSystemClassLoader();
        }
        return classLoader.getResource(string);
    }

    static URL which(Class clazz) {
        return ContextFinder.which(clazz, ContextFinder.getClassClassLoader(clazz));
    }

    private static ClassLoader getContextClassLoader() {
        if (System.getSecurityManager() == null) {
            return Thread.currentThread().getContextClassLoader();
        }
        return (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
    }

    private static ClassLoader getClassClassLoader(final Class clazz) {
        if (System.getSecurityManager() == null) {
            return clazz.getClassLoader();
        }
        return (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return clazz.getClassLoader();
            }
        });
    }

    private static ClassLoader getSystemClassLoader() {
        if (System.getSecurityManager() == null) {
            return ClassLoader.getSystemClassLoader();
        }
        return (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return ClassLoader.getSystemClassLoader();
            }
        });
    }

    @Deprecated
    static String firstByServiceLoaderDeprecated(Class clazz, ClassLoader classLoader) throws JAXBException {
        String string = clazz.getName();
        logger.fine("Searching META-INF/services");
        BufferedReader bufferedReader = null;
        String string2 = "META-INF/services/" + string;
        try {
            InputStream inputStream;
            InputStream inputStream2 = inputStream = classLoader == null ? ClassLoader.getSystemResourceAsStream(string2) : classLoader.getResourceAsStream(string2);
            if (inputStream != null) {
                bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
                String string3 = bufferedReader.readLine();
                if (string3 != null) {
                    string3 = string3.trim();
                }
                bufferedReader.close();
                logger.log(Level.FINE, "Configured factorty class:{0}", string3);
                String string4 = string3;
                return string4;
            }
            logger.log(Level.FINE, "Unable to load:{0}", string2);
            String string5 = null;
            return string5;
        }
        catch (IOException iOException) {
            throw new JAXBException(iOException);
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (IOException iOException) {
                logger.log(Level.SEVERE, "Unable to close resource: " + string2, iOException);
            }
        }
    }

    static {
        try {
            if (AccessController.doPrivileged(new GetPropertyAction("jaxb.debug")) != null) {
                logger.setUseParentHandlers(false);
                logger.setLevel(Level.ALL);
                ConsoleHandler consoleHandler = new ConsoleHandler();
                consoleHandler.setLevel(Level.ALL);
                logger.addHandler(consoleHandler);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        EXCEPTION_HANDLER = new ServiceLoaderUtil.ExceptionHandler<JAXBException>(){

            @Override
            public JAXBException createException(Throwable throwable, String string) {
                return new JAXBException(string, throwable);
            }
        };
    }
}

