/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.math.spectra.fft;

import org.apache.commons.math3.complex.Complex;

public class ComplexFFT_1D {
    private static Complex[][] coef;
    private static int coef_order;

    public static Complex[] cconvolve(Complex[] complexArray, Complex[] complexArray2) {
        if (complexArray.length != complexArray2.length) {
            throw new RuntimeException("Dimensions don't agree");
        }
        int n2 = complexArray.length;
        Complex[] complexArray3 = ComplexFFT_1D.fft(complexArray);
        Complex[] complexArray4 = ComplexFFT_1D.fft(complexArray2);
        Complex[] complexArray5 = new Complex[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            complexArray5[i2] = complexArray3[i2].multiply(complexArray4[i2]);
        }
        return ComplexFFT_1D.ifft(complexArray5);
    }

    public static Complex[] convolve(Complex[] complexArray, Complex[] complexArray2) {
        Complex complex = new Complex(0.0, 0.0);
        Complex[] complexArray3 = new Complex[2 * complexArray.length];
        System.arraycopy(complexArray, 0, complexArray3, 0, complexArray.length);
        for (int i2 = complexArray.length; i2 < 2 * complexArray.length; ++i2) {
            complexArray3[i2] = complex;
        }
        Complex[] complexArray4 = new Complex[2 * complexArray2.length];
        System.arraycopy(complexArray2, 0, complexArray4, 0, complexArray2.length);
        for (int i3 = complexArray2.length; i3 < 2 * complexArray2.length; ++i3) {
            complexArray4[i3] = complex;
        }
        return ComplexFFT_1D.cconvolve(complexArray3, complexArray4);
    }

    public static Complex[] fft(Complex[] complexArray) {
        int n2;
        int n3 = complexArray.length;
        if (n3 == 1) {
            return new Complex[]{complexArray[0]};
        }
        if (n3 % 2 != 0) {
            throw new RuntimeException("N is not a power of 2");
        }
        int n4 = (int)(Math.log(n3 / 2) / Math.log(2.0)) + 1;
        boolean bl2 = true;
        if (n4 > 17) {
            bl2 = false;
        }
        if ((coef == null || n4 > coef_order) && bl2) {
            int n5 = 0;
            n5 = n4 < 16 ? 16 : n4 + 1;
            coef = new Complex[n5][];
            for (n2 = 0; n2 < n5; ++n2) {
                ComplexFFT_1D.coef[n2] = new Complex[(int)Math.pow(2.0, n2)];
                for (int i2 = 0; i2 < (int)Math.pow(2.0, n2); ++i2) {
                    double d2 = (double)(-2 * i2) * Math.PI / Math.pow(2.0, n2);
                    ComplexFFT_1D.coef[n2][i2] = new Complex(Math.cos(d2), Math.sin(d2));
                }
            }
            coef_order = n5;
        }
        Complex[] complexArray2 = new Complex[n3 / 2];
        for (n2 = 0; n2 < n3 / 2; ++n2) {
            complexArray2[n2] = complexArray[2 * n2];
        }
        Complex[] complexArray3 = ComplexFFT_1D.fft(complexArray2);
        Complex[] complexArray4 = complexArray2;
        for (int i3 = 0; i3 < n3 / 2; ++i3) {
            complexArray4[i3] = complexArray[2 * i3 + 1];
        }
        Complex[] complexArray5 = ComplexFFT_1D.fft(complexArray4);
        Complex[] complexArray6 = new Complex[n3];
        for (int i4 = 0; i4 < n3 / 2; ++i4) {
            if (bl2) {
                complexArray6[i4] = complexArray3[i4].add(coef[n4][i4].multiply(complexArray5[i4]));
                complexArray6[i4 + n3 / 2] = complexArray3[i4].subtract(coef[n4][i4].multiply(complexArray5[i4]));
                continue;
            }
            double d3 = (double)(-2 * i4) * Math.PI / (double)n3;
            Complex complex = new Complex(Math.cos(d3), Math.sin(d3));
            complexArray6[i4] = complexArray3[i4].add(complex.multiply(complexArray5[i4]));
            complexArray6[i4 + n3 / 2] = complexArray3[i4].subtract(complex.multiply(complexArray5[i4]));
        }
        return complexArray6;
    }

    public static Complex[] fft_orig(Complex[] complexArray) {
        int n2 = complexArray.length;
        if (n2 == 1) {
            return new Complex[]{complexArray[0]};
        }
        if (n2 % 2 != 0) {
            throw new RuntimeException("N is not a power of 2");
        }
        Complex[] complexArray2 = new Complex[n2 / 2];
        for (int i2 = 0; i2 < n2 / 2; ++i2) {
            complexArray2[i2] = complexArray[2 * i2];
        }
        Complex[] complexArray3 = ComplexFFT_1D.fft(complexArray2);
        Complex[] complexArray4 = complexArray2;
        for (int i3 = 0; i3 < n2 / 2; ++i3) {
            complexArray4[i3] = complexArray[2 * i3 + 1];
        }
        Complex[] complexArray5 = ComplexFFT_1D.fft(complexArray4);
        Complex[] complexArray6 = new Complex[n2];
        for (int i4 = 0; i4 < n2 / 2; ++i4) {
            double d2 = (double)(-2 * i4) * Math.PI / (double)n2;
            Complex complex = new Complex(Math.cos(d2), Math.sin(d2));
            complexArray6[i4] = complexArray3[i4].add(complex.multiply(complexArray5[i4]));
            complexArray6[i4 + n2 / 2] = complexArray3[i4].subtract(complex.multiply(complexArray5[i4]));
        }
        return complexArray6;
    }

    public static Complex[] ifft(Complex[] complexArray) {
        int n2;
        int n3 = complexArray.length;
        Complex[] complexArray2 = new Complex[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            complexArray2[n2] = complexArray[n2].conjugate();
        }
        complexArray2 = ComplexFFT_1D.fft(complexArray2);
        for (n2 = 0; n2 < n3; ++n2) {
            complexArray2[n2] = complexArray2[n2].conjugate();
        }
        for (n2 = 0; n2 < n3; ++n2) {
            complexArray2[n2] = complexArray2[n2].multiply(1.0 / (double)n3);
        }
        return complexArray2;
    }

    public static void main(String[] stringArray) {
        int n2;
        int n3 = 1024;
        Complex[] complexArray = new Complex[1024];
        for (n2 = 0; n2 < 1024; ++n2) {
            complexArray[n2] = new Complex((double)n2, 0.0);
            complexArray[n2] = new Complex(-2.0 * Math.random() + 1.0, 0.0);
        }
        System.out.println("x");
        System.out.println("-------------------");
        for (n2 = 0; n2 < 1024; ++n2) {
            System.out.println(complexArray[n2]);
        }
        System.out.println();
        Complex[] complexArray2 = ComplexFFT_1D.fft(complexArray);
        System.out.println("y = fft(x)");
        System.out.println("-------------------");
        for (int i2 = 0; i2 < 1024; ++i2) {
            System.out.println(complexArray2[i2]);
        }
        System.out.println();
        Complex[] complexArray3 = ComplexFFT_1D.ifft(complexArray2);
        System.out.println("z = ifft(y)");
        System.out.println("-------------------");
        for (int i3 = 0; i3 < 1024; ++i3) {
            System.out.println(complexArray3[i3]);
        }
        System.out.println();
        Complex[] complexArray4 = ComplexFFT_1D.cconvolve(complexArray, complexArray);
        System.out.println("c = cconvolve(x, x)");
        System.out.println("-------------------");
        for (int i4 = 0; i4 < 1024; ++i4) {
            System.out.println(complexArray4[i4]);
        }
        System.out.println();
        Complex[] complexArray5 = ComplexFFT_1D.convolve(complexArray, complexArray);
        System.out.println("d = convolve(x, x)");
        System.out.println("-------------------");
        for (int i5 = 0; i5 < complexArray5.length; ++i5) {
            System.out.println(complexArray5[i5]);
        }
        System.out.println();
    }

    static {
        coef_order = 0;
    }
}

