/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.math.spectra;

import io.fair_acc.dataset.utils.AssertUtils;
import io.fair_acc.math.MathBase;
import java.util.Map;
import java.util.WeakHashMap;

public enum Apodization {
    Rectangular("rectangular"),
    Hamming("Hamming"),
    Hann("von Hann"),
    HannExp("exp. von Hann"),
    Blackman("Blackman"),
    Nuttall("Nuttall"),
    BlackmanHarris("Blackman-Harris"),
    BlackmanNuttall("Blackman-Nuttall"),
    FlatTop("Flat-Top"),
    Exponential("exponential");

    private static Map<ApodizationArrayDescription, double[]> windowCache;
    private final String fname;

    private Apodization(String string2) {
        this.fname = string2;
    }

    public void apodize(double[] dArray) {
        double[] dArray2 = this.getWindow(dArray.length);
        for (int i2 = 0; i2 < dArray.length; ++i2) {
            dArray[i2] = dArray[i2] * dArray2[i2];
        }
    }

    public double getIndex(int n2, int n3) {
        return this.getWindow(n3)[n2];
    }

    public double getIndex(int n2, int n3, double d2) {
        switch (this) {
            case Hamming: {
                return this.getIndex(n2, n3);
            }
            case HannExp: {
                double d3 = Math.PI * 2 / (double)(n3 - 1);
                return Math.pow(Math.sin(d3 * (double)n2), d2);
            }
        }
        return this.getIndex(n2, n3);
    }

    public double getIndexUncached(int n2, int n3) {
        switch (this) {
            case Hamming: {
                double d2 = Math.PI * 2 / (double)n3;
                return 0.53836 - 0.46164 * MathBase.cos(d2 * (double)n2);
            }
            case Hann: {
                double d3 = Math.PI * 2 / (double)(n3 - 1);
                return 0.5 - 0.5 * MathBase.cos(d3 * (double)n2);
            }
            case HannExp: {
                double d4 = Math.PI * 2 / (double)(n3 - 1);
                return Math.pow(MathBase.sin(d4 * (double)n2), 2.0);
            }
            case Blackman: {
                double d5 = Math.PI * 2 / (double)(n3 - 1);
                return 0.42 - 0.5 * MathBase.cos(d5 * (double)n2) + 0.08 * MathBase.cos(2.0 * d5 * (double)n2);
            }
            case Nuttall: {
                double d6 = Math.PI * 2 / (double)(n3 - 1);
                return 0.355768 - 0.487396 * MathBase.cos(d6 * (double)n2) + 0.144232 * MathBase.cos(2.0 * d6 * (double)n2) - 0.012604 * MathBase.cos(3.0 * d6 * (double)n2);
            }
            case BlackmanHarris: {
                double d7 = Math.PI * 2 / (double)(n3 - 1);
                return 0.35875 - 0.48829 * MathBase.cos(d7 * (double)n2) + 0.14128 * MathBase.cos(2.0 * d7 * (double)n2) - 0.01168 * MathBase.cos(3.0 * d7 * (double)n2);
            }
            case BlackmanNuttall: {
                double d8 = Math.PI * 2 / (double)(n3 - 1);
                return 0.3635819 - 0.4891775 * MathBase.cos(d8 * (double)n2) + 0.1365995 * MathBase.cos(2.0 * d8 * (double)n2) - 0.0106411 * MathBase.cos(3.0 * d8 * (double)n2);
            }
            case FlatTop: {
                double d9 = Math.PI * 2 / (double)(n3 - 1);
                return 1.0 - 1.93 * MathBase.cos(d9 * (double)n2) + 1.29 * MathBase.cos(2.0 * d9 * (double)n2) - 0.388 * MathBase.cos(3.0 * d9 * (double)n2) + 0.032 * MathBase.cos(4.0 * d9 * (double)n2);
            }
            case Exponential: {
                double d10 = 3 * n3;
                double d11 = MathBase.exp(0.0);
                return MathBase.exp((double)n2 / d10) / d11;
            }
        }
        return 1.0;
    }

    public String getName() {
        return this.fname;
    }

    public double[] getWindow(int n2) {
        return windowCache.computeIfAbsent(new ApodizationArrayDescription(this, n2), apodizationArrayDescription -> {
            double[] dArray = new double[apodizationArrayDescription.length];
            for (int i2 = 0; i2 < apodizationArrayDescription.length; ++i2) {
                dArray[i2] = this.getIndexUncached(i2, apodizationArrayDescription.length);
            }
            return dArray;
        });
    }

    public static void apodize(double[] dArray, Apodization apodization) {
        apodization.apodize(dArray);
    }

    public static Map<ApodizationArrayDescription, double[]> getWindowCache() {
        return windowCache;
    }

    public static void setWindowCache(Map<ApodizationArrayDescription, double[]> map) {
        windowCache = map;
    }

    static {
        windowCache = new WeakHashMap<ApodizationArrayDescription, double[]>();
    }

    protected static class ApodizationArrayDescription {
        protected final Apodization apodization;
        protected final int length;

        public ApodizationArrayDescription(Apodization apodization, int n2) {
            AssertUtils.notNull("apodization", apodization);
            this.apodization = apodization;
            this.length = n2;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof ApodizationArrayDescription)) {
                return false;
            }
            ApodizationArrayDescription apodizationArrayDescription = (ApodizationArrayDescription)object;
            return this.apodization == apodizationArrayDescription.apodization && this.length == apodizationArrayDescription.length;
        }

        public int hashCode() {
            int n2 = 31;
            int n3 = 1;
            n3 = 31 * n3 + this.apodization.hashCode();
            n3 = 31 * n3 + this.length;
            return n3;
        }
    }
}

