/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.math.filter.iir;

import io.fair_acc.math.filter.iir.BandPassTransform;
import io.fair_acc.math.filter.iir.BandStopTransform;
import io.fair_acc.math.filter.iir.Cascade;
import io.fair_acc.math.filter.iir.HighPassTransform;
import io.fair_acc.math.filter.iir.LayoutBase;
import io.fair_acc.math.filter.iir.LowPassTransform;
import org.apache.commons.math3.analysis.solvers.LaguerreSolver;
import org.apache.commons.math3.complex.Complex;

public class Bessel
extends Cascade {
    public void bandPass(int n2, double d2, double d3, double d4) {
        this.setupBandPass(n2, d2, d3, d4, 1);
    }

    public void bandPass(int n2, double d2, double d3, double d4, int n3) {
        this.setupBandPass(n2, d2, d3, d4, n3);
    }

    public void bandStop(int n2, double d2, double d3, double d4) {
        this.setupBandStop(n2, d2, d3, d4, 1);
    }

    public void bandStop(int n2, double d2, double d3, double d4, int n3) {
        this.setupBandStop(n2, d2, d3, d4, n3);
    }

    public void highPass(int n2, double d2, double d3) {
        this.setupHighPass(n2, d2, d3, 1);
    }

    public void highPass(int n2, double d2, double d3, int n3) {
        this.setupHighPass(n2, d2, d3, n3);
    }

    public void lowPass(int n2, double d2, double d3) {
        this.setupLowPass(n2, d2, d3, 1);
    }

    public void lowPass(int n2, double d2, double d3, int n3) {
        this.setupLowPass(n2, d2, d3, n3);
    }

    private void setupBandPass(int n2, double d2, double d3, double d4, int n3) {
        AnalogLowPass analogLowPass = new AnalogLowPass(n2);
        analogLowPass.design();
        LayoutBase layoutBase = new LayoutBase(n2 * 2);
        BandPassTransform.transform(d3 / d2, d4 / d2, layoutBase, analogLowPass);
        this.setLayout(layoutBase, n3);
    }

    private void setupBandStop(int n2, double d2, double d3, double d4, int n3) {
        AnalogLowPass analogLowPass = new AnalogLowPass(n2);
        analogLowPass.design();
        LayoutBase layoutBase = new LayoutBase(n2 * 2);
        BandStopTransform.transform(d3 / d2, d4 / d2, layoutBase, analogLowPass);
        this.setLayout(layoutBase, n3);
    }

    private void setupHighPass(int n2, double d2, double d3, int n3) {
        AnalogLowPass analogLowPass = new AnalogLowPass(n2);
        analogLowPass.design();
        LayoutBase layoutBase = new LayoutBase(n2);
        HighPassTransform.transform(d3 / d2, layoutBase, analogLowPass);
        this.setLayout(layoutBase, n3);
    }

    private void setupLowPass(int n2, double d2, double d3, int n3) {
        AnalogLowPass analogLowPass = new AnalogLowPass(n2);
        analogLowPass.design();
        LayoutBase layoutBase = new LayoutBase(n2);
        LowPassTransform.transform(d3 / d2, layoutBase, analogLowPass);
        this.setLayout(layoutBase, n3);
    }

    private static class AnalogLowPass
    extends LayoutBase {
        private final int degree;
        private final double[] mA;
        private Complex[] mRoot;

        public AnalogLowPass(int n2) {
            super(n2);
            this.degree = n2;
            this.mA = new double[this.degree + 1];
            this.mRoot = new Complex[this.degree];
            this.setNormal(0.0, 1.0);
        }

        public void design() {
            this.reset();
            for (int i2 = 0; i2 < this.degree + 1; ++i2) {
                this.mA[i2] = this.reversebessel(i2, this.degree);
            }
            LaguerreSolver laguerreSolver = new LaguerreSolver();
            this.mRoot = laguerreSolver.solveAllComplex(this.mA, 0.0);
            Complex complex = Complex.INF;
            int n2 = this.degree / 2;
            for (int i3 = 0; i3 < n2; ++i3) {
                Complex complex2 = this.mRoot[i3];
                this.addPoleZeroConjugatePairs(complex2, complex);
            }
            if ((this.degree & 1) == 1) {
                this.add(new Complex(this.mRoot[n2].getReal()), complex);
            }
        }

        private double factorial(int n2) {
            if (n2 == 0) {
                return 1.0;
            }
            double d2 = n2;
            for (double d3 = (double)n2 - 1.0; d3 > 0.0; d3 -= 1.0) {
                d2 *= d3;
            }
            return d2;
        }

        private double reversebessel(int n2, int n3) {
            int n4 = n3 - n2;
            return this.factorial(2 * n3 - n2) / (this.factorial(n4) * this.factorial(n2) * Math.pow(2.0, n4));
        }
    }
}

