/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.dataset.utils.trees;

import io.fair_acc.dataset.utils.trees.AbstractMap;
import io.fair_acc.dataset.utils.trees.AbstractSet;
import io.fair_acc.dataset.utils.trees.IndexedNavigableMap;
import io.fair_acc.dataset.utils.trees.IndexedTreeSet;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;

public class IndexedTreeMap<K, V>
extends AbstractMap<K, V>
implements IndexedNavigableMap<K, V>,
Cloneable,
Serializable {
    private static final boolean RED = false;
    private static final boolean BLACK = true;
    private static final long serialVersionUID = 919286545866124006L;
    private final Comparator<? super K> comparator;
    private Entry<K, V> root;
    private int size = 0;
    private int modCount = 0;
    private EntrySet entrySet;
    private KeySet<K> navigableKeySet;
    private NavigableMap<K, V> descendingMap;

    public IndexedTreeMap() {
        this.comparator = null;
    }

    public IndexedTreeMap(Comparator<? super K> comparator) {
        this.comparator = comparator;
    }

    public IndexedTreeMap(Map<? extends K, ? extends V> map) {
        this.comparator = null;
        this.putAll(map);
    }

    public IndexedTreeMap(SortedMap<K, ? extends V> sortedMap) {
        this.comparator = sortedMap.comparator();
        try {
            this.buildFromSorted(sortedMap.size(), sortedMap.entrySet().iterator(), null, null);
        }
        catch (IOException | ClassNotFoundException exception) {
            // empty catch block
        }
    }

    public void addAllForTreeSet(SortedSet<? extends K> sortedSet, V v2) {
        try {
            this.buildFromSorted(sortedSet.size(), sortedSet.iterator(), null, v2);
        }
        catch (IOException | ClassNotFoundException exception) {
            // empty catch block
        }
    }

    private Entry<K, V> buildFromSorted(int n2, int n3, int n4, int n5, Iterator<?> iterator, ObjectInputStream objectInputStream, V v2) throws IOException, ClassNotFoundException {
        V v3;
        Object object;
        Entry<Object, V> entry;
        if (n4 < n3) {
            return null;
        }
        int n6 = (n3 + n4) / 2;
        Entry<K, V> entry2 = null;
        if (n3 < n6) {
            entry2 = this.buildFromSorted(n2 + 1, n3, n6 - 1, n5, iterator, objectInputStream, v2);
        }
        if (iterator != null) {
            if (v2 == null) {
                entry = (Entry<Object, V>)iterator.next();
                object = entry.getKey();
                v3 = entry.getValue();
            } else {
                object = iterator.next();
                v3 = v2;
            }
        } else {
            object = objectInputStream.readObject();
            v3 = v2 != null ? v2 : objectInputStream.readObject();
        }
        entry = new Entry<Object, V>(object, v3, null);
        if (n2 == n5) {
            entry.color = false;
        }
        if (entry2 != null) {
            entry.left = entry2;
            entry2.parent = entry;
        }
        if (n6 < n4) {
            Entry<K, V> entry3 = this.buildFromSorted(n2 + 1, n6 + 1, n4, n5, iterator, objectInputStream, v2);
            entry.right = entry3;
            entry3.parent = entry;
        }
        return entry;
    }

    private void buildFromSorted(int n2, Iterator<?> iterator, ObjectInputStream objectInputStream, V v2) throws IOException, ClassNotFoundException {
        this.size = n2;
        this.root = this.buildFromSorted(0, 0, n2 - 1, IndexedTreeMap.computeRedLevel(n2), iterator, objectInputStream, v2);
    }

    @Override
    public Map.Entry<K, V> ceilingEntry(K k2) {
        return IndexedTreeMap.exportEntry(this.getCeilingEntry(k2));
    }

    @Override
    public K ceilingKey(K k2) {
        return IndexedTreeMap.keyOrNull(this.getCeilingEntry(k2));
    }

    @Override
    public void clear() {
        ++this.modCount;
        this.size = 0;
        this.root = null;
    }

    @Override
    public Object clone() {
        IndexedTreeMap indexedTreeMap = null;
        try {
            indexedTreeMap = (IndexedTreeMap)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
        indexedTreeMap.root = null;
        indexedTreeMap.size = 0;
        indexedTreeMap.modCount = 0;
        indexedTreeMap.entrySet = null;
        indexedTreeMap.navigableKeySet = null;
        indexedTreeMap.descendingMap = null;
        try {
            indexedTreeMap.buildFromSorted(this.size, this.entrySet().iterator(), null, null);
        }
        catch (IOException | ClassNotFoundException exception) {
            // empty catch block
        }
        return indexedTreeMap;
    }

    @Override
    public Comparator<? super K> comparator() {
        return this.comparator;
    }

    public final int compare(Object object, Object object2) {
        return this.comparator == null ? ((Comparable)object).compareTo(object2) : this.comparator.compare(object, object2);
    }

    @Override
    public boolean containsKey(Object object) {
        return this.getEntry(object) != null;
    }

    @Override
    public boolean containsValue(Object object) {
        Entry<K, V> entry = this.getFirstEntry();
        while (entry != null) {
            if (IndexedTreeMap.valEquals(object, entry.value)) {
                return true;
            }
            entry = IndexedTreeMap.successor(entry);
        }
        return false;
    }

    public void dbg() {
        Entry<K, V> entry = this.getFirstEntry();
        while (entry != null) {
            String string = entry.left == null ? "null" : "   " + entry.left.key;
            String string2 = entry.right == null ? "null" : "   " + entry.right.key;
            System.out.println(entry.key + ":" + string + ":" + string2 + ":" + entry.weight);
            entry = IndexedTreeMap.successor(entry);
        }
    }

    public void debug() throws Exception {
        Entry<K, V> entry = this.getFirstEntry();
        while (entry != null) {
            if (entry.weight != entry.sumup()) {
                throw new IllegalStateException("Weight is incorrect:" + entry.weight + "!=" + entry.sumup() + " for " + entry.key);
            }
            entry = IndexedTreeMap.successor(entry);
        }
    }

    private void deleteEntry(Entry<K, V> entry) {
        Entry<K, V> entry2;
        Entry<K, V> entry3 = entry;
        ++this.modCount;
        --this.size;
        if (entry3.left != null && entry3.right != null) {
            entry2 = IndexedTreeMap.successor(entry3);
            entry3.key = entry2.key;
            entry3.value = entry2.value;
            entry3 = entry2;
        }
        Entry entry4 = entry2 = entry3.left != null ? entry3.left : entry3.right;
        if (entry2 != null) {
            entry2.parent = entry3.parent;
            if (entry3.parent == null) {
                this.root = entry2;
            } else if (entry3 == entry3.parent.left) {
                int n2 = IndexedTreeMap.getWeight(entry2) - IndexedTreeMap.getWeight(entry3.parent.left);
                entry3.parent.left = entry2;
                entry3.parent.updateWeight(n2);
            } else {
                int n3 = IndexedTreeMap.getWeight(entry2) - IndexedTreeMap.getWeight(entry3.parent.right);
                entry3.parent.right = entry2;
                entry3.parent.updateWeight(n3);
            }
            entry3.parent = null;
            entry3.right = null;
            entry3.left = null;
            if (entry3.color) {
                this.fixAfterDeletion(entry2);
            }
        } else if (entry3.parent == null) {
            this.root = null;
        } else {
            if (entry3.color) {
                this.fixAfterDeletion(entry3);
            }
            if (entry3.parent != null) {
                if (entry3 == entry3.parent.left) {
                    entry3.parent.left = null;
                } else if (entry3 == entry3.parent.right) {
                    entry3.parent.right = null;
                }
                entry3.parent.updateWeight(-1);
                entry3.parent = null;
            }
        }
    }

    public Iterator<K> descendingKeyIterator() {
        return new DescendingKeyIterator(this.getLastEntry());
    }

    @Override
    public NavigableSet<K> descendingKeySet() {
        return this.descendingMap().navigableKeySet();
    }

    @Override
    public NavigableMap<K, V> descendingMap() {
        NavigableMap<K, V> navigableMap = this.descendingMap;
        return navigableMap != null ? navigableMap : (this.descendingMap = new DescendingSubMap(this, true, null, true, true, null, true));
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        EntrySet entrySet = this.entrySet;
        return entrySet == null ? (this.entrySet = new EntrySet()) : entrySet;
    }

    @Override
    public Entry<K, V> exactEntry(int n2) {
        return this.getExactEntry(this.root, n2);
    }

    @Override
    public K exactKey(int n2) {
        if (n2 < 0 || n2 > this.size() - 1) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.getExactKey(this.root, n2);
    }

    @Override
    public Map.Entry<K, V> firstEntry() {
        return IndexedTreeMap.exportEntry(this.getFirstEntry());
    }

    @Override
    public K firstKey() {
        return IndexedTreeMap.key(this.getFirstEntry());
    }

    private void fixAfterDeletion(Entry<K, V> entry) {
        while (entry != this.root && IndexedTreeMap.colorOf(entry)) {
            Entry<K, V> entry2;
            if (entry == IndexedTreeMap.leftOf(IndexedTreeMap.parentOf(entry))) {
                entry2 = IndexedTreeMap.rightOf(IndexedTreeMap.parentOf(entry));
                if (!IndexedTreeMap.colorOf(entry2)) {
                    IndexedTreeMap.setColor(entry2, true);
                    IndexedTreeMap.setColor(IndexedTreeMap.parentOf(entry), false);
                    this.rotateLeft(IndexedTreeMap.parentOf(entry));
                    entry2 = IndexedTreeMap.rightOf(IndexedTreeMap.parentOf(entry));
                }
                if (IndexedTreeMap.colorOf(IndexedTreeMap.leftOf(entry2)) && IndexedTreeMap.colorOf(IndexedTreeMap.rightOf(entry2))) {
                    IndexedTreeMap.setColor(entry2, false);
                    entry = IndexedTreeMap.parentOf(entry);
                    continue;
                }
                if (IndexedTreeMap.colorOf(IndexedTreeMap.rightOf(entry2))) {
                    IndexedTreeMap.setColor(IndexedTreeMap.leftOf(entry2), true);
                    IndexedTreeMap.setColor(entry2, false);
                    this.rotateRight(entry2);
                    entry2 = IndexedTreeMap.rightOf(IndexedTreeMap.parentOf(entry));
                }
                IndexedTreeMap.setColor(entry2, IndexedTreeMap.colorOf(IndexedTreeMap.parentOf(entry)));
                IndexedTreeMap.setColor(IndexedTreeMap.parentOf(entry), true);
                IndexedTreeMap.setColor(IndexedTreeMap.rightOf(entry2), true);
                this.rotateLeft(IndexedTreeMap.parentOf(entry));
                entry = this.root;
                continue;
            }
            entry2 = IndexedTreeMap.leftOf(IndexedTreeMap.parentOf(entry));
            if (!IndexedTreeMap.colorOf(entry2)) {
                IndexedTreeMap.setColor(entry2, true);
                IndexedTreeMap.setColor(IndexedTreeMap.parentOf(entry), false);
                this.rotateRight(IndexedTreeMap.parentOf(entry));
                entry2 = IndexedTreeMap.leftOf(IndexedTreeMap.parentOf(entry));
            }
            if (IndexedTreeMap.colorOf(IndexedTreeMap.rightOf(entry2)) && IndexedTreeMap.colorOf(IndexedTreeMap.leftOf(entry2))) {
                IndexedTreeMap.setColor(entry2, false);
                entry = IndexedTreeMap.parentOf(entry);
                continue;
            }
            if (IndexedTreeMap.colorOf(IndexedTreeMap.leftOf(entry2))) {
                IndexedTreeMap.setColor(IndexedTreeMap.rightOf(entry2), true);
                IndexedTreeMap.setColor(entry2, false);
                this.rotateLeft(entry2);
                entry2 = IndexedTreeMap.leftOf(IndexedTreeMap.parentOf(entry));
            }
            IndexedTreeMap.setColor(entry2, IndexedTreeMap.colorOf(IndexedTreeMap.parentOf(entry)));
            IndexedTreeMap.setColor(IndexedTreeMap.parentOf(entry), true);
            IndexedTreeMap.setColor(IndexedTreeMap.leftOf(entry2), true);
            this.rotateRight(IndexedTreeMap.parentOf(entry));
            entry = this.root;
        }
        IndexedTreeMap.setColor(entry, true);
    }

    private void fixAfterInsertion(Entry<K, V> entry) {
        entry.color = false;
        while (entry != null && entry != this.root && !entry.parent.color) {
            Entry<K, V> entry2;
            if (IndexedTreeMap.parentOf(entry) == IndexedTreeMap.leftOf(IndexedTreeMap.parentOf(IndexedTreeMap.parentOf(entry)))) {
                entry2 = IndexedTreeMap.rightOf(IndexedTreeMap.parentOf(IndexedTreeMap.parentOf(entry)));
                if (!IndexedTreeMap.colorOf(entry2)) {
                    IndexedTreeMap.setColor(IndexedTreeMap.parentOf(entry), true);
                    IndexedTreeMap.setColor(entry2, true);
                    IndexedTreeMap.setColor(IndexedTreeMap.parentOf(IndexedTreeMap.parentOf(entry)), false);
                    entry = IndexedTreeMap.parentOf(IndexedTreeMap.parentOf(entry));
                    continue;
                }
                if (entry == IndexedTreeMap.rightOf(IndexedTreeMap.parentOf(entry))) {
                    entry = IndexedTreeMap.parentOf(entry);
                    this.rotateLeft(entry);
                }
                IndexedTreeMap.setColor(IndexedTreeMap.parentOf(entry), true);
                IndexedTreeMap.setColor(IndexedTreeMap.parentOf(IndexedTreeMap.parentOf(entry)), false);
                this.rotateRight(IndexedTreeMap.parentOf(IndexedTreeMap.parentOf(entry)));
                continue;
            }
            entry2 = IndexedTreeMap.leftOf(IndexedTreeMap.parentOf(IndexedTreeMap.parentOf(entry)));
            if (!IndexedTreeMap.colorOf(entry2)) {
                IndexedTreeMap.setColor(IndexedTreeMap.parentOf(entry), true);
                IndexedTreeMap.setColor(entry2, true);
                IndexedTreeMap.setColor(IndexedTreeMap.parentOf(IndexedTreeMap.parentOf(entry)), false);
                entry = IndexedTreeMap.parentOf(IndexedTreeMap.parentOf(entry));
                continue;
            }
            if (entry == IndexedTreeMap.leftOf(IndexedTreeMap.parentOf(entry))) {
                entry = IndexedTreeMap.parentOf(entry);
                this.rotateRight(entry);
            }
            IndexedTreeMap.setColor(IndexedTreeMap.parentOf(entry), true);
            IndexedTreeMap.setColor(IndexedTreeMap.parentOf(IndexedTreeMap.parentOf(entry)), false);
            this.rotateLeft(IndexedTreeMap.parentOf(IndexedTreeMap.parentOf(entry)));
        }
        this.root.color = true;
    }

    @Override
    public Map.Entry<K, V> floorEntry(K k2) {
        return IndexedTreeMap.exportEntry(this.getFloorEntry(k2));
    }

    @Override
    public K floorKey(K k2) {
        return IndexedTreeMap.keyOrNull(this.getFloorEntry(k2));
    }

    @Override
    public V get(Object object) {
        Entry<Object, V> entry = this.getEntry(object);
        return entry == null ? null : (V)entry.value;
    }

    public final Entry<K, V> getCeilingEntry(K k2) {
        Entry<K, V> entry = this.root;
        while (entry != null) {
            int n2 = this.compare(k2, entry.key);
            if (n2 < 0) {
                if (entry.left != null) {
                    entry = entry.left;
                    continue;
                }
                return entry;
            }
            if (n2 > 0) {
                if (entry.right != null) {
                    entry = entry.right;
                    continue;
                }
                Entry entry2 = entry.parent;
                Entry<K, V> entry3 = entry;
                while (entry2 != null && entry3 == entry2.right) {
                    entry3 = entry2;
                    entry2 = entry2.parent;
                }
                return entry2;
            }
            return entry;
        }
        return null;
    }

    public final Entry<K, V> getEntry(K k2) {
        if (this.comparator != null) {
            return this.getEntryUsingComparator(k2);
        }
        if (k2 == null) {
            throw new IllegalStateException("key is null");
        }
        Comparable comparable = (Comparable)k2;
        Entry<K, V> entry = this.root;
        while (entry != null) {
            int n2 = comparable.compareTo(entry.key);
            if (n2 < 0) {
                entry = entry.left;
                continue;
            }
            if (n2 > 0) {
                entry = entry.right;
                continue;
            }
            return entry;
        }
        return null;
    }

    public final Entry<K, V> getEntryUsingComparator(K k2) {
        K k3 = k2;
        Comparator<K> comparator = this.comparator;
        if (comparator != null) {
            Entry<K, V> entry = this.root;
            while (entry != null) {
                int n2 = comparator.compare(k3, entry.key);
                if (n2 < 0) {
                    entry = entry.left;
                    continue;
                }
                if (n2 > 0) {
                    entry = entry.right;
                    continue;
                }
                return entry;
            }
        }
        return null;
    }

    private Entry<K, V> getExactEntry(Entry<K, V> entry, int n2) {
        if (entry.left == null && n2 == 0) {
            return entry;
        }
        if (entry.left == null && entry.right == null) {
            return entry;
        }
        if (entry.left != null && entry.left.weight > n2) {
            return this.getExactEntry(entry.left, n2);
        }
        if (entry.left != null && entry.left.weight == n2) {
            return entry;
        }
        return this.getExactEntry(entry.right, n2 - (entry.left == null ? 0 : entry.left.weight) - 1);
    }

    private K getExactKey(Entry<K, V> entry, int n2) {
        if (entry.left == null && n2 == 0) {
            return entry.key;
        }
        if (entry.left == null && entry.right == null) {
            return entry.key;
        }
        if (entry.left != null && entry.left.weight > n2) {
            return this.getExactKey(entry.left, n2);
        }
        if (entry.left != null && entry.left.weight == n2) {
            return entry.key;
        }
        return this.getExactKey(entry.right, n2 - (entry.left == null ? 0 : entry.left.weight) - 1);
    }

    public final Entry<K, V> getFirstEntry() {
        Entry<K, V> entry = this.root;
        if (entry != null) {
            while (entry.left != null) {
                entry = entry.left;
            }
        }
        return entry;
    }

    public final Entry<K, V> getFloorEntry(K k2) {
        Entry<K, V> entry = this.root;
        while (entry != null) {
            int n2 = this.compare(k2, entry.key);
            if (n2 > 0) {
                if (entry.right != null) {
                    entry = entry.right;
                    continue;
                }
                return entry;
            }
            if (n2 < 0) {
                if (entry.left != null) {
                    entry = entry.left;
                    continue;
                }
                Entry entry2 = entry.parent;
                Entry<K, V> entry3 = entry;
                while (entry2 != null && entry3 == entry2.left) {
                    entry3 = entry2;
                    entry2 = entry2.parent;
                }
                return entry2;
            }
            return entry;
        }
        return null;
    }

    public final Entry<K, V> getHigherEntry(K k2) {
        Entry<K, V> entry = this.root;
        while (entry != null) {
            int n2 = this.compare(k2, entry.key);
            if (n2 < 0) {
                if (entry.left != null) {
                    entry = entry.left;
                    continue;
                }
                return entry;
            }
            if (entry.right != null) {
                entry = entry.right;
                continue;
            }
            Entry entry2 = entry.parent;
            Entry<K, V> entry3 = entry;
            while (entry2 != null && entry3 == entry2.right) {
                entry3 = entry2;
                entry2 = entry2.parent;
            }
            return entry2;
        }
        return null;
    }

    public final Entry<K, V> getLastEntry() {
        Entry<K, V> entry = this.root;
        if (entry != null) {
            while (entry.right != null) {
                entry = entry.right;
            }
        }
        return entry;
    }

    public final Entry<K, V> getLowerEntry(K k2) {
        Entry<K, V> entry = this.root;
        while (entry != null) {
            int n2 = this.compare(k2, entry.key);
            if (n2 > 0) {
                if (entry.right != null) {
                    entry = entry.right;
                    continue;
                }
                return entry;
            }
            if (entry.left != null) {
                entry = entry.left;
                continue;
            }
            Entry entry2 = entry.parent;
            Entry<K, V> entry3 = entry;
            while (entry2 != null && entry3 == entry2.left) {
                entry3 = entry2;
                entry2 = entry2.parent;
            }
            return entry2;
        }
        return null;
    }

    @Override
    public SortedMap<K, V> headMap(K k2) {
        return this.headMap(k2, false);
    }

    @Override
    public NavigableMap<K, V> headMap(K k2, boolean bl2) {
        return new AscendingSubMap(this, true, null, true, false, k2, bl2);
    }

    @Override
    public Map.Entry<K, V> higherEntry(K k2) {
        return IndexedTreeMap.exportEntry(this.getHigherEntry(k2));
    }

    @Override
    public K higherKey(K k2) {
        return IndexedTreeMap.keyOrNull(this.getHigherEntry(k2));
    }

    @Override
    public int keyIndex(K k2) {
        if (k2 == null) {
            throw new IllegalStateException("key should be non-null");
        }
        Entry<K, V> entry = this.getEntry(k2);
        if (entry == null) {
            throw new IllegalStateException("element is null for key = " + k2);
        }
        if (entry == this.root) {
            return IndexedTreeMap.getWeight(entry) - IndexedTreeMap.getWeight(entry.right) - 1;
        }
        int n2 = 0;
        n2 += IndexedTreeMap.getWeight(entry.left);
        Entry entry2 = entry.parent;
        Comparator<K> comparator = this.comparator;
        if (comparator != null) {
            while (entry2 != null) {
                int n3 = comparator.compare(k2, entry2.key);
                if (n3 > 0) {
                    n2 += IndexedTreeMap.getWeight(entry2.left) + 1;
                }
                entry2 = entry2.parent;
            }
        } else {
            Comparable comparable = (Comparable)k2;
            while (entry2 != null) {
                if (comparable.compareTo(entry2.key) > 0) {
                    n2 += IndexedTreeMap.getWeight(entry2.left) + 1;
                }
                entry2 = entry2.parent;
            }
        }
        return n2;
    }

    public Iterator<K> keyIterator() {
        return new KeyIterator(this.getFirstEntry());
    }

    @Override
    public Set<K> keySet() {
        return this.navigableKeySet();
    }

    @Override
    public Map.Entry<K, V> lastEntry() {
        return IndexedTreeMap.exportEntry(this.getLastEntry());
    }

    @Override
    public K lastKey() {
        return IndexedTreeMap.key(this.getLastEntry());
    }

    @Override
    public Map.Entry<K, V> lowerEntry(K k2) {
        return IndexedTreeMap.exportEntry(this.getLowerEntry(k2));
    }

    @Override
    public K lowerKey(K k2) {
        return IndexedTreeMap.keyOrNull(this.getLowerEntry(k2));
    }

    @Override
    public NavigableSet<K> navigableKeySet() {
        KeySet<K> keySet = this.navigableKeySet;
        return keySet != null ? keySet : (this.navigableKeySet = new KeySet(this));
    }

    @Override
    public Map.Entry<K, V> pollFirstEntry() {
        Entry<K, V> entry = this.getFirstEntry();
        Map.Entry<K, V> entry2 = IndexedTreeMap.exportEntry(entry);
        if (entry != null) {
            this.deleteEntry(entry);
        }
        return entry2;
    }

    @Override
    public Map.Entry<K, V> pollLastEntry() {
        Entry<K, V> entry = this.getLastEntry();
        Map.Entry<K, V> entry2 = IndexedTreeMap.exportEntry(entry);
        if (entry != null) {
            this.deleteEntry(entry);
        }
        return entry2;
    }

    @Override
    public V put(K k2, V v2) {
        Object object;
        int n2;
        Entry<K, V> entry;
        Entry<K, V> entry2 = this.root;
        if (entry2 == null) {
            this.root = new Entry<K, V>(k2, v2, null);
            this.root.weight = 1;
            this.size = 1;
            ++this.modCount;
            return null;
        }
        Comparator<K> comparator = this.comparator;
        if (comparator != null) {
            do {
                entry = entry2;
                n2 = comparator.compare(k2, entry2.key);
                if (n2 < 0) {
                    entry2 = entry2.left;
                    continue;
                }
                if (n2 > 0) {
                    entry2 = entry2.right;
                    continue;
                }
                return entry2.setValue(v2);
            } while (entry2 != null);
        } else {
            if (k2 == null) {
                throw new IllegalStateException("key is null");
            }
            object = (Comparable)k2;
            do {
                entry = entry2;
                n2 = object.compareTo(entry2.key);
                if (n2 < 0) {
                    entry2 = entry2.left;
                    continue;
                }
                if (n2 > 0) {
                    entry2 = entry2.right;
                    continue;
                }
                return entry2.setValue(v2);
            } while (entry2 != null);
        }
        object = new Entry<K, V>(k2, v2, entry);
        if (n2 < 0) {
            entry.left = object;
        } else {
            entry.right = object;
        }
        ((Entry)object).updateWeight(1);
        this.fixAfterInsertion((Entry<K, V>)object);
        ++this.size;
        ++this.modCount;
        return null;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        Comparator comparator;
        int n2 = map.size();
        if (this.size == 0 && n2 != 0 && map instanceof SortedMap && Objects.equals(comparator = ((SortedMap)map).comparator(), this.comparator)) {
            ++this.modCount;
            try {
                this.buildFromSorted(n2, map.entrySet().iterator(), null, null);
            }
            catch (IOException | ClassNotFoundException exception) {
                // empty catch block
            }
            return;
        }
        super.putAll(map);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n2 = objectInputStream.readInt();
        this.buildFromSorted(n2, null, objectInputStream, null);
    }

    public void readTreeSet(int n2, ObjectInputStream objectInputStream, V v2) throws IOException, ClassNotFoundException {
        this.buildFromSorted(n2, null, objectInputStream, v2);
        if (this.root != null) {
            this.updateWeight(this.root);
        }
    }

    @Override
    public V remove(Object object) {
        Entry<Object, V> entry = this.getEntry(object);
        if (entry == null) {
            return null;
        }
        Object v2 = entry.value;
        this.deleteEntry(entry);
        return v2;
    }

    private void rotateLeft(Entry<K, V> entry) {
        if (entry != null) {
            Entry entry2 = entry.right;
            int n2 = IndexedTreeMap.getWeight(entry2.left) - IndexedTreeMap.getWeight(entry.right);
            entry.right = entry2.left;
            entry.updateWeight(n2);
            if (entry2.left != null) {
                entry2.left.parent = entry;
            }
            entry2.parent = entry.parent;
            if (entry.parent == null) {
                this.root = entry2;
            } else if (entry.parent.left == entry) {
                n2 = IndexedTreeMap.getWeight(entry2) - IndexedTreeMap.getWeight(entry.parent.left);
                entry.parent.left = entry2;
                entry.parent.updateWeight(n2);
            } else {
                n2 = IndexedTreeMap.getWeight(entry2) - IndexedTreeMap.getWeight(entry.parent.right);
                entry.parent.right = entry2;
                entry.parent.updateWeight(n2);
            }
            n2 = IndexedTreeMap.getWeight(entry) - IndexedTreeMap.getWeight(entry2.left);
            entry2.left = entry;
            entry2.updateWeight(n2);
            entry.parent = entry2;
        }
    }

    private void rotateRight(Entry<K, V> entry) {
        if (entry != null) {
            Entry entry2 = entry.left;
            int n2 = IndexedTreeMap.getWeight(entry2.right) - IndexedTreeMap.getWeight(entry.left);
            entry.left = entry2.right;
            entry.updateWeight(n2);
            if (entry2.right != null) {
                entry2.right.parent = entry;
            }
            entry2.parent = entry.parent;
            if (entry.parent == null) {
                this.root = entry2;
            } else if (entry.parent.right == entry) {
                n2 = IndexedTreeMap.getWeight(entry2) - IndexedTreeMap.getWeight(entry.parent.right);
                entry.parent.right = entry2;
                entry.parent.updateWeight(n2);
            } else {
                n2 = IndexedTreeMap.getWeight(entry2) - IndexedTreeMap.getWeight(entry.parent.left);
                entry.parent.left = entry2;
                entry.parent.updateWeight(n2);
            }
            n2 = IndexedTreeMap.getWeight(entry) - IndexedTreeMap.getWeight(entry2.right);
            entry2.right = entry;
            entry2.updateWeight(n2);
            entry.parent = entry2;
        }
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public NavigableMap<K, V> subMap(K k2, boolean bl2, K k3, boolean bl3) {
        return new AscendingSubMap(this, false, k2, bl2, false, k3, bl3);
    }

    @Override
    public SortedMap<K, V> subMap(K k2, K k3) {
        return this.subMap(k2, true, k3, false);
    }

    @Override
    public SortedMap<K, V> tailMap(K k2) {
        return this.tailMap(k2, true);
    }

    @Override
    public NavigableMap<K, V> tailMap(K k2, boolean bl2) {
        return new AscendingSubMap(this, false, k2, bl2, true, null, true);
    }

    private int updateWeight(Entry<K, V> entry) {
        int n2 = 1;
        if (entry.left != null) {
            n2 += this.updateWeight(entry.left);
        }
        if (entry.right != null) {
            n2 += this.updateWeight(entry.right);
        }
        entry.weight = n2;
        return n2;
    }

    @Override
    public Collection<V> values() {
        Collection collection = this.values;
        return collection != null ? collection : (this.values = new Values());
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.size);
        for (Map.Entry<K, V> entry : this.entrySet()) {
            objectOutputStream.writeObject(entry.getKey());
            objectOutputStream.writeObject(entry.getValue());
        }
    }

    private static <K, V> boolean colorOf(Entry<K, V> entry) {
        return entry == null ? true : entry.color;
    }

    private static int computeRedLevel(int n2) {
        int n3 = 0;
        int n4 = n2 - 1;
        while (n4 >= 0) {
            ++n3;
            n4 = n4 / 2 - 1;
        }
        return n3;
    }

    public static <K, V> Map.Entry<K, V> exportEntry(Entry<K, V> entry) {
        return entry == null ? null : new AbstractMap.SimpleImmutableEntry<K, V>(entry);
    }

    private static <K, V> int getWeight(Entry<K, V> entry) {
        return entry == null ? 0 : entry.weight;
    }

    public static <K> K key(Entry<K, ?> entry) {
        if (entry == null) {
            throw new NoSuchElementException();
        }
        return entry.key;
    }

    public static <K, V> K keyOrNull(Entry<K, V> entry) {
        return entry == null ? null : (K)entry.key;
    }

    private static <K, V> Entry<K, V> leftOf(Entry<K, V> entry) {
        return entry == null ? null : entry.left;
    }

    private static <K, V> Entry<K, V> parentOf(Entry<K, V> entry) {
        return entry == null ? null : entry.parent;
    }

    public static <K, V> Entry<K, V> predecessor(Entry<K, V> entry) {
        if (entry == null) {
            return null;
        }
        if (entry.left != null) {
            Entry entry2 = entry.left;
            while (entry2.right != null) {
                entry2 = entry2.right;
            }
            return entry2;
        }
        Entry entry3 = entry.parent;
        Entry<K, V> entry4 = entry;
        while (entry3 != null && entry4 == entry3.left) {
            entry4 = entry3;
            entry3 = entry3.parent;
        }
        return entry3;
    }

    private static <K, V> Entry<K, V> rightOf(Entry<K, V> entry) {
        return entry == null ? null : entry.right;
    }

    private static <K, V> void setColor(Entry<K, V> entry, boolean bl2) {
        if (entry != null) {
            entry.color = bl2;
        }
    }

    public static <K, V> Entry<K, V> successor(Entry<K, V> entry) {
        if (entry == null) {
            return null;
        }
        if (entry.right != null) {
            Entry entry2 = entry.right;
            while (entry2.left != null) {
                entry2 = entry2.left;
            }
            return entry2;
        }
        Entry entry3 = entry.parent;
        Entry<K, V> entry4 = entry;
        while (entry3 != null && entry4 == entry3.right) {
            entry4 = entry3;
            entry3 = entry3.parent;
        }
        return entry3;
    }

    public static boolean valEquals(Object object, Object object2) {
        return Objects.equals(object, object2);
    }

    protected static final class Entry<K, V>
    implements Map.Entry<K, V> {
        protected K key;
        protected V value;
        protected Entry<K, V> left = null;
        protected Entry<K, V> right = null;
        protected Entry<K, V> parent;
        protected boolean color = true;
        protected int weight = 0;

        protected Entry(K k2, V v2, Entry<K, V> entry) {
            this.key = k2;
            this.value = v2;
            this.parent = entry;
        }

        @Override
        public boolean equals(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            return IndexedTreeMap.valEquals(this.key, entry.getKey()) && IndexedTreeMap.valEquals(this.value, entry.getValue());
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public int hashCode() {
            int n2 = this.key == null ? 0 : this.key.hashCode();
            int n3 = this.value == null ? 0 : this.value.hashCode();
            return n2 ^ n3;
        }

        @Override
        public V setValue(V v2) {
            V v3 = this.value;
            this.value = v2;
            return v3;
        }

        public int sumup() {
            int n2 = this.left == null ? 0 : this.left.sumup();
            int n3 = this.right == null ? 0 : this.right.sumup();
            return n2 + n3 + 1;
        }

        public String toString() {
            return this.key + "=" + this.value;
        }

        public void updateWeight(int n2) {
            this.weight += n2;
            Entry<K, V> entry = this.parent;
            while (entry != null) {
                entry.weight += n2;
                entry = entry.parent;
            }
        }
    }

    class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        EntrySet() {
        }

        @Override
        public void clear() {
            IndexedTreeMap.this.clear();
        }

        @Override
        public boolean contains(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            Object v2 = entry.getValue();
            Entry entry2 = IndexedTreeMap.this.getEntry(entry.getKey());
            return entry2 != null && IndexedTreeMap.valEquals(entry2.getValue(), v2);
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new EntryIterator(IndexedTreeMap.this.getFirstEntry());
        }

        @Override
        public boolean remove(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            Object v2 = entry.getValue();
            Entry entry2 = IndexedTreeMap.this.getEntry(entry.getKey());
            if (entry2 != null && IndexedTreeMap.valEquals(entry2.getValue(), v2)) {
                IndexedTreeMap.this.deleteEntry(entry2);
                return true;
            }
            return false;
        }

        @Override
        public int size() {
            return IndexedTreeMap.this.size();
        }
    }

    static final class KeySet<E>
    extends AbstractSet<E>
    implements NavigableSet<E> {
        private final NavigableMap<E, Object> m;

        KeySet(NavigableMap<E, Object> navigableMap) {
            this.m = navigableMap;
        }

        @Override
        public E ceiling(E e2) {
            return this.m.ceilingKey(e2);
        }

        @Override
        public void clear() {
            this.m.clear();
        }

        @Override
        public Comparator<? super E> comparator() {
            return this.m.comparator();
        }

        @Override
        public boolean contains(Object object) {
            return this.m.containsKey(object);
        }

        @Override
        public Iterator<E> descendingIterator() {
            if (this.m instanceof IndexedTreeMap) {
                return ((IndexedTreeMap)this.m).descendingKeyIterator();
            }
            return ((NavigableSubMap)this.m).descendingKeyIterator();
        }

        @Override
        public NavigableSet<E> descendingSet() {
            return new IndexedTreeSet<E>(this.m.descendingMap());
        }

        @Override
        public E first() {
            return (E)this.m.firstKey();
        }

        @Override
        public E floor(E e2) {
            return this.m.floorKey(e2);
        }

        @Override
        public SortedSet<E> headSet(E e2) {
            return this.headSet(e2, false);
        }

        @Override
        public NavigableSet<E> headSet(E e2, boolean bl2) {
            return new IndexedTreeSet<E>(this.m.headMap(e2, bl2));
        }

        @Override
        public E higher(E e2) {
            return this.m.higherKey(e2);
        }

        @Override
        public boolean isEmpty() {
            return this.m.isEmpty();
        }

        @Override
        public Iterator<E> iterator() {
            if (this.m instanceof IndexedTreeMap) {
                return ((IndexedTreeMap)this.m).keyIterator();
            }
            return ((NavigableSubMap)this.m).keyIterator();
        }

        @Override
        public E last() {
            return (E)this.m.lastKey();
        }

        @Override
        public E lower(E e2) {
            return this.m.lowerKey(e2);
        }

        @Override
        public E pollFirst() {
            Map.Entry<E, Object> entry = this.m.pollFirstEntry();
            return entry == null ? null : (E)entry.getKey();
        }

        @Override
        public E pollLast() {
            Map.Entry<E, Object> entry = this.m.pollLastEntry();
            return entry == null ? null : (E)entry.getKey();
        }

        @Override
        public boolean remove(Object object) {
            int n2 = this.size();
            this.m.remove(object);
            return this.size() != n2;
        }

        @Override
        public int size() {
            return this.m.size();
        }

        @Override
        public NavigableSet<E> subSet(E e2, boolean bl2, E e3, boolean bl3) {
            return new IndexedTreeSet<E>(this.m.subMap(e2, bl2, e3, bl3));
        }

        @Override
        public SortedSet<E> subSet(E e2, E e3) {
            return this.subSet(e2, true, e3, false);
        }

        @Override
        public SortedSet<E> tailSet(E e2) {
            return this.tailSet(e2, true);
        }

        @Override
        public NavigableSet<E> tailSet(E e2, boolean bl2) {
            return new IndexedTreeSet<E>(this.m.tailMap(e2, bl2));
        }
    }

    final class DescendingKeyIterator
    extends PrivateEntryIterator<K> {
        DescendingKeyIterator(Entry<K, V> entry) {
            super(entry);
        }

        @Override
        public K next() {
            return this.prevEntry().key;
        }
    }

    static final class DescendingSubMap<K, V>
    extends NavigableSubMap<K, V> {
        private static final long serialVersionUID = 912986545866120460L;
        private final Comparator<? super K> reverseComparator;

        DescendingSubMap(IndexedTreeMap<K, V> indexedTreeMap, boolean bl2, K k2, boolean bl3, boolean bl4, K k3, boolean bl5) {
            super(indexedTreeMap, bl2, k2, bl3, bl4, k3, bl5);
            this.reverseComparator = Collections.reverseOrder(this.m.comparator);
        }

        @Override
        public Comparator<? super K> comparator() {
            return this.reverseComparator;
        }

        @Override
        public Iterator<K> descendingKeyIterator() {
            return new NavigableSubMap.SubMapKeyIterator(this.absLowest(), this.absHighFence());
        }

        @Override
        public NavigableMap<K, V> descendingMap() {
            AscendingSubMap ascendingSubMap = this.descendingMapView;
            return ascendingSubMap != null ? ascendingSubMap : (this.descendingMapView = new AscendingSubMap(this.m, this.fromStart, this.lo, this.loInclusive, this.toEnd, this.hi, this.hiInclusive));
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            NavigableSubMap.EntrySetView entrySetView = this.entrySetView;
            return entrySetView != null ? entrySetView : new DescendingEntrySetView();
        }

        @Override
        public NavigableMap<K, V> headMap(K k2, boolean bl2) {
            if (!this.inRange(k2, bl2)) {
                throw new IllegalArgumentException("toKey out of range");
            }
            return new DescendingSubMap<Object, V>(this.m, false, k2, bl2, this.toEnd, this.hi, this.hiInclusive);
        }

        @Override
        public Iterator<K> keyIterator() {
            return new NavigableSubMap.DescendingSubMapKeyIterator(this.absHighest(), this.absLowFence());
        }

        @Override
        public Entry<K, V> subCeiling(K k2) {
            return this.absFloor(k2);
        }

        @Override
        public Entry<K, V> subFloor(K k2) {
            return this.absCeiling(k2);
        }

        @Override
        public Entry<K, V> subHigher(K k2) {
            return this.absLower(k2);
        }

        @Override
        public Entry<K, V> subHighest() {
            return this.absLowest();
        }

        @Override
        public Entry<K, V> subLower(K k2) {
            return this.absHigher(k2);
        }

        @Override
        public Entry<K, V> subLowest() {
            return this.absHighest();
        }

        @Override
        public NavigableMap<K, V> subMap(K k2, boolean bl2, K k3, boolean bl3) {
            if (!this.inRange(k2, bl2)) {
                throw new IllegalArgumentException("fromKey out of range");
            }
            if (!this.inRange(k3, bl3)) {
                throw new IllegalArgumentException("toKey out of range");
            }
            return new DescendingSubMap<K, V>(this.m, false, k3, bl3, false, k2, bl2);
        }

        @Override
        public NavigableMap<K, V> tailMap(K k2, boolean bl2) {
            if (!this.inRange(k2, bl2)) {
                throw new IllegalArgumentException("fromKey out of range");
            }
            return new DescendingSubMap<Object, V>(this.m, this.fromStart, this.lo, this.loInclusive, false, k2, bl2);
        }

        protected final class DescendingEntrySetView
        extends NavigableSubMap.EntrySetView {
            protected DescendingEntrySetView() {
            }

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                return new NavigableSubMap.DescendingSubMapEntryIterator(DescendingSubMap.this.absHighest(), DescendingSubMap.this.absLowFence());
            }
        }
    }

    protected static final class AscendingSubMap<K, V>
    extends NavigableSubMap<K, V> {
        private static final long serialVersionUID = 912986545866124060L;

        AscendingSubMap(IndexedTreeMap<K, V> indexedTreeMap, boolean bl2, K k2, boolean bl3, boolean bl4, K k3, boolean bl5) {
            super(indexedTreeMap, bl2, k2, bl3, bl4, k3, bl5);
        }

        @Override
        public Comparator<? super K> comparator() {
            return this.m.comparator();
        }

        @Override
        public Iterator<K> descendingKeyIterator() {
            return new NavigableSubMap.DescendingSubMapKeyIterator(this.absHighest(), this.absLowFence());
        }

        @Override
        public NavigableMap<K, V> descendingMap() {
            DescendingSubMap descendingSubMap = this.descendingMapView;
            return descendingSubMap != null ? descendingSubMap : (this.descendingMapView = new DescendingSubMap(this.m, this.fromStart, this.lo, this.loInclusive, this.toEnd, this.hi, this.hiInclusive));
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            NavigableSubMap.EntrySetView entrySetView = this.entrySetView;
            return entrySetView != null ? entrySetView : new AscendingEntrySetView();
        }

        @Override
        public NavigableMap<K, V> headMap(K k2, boolean bl2) {
            if (!this.inRange(k2, bl2)) {
                throw new IllegalArgumentException("toKey out of range");
            }
            return new AscendingSubMap<Object, V>(this.m, this.fromStart, this.lo, this.loInclusive, false, k2, bl2);
        }

        @Override
        public Iterator<K> keyIterator() {
            return new NavigableSubMap.SubMapKeyIterator(this.absLowest(), this.absHighFence());
        }

        @Override
        public Entry<K, V> subCeiling(K k2) {
            return this.absCeiling(k2);
        }

        @Override
        public Entry<K, V> subFloor(K k2) {
            return this.absFloor(k2);
        }

        @Override
        public Entry<K, V> subHigher(K k2) {
            return this.absHigher(k2);
        }

        @Override
        public Entry<K, V> subHighest() {
            return this.absHighest();
        }

        @Override
        public Entry<K, V> subLower(K k2) {
            return this.absLower(k2);
        }

        @Override
        public Entry<K, V> subLowest() {
            return this.absLowest();
        }

        @Override
        public NavigableMap<K, V> subMap(K k2, boolean bl2, K k3, boolean bl3) {
            if (!this.inRange(k2, bl2)) {
                throw new IllegalArgumentException("fromKey out of range");
            }
            if (!this.inRange(k3, bl3)) {
                throw new IllegalArgumentException("toKey out of range");
            }
            return new AscendingSubMap<K, V>(this.m, false, k2, bl2, false, k3, bl3);
        }

        @Override
        public NavigableMap<K, V> tailMap(K k2, boolean bl2) {
            if (!this.inRange(k2, bl2)) {
                throw new IllegalArgumentException("fromKey out of range");
            }
            return new AscendingSubMap<Object, V>(this.m, false, k2, bl2, this.toEnd, this.hi, this.hiInclusive);
        }

        protected final class AscendingEntrySetView
        extends NavigableSubMap.EntrySetView {
            protected AscendingEntrySetView() {
            }

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                return new NavigableSubMap.SubMapEntryIterator(AscendingSubMap.this.absLowest(), AscendingSubMap.this.absHighFence());
            }
        }
    }

    final class KeyIterator
    extends PrivateEntryIterator<K> {
        KeyIterator(Entry<K, V> entry) {
            super(entry);
        }

        @Override
        public K next() {
            return this.nextEntry().key;
        }
    }

    class Values
    extends AbstractCollection<V> {
        Values() {
        }

        @Override
        public void clear() {
            IndexedTreeMap.this.clear();
        }

        @Override
        public boolean contains(Object object) {
            return IndexedTreeMap.this.containsValue(object);
        }

        @Override
        public Iterator<V> iterator() {
            return new ValueIterator(IndexedTreeMap.this.getFirstEntry());
        }

        @Override
        public boolean remove(Object object) {
            Entry entry = IndexedTreeMap.this.getFirstEntry();
            while (entry != null) {
                if (IndexedTreeMap.valEquals(entry.getValue(), object)) {
                    IndexedTreeMap.this.deleteEntry(entry);
                    return true;
                }
                entry = IndexedTreeMap.successor(entry);
            }
            return false;
        }

        @Override
        public int size() {
            return IndexedTreeMap.this.size();
        }
    }

    protected final class ValueIterator
    extends PrivateEntryIterator<V> {
        ValueIterator(Entry<K, V> entry) {
            super(entry);
        }

        @Override
        public V next() {
            return this.nextEntry().value;
        }
    }

    protected abstract class PrivateEntryIterator<T>
    implements Iterator<T> {
        protected Entry<K, V> next;
        protected Entry<K, V> lastReturned;
        protected int expectedModCount;

        protected PrivateEntryIterator(Entry<K, V> entry) {
            this.expectedModCount = IndexedTreeMap.this.modCount;
            this.lastReturned = null;
            this.next = entry;
        }

        @Override
        public final boolean hasNext() {
            return this.next != null;
        }

        public final Entry<K, V> nextEntry() {
            Entry entry = this.next;
            if (entry == null) {
                throw new NoSuchElementException();
            }
            if (IndexedTreeMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            this.next = IndexedTreeMap.successor(entry);
            this.lastReturned = entry;
            return entry;
        }

        public final Entry<K, V> prevEntry() {
            Entry entry = this.next;
            if (entry == null) {
                throw new NoSuchElementException();
            }
            if (IndexedTreeMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            this.next = IndexedTreeMap.predecessor(entry);
            this.lastReturned = entry;
            return entry;
        }

        @Override
        public void remove() {
            if (this.lastReturned == null) {
                throw new IllegalStateException();
            }
            if (IndexedTreeMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            if (this.lastReturned.left != null && this.lastReturned.right != null) {
                this.next = this.lastReturned;
            }
            IndexedTreeMap.this.deleteEntry(this.lastReturned);
            this.expectedModCount = IndexedTreeMap.this.modCount;
            this.lastReturned = null;
        }
    }

    static abstract class NavigableSubMap<K, V>
    extends java.util.AbstractMap<K, V>
    implements NavigableMap<K, V>,
    Serializable {
        private static final long serialVersionUID = 2043167872700380033L;
        protected final IndexedTreeMap<K, V> m;
        protected final K lo;
        protected final K hi;
        protected final boolean fromStart;
        protected final boolean toEnd;
        protected final boolean loInclusive;
        protected final boolean hiInclusive;
        protected NavigableMap<K, V> descendingMapView = null;
        protected EntrySetView entrySetView = null;
        protected KeySet<K> navigableKeySetView = null;

        protected NavigableSubMap(IndexedTreeMap<K, V> indexedTreeMap, boolean bl2, K k2, boolean bl3, boolean bl4, K k3, boolean bl5) {
            if (indexedTreeMap == null) {
                throw new IllegalStateException("m must not be null");
            }
            if (!bl2 && !bl4 && indexedTreeMap.compare(k2, k3) > 0) {
                throw new IllegalArgumentException("fromKey > toKey");
            }
            this.m = indexedTreeMap;
            this.fromStart = bl2;
            this.lo = k2;
            this.loInclusive = bl3;
            this.toEnd = bl4;
            this.hi = k3;
            this.hiInclusive = bl5;
        }

        public final Entry<K, V> absCeiling(K k2) {
            if (this.tooLow(k2)) {
                return this.absLowest();
            }
            Entry<K, V> entry = this.m.getCeilingEntry(k2);
            return entry == null || this.tooHigh(entry.key) ? null : entry;
        }

        public final Entry<K, V> absFloor(K k2) {
            if (this.tooHigh(k2)) {
                return this.absHighest();
            }
            Entry<K, V> entry = this.m.getFloorEntry(k2);
            return entry == null || this.tooLow(entry.key) ? null : entry;
        }

        public final Entry<K, V> absHigher(K k2) {
            if (this.tooLow(k2)) {
                return this.absLowest();
            }
            Entry<K, V> entry = this.m.getHigherEntry(k2);
            return entry == null || this.tooHigh(entry.key) ? null : entry;
        }

        public final Entry<K, V> absHighest() {
            Entry<K, V> entry = this.toEnd ? this.m.getLastEntry() : (this.hiInclusive ? this.m.getFloorEntry(this.hi) : this.m.getLowerEntry(this.hi));
            return entry == null || this.tooLow(entry.key) ? null : entry;
        }

        public final Entry<K, V> absHighFence() {
            return this.toEnd ? null : (this.hiInclusive ? this.m.getHigherEntry(this.hi) : this.m.getCeilingEntry(this.hi));
        }

        public final Entry<K, V> absLower(K k2) {
            if (this.tooHigh(k2)) {
                return this.absHighest();
            }
            Entry<K, V> entry = this.m.getLowerEntry(k2);
            return entry == null || this.tooLow(entry.key) ? null : entry;
        }

        public final Entry<K, V> absLowest() {
            Entry<K, V> entry = this.fromStart ? this.m.getFirstEntry() : (this.loInclusive ? this.m.getCeilingEntry(this.lo) : this.m.getHigherEntry(this.lo));
            return entry == null || this.tooHigh(entry.key) ? null : entry;
        }

        public final Entry<K, V> absLowFence() {
            return this.fromStart ? null : (this.loInclusive ? this.m.getLowerEntry(this.lo) : this.m.getFloorEntry(this.lo));
        }

        @Override
        public final Map.Entry<K, V> ceilingEntry(K k2) {
            return IndexedTreeMap.exportEntry(this.subCeiling(k2));
        }

        @Override
        public final K ceilingKey(K k2) {
            return IndexedTreeMap.keyOrNull(this.subCeiling(k2));
        }

        @Override
        public final boolean containsKey(Object object) {
            return this.inRange(object) && this.m.containsKey(object);
        }

        protected abstract Iterator<K> descendingKeyIterator();

        @Override
        public NavigableSet<K> descendingKeySet() {
            return this.descendingMap().navigableKeySet();
        }

        @Override
        public final Map.Entry<K, V> firstEntry() {
            return IndexedTreeMap.exportEntry(this.subLowest());
        }

        @Override
        public final K firstKey() {
            return IndexedTreeMap.key(this.subLowest());
        }

        @Override
        public final Map.Entry<K, V> floorEntry(K k2) {
            return IndexedTreeMap.exportEntry(this.subFloor(k2));
        }

        @Override
        public final K floorKey(K k2) {
            return IndexedTreeMap.keyOrNull(this.subFloor(k2));
        }

        @Override
        public final V get(Object object) {
            return !this.inRange(object) ? null : (V)this.m.get(object);
        }

        @Override
        public final SortedMap<K, V> headMap(K k2) {
            return this.headMap(k2, false);
        }

        @Override
        public final Map.Entry<K, V> higherEntry(K k2) {
            return IndexedTreeMap.exportEntry(this.subHigher(k2));
        }

        @Override
        public final K higherKey(K k2) {
            return IndexedTreeMap.keyOrNull(this.subHigher(k2));
        }

        public final boolean inClosedRange(Object object) {
            return !(!this.fromStart && this.m.compare(object, this.lo) < 0 || !this.toEnd && this.m.compare(this.hi, object) < 0);
        }

        public final boolean inRange(Object object) {
            return !this.tooLow(object) && !this.tooHigh(object);
        }

        public final boolean inRange(Object object, boolean bl2) {
            return bl2 ? this.inRange(object) : this.inClosedRange(object);
        }

        @Override
        public boolean isEmpty() {
            return this.fromStart && this.toEnd ? this.m.isEmpty() : this.entrySet().isEmpty();
        }

        protected abstract Iterator<K> keyIterator();

        @Override
        public final Set<K> keySet() {
            return this.navigableKeySet();
        }

        @Override
        public final Map.Entry<K, V> lastEntry() {
            return IndexedTreeMap.exportEntry(this.subHighest());
        }

        @Override
        public final K lastKey() {
            return IndexedTreeMap.key(this.subHighest());
        }

        @Override
        public final Map.Entry<K, V> lowerEntry(K k2) {
            return IndexedTreeMap.exportEntry(this.subLower(k2));
        }

        @Override
        public final K lowerKey(K k2) {
            return IndexedTreeMap.keyOrNull(this.subLower(k2));
        }

        @Override
        public final NavigableSet<K> navigableKeySet() {
            KeySet<K> keySet = this.navigableKeySetView;
            return keySet != null ? keySet : (this.navigableKeySetView = new KeySet(this));
        }

        @Override
        public final Map.Entry<K, V> pollFirstEntry() {
            Entry<K, V> entry = this.subLowest();
            Map.Entry<K, V> entry2 = IndexedTreeMap.exportEntry(entry);
            if (entry != null) {
                this.m.deleteEntry(entry);
            }
            return entry2;
        }

        @Override
        public final Map.Entry<K, V> pollLastEntry() {
            Entry<K, V> entry = this.subHighest();
            Map.Entry<K, V> entry2 = IndexedTreeMap.exportEntry(entry);
            if (entry != null) {
                this.m.deleteEntry(entry);
            }
            return entry2;
        }

        @Override
        public final V put(K k2, V v2) {
            if (!this.inRange(k2)) {
                throw new IllegalArgumentException("key out of range");
            }
            return this.m.put(k2, v2);
        }

        @Override
        public final V remove(Object object) {
            return !this.inRange(object) ? null : (V)this.m.remove(object);
        }

        @Override
        public int size() {
            return this.fromStart && this.toEnd ? this.m.size() : this.entrySet().size();
        }

        protected abstract Entry<K, V> subCeiling(K var1);

        protected abstract Entry<K, V> subFloor(K var1);

        protected abstract Entry<K, V> subHigher(K var1);

        protected abstract Entry<K, V> subHighest();

        protected abstract Entry<K, V> subLower(K var1);

        protected abstract Entry<K, V> subLowest();

        @Override
        public final SortedMap<K, V> subMap(K k2, K k3) {
            return this.subMap(k2, true, k3, false);
        }

        @Override
        public final SortedMap<K, V> tailMap(K k2) {
            return this.tailMap(k2, true);
        }

        public final boolean tooHigh(Object object) {
            if (!this.toEnd) {
                int n2 = this.m.compare(object, this.hi);
                return n2 > 0 || n2 == 0 && !this.hiInclusive;
            }
            return false;
        }

        public final boolean tooLow(Object object) {
            if (!this.fromStart) {
                int n2 = this.m.compare(object, this.lo);
                return n2 < 0 || n2 == 0 && !this.loInclusive;
            }
            return false;
        }

        protected abstract class EntrySetView
        extends AbstractSet<Map.Entry<K, V>> {
            private int size = -1;
            private int sizeModCount;

            protected EntrySetView() {
            }

            @Override
            public boolean contains(Object object) {
                if (!(object instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry entry = (Map.Entry)object;
                Object k2 = entry.getKey();
                if (!NavigableSubMap.this.inRange(k2)) {
                    return false;
                }
                Entry entry2 = NavigableSubMap.this.m.getEntry(k2);
                return entry2 != null && IndexedTreeMap.valEquals(entry2.getValue(), entry.getValue());
            }

            @Override
            public boolean isEmpty() {
                Entry entry = NavigableSubMap.this.absLowest();
                return entry == null || NavigableSubMap.this.tooHigh(entry.key);
            }

            @Override
            public boolean remove(Object object) {
                if (!(object instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry entry = (Map.Entry)object;
                Object k2 = entry.getKey();
                if (!NavigableSubMap.this.inRange(k2)) {
                    return false;
                }
                Entry entry2 = NavigableSubMap.this.m.getEntry(k2);
                if (entry2 != null && IndexedTreeMap.valEquals(entry2.getValue(), entry.getValue())) {
                    NavigableSubMap.this.m.deleteEntry(entry2);
                    return true;
                }
                return false;
            }

            @Override
            public int size() {
                if (NavigableSubMap.this.fromStart && NavigableSubMap.this.toEnd) {
                    return NavigableSubMap.this.m.size();
                }
                if (this.size == -1 || this.sizeModCount != NavigableSubMap.this.m.modCount) {
                    this.sizeModCount = NavigableSubMap.this.m.modCount;
                    this.size = 0;
                    Iterator iterator = this.iterator();
                    while (iterator.hasNext()) {
                        ++this.size;
                        iterator.next();
                    }
                }
                return this.size;
            }
        }

        protected final class SubMapKeyIterator
        extends SubMapIterator<K> {
            protected SubMapKeyIterator(Entry<K, V> entry, Entry<K, V> entry2) {
                super(entry, entry2);
            }

            @Override
            public K next() {
                return this.nextEntry().key;
            }

            @Override
            public void remove() {
                this.removeAscending();
            }
        }

        protected abstract class SubMapIterator<T>
        implements Iterator<T> {
            protected Entry<K, V> lastReturned;
            protected Entry<K, V> next;
            protected final K fenceKey;
            protected int expectedModCount;

            protected SubMapIterator(Entry<K, V> entry, Entry<K, V> entry2) {
                this.expectedModCount = NavigableSubMap.this.m.modCount;
                this.lastReturned = null;
                this.next = entry;
                this.fenceKey = entry2 == null ? null : entry2.key;
            }

            @Override
            public final boolean hasNext() {
                return this.next != null && this.next.key != this.fenceKey;
            }

            public final Entry<K, V> nextEntry() {
                Entry entry = this.next;
                if (entry == null || entry.key == this.fenceKey) {
                    throw new NoSuchElementException();
                }
                if (NavigableSubMap.this.m.modCount != this.expectedModCount) {
                    throw new ConcurrentModificationException();
                }
                this.next = IndexedTreeMap.successor(entry);
                this.lastReturned = entry;
                return entry;
            }

            public final Entry<K, V> prevEntry() {
                Entry entry = this.next;
                if (entry == null || entry.key == this.fenceKey) {
                    throw new NoSuchElementException();
                }
                if (NavigableSubMap.this.m.modCount != this.expectedModCount) {
                    throw new ConcurrentModificationException();
                }
                this.next = IndexedTreeMap.predecessor(entry);
                this.lastReturned = entry;
                return entry;
            }

            public final void removeAscending() {
                if (this.lastReturned == null) {
                    throw new IllegalStateException();
                }
                if (NavigableSubMap.this.m.modCount != this.expectedModCount) {
                    throw new ConcurrentModificationException();
                }
                if (this.lastReturned.left != null && this.lastReturned.right != null) {
                    this.next = this.lastReturned;
                }
                NavigableSubMap.this.m.deleteEntry(this.lastReturned);
                this.lastReturned = null;
                this.expectedModCount = NavigableSubMap.this.m.modCount;
            }

            public final void removeDescending() {
                if (this.lastReturned == null) {
                    throw new IllegalStateException();
                }
                if (NavigableSubMap.this.m.modCount != this.expectedModCount) {
                    throw new ConcurrentModificationException();
                }
                NavigableSubMap.this.m.deleteEntry(this.lastReturned);
                this.lastReturned = null;
                this.expectedModCount = NavigableSubMap.this.m.modCount;
            }
        }

        protected final class SubMapEntryIterator
        extends SubMapIterator<Map.Entry<K, V>> {
            SubMapEntryIterator(Entry<K, V> entry, Entry<K, V> entry2) {
                super(entry, entry2);
            }

            @Override
            public Map.Entry<K, V> next() {
                return this.nextEntry();
            }

            @Override
            public void remove() {
                this.removeAscending();
            }
        }

        protected final class DescendingSubMapKeyIterator
        extends SubMapIterator<K> {
            DescendingSubMapKeyIterator(Entry<K, V> entry, Entry<K, V> entry2) {
                super(entry, entry2);
            }

            @Override
            public K next() {
                return this.prevEntry().key;
            }

            @Override
            public void remove() {
                this.removeDescending();
            }
        }

        protected final class DescendingSubMapEntryIterator
        extends SubMapIterator<Map.Entry<K, V>> {
            DescendingSubMapEntryIterator(Entry<K, V> entry, Entry<K, V> entry2) {
                super(entry, entry2);
            }

            @Override
            public Map.Entry<K, V> next() {
                return this.prevEntry();
            }

            @Override
            public void remove() {
                this.removeDescending();
            }
        }
    }

    protected final class EntryIterator
    extends PrivateEntryIterator<Map.Entry<K, V>> {
        protected EntryIterator(Entry<K, V> entry) {
            super(entry);
        }

        @Override
        public Map.Entry<K, V> next() {
            return this.nextEntry();
        }
    }
}

