/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.dataset.utils;

import io.fair_acc.dataset.DataSet;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.security.InvalidParameterException;
import java.util.WeakHashMap;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSetUtilsHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataSetUtilsHelper.class);
    protected static final ReentrantLock BYTE_ARRAY_CACHE_LOCK = new ReentrantLock();
    protected static WeakHashMap<String, WeakHashMap<Integer, ByteBuffer>> byteArrayCache = new WeakHashMap();
    protected static final ReentrantLock STRING_BUFFER_CACHE_LOCK = new ReentrantLock();
    protected static WeakHashMap<String, WeakHashMap<Integer, StringBuilder>> stringBuilderCache = new WeakHashMap();

    protected static ByteBuffer getCachedDoubleArray(String string2, int n2) {
        BYTE_ARRAY_CACHE_LOCK.lock();
        WeakHashMap weakHashMap = byteArrayCache.computeIfAbsent(string2, string -> new WeakHashMap());
        ByteBuffer byteBuffer = (ByteBuffer)weakHashMap.get(n2);
        if (byteBuffer == null) {
            byteBuffer = ByteBuffer.allocate(n2);
        } else {
            byteArrayCache.get(string2).remove(n2);
        }
        BYTE_ARRAY_CACHE_LOCK.unlock();
        return byteBuffer;
    }

    protected static StringBuilder getCachedStringBuilder(String string2, int n2) {
        STRING_BUFFER_CACHE_LOCK.lock();
        WeakHashMap weakHashMap = stringBuilderCache.computeIfAbsent(string2, string -> new WeakHashMap());
        StringBuilder stringBuilder = (StringBuilder)weakHashMap.get(n2);
        if (stringBuilder == null) {
            stringBuilder = new StringBuilder(n2);
        } else {
            stringBuilderCache.get(string2).remove(n2);
        }
        stringBuilder.delete(0, stringBuilder.length());
        STRING_BUFFER_CACHE_LOCK.unlock();
        return stringBuilder;
    }

    protected static double integralSimple(DataSet dataSet) {
        double d2 = 0.0;
        double d3 = 0.0;
        if (dataSet.getDataCount() <= 1) {
            return 0.0;
        }
        if (dataSet.getDimension() > 2) {
            LOGGER.warn("integral not implemented for nDim > 2");
            return 0.0;
        }
        for (int i2 = 1; i2 < dataSet.getDataCount(); ++i2) {
            double d4 = dataSet.get(0, i2) - dataSet.get(0, i2 - 1);
            double d5 = dataSet.get(1, i2 - 1);
            double d6 = dataSet.get(1, i2);
            d2 += d4 * d5;
            d3 += d4 * d6;
        }
        return 0.5 * (d2 + d3);
    }

    protected static synchronized double mean(double[] dArray) {
        if (dArray.length <= 0) {
            return Double.NaN;
        }
        double d2 = 1.0 / (double)dArray.length;
        double d3 = 0.0;
        for (int i2 = 0; i2 < dArray.length; ++i2) {
            d3 += d2 * dArray[i2];
        }
        return d3;
    }

    protected static double[] readDoubleArrayFromBuffer(FloatBuffer floatBuffer, DoubleBuffer doubleBuffer) {
        if (floatBuffer != null) {
            double[] dArray = new double[floatBuffer.limit()];
            for (int i2 = 0; i2 < dArray.length; ++i2) {
                dArray[i2] = floatBuffer.get(i2);
            }
            return dArray;
        }
        if (doubleBuffer != null) {
            double[] dArray = new double[doubleBuffer.limit()];
            for (int i3 = 0; i3 < dArray.length; ++i3) {
                dArray[i3] = doubleBuffer.get(i3);
            }
            return dArray;
        }
        throw new InvalidParameterException("floatBuffer and doubleBuffer must not both be null");
    }

    protected static void release(String string, ByteBuffer byteBuffer) {
        if (byteBuffer == null) {
            return;
        }
        byteBuffer.clear();
        BYTE_ARRAY_CACHE_LOCK.lock();
        byteArrayCache.get(string).put(byteBuffer.capacity(), byteBuffer);
        BYTE_ARRAY_CACHE_LOCK.unlock();
    }

    protected static void release(String string, StringBuilder stringBuilder) {
        if (stringBuilder == null) {
            return;
        }
        STRING_BUFFER_CACHE_LOCK.lock();
        stringBuilderCache.get(string).put(stringBuilder.capacity(), stringBuilder);
        STRING_BUFFER_CACHE_LOCK.unlock();
    }

    protected static synchronized double rootMeanSquare(double[] dArray) {
        if (dArray.length <= 0) {
            return Double.NaN;
        }
        double d2 = 1.0 / (double)dArray.length;
        double d3 = 0.0;
        double d4 = 0.0;
        for (int i2 = 0; i2 < dArray.length; ++i2) {
            d3 += dArray[i2];
            d4 += dArray[i2] * dArray[i2];
        }
        return Math.sqrt(Math.abs((d4 *= d2) - (d3 *= d2) * d3));
    }

    public static double[] toDoubleArray(float[] fArray) {
        if (fArray == null) {
            return null;
        }
        int n2 = fArray.length;
        double[] dArray = new double[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            dArray[i2] = fArray[i2];
        }
        return dArray;
    }

    public static float[] toFloatArray(double[] dArray) {
        if (dArray == null) {
            return null;
        }
        int n2 = dArray.length;
        float[] fArray = new float[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            fArray[i2] = (float)dArray[i2];
        }
        return fArray;
    }

    protected static void writeDoubleArrayAsFloatToByteBuffer(ByteBuffer byteBuffer, double[] dArray, int n2) {
        if (byteBuffer == null) {
            throw new InvalidParameterException("ByteBuffer is 'null'");
        }
        if (dArray == null) {
            throw new InvalidParameterException("doubleBuffer is 'null'");
        }
        if (byteBuffer.capacity() < n2 * 4) {
            throw new InvalidParameterException("byte buffer size (" + byteBuffer.capacity() + ") is smaller than double buffer size (" + n2 * 4 + ")");
        }
        if (dArray.length < n2) {
            throw new InvalidParameterException("double array contains less (" + dArray.length + ") than nsamples (" + n2 + ") entries.");
        }
        byteBuffer.position(0);
        for (int i2 = 0; i2 < n2; ++i2) {
            byteBuffer.putFloat((float)dArray[i2]);
        }
    }

    protected static void writeDoubleArrayToByteBuffer(ByteBuffer byteBuffer, double[] dArray, int n2) {
        if (byteBuffer == null) {
            throw new InvalidParameterException("ByteBuffer is 'null'");
        }
        if (dArray == null) {
            throw new InvalidParameterException("doubleBuffer is 'null'");
        }
        if (byteBuffer.capacity() < n2 * 8) {
            throw new InvalidParameterException("byte buffer size (" + byteBuffer.capacity() + ") is smaller than double buffer size (" + n2 * 4 + ")");
        }
        if (dArray.length < n2) {
            throw new InvalidParameterException("double array contains less (" + dArray.length + ") than nsamples (" + n2 + ") entries.");
        }
        byteBuffer.position(0);
        for (int i2 = 0; i2 < n2; ++i2) {
            byteBuffer.putDouble(dArray[i2]);
        }
    }
}

