/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.dataset.utils;

import java.lang.reflect.Array;
import java.util.Arrays;

public class CircularBuffer<E> {
    private final E[] elements;
    private final int capacity;
    private int writePos;
    private boolean flipped;

    public CircularBuffer(E[] EArray, int n2) {
        this(n2);
        this.put(EArray, EArray.length);
    }

    public CircularBuffer(int n2) {
        if (n2 <= 0) {
            throw new IllegalArgumentException("capcacity='" + n2 + "' must be larger than zero");
        }
        this.capacity = n2;
        this.elements = new Object[n2];
        this.flipped = false;
    }

    public int available() {
        if (this.flipped) {
            return this.capacity;
        }
        return this.writePos;
    }

    public int capacity() {
        return this.capacity;
    }

    public E[] elements(E[] EArray) {
        return Arrays.copyOf(this.elements, this.available(), EArray.getClass());
    }

    public E get() {
        return this.get(0);
    }

    public E[] get(E[] EArray, int n2) {
        return this.get(EArray, 0, n2);
    }

    public E[] get(E[] EArray, int n2, int n3) {
        E[] EArray2 = EArray == null || EArray.length < n3 ? (Object[])Array.newInstance(this.elements[0].getClass(), n3) : EArray;
        for (int i2 = 0; i2 < n3; ++i2) {
            EArray2[i2] = this.get(i2 + n2);
        }
        return EArray2;
    }

    public E get(int n2) {
        int n3 = this.getIndex(n2);
        return this.elements[n3];
    }

    protected int getIndex(int n2) {
        int n3;
        int n4 = n3 = this.flipped ? this.writePos + n2 : n2;
        if (!this.flipped) {
            if (n3 >= 0) {
                return n3;
            }
            throw new IllegalArgumentException("writePos = '" + this.writePos + "' readPos = '" + n2 + "'/index = '" + n3 + "' is beyond circular buffer capacity limits = [0," + this.capacity + "]");
        }
        while (n3 < 0) {
            n3 += this.capacity;
        }
        while (n3 >= this.capacity) {
            n3 -= this.capacity;
        }
        return n3;
    }

    public boolean isBufferFlipped() {
        return this.flipped;
    }

    public boolean put(E e2) {
        this.elements[this.writePos++] = e2;
        if (this.writePos == this.capacity) {
            this.writePos = 0;
            this.flipped = true;
        }
        return true;
    }

    public int put(E[] EArray, int n2) {
        return this.put(EArray, 0, n2);
    }

    public int put(E[] EArray, int n2, int n3) {
        int n4 = this.capacity - this.writePos;
        if (n3 <= n4) {
            System.arraycopy(EArray, n2, this.elements, this.writePos, n3);
            this.writePos += n3;
            if (this.writePos == this.capacity) {
                this.writePos = 0;
                this.flipped = true;
            }
            return this.writePos;
        }
        System.arraycopy(EArray, n2, this.elements, this.writePos, n4);
        this.writePos = 0;
        this.flipped = true;
        return this.put(EArray, n2 + n4, n3 - n4);
    }

    public int remainingCapacity() {
        return this.capacity - this.available();
    }

    public E replace(E e2) {
        return this.replace(e2, 0);
    }

    public E replace(E e2, int n2) {
        int n3 = this.getIndex(n2);
        E e3 = this.elements[n3];
        this.elements[n3] = e2;
        return e3;
    }

    public void reset() {
        this.writePos = 0;
        this.flipped = false;
    }

    public int writePosition() {
        return this.writePos;
    }
}

