/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.dataset.spi.utils;

import io.fair_acc.dataset.spi.utils.MultiArray;
import io.fair_acc.dataset.utils.AssertUtils;
import java.util.Arrays;

public class MultiArrayInt
extends MultiArray<int[]> {
    public static MultiArrayInt wrap(int[] nArray) {
        return MultiArrayInt.wrap(nArray, 0, nArray.length);
    }

    public static MultiArrayInt wrap(int[] nArray, int n2, int n3) {
        return new MultiArray1DInt(nArray, new int[]{n3}, n2);
    }

    public static MultiArrayInt wrap(int[] nArray, int[] nArray2) {
        return MultiArrayInt.wrap(nArray, 0, nArray2);
    }

    public static MultiArrayInt wrap(int[] nArray, int n2, int[] nArray2) {
        int n3 = 1;
        for (int n4 : nArray2) {
            n3 *= n4;
        }
        AssertUtils.gtOrEqual("Array size", n3 + n2, nArray.length);
        switch (nArray2.length) {
            case 1: {
                return new MultiArray1DInt(nArray, nArray2, n2);
            }
            case 2: {
                return new MultiArray2DInt(nArray, nArray2, n2);
            }
        }
        return new MultiArrayInt(nArray, nArray2, n2);
    }

    public static MultiArrayInt allocate(int[] nArray) {
        switch (nArray.length) {
            case 1: {
                return new MultiArray1DInt(new int[nArray[0]], nArray, 0);
            }
            case 2: {
                return new MultiArray2DInt(new int[nArray[1] * nArray[0]], nArray, 0);
            }
        }
        int n2 = 1;
        for (int n3 : nArray) {
            n2 *= n3;
        }
        return new MultiArrayInt(new int[n2], nArray, 0);
    }

    protected MultiArrayInt(int[] nArray, int[] nArray2, int n2) {
        super(nArray, nArray2, n2);
    }

    public void setStrided(int n2, int n3) {
        ((int[])this.elements)[n2 + this.offset] = n3;
    }

    public void set(int[] nArray, int n2) {
        ((int[])this.elements)[this.getIndex((int[])nArray)] = n2;
    }

    public int getStrided(int n2) {
        return ((int[])this.elements)[n2 + this.offset];
    }

    public int get(int[] nArray) {
        return ((int[])this.elements)[this.getIndex(nArray)];
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof MultiArrayInt)) {
            return false;
        }
        MultiArrayInt multiArrayInt = (MultiArrayInt)object;
        return Arrays.equals(this.dimensions, multiArrayInt.dimensions) && Arrays.equals((int[])this.elements, this.offset, this.offset + this.getElementsCount(), (int[])multiArrayInt.elements, multiArrayInt.offset, multiArrayInt.offset + this.getElementsCount());
    }

    public int hashCode() {
        int n2 = 1;
        for (int i2 = this.offset; i2 < this.offset + this.getElementsCount(); ++i2) {
            n2 = 31 * n2 + Integer.hashCode(((int[])this.elements)[i2]);
        }
        n2 = 31 * n2 + Arrays.hashCode(this.dimensions);
        return n2;
    }

    public static class MultiArray1DInt
    extends MultiArrayInt {
        protected MultiArray1DInt(int[] nArray, int[] nArray2, int n2) {
            super(nArray, nArray2, n2);
        }

        public int get(int n2) {
            return this.getStrided(n2);
        }

        public void set(int n2, int n3) {
            this.setStrided(n2, n3);
        }
    }

    public static class MultiArray2DInt
    extends MultiArrayInt {
        private final int stride;

        protected MultiArray2DInt(int[] nArray, int[] nArray2, int n2) {
            super(nArray, nArray2, n2);
            this.stride = nArray2[1];
        }

        public int get(int n2, int n3) {
            return ((int[])this.elements)[this.offset + n3 + n2 * this.stride];
        }

        public void set(int n2, int n3, int n4) {
            ((int[])this.elements)[this.offset + n3 + n2 * this.stride] = n4;
        }

        public int[] getRow(int n2) {
            int n3 = n2 * this.stride + this.offset;
            return Arrays.copyOfRange((int[])this.elements, n3, n3 + this.stride);
        }
    }
}

