/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.dataset.spi;

import io.fair_acc.dataset.AxisDescription;
import io.fair_acc.dataset.DataSet;
import io.fair_acc.dataset.GridDataSet;
import io.fair_acc.dataset.events.BitState;
import io.fair_acc.dataset.events.ChartBits;
import io.fair_acc.dataset.locks.DataSetLock;
import io.fair_acc.dataset.utils.AssertUtils;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransposedDataSet
implements DataSet {
    private static final Logger LOGGER = LoggerFactory.getLogger(TransposedDataSet.class);
    private static final long serialVersionUID = 2019092401L;
    protected final DataSet dataSet;
    protected final int nDims;
    protected int[] permutation;
    private boolean transposed;

    private TransposedDataSet(DataSet dataSet, boolean bl2) {
        if (dataSet == null) {
            throw new IllegalArgumentException("DataSet is null");
        }
        this.dataSet = dataSet;
        this.permutation = new int[dataSet.getDimension()];
        this.transposed = bl2;
        this.nDims = dataSet.getDimension();
        for (int i2 = 0; i2 < this.permutation.length; ++i2) {
            this.permutation[i2] = i2;
        }
        if (bl2) {
            this.permutation[0] = 1;
            this.permutation[1] = 0;
        }
    }

    private TransposedDataSet(DataSet dataSet, int[] nArray) {
        if (dataSet == null) {
            throw new IllegalArgumentException("DataSet is null");
        }
        if (nArray == null) {
            throw new IllegalArgumentException("permutation is null");
        }
        for (int i2 = 0; i2 < dataSet.getDimension(); ++i2) {
            if (nArray[i2] < dataSet.getDimension()) continue;
            throw new IndexOutOfBoundsException("permutation[" + i2 + "] contains dimIndex='" + nArray[i2] + "' outside DataSet dimension (" + dataSet.getDimension() + ")");
        }
        this.dataSet = dataSet;
        this.nDims = nArray.length;
        this.permutation = Arrays.copyOf(nArray, this.dataSet.getDimension());
        this.transposed = false;
    }

    @Override
    public double get(int n2, int n3) {
        return this.dataSet.get(this.permutation[n2], n3);
    }

    @Override
    public List<AxisDescription> getAxisDescriptions() {
        return IntStream.of(this.permutation).mapToObj(this.dataSet::getAxisDescription).collect(Collectors.toList());
    }

    @Override
    public AxisDescription getAxisDescription(int n2) {
        return this.dataSet.getAxisDescription(this.permutation[n2]);
    }

    @Override
    public int getDataCount() {
        return this.dataSet.getDataCount();
    }

    @Override
    public String getDataLabel(int n2) {
        return this.dataSet.getDataLabel(n2);
    }

    @Override
    public boolean hasDataLabels() {
        return this.dataSet.hasDataLabels();
    }

    @Override
    public int getDimension() {
        return this.permutation.length;
    }

    @Override
    public int getIndex(int n2, double ... dArray) {
        AssertUtils.checkArrayDimension("value", dArray, 1);
        return this.dataSet.getIndex(this.permutation[n2], dArray);
    }

    @Override
    public String getName() {
        return this.dataSet.getName();
    }

    @Override
    public List<String> getStyleClasses() {
        return this.dataSet.getStyleClasses();
    }

    @Override
    public DataSet addStyleClasses(String ... stringArray) {
        this.dataSet.addStyleClasses(stringArray);
        return this;
    }

    public int[] getPermutation() {
        return Arrays.copyOf(this.permutation, this.permutation.length);
    }

    @Override
    public String getStyle() {
        return this.dataSet.getStyle();
    }

    @Override
    public String getStyle(int n2) {
        return this.dataSet.getStyle(n2);
    }

    @Override
    public boolean hasStyles() {
        return this.dataSet.hasStyles();
    }

    @Override
    public double[] getValues(int n2) {
        return this.dataSet.getValues(this.permutation[n2]);
    }

    public boolean isTransposed() {
        return this.transposed;
    }

    @Override
    public <D extends DataSet> DataSetLock<D> lock() {
        return this.dataSet.lock();
    }

    @Override
    public DataSet recomputeLimits(int n2) {
        return this.dataSet.recomputeLimits(this.permutation[n2]);
    }

    public void setPermutation(int[] nArray) {
        if (nArray == null) {
            throw new IllegalArgumentException("permutation is null");
        }
        this.lock().writeLockGuard(() -> {
            int n2;
            if (nArray.length != this.nDims) {
                throw new IllegalArgumentException("Cannot change number of output dimensions");
            }
            for (n2 = 0; n2 < this.dataSet.getDimension(); ++n2) {
                if (nArray[n2] < this.dataSet.getDimension()) continue;
                throw new IndexOutOfBoundsException("permutation[" + n2 + "] contains dimIndex='" + nArray[n2] + "' outside DataSet dimension (" + this.dataSet.getDimension() + ")");
            }
            this.permutation = Arrays.copyOf(nArray, this.dataSet.getDimension());
            if (this.transposed) {
                n2 = this.permutation[1];
                this.permutation[1] = this.permutation[0];
                this.permutation[0] = n2;
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.atDebug().addArgument(this.permutation).log("applied permutation: {}");
            }
        });
        this.fireInvalidated(ChartBits.DataSetPermutation);
    }

    @Override
    public DataSet setStyle(String string) {
        return this.lock().writeLockGuard(() -> this.dataSet.setStyle(string));
    }

    @Override
    public double getValue(int n2, double ... dArray) {
        return this.dataSet.getValue(this.permutation[n2], this.dataSet.getIndex(this.permutation[0], dArray[0]));
    }

    @Override
    public DataSet set(DataSet dataSet, boolean bl2) {
        throw new UnsupportedOperationException("copy setting transposed data set is not implemented");
    }

    public void setTransposed(boolean bl2) {
        this.lock().writeLockGuard(() -> {
            if (this.transposed != bl2) {
                int n2 = this.permutation[1];
                this.permutation[1] = this.permutation[0];
                this.permutation[0] = n2;
                this.transposed = bl2;
            }
        });
        this.fireInvalidated(ChartBits.DataSetPermutation);
    }

    @Override
    public BitState getBitState() {
        return this.dataSet.getBitState();
    }

    public static TransposedDataSet permute(DataSet dataSet, int[] nArray) {
        if (dataSet instanceof GridDataSet) {
            return new TransposedGridDataSet((GridDataSet)dataSet, nArray);
        }
        return new TransposedDataSet(dataSet, nArray);
    }

    public static TransposedDataSet transpose(DataSet dataSet) {
        return TransposedDataSet.transpose(dataSet, true);
    }

    public static TransposedDataSet transpose(DataSet dataSet, boolean bl2) {
        if (dataSet instanceof GridDataSet) {
            return new TransposedGridDataSet((GridDataSet)dataSet, bl2);
        }
        return new TransposedDataSet(dataSet, bl2);
    }

    public static class TransposedGridDataSet
    extends TransposedDataSet
    implements GridDataSet {
        private static final long serialVersionUID = 19092601L;

        private TransposedGridDataSet(GridDataSet gridDataSet, boolean bl2) {
            super((DataSet)gridDataSet, bl2);
        }

        private TransposedGridDataSet(GridDataSet gridDataSet, int[] nArray) {
            super((DataSet)gridDataSet, nArray);
            if (nArray[0] > 1 || nArray[1] > 1 || nArray[2] != 2) {
                throw new IllegalArgumentException("cannot swap first x or y dimension with z dimension (index missmatch)");
            }
        }

        @Override
        public int getDataCount() {
            return this.dataSet.getDataCount();
        }

        @Override
        public void setPermutation(int[] nArray) {
            AssertUtils.notNull("permutation", nArray);
            this.lock().writeLockGuard(() -> {
                if (nArray[0] > 1 || nArray[1] > 1 || nArray[2] != 2) {
                    throw new IllegalArgumentException("cannot swap first x or y dimension with z dimension (index missmatch)");
                }
                super.setPermutation(nArray);
            });
            this.fireInvalidated(ChartBits.DataSetPermutation);
        }

        @Override
        public int getIndex(int n2, double ... dArray) {
            AssertUtils.checkArrayDimension("value", dArray, this.getNGrid());
            return this.dataSet.getIndex(this.permutation[n2], this.permute(dArray));
        }

        private double[] permute(double[] dArray) {
            double[] dArray2 = new double[this.permutation.length];
            for (int i2 = 0; i2 < this.getNGrid(); ++i2) {
                if (dArray.length <= this.permutation[i2]) continue;
                dArray2[i2] = dArray[this.permutation[i2]];
            }
            return dArray2;
        }

        @Override
        public int[] getShape() {
            int[] nArray = ((GridDataSet)this.dataSet).getShape();
            int[] nArray2 = new int[nArray.length];
            for (int i2 = 0; i2 < nArray.length; ++i2) {
                nArray2[i2] = nArray[this.permutation[i2]];
            }
            return nArray2;
        }

        @Override
        public double getGrid(int n2, int n3) {
            return ((GridDataSet)this.dataSet).getGrid(this.permutation[n2], n3);
        }

        @Override
        public int getGridIndex(int n2, double d2) {
            return ((GridDataSet)this.dataSet).getGridIndex(this.permutation[n2], d2);
        }

        @Override
        public double get(int n2, int ... nArray) {
            int[] nArray2 = ((GridDataSet)this.dataSet).getShape();
            int[] nArray3 = new int[nArray2.length];
            for (int i2 = 0; i2 < nArray2.length; ++i2) {
                if (this.permutation[i2] >= nArray.length) continue;
                nArray3[this.permutation[i2]] = nArray[i2];
            }
            return ((GridDataSet)this.dataSet).get(this.permutation[n2], nArray3);
        }

        @Override
        public double getValue(int n2, double ... dArray) {
            return this.dataSet.getValue(this.permutation[n2], this.permute(dArray));
        }
    }
}

