/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.dataset.spi;

import java.io.Serializable;
import java.util.Objects;

public class DataRange {
    private static final double MIN_VALUE = -1.7976931348623157E308;
    private static final double MAX_VALUE = Double.MAX_VALUE;
    protected double min;
    protected double max;

    public DataRange() {
        this(Double.MAX_VALUE, -1.7976931348623157E308);
    }

    public DataRange(DataRange dataRange) {
        this.set(dataRange.min, dataRange.max);
    }

    public DataRange(double d2, double d3) {
        this.set(d2, d3);
    }

    public boolean add(DataRange dataRange) {
        boolean bl2 = this.add(dataRange.min);
        boolean bl3 = this.add(dataRange.max);
        return bl2 || bl3;
    }

    public boolean add(double d2) {
        if (!Double.isFinite(d2)) {
            return false;
        }
        if (d2 > this.min && d2 < this.max) {
            return false;
        }
        boolean bl2 = false;
        if (d2 < this.min) {
            this.min = d2;
            bl2 = true;
        }
        if (d2 > this.max) {
            this.max = d2;
            bl2 = true;
        }
        return bl2;
    }

    public boolean add(double[] dArray) {
        return this.add(dArray, dArray.length);
    }

    public boolean add(double[] dArray, int n2) {
        boolean bl2 = false;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (!this.add(dArray[i2])) continue;
            bl2 = true;
        }
        return bl2;
    }

    public boolean clear() {
        return this.set(Double.MAX_VALUE, -1.7976931348623157E308);
    }

    public boolean contains(double d2) {
        return this.isDefined() && d2 <= this.max && d2 >= this.min;
    }

    public boolean equals(Object object) {
        if (!(object instanceof DataRange)) {
            return false;
        }
        DataRange dataRange = (DataRange)object;
        return dataRange.hashCode() == this.hashCode();
    }

    public double getLength() {
        double d2 = this.getMax() - this.getMin();
        return this.isDefined() ? d2 : 0.0;
    }

    public double getMax() {
        if (this.isMaxDefined()) {
            return this.max;
        }
        return Double.NaN;
    }

    public double getMin() {
        if (this.isMinDefined()) {
            return this.min;
        }
        return Double.NaN;
    }

    public int hashCode() {
        return Objects.hash(this.min, this.max);
    }

    public boolean isDefined() {
        return this.isMinDefined() && this.isMaxDefined();
    }

    public boolean isMaxDefined() {
        return this.max > -1.7976931348623157E308;
    }

    public boolean isMinDefined() {
        return this.min < Double.MAX_VALUE;
    }

    public boolean set(DataRange dataRange) {
        return this.set(dataRange.min, dataRange.max);
    }

    public boolean set(double d2, double d3) {
        boolean bl2 = this.setMin(d2);
        boolean bl3 = this.setMax(d3);
        return bl2 || bl3;
    }

    public boolean setMax(double d2) {
        if (this.max == d2) {
            return false;
        }
        this.max = d2;
        return true;
    }

    public boolean setMin(double d2) {
        if (this.min == d2) {
            return false;
        }
        this.min = d2;
        return true;
    }

    public String toString() {
        String string = this.getClass().getSimpleName() + " [min=" + (Serializable)(this.isMinDefined() ? Double.valueOf(this.getMin()) : "NotDefined") + ", max=" + (Serializable)(this.isMaxDefined() ? Double.valueOf(this.getMax()) : "NotDefined") + "]";
        return string;
    }
}

