/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.dataset;

import io.fair_acc.bench.Measurable;
import io.fair_acc.dataset.AxisDescription;
import io.fair_acc.dataset.events.ChartBits;
import io.fair_acc.dataset.events.EventSource;
import io.fair_acc.dataset.locks.DataSetLock;
import io.fair_acc.dataset.utils.IndexedStringConsumer;
import java.io.Serializable;
import java.util.List;

public interface DataSet
extends EventSource,
Serializable,
Measurable.EmptyDefault {
    public static final int DIM_X = 0;
    public static final int DIM_Y = 1;
    public static final int DIM_Z = 2;

    public double get(int var1, int var2);

    default public AxisDescription getAxisDescription(int n2) {
        return this.getAxisDescriptions().get(n2);
    }

    public List<AxisDescription> getAxisDescriptions();

    public int getDataCount();

    public String getDataLabel(int var1);

    public boolean hasDataLabels();

    default public void forEachDataLabel(int n2, int n3, IndexedStringConsumer indexedStringConsumer) {
        for (int i2 = n2; i2 < n3; ++i2) {
            String string = this.getDataLabel(i2);
            if (string == null) continue;
            indexedStringConsumer.accept(i2, string);
        }
    }

    public int getDimension();

    public int getIndex(int var1, double ... var2);

    public String getName();

    public List<String> getStyleClasses();

    public DataSet addStyleClasses(String ... var1);

    public String getStyle();

    public String getStyle(int var1);

    public boolean hasStyles();

    default public void forEachStyle(int n2, int n3, IndexedStringConsumer indexedStringConsumer) {
        for (int i2 = n2; i2 < n3; ++i2) {
            String string = this.getStyle(i2);
            if (string == null) continue;
            indexedStringConsumer.accept(i2, string);
        }
    }

    public double[] getValues(int var1);

    public <D extends DataSet> DataSetLock<D> lock();

    default public DataSet recomputeLimits() {
        if (this.getBitState().isDirty(ChartBits.DataSetData, ChartBits.DataSetRange)) {
            for (int i2 = 0; i2 < this.getDimension(); ++i2) {
                this.recomputeLimits(i2);
            }
            this.getBitState().clear(ChartBits.DataSetData, ChartBits.DataSetRange);
        }
        return this;
    }

    public DataSet recomputeLimits(int var1);

    public DataSet setStyle(String var1);

    public double getValue(int var1, double ... var2);

    public DataSet set(DataSet var1, boolean var2);

    default public DataSet set(DataSet dataSet) {
        return this.set(dataSet, true);
    }
}

