/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.chartfx.ui.geometry;

import javafx.css.PseudoClass;
import javafx.scene.Node;

public enum Side {
    TOP,
    BOTTOM,
    LEFT,
    RIGHT,
    CENTER_HOR,
    CENTER_VER;

    private static final PseudoClass CSS_TOP;
    private static final PseudoClass CSS_BOTTOM;
    private static final PseudoClass CSS_LEFT;
    private static final PseudoClass CSS_RIGHT;
    private static final PseudoClass CSS_CENTER_HOR;
    private static final PseudoClass CSS_CENTER_VER;
    private static final PseudoClass CSS_HORIZONTAL;
    private static final PseudoClass CSS_VERTICAL;
    private static final PseudoClass CSS_CENTER;

    public boolean isHorizontal() {
        return this == TOP || this == BOTTOM || this == CENTER_HOR;
    }

    public boolean isVertical() {
        return this == LEFT || this == RIGHT || this == CENTER_VER;
    }

    public boolean isCenter() {
        return this == CENTER_VER || this == CENTER_HOR;
    }

    public void applyPseudoClasses(Node node) {
        node.pseudoClassStateChanged(CSS_TOP, this == TOP);
        node.pseudoClassStateChanged(CSS_BOTTOM, this == BOTTOM);
        node.pseudoClassStateChanged(CSS_LEFT, this == LEFT);
        node.pseudoClassStateChanged(CSS_RIGHT, this == RIGHT);
        node.pseudoClassStateChanged(CSS_CENTER_HOR, this == CENTER_HOR);
        node.pseudoClassStateChanged(CSS_CENTER_VER, this == CENTER_VER);
        node.pseudoClassStateChanged(CSS_HORIZONTAL, this.isHorizontal());
        node.pseudoClassStateChanged(CSS_VERTICAL, this.isVertical());
        node.pseudoClassStateChanged(CSS_CENTER, this.isCenter());
    }

    static {
        CSS_TOP = PseudoClass.getPseudoClass((String)"top");
        CSS_BOTTOM = PseudoClass.getPseudoClass((String)"bottom");
        CSS_LEFT = PseudoClass.getPseudoClass((String)"left");
        CSS_RIGHT = PseudoClass.getPseudoClass((String)"right");
        CSS_CENTER_HOR = PseudoClass.getPseudoClass((String)"center-hor");
        CSS_CENTER_VER = PseudoClass.getPseudoClass((String)"center-ver");
        CSS_HORIZONTAL = PseudoClass.getPseudoClass((String)"horizontal");
        CSS_VERTICAL = PseudoClass.getPseudoClass((String)"vertical");
        CSS_CENTER = PseudoClass.getPseudoClass((String)"center");
    }
}

