/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.chartfx.renderer.spi.financial;

import io.fair_acc.chartfx.XYChart;
import io.fair_acc.chartfx.axes.Axis;
import io.fair_acc.chartfx.renderer.spi.financial.FinancialDataSetNode;
import io.fair_acc.chartfx.renderer.spi.financial.service.DataSetAware;
import io.fair_acc.chartfx.renderer.spi.financial.service.OhlcvRendererEpData;
import io.fair_acc.chartfx.renderer.spi.financial.service.RendererPaintAfterEP;
import io.fair_acc.dataset.DataSet;
import java.util.ArrayList;
import java.util.List;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.scene.text.TextAlignment;

public class PositionFinancialRendererPaintAfterEP
implements RendererPaintAfterEP,
DataSetAware {
    protected final DataSet ds;
    protected final XYChart chart;
    protected final Axis xAxis;
    protected final Axis yAxis;
    private Paint positionTriangleLongColor;
    private Paint positionTriangleShortColor;
    private Paint positionTriangleExitColor;
    private Paint positionArrowLongColor;
    private Paint positionArrowShortColor;
    private Paint positionArrowExitColor;
    private Paint positionLabelTradeDescriptionColor;
    private Paint positionOrderLinkageProfitColor;
    private Paint positionOrderLinkageLossColor;
    private String positionLabelLongText;
    private String positionLabelShortText;
    private double positionPaintMainRatio;
    private double positionOrderLinkageLineDash;
    private double positionOrderLinkageLineWidth;

    public PositionFinancialRendererPaintAfterEP(DataSet dataSet, XYChart xYChart) {
        this.ds = dataSet;
        this.chart = xYChart;
        this.xAxis = xYChart.getXAxis();
        this.yAxis = xYChart.getYAxis();
        if (!(dataSet instanceof PositionRenderedAware)) {
            throw new IllegalArgumentException("The position dataset has to implement PositionRenderedAware interface");
        }
    }

    @Override
    public DataSet getDataSet() {
        return this.ds;
    }

    protected void initByDatasetFxStyle(FinancialDataSetNode financialDataSetNode) {
        this.positionTriangleLongColor = financialDataSetNode.getPositionTriangleLongColor();
        this.positionTriangleShortColor = financialDataSetNode.getPositionTriangleShortColor();
        this.positionTriangleExitColor = financialDataSetNode.getPositionTriangleExitColor();
        this.positionArrowLongColor = financialDataSetNode.getPositionArrowLongColor();
        this.positionArrowShortColor = financialDataSetNode.getPositionArrowShortColor();
        this.positionArrowExitColor = financialDataSetNode.getPositionArrowExitColor();
        this.positionLabelTradeDescriptionColor = financialDataSetNode.getPositionLabelTradeDescriptionColor();
        this.positionOrderLinkageProfitColor = financialDataSetNode.getPositionOrderLinkageProfitColor();
        this.positionOrderLinkageLossColor = financialDataSetNode.getPositionOrderLinkageLossColor();
        this.positionLabelLongText = financialDataSetNode.getPositionLabelLongText();
        this.positionLabelShortText = financialDataSetNode.getPositionLabelShortText();
        this.positionOrderLinkageLineDash = financialDataSetNode.getPositionOrderLinkageLineDash();
        this.positionOrderLinkageLineWidth = financialDataSetNode.getPositionOrderLinkageLineWidth();
        this.positionPaintMainRatio = financialDataSetNode.getPositionPaintMainRatio();
    }

    @Override
    public void paintAfter(OhlcvRendererEpData ohlcvRendererEpData) {
        long l2;
        PositionRendered positionRendered;
        if (ohlcvRendererEpData.index == ohlcvRendererEpData.minIndex) {
            this.initByDatasetFxStyle(ohlcvRendererEpData.style);
        }
        if ((positionRendered = ((PositionRenderedAware)((Object)this.ds)).getPositionByTime(l2 = Math.round((double)ohlcvRendererEpData.ohlcvItem.getTimeStamp().getTime() / 1000.0))) == null) {
            return;
        }
        ohlcvRendererEpData.gc.save();
        double d2 = ohlcvRendererEpData.xCenter;
        double d3 = this.yAxis.getDisplayPosition(positionRendered.price);
        double d4 = Math.pow(ohlcvRendererEpData.barWidth, 0.25) * this.positionPaintMainRatio;
        double d5 = d4 * 0.25;
        ohlcvRendererEpData.gc.setStroke((Paint)Color.BLACK);
        ohlcvRendererEpData.gc.setLineWidth(1.0);
        if (positionRendered.entryExit == 1) {
            ohlcvRendererEpData.gc.setFill(positionRendered.posType > 0 ? this.positionTriangleLongColor : this.positionTriangleShortColor);
            this.drawTriangle(ohlcvRendererEpData, d2, d3, d4, -1.0);
        } else {
            ohlcvRendererEpData.gc.setFill(this.positionTriangleExitColor);
            this.drawTriangle(ohlcvRendererEpData, d2, d3, d4, 1.0);
        }
        if (positionRendered.entryExit == 1) {
            if (positionRendered.posType > 0) {
                ohlcvRendererEpData.gc.setFill(this.positionArrowLongColor);
                this.drawArrow(ohlcvRendererEpData, d2, ohlcvRendererEpData.yLow + d4, d5, 1.0);
            } else {
                ohlcvRendererEpData.gc.setFill(this.positionArrowShortColor);
                this.drawArrow(ohlcvRendererEpData, d2, ohlcvRendererEpData.yHigh - d4, d5, -1.0);
            }
        } else {
            ohlcvRendererEpData.gc.setFill(this.positionArrowExitColor);
            if (positionRendered.posType > 0) {
                this.drawArrow(ohlcvRendererEpData, d2, ohlcvRendererEpData.yHigh - d4, d5, -1.0);
            } else {
                this.drawArrow(ohlcvRendererEpData, d2, ohlcvRendererEpData.yLow + d4, d5, 1.0);
            }
        }
        ohlcvRendererEpData.gc.setStroke(this.positionLabelTradeDescriptionColor);
        ohlcvRendererEpData.gc.setFill(this.positionLabelTradeDescriptionColor);
        ohlcvRendererEpData.gc.setFont(new Font(1.5 * d4));
        ohlcvRendererEpData.gc.setTextAlign(TextAlignment.CENTER);
        if (positionRendered.posType > 0 && positionRendered.entryExit == 1 || positionRendered.posType < 0 && positionRendered.entryExit != 1) {
            var13_8 = String.format(this.positionLabelLongText, positionRendered.quantity, positionRendered.price);
            ohlcvRendererEpData.gc.fillText((String)var13_8, d2, ohlcvRendererEpData.yLow + 6.0 * d4);
        } else {
            var13_8 = String.format(this.positionLabelShortText, -positionRendered.quantity, positionRendered.price);
            ohlcvRendererEpData.gc.fillText((String)var13_8, d2, ohlcvRendererEpData.yHigh - 9.0 * d4);
        }
        if (positionRendered.entryExit != 1) {
            for (List list : positionRendered.joinedEntries) {
                double d6 = this.xAxis.getDisplayPosition((Double)list.get(0));
                double d7 = this.yAxis.getDisplayPosition((Double)list.get(1));
                ohlcvRendererEpData.gc.setStroke((Double)list.get(2) > 0.0 ? this.positionOrderLinkageProfitColor : this.positionOrderLinkageLossColor);
                ohlcvRendererEpData.gc.setLineWidth(this.positionOrderLinkageLineWidth);
                ohlcvRendererEpData.gc.setLineDashes(new double[]{this.positionOrderLinkageLineDash});
                ohlcvRendererEpData.gc.strokeLine(d2, d3, d6, d7);
            }
        }
        ohlcvRendererEpData.gc.restore();
    }

    protected void drawArrow(OhlcvRendererEpData ohlcvRendererEpData, double d2, double d3, double d4, double d5) {
        ohlcvRendererEpData.gc.fillPolygon(new double[]{d2, d2 - 3.0 * d4, d2 - 1.5 * d4, d2 - 1.5 * d4, d2 + 1.5 * d4, d2 + 1.5 * d4, d2 + 3.0 * d4, d2}, new double[]{d3, d3 + d5 * 3.0 * d4, d3 + d5 * 3.0 * d4, d3 + d5 * 9.0 * d4, d3 + d5 * 9.0 * d4, d3 + d5 * 3.0 * d4, d3 + d5 * 3.0 * d4, d3}, 8);
    }

    protected void drawTriangle(OhlcvRendererEpData ohlcvRendererEpData, double d2, double d3, double d4, double d5) {
        ohlcvRendererEpData.gc.fillPolygon(new double[]{d2, d2 + d5 * d4, d2 + d5 * d4, d2}, new double[]{d3, d3 + d4, d3 - d4, d3}, 4);
    }

    public static interface PositionRenderedAware {
        public PositionRendered getPositionByTime(long var1);
    }

    public static class PositionRendered
    implements Comparable<PositionRendered> {
        public long positionId;
        public long index;
        public int entryExit;
        public double quantity;
        public int posType;
        public double price;
        public boolean closed;
        public List<List<Double>> joinedEntries = new ArrayList<List<Double>>();

        @Override
        public int compareTo(PositionRendered positionRendered) {
            return Double.compare(this.index, positionRendered.index);
        }

        public String toString() {
            return "PositionRendered{positionId=" + this.positionId + ", index=" + this.index + ", entryExit=" + this.entryExit + ", quantity=" + this.quantity + ", posType=" + this.posType + ", price=" + this.price + ", closed=" + this.closed + ", joinedEntries=" + this.joinedEntries + "}";
        }
    }
}

