/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.chartfx.renderer.datareduction;

import io.fair_acc.chartfx.renderer.RendererDataReducer;
import io.fair_acc.dataset.utils.AssertUtils;
import io.fair_acc.dataset.utils.ProcessingProfiler;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleIntegerProperty;

public class DefaultDataReducer
implements RendererDataReducer {
    protected IntegerProperty minPointPixelDistance = new SimpleIntegerProperty(this, "minPixelDistance", 6){

        public void set(int n2) {
            if (n2 < 0) {
                throw new IllegalArgumentException("minPointPixelDistance " + n2 + " must be greater than zero");
            }
            super.set(n2);
        }
    };

    public final int getMinPointPixelDistance() {
        return this.minPointPixelDistanceProperty().get();
    }

    public final IntegerProperty minPointPixelDistanceProperty() {
        return this.minPointPixelDistance;
    }

    @Override
    public int reducePoints(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, double[] dArray5, double[] dArray6, String[] stringArray, boolean[] blArray, int n2, int n3) {
        boolean bl2;
        AssertUtils.nonEmptyArray("xValues", dArray);
        int n4 = dArray.length;
        AssertUtils.checkArrayDimension("yValues", dArray2, n4);
        AssertUtils.checkArrayDimension("pointSelected", blArray, n4);
        AssertUtils.gtEqThanZero("indexMax", n2);
        AssertUtils.gtThanZero("indexMax", n3);
        boolean bl3 = dArray3 != null;
        boolean bl4 = dArray4 != null;
        boolean bl5 = dArray5 != null;
        boolean bl6 = bl2 = dArray6 != null;
        if (bl3 && bl4 && bl5 && bl2) {
            AssertUtils.checkArrayDimension("xPointErrorsPos", dArray3, n4);
            AssertUtils.checkArrayDimension("xPointErrorsNeg", dArray4, n4);
            AssertUtils.checkArrayDimension("yPointErrorsPos", dArray5, n4);
            AssertUtils.checkArrayDimension("yPointErrorsNeg", dArray6, n4);
            return this.reducePointsInternal(dArray, dArray2, dArray3, dArray4, dArray5, dArray6, stringArray, blArray, n2, n3);
        }
        if (bl5 && bl2) {
            AssertUtils.checkArrayDimension("yPointErrorsPos", dArray5, n4);
            AssertUtils.checkArrayDimension("yPointErrorsNeg", dArray6, n4);
            return this.reducePointsInternal(dArray, dArray2, dArray5, dArray6, stringArray, blArray, n2, n3);
        }
        return this.reducePointsInternal(dArray, dArray2, stringArray, blArray, n2, n3);
    }

    private int reducePointsInternal(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, double[] dArray5, double[] dArray6, String[] stringArray, boolean[] blArray, int n2, int n3) {
        long l2 = ProcessingProfiler.getTimeStamp();
        int n4 = 0;
        int n5 = 0;
        double d2 = 0.0;
        double d3 = 0.0;
        int n6 = Integer.MAX_VALUE;
        int n7 = -2147483647;
        int n8 = Integer.MAX_VALUE;
        int n9 = -2147483647;
        String string = null;
        boolean bl2 = false;
        double d4 = dArray[n2];
        double d5 = dArray2[n2];
        int n10 = this.getMinPointPixelDistance();
        dArray[n4] = dArray[n2];
        dArray2[n4] = dArray2[n2];
        dArray4[n4] = dArray4[n2];
        dArray3[n4] = dArray3[n2];
        dArray6[n4] = dArray6[n2];
        dArray5[n4] = dArray5[n2];
        blArray[n4] = blArray[n2];
        stringArray[n4] = stringArray[n2];
        ++n4;
        for (int i2 = n2 + 1; i2 < n3 - 1; ++i2) {
            double d6 = dArray[i2];
            double d7 = dArray2[i2];
            boolean bl3 = Double.isNaN(d7);
            int n11 = (int)Math.abs(d4 - d6);
            int n12 = (int)Math.abs(d5 - d7);
            if (n11 > n10 || n12 > n10 || bl3) {
                if (n5 > 0) {
                    if (n5 == 1) {
                        dArray[n4] = (int)d2;
                        dArray2[n4] = (int)d3;
                    } else {
                        dArray[n4] = (int)(d2 / (double)n5);
                        dArray2[n4] = (int)(d3 / (double)n5);
                    }
                    dArray4[n4] = n8;
                    dArray3[n4] = n9;
                    dArray6[n4] = n7;
                    dArray5[n4] = n6;
                    blArray[n4] = bl2;
                    stringArray[n4] = string;
                    ++n4;
                }
                if (bl3) {
                    dArray[n4] = d6;
                    dArray2[n4] = Double.NaN;
                    dArray4[n4] = 0.0;
                    dArray3[n4] = 0.0;
                    dArray6[n4] = Double.NaN;
                    dArray5[n4] = Double.NaN;
                    blArray[n4] = blArray[i2];
                    stringArray[n4] = stringArray[i2];
                    ++n4;
                    d2 = 0.0;
                    d3 = 0.0;
                    n8 = Integer.MAX_VALUE;
                    n9 = Integer.MIN_VALUE;
                    n6 = Integer.MAX_VALUE;
                    n7 = Integer.MIN_VALUE;
                    bl2 = false;
                    string = null;
                    n5 = 0;
                } else {
                    d2 = d6;
                    d3 = d7;
                    n8 = (int)dArray3[i2];
                    n9 = (int)dArray4[i2];
                    n6 = (int)dArray5[i2];
                    n7 = (int)dArray6[i2];
                    bl2 = blArray[i2];
                    string = stringArray[i2];
                    n5 = 1;
                }
                d4 = d6;
                d5 = d7;
                continue;
            }
            d2 += d6;
            d3 += d7;
            n6 = Math.min(n6, (int)dArray5[i2]);
            n7 = Math.max(n7, (int)dArray6[i2]);
            n8 = Math.min(n8, (int)dArray3[i2]);
            n9 = Math.max(n9, (int)dArray4[i2]);
            bl2 |= blArray[i2];
            ++n5;
        }
        if (n5 > 0) {
            if (n5 == 1) {
                dArray[n4] = (int)d2;
                dArray2[n4] = (int)d3;
            } else {
                dArray[n4] = (int)(d2 / (double)n5);
                dArray2[n4] = (int)(d3 / (double)n5);
            }
            dArray4[n4] = n8;
            dArray3[n4] = n9;
            dArray6[n4] = n7;
            dArray5[n4] = n6;
            blArray[n4] = bl2;
            stringArray[n4] = string;
            ++n4;
        }
        dArray[n4] = dArray[n3 - 1];
        dArray2[n4] = dArray2[n3 - 1];
        dArray4[n4] = dArray4[n3 - 1];
        dArray3[n4] = dArray3[n3 - 1];
        dArray6[n4] = dArray6[n3 - 1];
        dArray5[n4] = dArray5[n3 - 1];
        blArray[n4] = blArray[n3 - 1];
        stringArray[n4] = stringArray[n3 - 1];
        ++n4;
        if (ProcessingProfiler.getDebugState()) {
            ProcessingProfiler.getTimeDiff(l2, String.format("data reduction (full-xy error definitions: from %d to %d)", n3 - n2, n4));
        }
        return n4;
    }

    private int reducePointsInternal(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, String[] stringArray, boolean[] blArray, int n2, int n3) {
        long l2 = ProcessingProfiler.getTimeStamp();
        int n4 = 0;
        int n5 = 0;
        double d2 = 0.0;
        double d3 = 0.0;
        int n6 = Integer.MAX_VALUE;
        int n7 = -2147483647;
        String string = null;
        boolean bl2 = false;
        double d4 = dArray[n2];
        double d5 = dArray2[n2];
        int n8 = this.getMinPointPixelDistance();
        dArray[n4] = dArray[n2];
        dArray2[n4] = dArray2[n2];
        dArray4[n4] = dArray4[n2];
        dArray3[n4] = dArray3[n2];
        blArray[n4] = blArray[n2];
        stringArray[n4] = stringArray[n2];
        ++n4;
        for (int i2 = n2 + 1; i2 < n3 - 1; ++i2) {
            double d6 = dArray[i2];
            double d7 = dArray2[i2];
            boolean bl3 = Double.isNaN(d7);
            int n9 = (int)Math.abs(d4 - d6);
            int n10 = (int)Math.abs(d5 - d7);
            if (n9 > n8 || n10 > n8 || bl3) {
                if (n5 > 0) {
                    if (n5 == 1) {
                        dArray[n4] = (int)d2;
                        dArray2[n4] = (int)d3;
                    } else {
                        dArray[n4] = (int)(d2 / (double)n5);
                        dArray2[n4] = (int)(d3 / (double)n5);
                    }
                    dArray4[n4] = n7;
                    dArray3[n4] = n6;
                    blArray[n4] = bl2;
                    stringArray[n4] = string;
                    ++n4;
                }
                if (bl3) {
                    dArray[n4] = d6;
                    dArray2[n4] = Double.NaN;
                    dArray4[n4] = Double.NaN;
                    dArray3[n4] = Double.NaN;
                    blArray[n4] = blArray[i2];
                    stringArray[n4] = stringArray[i2];
                    ++n4;
                    d2 = 0.0;
                    d3 = 0.0;
                    n6 = Integer.MAX_VALUE;
                    n7 = Integer.MIN_VALUE;
                    bl2 = blArray[i2];
                    string = stringArray[i2];
                    n5 = 0;
                } else {
                    d2 = d6;
                    d3 = d7;
                    n6 = (int)dArray3[i2];
                    n7 = (int)dArray4[i2];
                    bl2 = blArray[i2];
                    string = stringArray[i2];
                    n5 = 1;
                }
                d4 = d6;
                d5 = d7;
                continue;
            }
            d2 += d6;
            d3 += d7;
            n6 = Math.min(n6, (int)dArray3[i2]);
            n7 = Math.max(n7, (int)dArray4[i2]);
            bl2 |= blArray[i2];
            ++n5;
        }
        if (n5 > 0) {
            if (n5 == 1) {
                dArray[n4] = (int)d2;
                dArray2[n4] = (int)d3;
            } else {
                dArray[n4] = (int)(d2 / (double)n5);
                dArray2[n4] = (int)(d3 / (double)n5);
            }
            dArray4[n4] = n7;
            dArray3[n4] = n6;
            blArray[n4] = bl2;
            stringArray[n4] = string;
            ++n4;
        }
        dArray[n4] = dArray[n3 - 1];
        dArray2[n4] = dArray2[n3 - 1];
        dArray4[n4] = dArray4[n3 - 1];
        dArray3[n4] = dArray3[n3 - 1];
        blArray[n4] = blArray[n3 - 1];
        stringArray[n4] = stringArray[n3 - 1];
        ++n4;
        if (ProcessingProfiler.getDebugState()) {
            ProcessingProfiler.getTimeDiff(l2, String.format("only-y error definitions: data reduction (from %d to %d)", n3 - n2, n4));
        }
        return n4;
    }

    private int reducePointsInternal(double[] dArray, double[] dArray2, String[] stringArray, boolean[] blArray, int n2, int n3) {
        long l2 = ProcessingProfiler.getTimeStamp();
        int n4 = 0;
        int n5 = 0;
        double d2 = 0.0;
        double d3 = 0.0;
        String string = null;
        boolean bl2 = false;
        double d4 = dArray[n2];
        double d5 = dArray2[n2];
        int n6 = this.getMinPointPixelDistance();
        dArray[n4] = dArray[n2];
        dArray2[n4] = dArray2[n2];
        blArray[n4] = blArray[n2];
        stringArray[n4] = stringArray[n2];
        ++n4;
        for (int i2 = n2 + 1; i2 < n3 - 1; ++i2) {
            double d6 = dArray[i2];
            double d7 = dArray2[i2];
            boolean bl3 = Double.isNaN(d7);
            int n7 = (int)Math.abs(d4 - d6);
            int n8 = (int)Math.abs(d5 - d7);
            if (n7 > n6 || n8 > n6 || bl3) {
                if (n5 > 0) {
                    if (n5 == 1) {
                        dArray[n4] = (int)d2;
                        dArray2[n4] = (int)d3;
                    } else {
                        dArray[n4] = (int)(d2 / (double)n5);
                        dArray2[n4] = (int)(d3 / (double)n5);
                    }
                    blArray[n4] = bl2;
                    stringArray[n4] = string;
                    ++n4;
                }
                if (bl3) {
                    dArray[n4] = (int)d6;
                    dArray2[n4] = Double.NaN;
                    blArray[n4] = blArray[i2];
                    stringArray[n4] = stringArray[i2];
                    ++n4;
                    d2 = 0.0;
                    d3 = 0.0;
                    bl2 = false;
                    string = null;
                    n5 = 0;
                } else {
                    d2 = d6;
                    d3 = d7;
                    bl2 = blArray[i2];
                    string = stringArray[i2];
                    n5 = 1;
                }
                d4 = d6;
                d5 = d7;
                continue;
            }
            d2 += d6;
            d3 += d7;
            bl2 |= blArray[i2];
            ++n5;
        }
        if (n5 > 0) {
            if (n5 == 1) {
                dArray[n4] = (int)d2;
                dArray2[n4] = (int)d3;
            } else {
                dArray[n4] = (int)(d2 / (double)n5);
                dArray2[n4] = (int)(d3 / (double)n5);
            }
            blArray[n4] = bl2;
            stringArray[n4] = string;
            ++n4;
        }
        dArray[n4] = dArray[n3 - 1];
        dArray2[n4] = dArray2[n3 - 1];
        blArray[n4] = blArray[n3 - 1];
        stringArray[n4] = stringArray[n3 - 1];
        ++n4;
        if (ProcessingProfiler.getDebugState()) {
            ProcessingProfiler.getTimeDiff(l2, String.format("data reduction (no error definitions: from %d to %d)", n3 - n2, n4));
        }
        return n4;
    }

    public final void setMinPointPixelDistance(int n2) {
        this.minPointPixelDistanceProperty().setValue((Number)n2);
    }
}

