/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.chartfx.plugins;

import io.fair_acc.chartfx.Chart;
import io.fair_acc.chartfx.plugins.ChartPlugin;
import io.fair_acc.chartfx.utils.FXUtils;
import io.fair_acc.dataset.DataSet;
import io.fair_acc.dataset.DataSetError;
import io.fair_acc.dataset.EditConstraints;
import io.fair_acc.dataset.EditableDataSet;
import io.fair_acc.dataset.events.ChartBits;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javafx.beans.binding.Bindings;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.ObservableListBase;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.Separator;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.Tooltip;
import javafx.scene.control.cell.TextFieldTableCell;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import javafx.scene.layout.HBox;
import javafx.stage.FileChooser;
import javafx.util.StringConverter;
import javafx.util.converter.DoubleStringConverter;
import org.kordamp.ikonli.javafx.FontIcon;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableViewer
extends ChartPlugin {
    private static final Logger LOGGER = LoggerFactory.getLogger(TableViewer.class);
    private static final int MAX_DATASETS_IN_TABLE = 100;
    protected static final int FONT_SIZE = 22;
    static final String BUTTON_SAVE_TABLE_VIEW_STYLE_CLASS = "save-table-view";
    static final String BUTTON_COPY_TO_CLIPBOARD_STYLE_CLASS = "copy-to-clip-board";
    static final String BUTTON_SWITCH_TABLE_VIEW_STYLE_CLASS = "switch-table-view";
    static final String BUTTON_BAR_STYLE_CLASS = "table-viewer-button-bar";
    protected static final int MIN_REFRESH_RATE_WARN = 20;
    private final FontIcon tableView = new FontIcon("fa-table:22");
    private final FontIcon graphView = new FontIcon("fa-line-chart:22");
    private final FontIcon saveIcon = new FontIcon("fa-save:22");
    private final FontIcon clipBoardIcon = new FontIcon("far-clipboard:22");
    private final HBox interactorButtons = this.getInteractorBar();
    private final TableView<DataSetsRow> table = new TableView();
    private final DataSetsModel dsModel = new DataSetsModel();
    protected boolean editable;
    private final Timer timer = new Timer("TableViewer-update-task", true);
    private final IntegerProperty refreshRate = new SimpleIntegerProperty(this, "refreshRate", 1000){

        public void set(int n2) {
            if (n2 < 0) {
                throw new IllegalArgumentException("refresh rate must be positive");
            }
            if (n2 < 20) {
                LOGGER.atWarn().addArgument(n2).addArgument(20).log("New refresh rate ({}ms) lower than recommended minimun ({}ms)");
            }
            super.set(n2);
        }
    };

    public TableViewer() {
        this.table.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        this.table.getSelectionModel().setCellSelectionEnabled(true);
        this.table.setEditable(true);
        this.table.setItems((ObservableList)this.dsModel);
        Bindings.bindContent((List)this.table.getColumns(), this.dsModel.getColumns());
        this.chartProperty().addListener((observableValue, chart, chart2) -> {
            if (chart != null) {
                chart.getToolBar().getChildren().remove((Object)this.interactorButtons);
                chart.getPlotForeground().getChildren().remove(this.table);
                chart.getPlotArea().setBottom(null);
                this.table.prefWidthProperty().unbind();
                this.table.prefHeightProperty().unbind();
            }
            if (chart2 != null && this.isAddButtonsToToolBar()) {
                chart2.getToolBar().getChildren().add((Object)this.interactorButtons);
            }
            this.dsModel.chartChanged((Chart)chart, (Chart)chart2);
        });
        this.addButtonsToToolBarProperty().addListener((observableValue, bl2, bl3) -> {
            Chart chart = this.getChart();
            if (chart == null || bl2.equals(bl3)) {
                return;
            }
            if (Boolean.TRUE.equals(bl3)) {
                chart.getToolBar().getChildren().add((Object)this.interactorButtons);
            } else {
                chart.getToolBar().getChildren().remove((Object)this.interactorButtons);
            }
        });
    }

    public IntegerProperty refreshRateProperty() {
        return this.refreshRate;
    }

    public int getRefreshRate() {
        return this.refreshRate.get();
    }

    public void setRefreshRate(int n2) {
        this.refreshRate.set(n2);
    }

    public void copySelectedToClipboard() {
        this.dsModel.runPreLayout();
        ClipboardContent clipboardContent = new ClipboardContent();
        clipboardContent.putString(this.dsModel.getSelectedData((TableView.TableViewSelectionModel<DataSetsRow>)this.table.getSelectionModel()));
        Clipboard.getSystemClipboard().setContent((Map)clipboardContent);
    }

    public void exportGridToCSV() {
        this.dsModel.runPreLayout();
        FileChooser fileChooser = new FileChooser();
        File file = fileChooser.showSaveDialog(this.getChart().getScene().getWindow());
        if (file == null) {
            return;
        }
        String string = this.dsModel.getSelectedData((TableView.TableViewSelectionModel<DataSetsRow>)this.table.getSelectionModel());
        try (BufferedWriter bufferedWriter = Files.newBufferedWriter(Paths.get(file.getPath() + ".csv", new String[0]), StandardCharsets.UTF_8, new OpenOption[0]);){
            bufferedWriter.write(string);
        }
        catch (IOException iOException) {
            LOGGER.atError().setCause(iOException).log("error while exporting data to csv");
        }
    }

    protected HBox getInteractorBar() {
        Separator separator = new Separator();
        separator.setOrientation(Orientation.VERTICAL);
        HBox hBox = new HBox();
        hBox.getStyleClass().add((Object)BUTTON_BAR_STYLE_CLASS);
        hBox.setPadding(new Insets(1.0, 1.0, 1.0, 1.0));
        Button button = new Button("", (Node)this.tableView);
        button.getStyleClass().add((Object)BUTTON_SWITCH_TABLE_VIEW_STYLE_CLASS);
        button.setPadding(new Insets(3.0, 3.0, 3.0, 3.0));
        button.setTooltip(new Tooltip("switches between graph and table view"));
        Button button2 = new Button("", (Node)this.clipBoardIcon);
        button2.getStyleClass().add((Object)BUTTON_COPY_TO_CLIPBOARD_STYLE_CLASS);
        button2.setPadding(new Insets(3.0, 3.0, 3.0, 3.0));
        button2.setTooltip(new Tooltip("copy selected content top system clipboard"));
        button2.setOnAction(actionEvent -> this.copySelectedToClipboard());
        Button button3 = new Button("", (Node)this.saveIcon);
        button3.getStyleClass().add((Object)BUTTON_SAVE_TABLE_VIEW_STYLE_CLASS);
        button3.setPadding(new Insets(3.0, 3.0, 3.0, 3.0));
        button3.setTooltip(new Tooltip("store actively shown content as .csv file"));
        button3.setOnAction(actionEvent -> this.exportGridToCSV());
        button.setOnAction(actionEvent -> {
            ObservableList observableList = this.getChart().getPlotForeground().getChildren();
            boolean bl2 = observableList.contains(this.table);
            if (bl2) {
                observableList.remove(this.table);
                this.table.prefWidthProperty().unbind();
                this.table.prefHeightProperty().unbind();
            } else {
                observableList.add(this.table);
                this.table.toFront();
                this.table.prefWidthProperty().bind((ObservableValue)this.getChart().getPlotForeground().widthProperty());
                this.table.prefHeightProperty().bind((ObservableValue)this.getChart().getPlotForeground().heightProperty());
            }
            button.setGraphic((Node)(bl2 ? this.tableView : this.graphView));
            this.getChart().getPlotForeground().setMouseTransparent(bl2);
            this.table.setMouseTransparent(bl2);
            this.dsModel.runPreLayout();
        });
        hBox.getChildren().addAll((Object[])new Node[]{separator, button, button2, button3});
        return hBox;
    }

    public TableView<?> getTable() {
        return this.table;
    }

    protected class DataSetsModel
    extends ObservableListBase<DataSetsRow> {
        protected static final double DEFAULT_COL_WIDTH = 150.0;
        private int nRows;
        private final ObservableList<TableColumn<DataSetsRow, ?>> columns = FXCollections.observableArrayList();
        private boolean forceNextUpdate = false;

        public DataSetsModel() {
            this.columns.add((Object)new RowIndexHeaderTableColumn());
        }

        public String toString() {
            return "TableModel";
        }

        public void runPreLayout() {
            Chart chart = TableViewer.this.getChart();
            if (chart == null) {
                return;
            }
            if (!TableViewer.this.table.isVisible()) {
                return;
            }
            if (!this.forceNextUpdate && chart.getBitState().isClean(ChartBits.DataSetMask)) {
                return;
            }
            this.forceNextUpdate = false;
            List list = TableViewer.this.getChart().getAllDatasets().stream().sorted(Comparator.comparing(DataSet::getName)).collect(Collectors.toList());
            if (list.size() >= 100) {
                LOGGER.atWarn().addArgument(list.size()).log("Limiting number of DataSets shown in Table, chart has {} DataSets.");
            }
            List<TableColumn> list2 = FXUtils.sizedList(this.columns, Math.min(list.size() + 1, 100), () -> new DataSetTableColumns());
            int n2 = 1;
            int n3 = 0;
            for (DataSet dataSet : list) {
                if (!(list2.get(n2) instanceof DataSetTableColumns)) continue;
                ((DataSetTableColumns)list2.get(n2++)).update(dataSet);
                n3 = Math.max(n3, dataSet.getDataCount());
            }
            if (this.nRows != n3) {
                this.nRows = n3;
                TableViewer.this.table.setItems(null);
                TableViewer.this.table.setItems((ObservableList)TableViewer.this.dsModel);
            } else {
                TableViewer.this.table.refresh();
            }
        }

        public void chartChanged(Chart chart, Chart chart2) {
            if (chart2 != null) {
                this.runPreLayout();
            }
            this.forceNextUpdate = true;
        }

        public boolean contains(Object object) {
            if (object instanceof DataSetsRow) {
                return this.nRows > ((DataSetsRow)object).getRow();
            }
            return false;
        }

        public DataSetsRow get(int n2) {
            return new DataSetsRow(n2, this);
        }

        protected String getAllData() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append('#');
            int n2 = 0;
            for (Object object : this.columns) {
                if (!(object instanceof DataSetTableColumns) || !object.isVisible()) continue;
                ++n2;
                for (Object object2 : object.getColumns()) {
                    if (!(object2 instanceof DataSetTableColumn) || !((DataSetTableColumn)((Object)object2)).active) continue;
                    stringBuilder.append(object2.getText()).append(n2).append(", ");
                }
            }
            stringBuilder.setCharAt(stringBuilder.length() - 2, '\n');
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
            for (int i2 = 0; i2 < this.nRows; ++i2) {
                for (Iterator iterator : this.columns) {
                    if (iterator instanceof DataSetTableColumns && iterator.isVisible()) {
                        for (TableColumn tableColumn : iterator.getColumns()) {
                            if (!(tableColumn instanceof DataSetTableColumn) || !((DataSetTableColumn)tableColumn).active) continue;
                            stringBuilder.append(((DataSetTableColumn)tableColumn).getValue(i2)).append(", ");
                        }
                        continue;
                    }
                    if (!(iterator instanceof RowIndexHeaderTableColumn)) continue;
                    stringBuilder.append(iterator.getCellData(i2)).append(", ");
                }
                stringBuilder.setCharAt(stringBuilder.length() - 2, '\n');
                stringBuilder.deleteCharAt(stringBuilder.length() - 1);
            }
            return stringBuilder.toString();
        }

        public ObservableList<TableColumn<DataSetsRow, ?>> getColumns() {
            return this.columns;
        }

        protected String getSelectedData(TableView.TableViewSelectionModel<DataSetsRow> tableViewSelectionModel) {
            Object object22;
            ObservableList observableList = tableViewSelectionModel.getSelectedCells();
            if (observableList.isEmpty()) {
                return this.getAllData();
            }
            TreeSet<Integer> treeSet = new TreeSet<Integer>();
            TreeMap<Integer, TableColumn> treeMap = new TreeMap<Integer, TableColumn>();
            for (Object object22 : observableList) {
                treeMap.put(object22.getColumn(), object22.getTableColumn());
                treeSet.add(object22.getRow());
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append('#');
            for (Map.Entry entry : treeMap.entrySet()) {
                stringBuilder.append(((TableColumn)entry.getValue()).getText()).append(", ");
            }
            stringBuilder.setCharAt(stringBuilder.length() - 2, '\n');
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
            object22 = treeSet.iterator();
            while (object22.hasNext()) {
                int n2 = (Integer)object22.next();
                for (Map.Entry entry : treeMap.entrySet()) {
                    if (entry.getValue() instanceof DataSetTableColumn) {
                        stringBuilder.append(((DataSetTableColumn)((Object)entry.getValue())).getValue(n2)).append(", ");
                        continue;
                    }
                    stringBuilder.append(((TableColumn)entry.getValue()).getCellData(n2)).append(", ");
                }
                stringBuilder.setCharAt(stringBuilder.length() - 2, '\n');
                stringBuilder.deleteCharAt(stringBuilder.length() - 1);
            }
            return stringBuilder.toString();
        }

        public double getValue(int n2, DataSet dataSet, ColumnType columnType) {
            if (dataSet == null || n2 >= dataSet.getDataCount()) {
                return 0.0;
            }
            if (!columnType.errorCol) {
                return dataSet.get(columnType.dimIdx, n2);
            }
            if (!(dataSet instanceof DataSetError)) {
                return 0.0;
            }
            DataSetError dataSetError = (DataSetError)dataSet;
            if (columnType.positive) {
                return dataSetError.getErrorPositive(columnType.dimIdx, n2);
            }
            return dataSetError.getErrorNegative(columnType.dimIdx, n2);
        }

        public int indexOf(Object object) {
            if (object instanceof DataSetsRow) {
                int n2 = ((DataSetsRow)object).row;
                return n2 < this.nRows ? n2 : -1;
            }
            return -1;
        }

        public boolean isEmpty() {
            return this.nRows >= 0;
        }

        public int size() {
            return this.nRows;
        }

        protected class RowIndexHeaderTableColumn
        extends TableColumn<DataSetsRow, Integer> {
            public RowIndexHeaderTableColumn() {
                this.setSortable(false);
                this.setReorderable(false);
                this.setCellValueFactory(cellDataFeatures -> new ReadOnlyObjectWrapper((Object)((DataSetsRow)cellDataFeatures.getValue()).getRow()));
                this.getStyleClass().add((Object)"column-header");
                this.setEditable(false);
            }
        }

        protected class DataSetTableColumns
        extends TableColumn<DataSetsRow, Double> {
            private DataSet dataSet;

            public DataSetTableColumns() {
                super("");
                this.setSortable(false);
                this.setReorderable(false);
                this.dataSet = null;
                for (ColumnType columnType : ColumnType.values()) {
                    this.getColumns().add((Object)new DataSetTableColumn(columnType));
                }
            }

            public void update(DataSet dataSet) {
                this.dataSet = dataSet;
                if (dataSet != null) {
                    this.setText(dataSet.getName());
                    this.setPrefWidth(150.0);
                } else {
                    this.setText("");
                    this.setPrefWidth(0.0);
                }
                this.getColumns().forEach(tableColumn -> {
                    if (tableColumn instanceof DataSetTableColumn) {
                        ((DataSetTableColumn)((Object)tableColumn)).update(this.dataSet);
                    }
                });
            }
        }

        protected class DataSetTableColumn
        extends TableColumn<DataSetsRow, Double> {
            private DataSet ds;
            private final ColumnType type;
            protected boolean active;

            public DataSetTableColumn(ColumnType columnType) {
                super("");
                this.active = false;
                this.setSortable(false);
                this.setReorderable(false);
                this.ds = null;
                this.type = columnType;
                this.setCellValueFactory(cellDataFeatures -> new ReadOnlyObjectWrapper((Object)((DataSetsRow)cellDataFeatures.getValue()).getValue(this.ds, columnType)));
                this.setPrefWidth(0.0);
            }

            public double getValue(int n2) {
                return TableViewer.this.dsModel.getValue(n2, this.ds, this.type);
            }

            public void update(DataSet dataSet) {
                this.ds = dataSet;
                if (this.ds == null) {
                    this.setText("");
                    this.setPrefWidth(0.0);
                    this.active = false;
                    return;
                }
                if (TableViewer.this.editable) {
                    this.updateEditableState();
                }
                if (!this.type.errorCol) {
                    this.setText(this.type.label);
                    this.setPrefWidth(150.0);
                    this.active = true;
                    return;
                }
                if (!(dataSet instanceof DataSetError)) {
                    this.setText("");
                    this.setPrefWidth(0.0);
                    this.active = false;
                    return;
                }
                DataSetError dataSetError = (DataSetError)dataSet;
                switch (dataSetError.getErrorType(this.type.dimIdx)) {
                    case SYMMETRIC: {
                        this.setText(this.type.positive ? "" : this.type.label);
                        this.setPrefWidth(this.type.positive ? 0.0 : 150.0);
                        this.active = !this.type.positive;
                        return;
                    }
                    case ASYMMETRIC: {
                        this.setText((this.type.positive ? (char)'+' : '-') + this.type.label);
                        this.setPrefWidth(150.0);
                        this.active = true;
                        return;
                    }
                }
                this.setText("");
                this.setPrefWidth(0.0);
                this.active = false;
            }

            private void updateEditableState() {
                this.setEditable(false);
                this.setOnEditCommit(null);
                if (!(this.ds instanceof EditableDataSet) || this.type != ColumnType.X && this.type != ColumnType.Y) {
                    return;
                }
                EditableDataSet editableDataSet = (EditableDataSet)this.ds;
                EditConstraints editConstraints = editableDataSet.getEditConstraints();
                if (this.type == ColumnType.X && editConstraints != null && !editConstraints.isEditable(0)) {
                    return;
                }
                if (this.type == ColumnType.Y && editConstraints != null && !editConstraints.isEditable(1)) {
                    return;
                }
                this.setEditable(true);
                this.setCellFactory(TextFieldTableCell.forTableColumn((StringConverter)new DoubleStringConverter()));
                this.setOnEditCommit(cellEditEvent -> {
                    DataSetsRow dataSetsRow = (DataSetsRow)cellEditEvent.getRowValue();
                    if (dataSetsRow == null) {
                        LOGGER.atError().log("DataSet row should not be null");
                        return;
                    }
                    int n2 = dataSetsRow.getRow();
                    double d2 = editableDataSet.get(0, n2);
                    double d3 = editableDataSet.get(1, n2);
                    if (editConstraints != null && !editConstraints.canChange(n2)) {
                        editableDataSet.set(n2, d2, d3);
                        return;
                    }
                    double d4 = (Double)cellEditEvent.getNewValue();
                    switch (this.type) {
                        case X: {
                            if (editConstraints != null && !editConstraints.isAcceptable(n2, d4, d3)) {
                                editableDataSet.set(n2, d2, d3);
                                break;
                            }
                            editableDataSet.set(n2, d4, d3);
                            break;
                        }
                        case Y: {
                            if (editConstraints != null && !editConstraints.isAcceptable(n2, d2, d4)) {
                                editableDataSet.set(n2, d2, d3);
                                break;
                            }
                            editableDataSet.set(n2, d2, d4);
                            break;
                        }
                        default: {
                            editableDataSet.set(n2, d2, d3);
                        }
                    }
                });
            }
        }
    }

    protected class DataSetsRow {
        private final int row;
        private final DataSetsModel model;

        private DataSetsRow(int n2, DataSetsModel dataSetsModel) {
            this.row = n2;
            this.model = dataSetsModel;
        }

        public boolean equals(Object object) {
            if (object instanceof DataSetsRow) {
                DataSetsRow dataSetsRow = (DataSetsRow)object;
                return dataSetsRow.getRow() == this.row && this.model == dataSetsRow.getModel();
            }
            return false;
        }

        protected DataSetsModel getModel() {
            return this.model;
        }

        public int getRow() {
            return this.row;
        }

        public double getValue(DataSet dataSet, ColumnType columnType) {
            return this.model.getValue(this.row, dataSet, columnType);
        }

        public int hashCode() {
            int n2 = 7;
            n2 = 31 * n2 + System.identityHashCode((Object)this.model);
            n2 = 31 * n2 + this.row;
            return n2;
        }
    }

    protected static enum ColumnType {
        X(0, "x", false, true),
        Y(1, "y", false, true),
        EXN(0, "e_x", true, false),
        EXP(0, "e_x", true, true),
        EYN(1, "e_y", true, false),
        EYP(1, "e_y", true, true);

        final int dimIdx;
        final String label;
        final boolean errorCol;
        final boolean positive;

        private ColumnType(int n3, String string2, boolean bl2, boolean bl3) {
            this.dimIdx = n3;
            this.label = string2;
            this.errorCol = bl2;
            this.positive = bl3;
        }
    }
}

