/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.chartfx.plugins;

import io.fair_acc.chartfx.plugins.ChartPlugin;
import io.fair_acc.chartfx.plugins.measurements.AbstractChartMeasurement;
import io.fair_acc.chartfx.plugins.measurements.DataSetMeasurements;
import io.fair_acc.chartfx.plugins.measurements.SimpleMeasurements;
import io.fair_acc.chartfx.plugins.measurements.TrendingMeasurements;
import io.fair_acc.chartfx.ui.TilingPane;
import io.fair_acc.chartfx.ui.geometry.Side;
import io.fair_acc.chartfx.viewer.DataView;
import javafx.beans.value.ChangeListener;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.scene.Node;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuBar;
import javafx.scene.control.MenuItem;
import javafx.scene.control.Tooltip;
import org.kordamp.ikonli.javafx.FontIcon;

public class ParameterMeasurements
extends ChartPlugin {
    private static final String TOOL_BUTTON = "fas-drafting-compass:18";
    protected final ObservableList<AbstractChartMeasurement> chartMeasurements = FXCollections.observableArrayList();
    private final DataView dataView = new DataView("ChartViews", (Node)new FontIcon("fas-drafting-compass:18"));
    private MenuBar parameterMenu;
    private final ChangeListener<Boolean> parentVisibleListener = (observableValue, bl2, bl3) -> {
        if (Boolean.FALSE.equals(bl3)) {
            ((Menu)this.parameterMenu.getMenus().get(0)).hide();
        }
    };

    public ParameterMeasurements() {
        this(Side.RIGHT, true);
    }

    public ParameterMeasurements(Side side, boolean bl4) {
        this.parameterMenu = this.getMenuBar();
        this.parameterMenu.setId("ParameterMeasurements::parameterMenu");
        this.parameterMenu.parentProperty().addListener((observableValue, parent, parent2) -> {
            if (parent != null) {
                parent.visibleProperty().addListener(this.parentVisibleListener);
            }
            if (parent2 != null) {
                parent2.visibleProperty().addListener(this.parentVisibleListener);
            }
        });
        this.chartProperty().addListener((observableValue, chart, chart2) -> {
            if (chart != null) {
                chart.getToolBar().getChildren().remove((Object)this.parameterMenu);
                chart.getMeasurementPane().remove((Node)this.dataView, new Node[0]);
            }
            if (chart2 != null) {
                if (bl4) {
                    chart2.getToolBar().getChildren().add((Object)this.parameterMenu);
                }
                chart2.getMeasurementPane().addSide(side, (Node)this.dataView, new Node[0]);
            }
        });
        this.dataView.setNodeLayout(TilingPane.Layout.VBOX);
    }

    public ObservableList<AbstractChartMeasurement> getChartMeasurements() {
        return this.chartMeasurements;
    }

    public DataView getDataView() {
        return this.dataView;
    }

    public MenuBar getMenuBar() {
        MenuItem menuItem;
        Menu menu;
        if (this.parameterMenu != null) {
            return this.parameterMenu;
        }
        this.parameterMenu = new MenuBar();
        Menu menu2 = new Menu(null, (Node)new FontIcon(TOOL_BUTTON));
        menu2.getProperties().put((Object)"TOOL_TIP", (Object)new Tooltip("add measurement indicator"));
        menu2.setId("ParameterMeasurements::measurementMenu");
        for (SimpleMeasurements.MeasurementCategory enum_ : SimpleMeasurements.MeasurementCategory.values()) {
            menu = new Menu(enum_.getName());
            menu2.getItems().addAll((Object[])new MenuItem[]{menu});
            for (SimpleMeasurements.MeasurementType measurementType : SimpleMeasurements.MeasurementType.values()) {
                if (measurementType.getCategory() != enum_) continue;
                menuItem = new MenuItem(measurementType.getName());
                menuItem.setId("ParameterMeasurements::newMeasurement::" + measurementType.toString());
                menuItem.setOnAction(actionEvent -> new SimpleMeasurements(this, measurementType).initialize());
                menu.getItems().addAll((Object[])new MenuItem[]{menuItem});
            }
        }
        for (Enum enum_ : DataSetMeasurements.MeasurementCategory.values()) {
            menu = new Menu(((DataSetMeasurements.MeasurementCategory)enum_).getName());
            menu2.getItems().addAll((Object[])new MenuItem[]{menu});
            for (Enum enum_2 : DataSetMeasurements.MeasurementType.values()) {
                if (((DataSetMeasurements.MeasurementType)enum_2).getCategory() != enum_) continue;
                menuItem = new MenuItem(((DataSetMeasurements.MeasurementType)enum_2).getName());
                menuItem.setId("ParameterMeasurements::newMeasurement::" + enum_2.toString());
                menuItem.setOnAction(arg_0 -> this.lambda$getMenuBar$4((DataSetMeasurements.MeasurementType)enum_2, arg_0));
                menu.getItems().addAll((Object[])new MenuItem[]{menuItem});
            }
        }
        for (Enum enum_ : TrendingMeasurements.MeasurementCategory.values()) {
            menu = new Menu(((TrendingMeasurements.MeasurementCategory)enum_).getName());
            menu2.getItems().addAll((Object[])new MenuItem[]{menu});
            for (Enum enum_3 : TrendingMeasurements.MeasurementType.values()) {
                if (((TrendingMeasurements.MeasurementType)enum_3).getCategory() != enum_) continue;
                menuItem = new MenuItem(((TrendingMeasurements.MeasurementType)enum_3).getName());
                menuItem.setId("ParameterMeasurements::newMeasurement::" + enum_3.toString());
                menuItem.setOnAction(arg_0 -> this.lambda$getMenuBar$5((TrendingMeasurements.MeasurementType)enum_3, arg_0));
                menu.getItems().addAll((Object[])new MenuItem[]{menuItem});
            }
        }
        this.parameterMenu.getMenus().addAll((Object[])new Menu[]{menu2});
        return this.parameterMenu;
    }

    private /* synthetic */ void lambda$getMenuBar$5(TrendingMeasurements.MeasurementType measurementType, ActionEvent actionEvent) {
        new TrendingMeasurements(this, measurementType).initialize();
    }

    private /* synthetic */ void lambda$getMenuBar$4(DataSetMeasurements.MeasurementType measurementType, ActionEvent actionEvent) {
        new DataSetMeasurements(this, measurementType).initialize();
    }
}

