/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.chartfx.axes.spi;

import io.fair_acc.chartfx.ui.geometry.Side;
import io.fair_acc.dataset.spi.DataRange;
import java.security.InvalidParameterException;
import java.util.Objects;

public class AxisRange
extends DataRange {
    protected double axisLength;
    protected double scale = 1.0;
    protected double tickUnit;

    public AxisRange() {
        this(Double.NaN, Double.NaN, 1.0, 1.0, 0.1);
    }

    public AxisRange(AxisRange axisRange) {
        this(axisRange.getMin(), axisRange.getMax(), axisRange.getAxisLength(), axisRange.getScale(), axisRange.getTickUnit());
    }

    public boolean set(AxisRange axisRange) {
        boolean bl2;
        boolean bl3 = bl2 = !this.equals(axisRange);
        if (bl2) {
            super.set(axisRange);
            this.axisLength = axisRange.axisLength;
            this.scale = axisRange.scale;
            this.tickUnit = axisRange.tickUnit;
        }
        return bl2;
    }

    public AxisRange(double d2, double d3, double d4, double d5, double d6) {
        super(d2, d3);
        if (d5 == 0.0) {
            throw new InvalidParameterException("scale should not be '0'");
        }
        if (d6 <= 0.0) {
            throw new InvalidParameterException("tickUnit should not be <='0'");
        }
        this.axisLength = d4;
        this.scale = d5;
        this.tickUnit = d6;
    }

    public boolean add(AxisRange axisRange) {
        boolean bl2 = false;
        if (this.add(axisRange.min)) {
            bl2 = true;
        }
        if (this.add(axisRange.max)) {
            bl2 = true;
        }
        return bl2;
    }

    public AxisRange copy() {
        return new AxisRange(this.getLowerBound(), this.getUpperBound(), this.getAxisLength(), this.getScale(), this.getTickUnit());
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof AxisRange)) {
            return false;
        }
        return object.hashCode() == this.hashCode();
    }

    public double getAxisLength() {
        return this.axisLength;
    }

    public double getLowerBound() {
        return this.min;
    }

    public double getScale() {
        return this.scale;
    }

    public double getTickUnit() {
        return this.tickUnit;
    }

    public double getUpperBound() {
        return this.max;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.min, this.max, this.axisLength, this.scale, this.tickUnit);
    }

    public void setAxisLength(double d2, Side side) {
        if (d2 == 0.0) {
            throw new InvalidParameterException("length should not be '0'");
        }
        this.axisLength = d2;
        double d3 = 1.0;
        double d4 = this.max - this.min;
        d3 = side.isVertical() ? (d4 == 0.0 ? -d2 : -(d2 / d4)) : (d4 == 0.0 ? d2 : d2 / d4);
        this.scale = d3;
        this.tickUnit = d4 / 10.0;
    }

    @Override
    public String toString() {
        return String.format("AxisRange [min=%f, max=%f, axisLength=%f, scale=%f, tickUnit=%f]", this.min, this.max, this.axisLength, this.scale, this.tickUnit);
    }
}

