/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.chartfx.axes.spi;

import io.fair_acc.bench.DurationMeasure;
import io.fair_acc.bench.Measurable;
import io.fair_acc.bench.MeasurementRecorder;
import io.fair_acc.chartfx.axes.Axis;
import io.fair_acc.chartfx.axes.AxisLabelFormatter;
import io.fair_acc.chartfx.axes.AxisLabelOverlapPolicy;
import io.fair_acc.chartfx.axes.spi.AbstractAxisParameter;
import io.fair_acc.chartfx.axes.spi.AxisRange;
import io.fair_acc.chartfx.axes.spi.TickMark;
import io.fair_acc.chartfx.axes.spi.format.DefaultFormatter;
import io.fair_acc.chartfx.axes.spi.format.DefaultTimeFormatter;
import io.fair_acc.chartfx.ui.ResizableCanvas;
import io.fair_acc.chartfx.ui.css.LineStyle;
import io.fair_acc.chartfx.ui.css.TextStyle;
import io.fair_acc.chartfx.ui.geometry.Side;
import io.fair_acc.chartfx.utils.FXUtils;
import io.fair_acc.chartfx.utils.PropUtil;
import io.fair_acc.dataset.events.ChartBits;
import io.fair_acc.dataset.spi.fastutil.DoubleArrayList;
import java.util.List;
import java.util.Objects;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.geometry.Bounds;
import javafx.geometry.VPos;
import javafx.scene.CacheHint;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.text.TextAlignment;
import javafx.util.StringConverter;

public abstract class AbstractAxis
extends AbstractAxisParameter
implements Axis,
Measurable {
    protected static final double MIN_NARROW_FONT_SCALE = 0.7;
    protected static final double MAX_NARROW_FONT_SCALE = 1.0;
    protected static final double MIN_TICK_GAP = 1.0;
    private final transient Canvas canvas = new ResizableCanvas();
    private boolean drawAxisLabel;
    private boolean shiftLabels;
    protected boolean labelOverlap;
    protected double scaleFont = 1.0;
    protected double maxLabelHeight;
    protected double maxLabelWidth;
    private double canvasPadX;
    private double canvasPadY;
    private final transient ObjectProperty<AxisLabelFormatter> axisFormatter = new SimpleObjectProperty<AxisLabelFormatter>((Object)this, "axisLabelFormatter", null){
        private final AxisLabelFormatter defaultFormatter;
        private final AxisLabelFormatter defaultTimeFormatter;
        private final AxisLabelFormatter defaultLogTimeFormatter;
        {
            this.defaultFormatter = new DefaultFormatter(AbstractAxis.this);
            this.defaultTimeFormatter = new DefaultTimeFormatter(AbstractAxis.this);
            this.defaultLogTimeFormatter = new DefaultTimeFormatter(AbstractAxis.this);
        }

        public AxisLabelFormatter get() {
            AxisLabelFormatter axisLabelFormatter = (AxisLabelFormatter)super.get();
            if (axisLabelFormatter != null) {
                return axisLabelFormatter;
            }
            if (AbstractAxis.this.isTimeAxis()) {
                if (AbstractAxis.this.isLogAxis()) {
                    return this.defaultLogTimeFormatter;
                }
                return this.defaultTimeFormatter;
            }
            return this.defaultFormatter;
        }

        protected void invalidated() {
            AbstractAxis.this.forceRedraw();
        }
    };
    private double tickMarkOffset;
    private double evenLabelsOffset;
    private double oddLabelsOffset;
    private double axisLabelOffset;
    private final transient DoubleArrayList newTickValues = new DoubleArrayList();
    private final TickMark tmpTickMark = new TickMark(this.getTickLabelStyle());
    private DurationMeasure benchComputePrefSize = DurationMeasure.DISABLED;
    private DurationMeasure benchUpdateDirtyContent = DurationMeasure.DISABLED;
    private DurationMeasure benchDrawAxis = DurationMeasure.DISABLED;

    protected AbstractAxis() {
        this.setMouseTransparent(false);
        this.setPickOnBounds(true);
        this.canvas.setMouseTransparent(false);
        this.canvas.toFront();
        if (!this.canvas.isCache()) {
            this.canvas.setCache(true);
            this.canvas.setCacheHint(CacheHint.QUALITY);
        }
        this.getChildren().add((Object)this.canvas);
        PropUtil.initAndRunOnChange(this::updateAxisLabelAlignment, new ObservableValue[]{this.sideProperty()});
        PropUtil.initAndRunOnChange(this::updateTickLabelAlignment, new ObservableValue[]{this.sideProperty(), this.getTickLabelStyle().rotateProperty()});
    }

    protected AbstractAxis(double d2, double d3) {
        this();
        this.set(d2, d3);
        this.setAutoRanging(false);
    }

    public ObjectProperty<AxisLabelFormatter> axisLabelFormatterProperty() {
        return this.axisFormatter;
    }

    public abstract double computePreferredTickUnit(double var1);

    @Override
    public void drawAxis(GraphicsContext graphicsContext, double d2, double d3) {
        if (graphicsContext == null || this.getSide() == null) {
            return;
        }
        this.drawAxisPre();
        double d4 = this.getLength();
        if (this.isTickLabelRendered()) {
            double d5;
            ObservableList<TickMark> observableList = this.getTickMarks();
            ObservableList<TickMark> observableList2 = this.getMinorTickMarks();
            if (this.isMinorTickVisible() && this.getMinorTickLength() > 0.0 && d4 > (d5 = (double)observableList.size() * (this.getMajorTickStyle().getStrokeWidth() + 1.0) + (double)observableList2.size() * (this.getMinorTickStyle().getStrokeWidth() + 1.0))) {
                this.drawTickMarks(graphicsContext, d4, d2, d3, observableList2, this.getMinorTickLength(), this.getMinorTickStyle());
            }
            this.applyOverlapPolicy((List<TickMark>)this.majorTickMarks);
            this.drawTickMarks(graphicsContext, d4, d2, d3, observableList, this.getTickLength(), this.getMajorTickStyle());
            this.drawTickLabels(graphicsContext, d2, d3, observableList, this.getTickLength());
        }
        this.drawAxisLabel(graphicsContext, d2, d3, this.getAxisLabel(), this.getTickLength());
        this.drawAxisLine(graphicsContext, d4, d2, d3);
        this.drawAxisPost();
    }

    public AxisLabelFormatter getAxisLabelFormatter() {
        return (AxisLabelFormatter)this.axisFormatter.get();
    }

    @Override
    public Canvas getCanvas() {
        return this.canvas;
    }

    @Override
    public double getDisplayPosition(double d2) {
        return this.cachedOffset + (d2 - this.getMin()) * this.getScale();
    }

    public GraphicsContext getGraphicsContext() {
        return this.canvas.getGraphicsContext2D();
    }

    @Override
    public String getTickMarkLabel(double d2) {
        double d3 = d2 / this.getUnitScaling();
        StringConverter<Number> stringConverter = this.getTickLabelFormatter();
        if (stringConverter != null) {
            return stringConverter.toString((Object)d3);
        }
        return this.getAxisLabelFormatter().toString(d3);
    }

    @Override
    public double getZeroPosition() {
        if (0.0 < this.getMin() || 0.0 > this.getMax()) {
            return Double.NaN;
        }
        return this.getDisplayPosition(0.0);
    }

    public boolean isLabelOverlapping() {
        return this.labelOverlap;
    }

    @Override
    public boolean isValueOnAxis(double d2) {
        return Double.isFinite(d2) && d2 >= this.getMin() && d2 <= this.getMax();
    }

    protected void updateDirtyContent(double d2) {
        this.benchUpdateDirtyContent.start();
        this.updateAxisRange(d2);
        this.updateAxisLabel();
        this.benchUpdateDirtyContent.stop();
    }

    protected void updateAxisRange(double d2) {
        if (this.state.isClean(ChartBits.AxisRange, ChartBits.AxisTickLabelText) && d2 == this.getLength()) {
            return;
        }
        this.setLength(d2);
        AxisRange axisRange = this.getRange();
        this.set(axisRange.getMin(), axisRange.getMax());
        axisRange.scale = this.calculateNewScale(d2, this.getMin(), this.getMax());
        this.setScale(axisRange.scale);
        axisRange.tickUnit = this.computePreferredTickUnit(d2);
        this.setTickUnit(axisRange.tickUnit);
        axisRange.axisLength = d2;
        this.updateScaleAndUnitPrefix();
        this.updateCachedTransforms();
        this.updateMajorTickMarks(axisRange);
        this.updateMinorTickMarks();
        this.updateTickMarkPositions((List<TickMark>)this.getTickMarks());
        this.updateTickMarkPositions((List<TickMark>)this.getMinorTickMarks());
        this.state.clear(ChartBits.AxisRange, ChartBits.AxisTickLabelText);
    }

    @Override
    public AxisRange getRange() {
        if (this.isAutoRanging() || this.isAutoGrowRanging()) {
            return this.autoRange(this.getLength());
        }
        return this.getUserRange();
    }

    public void setAxisLabelFormatter(AxisLabelFormatter axisLabelFormatter) {
        this.axisFormatter.set((Object)axisLabelFormatter);
    }

    @Override
    public boolean setMax(double d2) {
        if (this.isLogAxis() && (d2 <= 0.0 || !Double.isFinite(d2))) {
            if (this.getMin() >= 0.0) {
                return super.setMax(this.getMin() * 1000000.0);
            }
            return false;
        }
        return super.setMax(d2);
    }

    @Override
    public boolean setMin(double d2) {
        if (this.isLogAxis() && (d2 <= 0.0 || !Double.isFinite(d2))) {
            if (this.getMax() > 0.0) {
                return super.setMin(this.getMax() / 1000000.0);
            }
            return false;
        }
        return super.setMin(d2);
    }

    protected AxisRange autoRange(double d2) {
        if (this.isAutoRanging() || this.isAutoGrowRanging()) {
            double d3 = this.getTickLabelFont().getSize() * 1.2;
            return this.autoRange(this.getAutoRange().getMin(), this.getAutoRange().getMax(), d2, d3);
        }
        return this.getRange();
    }

    protected abstract AxisRange autoRange(double var1, double var3, double var5, double var7);

    protected abstract void calculateMajorTickValues(AxisRange var1, DoubleArrayList var2);

    protected abstract void calculateMinorTickValues(DoubleArrayList var1);

    protected double calculateNewScale(double d2, double d3, double d4) {
        double d5;
        double d6 = d4 - d3;
        double d7 = d5 = d6 == 0.0 ? d2 : d2 / d6;
        if (d5 == 0.0) {
            return -1.0;
        }
        return this.getSide().isVertical() ? -d5 : d5;
    }

    protected void clearAxisCanvas(GraphicsContext graphicsContext, double d2, double d3) {
        graphicsContext.clearRect(0.0, 0.0, d2, d3);
    }

    protected double computePrefHeight(double d2) {
        Side side = this.getSide();
        if (side == null || side.isVertical()) {
            return Math.max(this.getAxisLabel().getBoundsInParent().getHeight(), 150.0);
        }
        return this.computePrefSize(d2);
    }

    protected double computePrefWidth(double d2) {
        Side side = this.getSide();
        if (side == null || side.isHorizontal()) {
            return Math.max(this.getAxisLabel().getBoundsInParent().getWidth(), 150.0);
        }
        return this.computePrefSize(d2);
    }

    private double computePrefSize(double d2) {
        double d3;
        if (d2 == -1.0) {
            return this.computeMinSize();
        }
        boolean bl2 = this.getSide().isHorizontal();
        if (this.getLength() == d2 && this.state.isClean(ChartBits.AxisLayout)) {
            return bl2 ? this.getHeight() : this.getWidth();
        }
        this.benchComputePrefSize.start();
        this.updateDirtyContent(d2);
        this.scaleFont = 1.0;
        this.maxLabelHeight = 0.0;
        this.maxLabelWidth = 0.0;
        this.drawAxisLabel = false;
        this.shiftLabels = false;
        this.labelOverlap = false;
        double d4 = this.isTickMarkVisible() ? this.getTickLength() : this.getMajorTickStyle().getStrokeWidth();
        double d5 = 0.0;
        if (this.isTickLabelRendered()) {
            for (TickMark tickMark : this.getTickMarks()) {
                this.maxLabelHeight = Math.max(this.maxLabelHeight, tickMark.getHeight());
                this.maxLabelWidth = Math.max(this.maxLabelWidth, tickMark.getWidth());
            }
            d5 = bl2 ? this.maxLabelHeight : this.maxLabelWidth;
            switch (this.getOverlapPolicy()) {
                case FORCED_SHIFT_ALT: {
                    this.shiftLabels = true;
                    break;
                }
                case SHIFT_ALT: {
                    this.shiftLabels = this.isTickLabelsOverlap((List<TickMark>)this.getTickMarks(), 0, 1);
                }
            }
        }
        this.drawAxisLabel = (d3 = this.getAxisLabelSize()) > 0.0;
        double d6 = d5 <= 0.0 ? 0.0 : this.getTickLabelGap();
        double d7 = d3 <= 0.0 ? 0.0 : this.getAxisLabelGap();
        double d8 = d3 <= 0.0 ? 0.0 : this.getExtraLabelOffset();
        this.tickMarkOffset = this.getTickMarkGap();
        this.oddLabelsOffset = this.evenLabelsOffset = this.tickMarkOffset + d4 + d6;
        if (this.shiftLabels) {
            this.oddLabelsOffset += d5 + d6;
        }
        this.axisLabelOffset = this.oddLabelsOffset + d5 + d7 + d8;
        double d9 = this.axisLabelOffset + d3 + this.getAxisLabelGap();
        if (this.getSide() == Side.CENTER_VER) {
            this.axisLabelOffset = -this.axisLabelOffset;
        }
        this.benchComputePrefSize.stop();
        return Math.ceil(this.getSide().isCenter() ? 2.0 * d9 : d9);
    }

    private double computeMinSize() {
        double d2 = this.isTickMarkVisible() ? this.getTickLength() : this.getMajorTickStyle().getStrokeWidth();
        double d3 = 0.0;
        boolean bl2 = false;
        if (this.isTickMarkVisible() && this.isTickLabelsVisible()) {
            this.tmpTickMark.setValue(0.0, "0.0");
            double d4 = d3 = this.getSide().isHorizontal() ? this.tmpTickMark.getHeight() : this.tmpTickMark.getWidth();
            if (this.getOverlapPolicy() == AxisLabelOverlapPolicy.FORCED_SHIFT_ALT) {
                bl2 = true;
            }
        }
        double d5 = this.getAxisLabelSize();
        double d6 = d3 <= 0.0 ? 0.0 : this.getTickLabelGap();
        double d7 = d5 <= 0.0 ? 0.0 : this.getAxisLabelGap();
        double d8 = d5 <= 0.0 ? 0.0 : this.getExtraLabelOffset();
        double d9 = this.getTickMarkGap() + d2 + d6 + (bl2 ? d3 + d6 : 0.0) + d3 + d7 + d8 + d5 + this.getAxisLabelGap();
        return Math.ceil(this.getSide().isCenter() ? 2.0 * d9 : d9);
    }

    private double getAxisLabelSize() {
        TextStyle textStyle = this.getAxisLabel();
        if (textStyle.isVisible() && !PropUtil.isNullOrEmpty(textStyle.getText())) {
            Bounds bounds = textStyle.getBoundsInParent();
            return this.getSide().isHorizontal() ? bounds.getHeight() : bounds.getWidth();
        }
        return 0.0;
    }

    private double getExtraLabelOffset() {
        switch (this.getSide()) {
            case LEFT: 
            case CENTER_VER: {
                return this.getTickLabelGap();
            }
        }
        return 0.0;
    }

    private boolean isTickLabelRendered() {
        return this.isTickMarkVisible() && this.isTickLabelsVisible() && Double.isFinite(this.getMin()) && Double.isFinite(this.getMax());
    }

    private void applyOverlapPolicy(List<TickMark> list) {
        if (list.isEmpty()) {
            return;
        }
        for (TickMark tickMark : list) {
            tickMark.setVisible(true);
        }
        this.hideLabelsOutsideParentBounds(list);
        if (!this.shiftLabels) {
            this.labelOverlap = this.isTickLabelsOverlap(list, 0, 1);
        } else {
            boolean bl2 = this.labelOverlap = this.isTickLabelsOverlap(list, 0, 2) || this.isTickLabelsOverlap(list, 1, 2);
        }
        if (!this.labelOverlap) {
            return;
        }
        switch (this.getOverlapPolicy()) {
            case DO_NOTHING: {
                break;
            }
            case FORCED_SHIFT_ALT: 
            case SHIFT_ALT: {
                break;
            }
            case SKIP_ALT: {
                int n2;
                for (int i2 = n2 = !list.get(0).isVisible() ? 0 : 1; i2 < list.size(); i2 += 2) {
                    list.get(i2).setVisible(false);
                }
                break;
            }
            case NARROW_FONT: {
                double d2 = this.getSide().isHorizontal() ? this.maxLabelWidth : this.maxLabelHeight;
                double d3 = (double)(this.majorTickMarks.size() + 1) * d2;
                double d4 = this.getLength() / d3;
                this.scaleFont = Math.min(Math.max(d4, 0.7), 1.0);
            }
        }
    }

    private void hideLabelsOutsideParentBounds(List<TickMark> list) {
        if (this.getParent() == null || !(this.getParent() instanceof Pane)) {
            return;
        }
        if (this.getSide().isHorizontal()) {
            double d2 = this.getLayoutX();
            double d3 = ((Pane)this.getParent()).getWidth();
            for (TickMark tickMark : list) {
                double d4 = tickMark.getWidth();
                double d5 = tickMark.getPosition() - d4 / 2.0 + d2;
                double d6 = tickMark.getPosition() + d4 / 2.0 + d2;
                if (!(d5 < 0.0) && !(d6 > d3)) continue;
                tickMark.setVisible(false);
            }
        } else {
            double d7 = this.getLayoutY();
            double d8 = ((Pane)this.getParent()).getHeight();
            for (TickMark tickMark : list) {
                double d9 = tickMark.getHeight();
                double d10 = tickMark.getPosition() - d9 / 2.0 + d7;
                double d11 = tickMark.getPosition() + d9 / 2.0 + d7;
                if (!(d10 < 0.0) && !(d11 > d8)) continue;
                tickMark.setVisible(false);
            }
        }
    }

    @Deprecated
    List<TickMark> computeTickMarks(AxisRange axisRange, boolean bl2) {
        if (bl2) {
            this.updateMajorTickMarks(axisRange);
            return this.majorTickMarks;
        }
        this.updateMinorTickMarks();
        return this.minorTickMarks;
    }

    protected void updateMajorTickMarks(AxisRange axisRange) {
        this.newTickValues.clear();
        this.newTickValues.ensureCapacity(this.getMaxMajorTickLabelCount());
        this.calculateMajorTickValues(axisRange, this.newTickValues);
        DoubleArrayList doubleArrayList = this.getTickMarkValues();
        if (this.newTickValues.equals(doubleArrayList) && this.state.isClean(ChartBits.AxisTickLabelText)) {
            return;
        }
        if (this.isTickLabelsVisible()) {
            this.getAxisLabelFormatter().updateFormatter(this.newTickValues, this.getUnitScaling());
        }
        List<TickMark> list = FXUtils.sizedList(this.getTickMarks(), this.newTickValues.size(), () -> new TickMark(this.getTickLabelStyle()));
        int n2 = 0;
        for (TickMark tickMark : list) {
            double d2 = this.newTickValues.getDouble(n2++);
            tickMark.setValue(d2, this.isTickLabelsVisible() ? this.getTickMarkLabel(d2) : "");
        }
        doubleArrayList.setAll(this.newTickValues);
        this.tickMarksUpdated();
    }

    protected void updateMinorTickMarks() {
        this.newTickValues.clear();
        this.newTickValues.ensureCapacity(this.getMaxMajorTickLabelCount() * this.getMinorTickCount());
        this.calculateMinorTickValues(this.newTickValues);
        DoubleArrayList doubleArrayList = this.getMinorTickMarkValues();
        if (this.newTickValues.equals(doubleArrayList)) {
            return;
        }
        List<TickMark> list = FXUtils.sizedList(this.getMinorTickMarks(), this.newTickValues.size(), () -> new TickMark(this.getTickLabelStyle()));
        int n2 = 0;
        for (TickMark tickMark : list) {
            tickMark.setValue(this.newTickValues.getDouble(n2++), "");
        }
        doubleArrayList.setAll(this.newTickValues);
        this.tickMarksUpdated();
    }

    protected void updateTickMarkPositions(List<TickMark> list) {
        for (TickMark tickMark : list) {
            tickMark.setPosition(this.getDisplayPosition(tickMark.getValue()));
        }
    }

    protected abstract AxisRange computeRange(double var1, double var3, double var5, double var7);

    protected void drawAxisLabel(GraphicsContext graphicsContext, double d2, double d3, TextStyle textStyle, double d4) {
        double d5;
        if (!this.drawAxisLabel) {
            return;
        }
        double d6 = switch (textStyle.getTextAlignment()) {
            case TextAlignment.LEFT -> {
                d5 = 0.0;
                yield this.getTickLabelGap();
            }
            case TextAlignment.RIGHT -> {
                d5 = 1.0;
                yield -this.getTickLabelGap();
            }
            default -> {
                d5 = 0.5;
                yield 0.0;
            }
        };
        d6 *= Math.signum(this.axisLabelOffset);
        double d7 = this.getCanvasCoordinate(d2, d3, this.axisLabelOffset);
        if (this.getSide().isHorizontal()) {
            double d8 = d5 * d2 + d6;
            AbstractAxis.drawAxisLabel(graphicsContext, d8, d7, textStyle);
        } else {
            double d9 = (1.0 - d5) * d3 + d6;
            AbstractAxis.drawAxisLabel(graphicsContext, d7, d9, textStyle);
        }
    }

    protected void drawAxisLine(GraphicsContext graphicsContext, double d2, double d3, double d4) {
        graphicsContext.save();
        this.getMajorTickStyle().copyStyleTo(graphicsContext);
        double d5 = this.getCanvasCoordinate(d3, d4, AbstractAxis.snap(this.tickMarkOffset));
        double d6 = AbstractAxis.snap(0.0);
        double d7 = AbstractAxis.snap(d2);
        if (this.getSide().isHorizontal()) {
            graphicsContext.strokeLine(d6, d5, d7, d5);
        } else {
            graphicsContext.strokeLine(d5, d6, d5, d7);
        }
        graphicsContext.restore();
    }

    protected void drawAxisPost() {
    }

    protected void drawAxisPre() {
    }

    private double getCanvasCoordinate(double d2, double d3, double d4) {
        switch (this.getSide()) {
            case CENTER_HOR: {
                return this.getAxisCenterPosition() * d3 + d4;
            }
            case CENTER_VER: {
                return this.getAxisCenterPosition() * d2 + d4;
            }
            case TOP: {
                return d3 - d4;
            }
            case LEFT: {
                return d2 - d4;
            }
        }
        return d4;
    }

    protected void drawTickLabels(GraphicsContext graphicsContext, double d2, double d3, ObservableList<TickMark> observableList, double d4) {
        if (observableList.isEmpty()) {
            return;
        }
        double d5 = this.getCanvasCoordinate(d2, d3, this.evenLabelsOffset);
        double d6 = this.getCanvasCoordinate(d2, d3, this.oddLabelsOffset);
        graphicsContext.save();
        this.getTickLabelStyle().copyStyleTo(graphicsContext);
        boolean bl2 = this.getSide().isHorizontal();
        boolean bl3 = false;
        if (this.shiftLabels) {
            bl3 = (int)((TickMark)observableList.get(0)).getValue() % 2 == 0;
        }
        for (TickMark tickMark : observableList) {
            double d7;
            boolean bl4 = bl3 = !bl3;
            if (!tickMark.isVisible()) continue;
            double d8 = tickMark.getPosition();
            double d9 = d7 = bl3 ? d5 : d6;
            if (bl2) {
                AbstractAxis.drawTickMarkLabel(graphicsContext, d8, d7, this.scaleFont, tickMark);
                continue;
            }
            AbstractAxis.drawTickMarkLabel(graphicsContext, d7, d8, this.scaleFont, tickMark);
        }
        graphicsContext.restore();
    }

    protected void drawTickMarks(GraphicsContext graphicsContext, double d2, double d3, double d4, ObservableList<TickMark> observableList, double d5, LineStyle lineStyle) {
        if (d5 <= 0.0) {
            return;
        }
        double d6 = this.getSide().isCenter() ? this.getCanvasCoordinate(d3, d4, AbstractAxis.snap(this.tickMarkOffset - d5)) : this.getCanvasCoordinate(d3, d4, AbstractAxis.snap(this.tickMarkOffset));
        double d7 = this.getCanvasCoordinate(d3, d4, AbstractAxis.snap(this.tickMarkOffset + d5));
        boolean bl2 = this.getSide().isHorizontal();
        graphicsContext.save();
        lineStyle.copyStyleTo(graphicsContext);
        for (TickMark tickMark : observableList) {
            double d8 = AbstractAxis.snap(tickMark.getPosition());
            if (d8 < 0.0 || d8 > d2) continue;
            if (bl2) {
                graphicsContext.strokeLine(d8, d6, d8, d7);
                continue;
            }
            graphicsContext.strokeLine(d6, d8, d7, d8);
        }
        graphicsContext.restore();
    }

    protected void layoutChildren() {
        if (this.getSide() == null) {
            this.canvasPadX = 0.0;
            this.canvasPadY = 0.0;
        } else if (this.getSide().isHorizontal()) {
            this.canvasPadX = this.getAxisPadding();
            this.canvasPadY = 0.0;
        } else {
            this.canvasPadX = 0.0;
            this.canvasPadY = this.getAxisPadding();
        }
        this.canvas.resizeRelocate(-this.canvasPadX, -this.canvasPadY, this.getWidth() + 2.0 * this.canvasPadX, this.getHeight() + 2.0 * this.canvasPadY);
        double d2 = this.getSide().isHorizontal() ? this.getWidth() : this.getHeight();
        this.updateDirtyContent(d2);
        this.invalidateCanvas.run();
    }

    @Override
    public void drawAxis() {
        if (this.state.isClean()) {
            return;
        }
        this.benchDrawAxis.start();
        this.updateDirtyContent(this.getLength());
        if (this.state.isDirty(ChartBits.AxisCanvas)) {
            GraphicsContext graphicsContext = this.canvas.getGraphicsContext2D();
            this.clearAxisCanvas(graphicsContext, this.canvas.getWidth(), this.canvas.getHeight());
            try {
                graphicsContext.translate(this.canvasPadX, this.canvasPadY);
                this.drawAxis(graphicsContext, this.getWidth(), this.getHeight());
            }
            finally {
                graphicsContext.translate(-this.canvasPadX, -this.canvasPadY);
            }
        }
        this.state.clear();
        this.benchDrawAxis.stop();
    }

    protected double measureTickMarkLength(double d2) {
        this.tmpTickMark.setValue(d2, this.getTickMarkLabel(d2));
        return this.getSide().isHorizontal() ? this.tmpTickMark.getWidth() : this.tmpTickMark.getHeight();
    }

    protected void updateAxisLabelAlignment() {
        TextStyle textStyle = this.getAxisLabel();
        switch (this.getSide()) {
            case LEFT: {
                textStyle.setTextAlignment(TextAlignment.CENTER);
                textStyle.setTextOrigin(VPos.BASELINE);
                textStyle.setRotate(-90.0);
                break;
            }
            case RIGHT: {
                textStyle.setTextAlignment(TextAlignment.CENTER);
                textStyle.setTextOrigin(VPos.TOP);
                textStyle.setRotate(-90.0);
                break;
            }
            case TOP: {
                textStyle.setTextAlignment(TextAlignment.CENTER);
                textStyle.setTextOrigin(VPos.BOTTOM);
                textStyle.setRotate(0.0);
                break;
            }
            case BOTTOM: {
                textStyle.setTextAlignment(TextAlignment.CENTER);
                textStyle.setTextOrigin(VPos.TOP);
                textStyle.setRotate(0.0);
                break;
            }
            case CENTER_VER: {
                textStyle.setTextAlignment(TextAlignment.RIGHT);
                textStyle.setTextOrigin(VPos.TOP);
                textStyle.setRotate(-90.0);
                break;
            }
            case CENTER_HOR: {
                textStyle.setTextAlignment(TextAlignment.RIGHT);
                textStyle.setTextOrigin(VPos.TOP);
                textStyle.setRotate(0.0);
            }
        }
    }

    protected void updateTickLabelAlignment() {
        int n2 = (int)this.getTickLabelRotation() % 360;
        TextStyle textStyle = this.getTickLabelStyle();
        TextAlignment textAlignment = textStyle.getTextAlignment();
        VPos vPos = textStyle.getTextOrigin();
        switch (this.getSide()) {
            case TOP: {
                textAlignment = TextAlignment.CENTER;
                vPos = VPos.BOTTOM;
                if (n2 != 0 && n2 % 90 == 0) {
                    textAlignment = TextAlignment.LEFT;
                    vPos = VPos.CENTER;
                    break;
                }
                if (n2 % 90 == 0) break;
                textAlignment = TextAlignment.LEFT;
                vPos = VPos.BOTTOM;
                break;
            }
            case CENTER_HOR: 
            case BOTTOM: {
                textAlignment = TextAlignment.CENTER;
                vPos = VPos.TOP;
                if (n2 != 0 && n2 % 90 == 0) {
                    textAlignment = TextAlignment.LEFT;
                    vPos = VPos.CENTER;
                    break;
                }
                if (n2 % 90 == 0) break;
                textAlignment = TextAlignment.LEFT;
                vPos = VPos.TOP;
                break;
            }
            case LEFT: {
                textAlignment = TextAlignment.RIGHT;
                vPos = VPos.CENTER;
                if (n2 == 0 || n2 % 90 != 0) break;
                textAlignment = TextAlignment.CENTER;
                vPos = VPos.BOTTOM;
                break;
            }
            case CENTER_VER: 
            case RIGHT: {
                textAlignment = TextAlignment.LEFT;
                vPos = VPos.CENTER;
                if (n2 == 0 || n2 % 90 != 0) break;
                textAlignment = TextAlignment.CENTER;
                vPos = VPos.TOP;
                break;
            }
        }
        if (textAlignment != textStyle.getTextAlignment()) {
            textStyle.setTextAlignment(textAlignment);
        }
        if (vPos != textStyle.getTextOrigin()) {
            textStyle.setTextOrigin(vPos);
        }
    }

    protected boolean shouldAnimate() {
        return this.isAnimated() && this.getScene() != null;
    }

    protected void tickMarksUpdated() {
    }

    private boolean isTickLabelsOverlap(List<TickMark> list, int n2, int n3) {
        TickMark tickMark = null;
        for (int i2 = n2; i2 < list.size(); i2 += n3) {
            TickMark tickMark2 = list.get(i2);
            if (!tickMark2.isVisible()) continue;
            if (tickMark != null && AbstractAxis.isTickLabelsOverlap(tickMark, tickMark2, this.getSide(), this.getTickLabelSpacing(), this.scaleFont)) {
                return true;
            }
            tickMark = tickMark2;
        }
        return false;
    }

    private static boolean isTickLabelsOverlap(TickMark tickMark, TickMark tickMark2, Side side, double d2, double d3) {
        double d4 = Math.abs(tickMark2.getPosition() - tickMark.getPosition());
        double d5 = d2 + d3 * (side.isHorizontal() ? (tickMark.getWidth() + tickMark2.getWidth()) / 2.0 : (tickMark.getHeight() + tickMark2.getHeight()) / 2.0);
        return d4 < d5;
    }

    protected static void drawAxisLabel(GraphicsContext graphicsContext, double d2, double d3, TextStyle textStyle) {
        if (PropUtil.isNullOrEmpty(textStyle.getText())) {
            return;
        }
        graphicsContext.save();
        graphicsContext.translate(d2, d3);
        if (textStyle.getRotate() != 0.0) {
            graphicsContext.rotate(textStyle.getRotate());
        }
        textStyle.copyStyleTo(graphicsContext);
        graphicsContext.fillText(textStyle.getText(), 0.0, 0.0);
        if (!Objects.equals(graphicsContext.getStroke(), Color.TRANSPARENT)) {
            graphicsContext.strokeText(textStyle.getText(), 0.0, 0.0);
        }
        graphicsContext.restore();
    }

    protected static void drawTickMarkLabel(GraphicsContext graphicsContext, double d2, double d3, double d4, TickMark tickMark) {
        if (PropUtil.isNullOrEmpty(tickMark.getText())) {
            return;
        }
        graphicsContext.save();
        graphicsContext.translate(d2, d3);
        if (tickMark.getRotation() != 0.0) {
            graphicsContext.rotate(tickMark.getRotation());
        }
        if (d4 != 1.0) {
            graphicsContext.scale(d4, d4);
        }
        graphicsContext.fillText(tickMark.getText(), 0.0, 0.0);
        if (!Objects.equals(graphicsContext.getStroke(), Color.TRANSPARENT)) {
            graphicsContext.strokeText(tickMark.getText(), 0.0, 0.0);
        }
        graphicsContext.restore();
    }

    protected static double snap(double d2) {
        return (double)Math.round(d2) + 0.5;
    }

    @Override
    public void requestAxisLayout() {
        this.invalidateLayout.run();
    }

    protected void invalidate() {
        this.invalidateLayout.run();
    }

    @Override
    public void forceRedraw() {
        this.invalidateLayout.run();
    }

    @Override
    public void invalidateRange() {
        this.invalidateAxisRange.run();
    }

    @Override
    public void setRecorder(MeasurementRecorder measurementRecorder) {
        this.benchComputePrefSize = measurementRecorder.newDuration("axis-computePrefSize");
        this.benchUpdateDirtyContent = measurementRecorder.newDuration("axis-updateDirtyContent");
        this.benchDrawAxis = measurementRecorder.newDuration("axis-drawAxis");
    }
}

