/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.protocol;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.agrona.LangUtil;
import org.agrona.concurrent.UnsafeBuffer;

public class HeaderFlyweight
extends UnsafeBuffer {
    public static final int HDR_TYPE_PAD = 0;
    public static final int HDR_TYPE_DATA = 1;
    public static final int HDR_TYPE_NAK = 2;
    public static final int HDR_TYPE_SM = 3;
    public static final int HDR_TYPE_ERR = 4;
    public static final int HDR_TYPE_SETUP = 5;
    public static final int HDR_TYPE_RTTM = 6;
    public static final int HDR_TYPE_RES = 7;
    public static final int HDR_TYPE_EXT = 65535;
    public static final byte CURRENT_VERSION = 0;
    public static final int FRAME_LENGTH_FIELD_OFFSET = 0;
    public static final int VERSION_FIELD_OFFSET = 4;
    public static final int FLAGS_FIELD_OFFSET = 5;
    public static final int TYPE_FIELD_OFFSET = 6;
    public static final int MIN_HEADER_LENGTH = 8;

    public HeaderFlyweight() {
    }

    public HeaderFlyweight(UnsafeBuffer unsafeBuffer) {
        super(unsafeBuffer);
    }

    public HeaderFlyweight(ByteBuffer byteBuffer) {
        super(byteBuffer);
    }

    public short version() {
        return (short)(this.getByte(4) & 0xFF);
    }

    public HeaderFlyweight version(short s2) {
        this.putByte(4, (byte)s2);
        return this;
    }

    public short flags() {
        return (short)(this.getByte(5) & 0xFF);
    }

    public HeaderFlyweight flags(short s2) {
        this.putByte(5, (byte)s2);
        return this;
    }

    public int headerType() {
        return this.getShort(6, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
    }

    public HeaderFlyweight headerType(int n2) {
        this.putShort(6, (short)n2, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public int frameLength() {
        return this.getInt(0, ByteOrder.LITTLE_ENDIAN);
    }

    public HeaderFlyweight frameLength(int n2) {
        this.putInt(0, n2, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static char[] flagsToChars(short s2) {
        char[] cArray = new char[]{'0', '0', '0', '0', '0', '0', '0', '0'};
        int n2 = cArray.length;
        short s3 = (short)(1 << n2 - 1);
        for (int i2 = 0; i2 < n2; ++i2) {
            if ((s2 & s3) == s3) {
                cArray[i2] = 49;
            }
            s3 = (short)(s3 >> 1);
        }
        return cArray;
    }

    public static void appendFlagsAsChars(short s2, Appendable appendable) {
        int n2 = 8;
        int n3 = 128;
        try {
            for (int i2 = 0; i2 < 8; ++i2) {
                appendable.append((s2 & n3) == n3 ? (char)'1' : '0');
                n3 = (short)(n3 >> 1);
            }
        }
        catch (IOException iOException) {
            LangUtil.rethrowUnchecked(iOException);
        }
    }
}

