/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver.reports;

import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.agrona.BitUtil;
import org.agrona.concurrent.AtomicBuffer;

public final class LossReportReader {
    public static final String LOSS_REPORT_CSV_HEADER = "#OBSERVATION_COUNT,TOTAL_BYTES_LOST,FIRST_OBSERVATION,LAST_OBSERVATION,SESSION_ID,STREAM_ID,CHANNEL,SOURCE";

    public static EntryConsumer defaultEntryConsumer(PrintStream printStream) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSSZ");
        return (l2, l3, l4, l5, n2, n3, string, string2) -> printStream.format("%d,%d,%s,%s,%d,%d,%s,%s%n", l2, l3, simpleDateFormat.format(new Date(l4)), simpleDateFormat.format(new Date(l5)), n2, n3, string, string2);
    }

    public static int read(AtomicBuffer atomicBuffer, EntryConsumer entryConsumer) {
        long l2;
        int n2;
        int n3 = atomicBuffer.capacity();
        int n4 = 0;
        for (int i2 = 0; i2 < n3 && (l2 = atomicBuffer.getLongVolatile(i2 + 0)) > 0L; i2 += BitUtil.align(n2, 64)) {
            ++n4;
            String string = atomicBuffer.getStringAscii(i2 + 40);
            String string2 = atomicBuffer.getStringAscii(i2 + 40 + BitUtil.align(4 + string.length(), 4));
            entryConsumer.accept(l2, atomicBuffer.getLongVolatile(i2 + 8), atomicBuffer.getLong(i2 + 16), atomicBuffer.getLongVolatile(i2 + 24), atomicBuffer.getInt(i2 + 32), atomicBuffer.getInt(i2 + 36), string, string2);
            n2 = 40 + BitUtil.align(4 + string.length(), 4) + 4 + string2.length();
        }
        return n4;
    }

    @FunctionalInterface
    public static interface EntryConsumer {
        public void accept(long var1, long var3, long var5, long var7, int var9, int var10, String var11, String var12);
    }
}

