/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver;

import io.aeron.driver.DriverConductorProxy;
import io.aeron.driver.PublicationImage;
import io.aeron.driver.Receiver;
import io.aeron.driver.exceptions.UnknownSubscriptionException;
import io.aeron.driver.media.ReceiveChannelEndpoint;
import io.aeron.protocol.DataHeaderFlyweight;
import io.aeron.protocol.RttMeasurementFlyweight;
import io.aeron.protocol.SetupFlyweight;
import java.net.InetSocketAddress;
import org.agrona.collections.Int2ObjectHashMap;
import org.agrona.collections.IntHashSet;
import org.agrona.concurrent.UnsafeBuffer;

public final class DataPacketDispatcher {
    private final Int2ObjectHashMap<StreamInterest> streamInterestByIdMap = new Int2ObjectHashMap();
    private final DriverConductorProxy conductorProxy;
    private final Receiver receiver;

    DataPacketDispatcher(DriverConductorProxy driverConductorProxy, Receiver receiver) {
        this.conductorProxy = driverConductorProxy;
        this.receiver = receiver;
    }

    public void addSubscription(int n2) {
        StreamInterest streamInterest = this.streamInterestByIdMap.get(n2);
        if (null == streamInterest) {
            this.streamInterestByIdMap.put(n2, new StreamInterest(true));
        } else if (!streamInterest.isAllSessions) {
            streamInterest.isAllSessions = true;
            Int2ObjectHashMap.ValueIterator valueIterator = streamInterest.sessionInterestByIdMap.values().iterator();
            while (valueIterator.hasNext()) {
                SessionInterest sessionInterest = (SessionInterest)valueIterator.next();
                if (SessionState.NO_INTEREST != sessionInterest.state) continue;
                valueIterator.remove();
            }
        }
    }

    public void addSubscription(int n2, int n3) {
        StreamInterest streamInterest = this.streamInterestByIdMap.get(n2);
        if (null == streamInterest) {
            streamInterest = new StreamInterest(false);
            this.streamInterestByIdMap.put(n2, streamInterest);
        }
        streamInterest.subscribedSessionIds.add(n3);
        SessionInterest sessionInterest = streamInterest.sessionInterestByIdMap.get(n3);
        if (null != sessionInterest && SessionState.NO_INTEREST == sessionInterest.state) {
            streamInterest.sessionInterestByIdMap.remove(n3);
        }
    }

    public void removeSubscription(int n2) {
        StreamInterest streamInterest = this.streamInterestByIdMap.get(n2);
        if (null == streamInterest) {
            throw new UnknownSubscriptionException("no subscription for stream " + n2);
        }
        Int2ObjectHashMap.EntryIterator entryIterator = streamInterest.sessionInterestByIdMap.entrySet().iterator();
        while (entryIterator.hasNext()) {
            entryIterator.next();
            int n3 = entryIterator.getIntKey();
            if (streamInterest.subscribedSessionIds.contains(n3)) continue;
            SessionInterest sessionInterest = (SessionInterest)entryIterator.getValue();
            if (null != sessionInterest.image) {
                sessionInterest.image.deactivate();
            }
            entryIterator.remove();
        }
        streamInterest.isAllSessions = false;
        if (streamInterest.subscribedSessionIds.isEmpty()) {
            this.streamInterestByIdMap.remove(n2);
        }
    }

    public void removeSubscription(int n2, int n3) {
        SessionInterest sessionInterest;
        StreamInterest streamInterest = this.streamInterestByIdMap.get(n2);
        if (null == streamInterest) {
            throw new UnknownSubscriptionException("no subscription for stream " + n2);
        }
        if (!streamInterest.isAllSessions && null != (sessionInterest = streamInterest.sessionInterestByIdMap.remove(n3)) && null != sessionInterest.image) {
            sessionInterest.image.deactivate();
        }
        streamInterest.subscribedSessionIds.remove(n3);
        if (!streamInterest.isAllSessions && streamInterest.subscribedSessionIds.isEmpty()) {
            this.streamInterestByIdMap.remove(n2);
        }
    }

    public void addPublicationImage(PublicationImage publicationImage) {
        StreamInterest streamInterest = this.streamInterestByIdMap.get(publicationImage.streamId());
        SessionInterest sessionInterest = streamInterest.sessionInterestByIdMap.get(publicationImage.sessionId());
        if (null == sessionInterest) {
            sessionInterest = new SessionInterest(SessionState.ACTIVE);
            streamInterest.sessionInterestByIdMap.put(publicationImage.sessionId(), sessionInterest);
        } else {
            sessionInterest.state = SessionState.ACTIVE;
        }
        sessionInterest.image = publicationImage;
        publicationImage.activate();
    }

    public void removePublicationImage(PublicationImage publicationImage) {
        SessionInterest sessionInterest;
        StreamInterest streamInterest = this.streamInterestByIdMap.get(publicationImage.streamId());
        if (null != streamInterest && null != (sessionInterest = streamInterest.sessionInterestByIdMap.get(publicationImage.sessionId())) && null != sessionInterest.image && sessionInterest.image.correlationId() == publicationImage.correlationId()) {
            sessionInterest.state = SessionState.ON_COOL_DOWN;
            sessionInterest.image = null;
        }
        publicationImage.deactivate();
    }

    public void removePendingSetup(int n2, int n3) {
        SessionInterest sessionInterest;
        StreamInterest streamInterest = this.streamInterestByIdMap.get(n3);
        if (null != streamInterest && null != (sessionInterest = streamInterest.sessionInterestByIdMap.get(n2)) && SessionState.PENDING_SETUP_FRAME == sessionInterest.state) {
            streamInterest.sessionInterestByIdMap.remove(n2);
        }
    }

    public void removeCoolDown(int n2, int n3) {
        SessionInterest sessionInterest;
        StreamInterest streamInterest = this.streamInterestByIdMap.get(n3);
        if (null != streamInterest && null != (sessionInterest = streamInterest.sessionInterestByIdMap.get(n2)) && SessionState.ON_COOL_DOWN == sessionInterest.state) {
            streamInterest.sessionInterestByIdMap.remove(n2);
        }
    }

    public int onDataPacket(ReceiveChannelEndpoint receiveChannelEndpoint, DataHeaderFlyweight dataHeaderFlyweight, UnsafeBuffer unsafeBuffer, int n2, InetSocketAddress inetSocketAddress, int n3) {
        int n4 = dataHeaderFlyweight.streamId();
        StreamInterest streamInterest = this.streamInterestByIdMap.get(n4);
        if (null != streamInterest) {
            int n5 = dataHeaderFlyweight.sessionId();
            SessionInterest sessionInterest = streamInterest.sessionInterestByIdMap.get(n5);
            if (null != sessionInterest) {
                if (null != sessionInterest.image) {
                    return sessionInterest.image.insertPacket(dataHeaderFlyweight.termId(), dataHeaderFlyweight.termOffset(), unsafeBuffer, n2, n3, inetSocketAddress);
                }
            } else if (!DataHeaderFlyweight.isEndOfStream(unsafeBuffer)) {
                if (streamInterest.isAllSessions || streamInterest.subscribedSessionIds.contains(n5)) {
                    streamInterest.sessionInterestByIdMap.put(n5, new SessionInterest(SessionState.PENDING_SETUP_FRAME));
                    this.elicitSetupMessageFromSource(receiveChannelEndpoint, n3, inetSocketAddress, n4, n5);
                } else {
                    streamInterest.sessionInterestByIdMap.put(n5, new SessionInterest(SessionState.NO_INTEREST));
                }
            }
        }
        return 0;
    }

    public void onSetupMessage(ReceiveChannelEndpoint receiveChannelEndpoint, SetupFlyweight setupFlyweight, InetSocketAddress inetSocketAddress, int n2) {
        int n3 = setupFlyweight.streamId();
        StreamInterest streamInterest = this.streamInterestByIdMap.get(n3);
        if (null != streamInterest) {
            int n4 = setupFlyweight.sessionId();
            SessionInterest sessionInterest = streamInterest.sessionInterestByIdMap.get(n4);
            if (null != sessionInterest) {
                if (null == sessionInterest.image && SessionState.PENDING_SETUP_FRAME == sessionInterest.state) {
                    sessionInterest.state = SessionState.INIT_IN_PROGRESS;
                    this.createPublicationImage(receiveChannelEndpoint, n2, inetSocketAddress, n3, n4, setupFlyweight.initialTermId(), setupFlyweight.activeTermId(), setupFlyweight.termOffset(), setupFlyweight.termLength(), setupFlyweight.mtuLength(), setupFlyweight.ttl());
                } else if (null != sessionInterest.image) {
                    sessionInterest.image.addDestinationConnectionIfUnknown(n2, inetSocketAddress);
                }
            } else if (streamInterest.isAllSessions || streamInterest.subscribedSessionIds.contains(n4)) {
                streamInterest.sessionInterestByIdMap.put(n4, new SessionInterest(SessionState.INIT_IN_PROGRESS));
                this.createPublicationImage(receiveChannelEndpoint, n2, inetSocketAddress, n3, n4, setupFlyweight.initialTermId(), setupFlyweight.activeTermId(), setupFlyweight.termOffset(), setupFlyweight.termLength(), setupFlyweight.mtuLength(), setupFlyweight.ttl());
            } else {
                streamInterest.sessionInterestByIdMap.put(n4, new SessionInterest(SessionState.NO_INTEREST));
            }
        }
    }

    public void onRttMeasurement(ReceiveChannelEndpoint receiveChannelEndpoint, RttMeasurementFlyweight rttMeasurementFlyweight, InetSocketAddress inetSocketAddress, int n2) {
        int n3;
        SessionInterest sessionInterest;
        int n4 = rttMeasurementFlyweight.streamId();
        StreamInterest streamInterest = this.streamInterestByIdMap.get(n4);
        if (null != streamInterest && null != (sessionInterest = streamInterest.sessionInterestByIdMap.get(n3 = rttMeasurementFlyweight.sessionId())) && null != sessionInterest.image) {
            if (128 == (rttMeasurementFlyweight.flags() & 0x80)) {
                InetSocketAddress inetSocketAddress2 = receiveChannelEndpoint.isMulticast(n2) ? receiveChannelEndpoint.udpChannel(n2).remoteControl() : inetSocketAddress;
                receiveChannelEndpoint.sendRttMeasurement(n2, inetSocketAddress2, n3, n4, rttMeasurementFlyweight.echoTimestampNs(), 0L, false);
            } else {
                sessionInterest.image.onRttMeasurement(rttMeasurementFlyweight, n2, inetSocketAddress);
            }
        }
    }

    public boolean shouldElicitSetupMessage() {
        return !this.streamInterestByIdMap.isEmpty();
    }

    private void elicitSetupMessageFromSource(ReceiveChannelEndpoint receiveChannelEndpoint, int n2, InetSocketAddress inetSocketAddress, int n3, int n4) {
        InetSocketAddress inetSocketAddress2 = receiveChannelEndpoint.isMulticast(n2) ? receiveChannelEndpoint.udpChannel(n2).remoteControl() : inetSocketAddress;
        receiveChannelEndpoint.sendSetupElicitingStatusMessage(n2, inetSocketAddress2, n4, n3);
        this.receiver.addPendingSetupMessage(n4, n3, n2, receiveChannelEndpoint, false, inetSocketAddress2);
    }

    private void createPublicationImage(ReceiveChannelEndpoint receiveChannelEndpoint, int n2, InetSocketAddress inetSocketAddress, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10) {
        InetSocketAddress inetSocketAddress2;
        InetSocketAddress inetSocketAddress3 = inetSocketAddress2 = receiveChannelEndpoint.isMulticast(n2) ? receiveChannelEndpoint.udpChannel(n2).remoteControl() : inetSocketAddress;
        if (receiveChannelEndpoint.isMulticast(n2) && receiveChannelEndpoint.multicastTtl(n2) < n10) {
            receiveChannelEndpoint.possibleTtlAsymmetryEncountered();
        }
        this.conductorProxy.createPublicationImage(n4, n3, n5, n6, n7, n8, n9, n2, inetSocketAddress2, inetSocketAddress, receiveChannelEndpoint);
    }

    static class StreamInterest {
        boolean isAllSessions;
        final Int2ObjectHashMap<SessionInterest> sessionInterestByIdMap = new Int2ObjectHashMap();
        final IntHashSet subscribedSessionIds = new IntHashSet();

        StreamInterest(boolean bl2) {
            this.isAllSessions = bl2;
        }
    }

    static class SessionInterest {
        SessionState state;
        PublicationImage image;

        SessionInterest(SessionState sessionState) {
            this.state = sessionState;
        }
    }

    static enum SessionState {
        ACTIVE,
        PENDING_SETUP_FRAME,
        INIT_IN_PROGRESS,
        ON_COOL_DOWN,
        NO_INTEREST;

    }
}

