/*
 * Decompiled with CFR 0.152.
 */
package io.aeron;

import io.aeron.ClientConductor;
import io.aeron.ErrorCode;
import io.aeron.command.ClientTimeoutFlyweight;
import io.aeron.command.CounterUpdateFlyweight;
import io.aeron.command.ErrorResponseFlyweight;
import io.aeron.command.ImageBuffersReadyFlyweight;
import io.aeron.command.ImageMessageFlyweight;
import io.aeron.command.OperationSucceededFlyweight;
import io.aeron.command.PublicationBuffersReadyFlyweight;
import io.aeron.command.SubscriptionReadyFlyweight;
import org.agrona.MutableDirectBuffer;
import org.agrona.collections.LongHashSet;
import org.agrona.concurrent.MessageHandler;
import org.agrona.concurrent.broadcast.CopyBroadcastReceiver;

class DriverEventsAdapter
implements MessageHandler {
    private final ErrorResponseFlyweight errorResponse = new ErrorResponseFlyweight();
    private final PublicationBuffersReadyFlyweight publicationReady = new PublicationBuffersReadyFlyweight();
    private final SubscriptionReadyFlyweight subscriptionReady = new SubscriptionReadyFlyweight();
    private final ImageBuffersReadyFlyweight imageReady = new ImageBuffersReadyFlyweight();
    private final OperationSucceededFlyweight operationSucceeded = new OperationSucceededFlyweight();
    private final ImageMessageFlyweight imageMessage = new ImageMessageFlyweight();
    private final CounterUpdateFlyweight counterUpdate = new CounterUpdateFlyweight();
    private final ClientTimeoutFlyweight clientTimeout = new ClientTimeoutFlyweight();
    private final CopyBroadcastReceiver receiver;
    private final ClientConductor conductor;
    private final LongHashSet asyncCommandIdSet;
    private final long clientId;
    private long activeCorrelationId;
    private long receivedCorrelationId;
    private boolean isInvalid;

    DriverEventsAdapter(long l2, CopyBroadcastReceiver copyBroadcastReceiver, ClientConductor clientConductor, LongHashSet longHashSet) {
        this.clientId = l2;
        this.receiver = copyBroadcastReceiver;
        this.conductor = clientConductor;
        this.asyncCommandIdSet = longHashSet;
    }

    int receive(long l2) {
        this.activeCorrelationId = l2;
        this.receivedCorrelationId = -1L;
        try {
            return this.receiver.receive(this);
        }
        catch (IllegalStateException illegalStateException) {
            this.isInvalid = true;
            throw illegalStateException;
        }
    }

    long receivedCorrelationId() {
        return this.receivedCorrelationId;
    }

    boolean isInvalid() {
        return this.isInvalid;
    }

    long clientId() {
        return this.clientId;
    }

    @Override
    public void onMessage(int n2, MutableDirectBuffer mutableDirectBuffer, int n3, int n4) {
        switch (n2) {
            case 3841: {
                this.errorResponse.wrap(mutableDirectBuffer, n3);
                long l2 = this.errorResponse.offendingCommandCorrelationId();
                int n5 = this.errorResponse.errorCodeValue();
                ErrorCode errorCode = ErrorCode.get(n5);
                boolean bl2 = true;
                if (ErrorCode.CHANNEL_ENDPOINT_ERROR == errorCode) {
                    bl2 = false;
                    this.conductor.onChannelEndpointError(l2, this.errorResponse.errorMessage());
                } else if (l2 == this.activeCorrelationId) {
                    bl2 = false;
                    this.receivedCorrelationId = l2;
                    this.conductor.onError(l2, n5, errorCode, this.errorResponse.errorMessage());
                }
                if (!this.asyncCommandIdSet.remove(l2) || !bl2) break;
                this.conductor.onAsyncError(l2, n5, errorCode, this.errorResponse.errorMessage());
                break;
            }
            case 3842: {
                this.imageReady.wrap(mutableDirectBuffer, n3);
                this.conductor.onAvailableImage(this.imageReady.correlationId(), this.imageReady.sessionId(), this.imageReady.subscriptionRegistrationId(), this.imageReady.subscriberPositionId(), this.imageReady.logFileName(), this.imageReady.sourceIdentity());
                break;
            }
            case 3843: {
                this.publicationReady.wrap(mutableDirectBuffer, n3);
                long l3 = this.publicationReady.correlationId();
                if (l3 != this.activeCorrelationId && !this.asyncCommandIdSet.remove(l3)) break;
                this.receivedCorrelationId = l3;
                this.conductor.onNewPublication(l3, this.publicationReady.registrationId(), this.publicationReady.streamId(), this.publicationReady.sessionId(), this.publicationReady.publicationLimitCounterId(), this.publicationReady.channelStatusCounterId(), this.publicationReady.logFileName());
                break;
            }
            case 3847: {
                this.subscriptionReady.wrap(mutableDirectBuffer, n3);
                long l4 = this.subscriptionReady.correlationId();
                if (l4 != this.activeCorrelationId && !this.asyncCommandIdSet.remove(l4)) break;
                this.receivedCorrelationId = l4;
                this.conductor.onNewSubscription(l4, this.subscriptionReady.channelStatusCounterId());
                break;
            }
            case 3844: {
                this.operationSucceeded.wrap(mutableDirectBuffer, n3);
                long l5 = this.operationSucceeded.correlationId();
                this.asyncCommandIdSet.remove(l5);
                if (l5 != this.activeCorrelationId) break;
                this.receivedCorrelationId = l5;
                break;
            }
            case 3845: {
                this.imageMessage.wrap(mutableDirectBuffer, n3);
                this.conductor.onUnavailableImage(this.imageMessage.correlationId(), this.imageMessage.subscriptionRegistrationId());
                break;
            }
            case 3846: {
                this.publicationReady.wrap(mutableDirectBuffer, n3);
                long l6 = this.publicationReady.correlationId();
                if (l6 != this.activeCorrelationId && !this.asyncCommandIdSet.remove(l6)) break;
                this.receivedCorrelationId = l6;
                this.conductor.onNewExclusivePublication(l6, this.publicationReady.registrationId(), this.publicationReady.streamId(), this.publicationReady.sessionId(), this.publicationReady.publicationLimitCounterId(), this.publicationReady.channelStatusCounterId(), this.publicationReady.logFileName());
                break;
            }
            case 3848: {
                this.counterUpdate.wrap(mutableDirectBuffer, n3);
                int n6 = this.counterUpdate.counterId();
                long l7 = this.counterUpdate.correlationId();
                if (l7 == this.activeCorrelationId) {
                    this.receivedCorrelationId = l7;
                    this.conductor.onNewCounter(l7, n6);
                    break;
                }
                this.conductor.onAvailableCounter(l7, n6);
                break;
            }
            case 3849: {
                this.counterUpdate.wrap(mutableDirectBuffer, n3);
                this.conductor.onUnavailableCounter(this.counterUpdate.correlationId(), this.counterUpdate.counterId());
                break;
            }
            case 3850: {
                this.clientTimeout.wrap(mutableDirectBuffer, n3);
                if (this.clientTimeout.clientId() != this.clientId) break;
                this.conductor.onClientTimeout();
            }
        }
    }
}

