/*
 * Decompiled with CFR 0.152.
 */
package impl.org.controlsfx.tools.rectangle.change;

import impl.org.controlsfx.tools.rectangle.Rectangles2D;
import impl.org.controlsfx.tools.rectangle.change.AbstractRatioRespectingChangeStrategy;
import java.util.Objects;
import javafx.geometry.Point2D;
import javafx.geometry.Rectangle2D;

abstract class AbstractFixedPointChangeStrategy
extends AbstractRatioRespectingChangeStrategy {
    private final Rectangle2D bounds;
    private Point2D fixedCorner;

    protected AbstractFixedPointChangeStrategy(boolean bl2, double d2, Rectangle2D rectangle2D) {
        super(bl2, d2);
        Objects.requireNonNull(rectangle2D, "The argument 'bounds' must not be null.");
        this.bounds = rectangle2D;
    }

    protected abstract Point2D getFixedCorner();

    private final Rectangle2D createFromCorners(Point2D point2D) {
        Point2D point2D2 = Rectangles2D.inRectangle(this.bounds, point2D);
        if (this.isRatioFixed()) {
            return Rectangles2D.forDiagonalCornersAndRatio(this.fixedCorner, point2D2, this.getRatio());
        }
        return Rectangles2D.forDiagonalCorners(this.fixedCorner, point2D2);
    }

    @Override
    protected final Rectangle2D doBegin(Point2D point2D) {
        boolean bl2;
        boolean bl3 = bl2 = !this.bounds.contains(point2D);
        if (bl2) {
            throw new IllegalArgumentException("The change's start point (" + point2D + ") must lie within the bounds (" + this.bounds + ").");
        }
        this.fixedCorner = this.getFixedCorner();
        return this.createFromCorners(point2D);
    }

    @Override
    protected Rectangle2D doContinue(Point2D point2D) {
        return this.createFromCorners(point2D);
    }

    @Override
    protected final Rectangle2D doEnd(Point2D point2D) {
        Rectangle2D rectangle2D = this.createFromCorners(point2D);
        this.fixedCorner = null;
        return rectangle2D;
    }
}

