/*
 * Decompiled with CFR 0.152.
 */
package impl.org.controlsfx.tableview2;

import impl.org.controlsfx.tableview2.RowHeader;
import impl.org.controlsfx.tableview2.SouthTableColumnHeader;
import impl.org.controlsfx.tableview2.TableView2Skin;
import java.util.Collection;
import java.util.stream.Collectors;
import javafx.beans.InvalidationListener;
import javafx.beans.WeakInvalidationListener;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.WeakListChangeListener;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableColumnBase;
import javafx.scene.control.TableView;
import javafx.scene.layout.Region;
import org.controlsfx.control.tableview2.TableView2;

public class SouthTableHeaderRow
extends Region {
    public static final String SOUTH_HEADER_STYLE = "south";
    private final TableView2Skin<?> skin;
    private final TableView2<?> control;
    private ObservableList<SouthTableColumnHeader> southColumnHeaders;
    private SouthTableHeaderRow parentSouthHeader;
    private final ListChangeListener tableColumnsListener = change -> {
        while (change.next()) {
            this.updateSouthHeaders();
        }
    };
    private final WeakListChangeListener weakTableColumnsListener = new WeakListChangeListener(this.tableColumnsListener);
    private final InvalidationListener southHeaderBlendedListener = observable -> this.updateSouthHeaderRowStyle();
    private final WeakInvalidationListener weakSouthHeaderBlendedListener = new WeakInvalidationListener(this.southHeaderBlendedListener);

    public SouthTableHeaderRow(TableView2Skin<?> tableView2Skin) {
        this.skin = tableView2Skin;
        this.control = (TableView2)tableView2Skin.getSkinnable();
        this.getStyleClass().setAll((Object[])new String[]{"column-header-background", "south-header"});
        this.init();
    }

    private void init() {
        this.updateSouthHeaders();
        this.control.getVisibleLeafColumns().addListener((ListChangeListener)this.weakTableColumnsListener);
        this.control.getColumns().addListener((ListChangeListener)this.weakTableColumnsListener);
        this.control.southHeaderBlendedProperty().addListener((InvalidationListener)this.weakSouthHeaderBlendedListener);
        this.updateSouthHeaderRowStyle();
        if (this.control.getParent() != null && this.control.getParent() instanceof RowHeader) {
            this.parentSouthHeader = ((TableView2Skin)((RowHeader)this.control.getParent()).getParentTableView().getSkin()).getSouthHeader();
        }
    }

    public ObservableList<SouthTableColumnHeader> getSouthColumnHeaders() {
        if (this.southColumnHeaders == null) {
            this.southColumnHeaders = FXCollections.observableArrayList();
        }
        return this.southColumnHeaders;
    }

    public SouthTableColumnHeader getSouthColumnHeaderFor(TableColumnBase<?, ?> tableColumnBase) {
        if (tableColumnBase == null) {
            return null;
        }
        return this.getSouthColumnHeaders().stream().filter(southTableColumnHeader -> southTableColumnHeader.getTableColumn().equals(tableColumnBase)).findFirst().orElse(null);
    }

    protected void layoutChildren() {
        super.layoutChildren();
        double d2 = this.snappedLeftInset();
        double d3 = this.getHeight() - this.snappedTopInset() - this.snappedBottomInset();
        double d4 = 0.0;
        double d5 = this.skin.getHBar().getValue();
        int n2 = this.getSouthColumnHeaders().size();
        for (int i2 = 0; i2 < n2; ++i2) {
            SouthTableColumnHeader southTableColumnHeader = (SouthTableColumnHeader)((Object)this.getSouthColumnHeaders().get(i2));
            if (!southTableColumnHeader.isVisible()) continue;
            double d6 = this.snapSize(southTableColumnHeader.prefWidth(-1.0));
            TableColumn tableColumn = (TableColumn)southTableColumnHeader.getTableColumn();
            while (tableColumn.getParentColumn() != null) {
                tableColumn = (TableColumn)tableColumn.getParentColumn();
            }
            double d7 = 0.0;
            if (this.control.isColumnFixingEnabled() && this.control.getFixedColumns().contains((Object)tableColumn) && d5 + d4 > d2) {
                d7 = Math.abs(d5 + d4 - d2);
                southTableColumnHeader.toFront();
                d4 += d6;
            }
            southTableColumnHeader.relocate(d2 + d7, this.snappedTopInset());
            southTableColumnHeader.resize(d6, this.snapSize(d3));
            d2 += d6;
        }
    }

    protected void updateScrollX() {
        this.requestLayout();
    }

    private void updateSouthHeaders() {
        this.getSouthColumnHeaders().forEach(SouthTableColumnHeader::dispose);
        this.getSouthColumnHeaders().setAll((Collection)((TableView)this.skin.getSkinnable()).getVisibleLeafColumns().stream().map(tableColumn -> new SouthTableColumnHeader(this.skin, (TableColumnBase)tableColumn)).collect(Collectors.toList()));
        this.getChildren().setAll(this.getSouthColumnHeaders());
    }

    private void updateSouthHeaderRowStyle() {
        if (this.control.isSouthHeaderBlended() && !this.getStyleClass().contains((Object)SOUTH_HEADER_STYLE)) {
            this.getStyleClass().add((Object)SOUTH_HEADER_STYLE);
        } else if (!this.control.isSouthHeaderBlended() && this.getStyleClass().contains((Object)SOUTH_HEADER_STYLE)) {
            this.getStyleClass().remove((Object)SOUTH_HEADER_STYLE);
        }
    }

    protected double computePrefHeight(double d2) {
        double d3 = this.getSouthColumnHeaders().stream().map(southTableColumnHeader -> southTableColumnHeader.prefHeight(-1.0)).max(Double::compare).orElse(0.0);
        if (this.parentSouthHeader != null) {
            double d4 = this.parentSouthHeader.getHeight();
            d3 = d4 == 0.0 ? 0.0 : Math.max(d3, d4);
        }
        return d3 + this.snappedTopInset() + this.snappedBottomInset();
    }
}

