/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.validation;

import com.jfoenix.validation.base.ValidatorBase;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import javafx.beans.DefaultProperty;
import javafx.scene.control.TextInputControl;
import javafx.util.converter.NumberStringConverter;

@DefaultProperty(value="icon")
public class NumberValidator
extends ValidatorBase {
    private NumberStringConverter numberStringConverter = new NumberStringConverter(){

        public Number fromString(String string) {
            try {
                if (string == null) {
                    return null;
                }
                if ((string = string.trim()).length() < 1) {
                    return null;
                }
                NumberFormat numberFormat = this.getNumberFormat();
                ParsePosition parsePosition = new ParsePosition(0);
                Number number = numberFormat.parse(string, parsePosition);
                int n2 = parsePosition.getIndex();
                if (n2 == 0 || n2 < string.length()) {
                    throw new ParseException("Unparseable number: \"" + string + "\"", parsePosition.getErrorIndex());
                }
                return number;
            }
            catch (ParseException parseException) {
                throw new RuntimeException(parseException);
            }
        }
    };

    public NumberValidator() {
    }

    public NumberValidator(String string) {
        super(string);
    }

    public NumberValidator(NumberStringConverter numberStringConverter) {
        this.numberStringConverter = numberStringConverter;
    }

    public NumberValidator(String string, NumberStringConverter numberStringConverter) {
        super(string);
        this.numberStringConverter = numberStringConverter;
    }

    @Override
    protected void eval() {
        if (this.srcControl.get() instanceof TextInputControl) {
            this.evalTextInputField();
        }
    }

    private void evalTextInputField() {
        TextInputControl textInputControl = (TextInputControl)this.srcControl.get();
        String string = textInputControl.getText();
        try {
            this.hasErrors.set(false);
            if (!string.isEmpty()) {
                this.numberStringConverter.fromString(string);
            }
        }
        catch (Exception exception) {
            this.hasErrors.set(true);
        }
    }

    public NumberStringConverter getNumberStringConverter() {
        return this.numberStringConverter;
    }

    public void setNumberStringConverter(NumberStringConverter numberStringConverter) {
        this.numberStringConverter = numberStringConverter;
    }
}

