/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.skins;

import com.jfoenix.controls.JFXAutoCompletePopup;
import com.jfoenix.controls.JFXChip;
import com.jfoenix.controls.JFXChipView;
import com.jfoenix.controls.JFXDefaultChip;
import com.jfoenix.skins.JFXAutoCompletePopupSkin;
import com.sun.javafx.scene.control.behavior.BehaviorBase;
import com.sun.javafx.scene.control.behavior.FocusTraversalInputMap;
import com.sun.javafx.scene.control.inputmap.InputMap;
import com.sun.javafx.scene.traversal.Direction;
import java.util.List;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.WeakListChangeListener;
import javafx.css.PseudoClass;
import javafx.event.Event;
import javafx.event.EventTarget;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.VPos;
import javafx.scene.AccessibleAttribute;
import javafx.scene.Node;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.SkinBase;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextInputControl;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.Region;
import javafx.scene.text.Text;
import javafx.stage.Window;
import javafx.util.StringConverter;

public class JFXChipViewSkin<T>
extends SkinBase<JFXChipView<T>> {
    private static final PseudoClass PSEUDO_CLASS_ERROR = PseudoClass.getPseudoClass((String)"error");
    private CustomFlowPane root;
    private JFXChipView<T> control;
    private FakeFocusTextArea editor;
    private ChipsAutoComplete<T> autoCompletePopup;
    private boolean moveToNewLine = false;
    private boolean editorOnNewLine = true;
    private double availableWidth;
    private double requiredWidth;
    private final ListChangeListener<T> chipsChangeListeners = change -> {
        while (change.next()) {
            block1: for (Object e2 : change.getRemoved()) {
                for (int i2 = this.root.getChildren().size() - 2; i2 >= 0; --i2) {
                    Node node = (Node)this.root.getChildren().get(i2);
                    if (!(node instanceof JFXChip) || ((JFXChip)node).getItem() != e2) continue;
                    this.root.getChildren().remove(i2);
                    continue block1;
                }
            }
            for (Object e2 : change.getAddedSubList()) {
                this.createChip(e2);
            }
        }
    };
    private final ScrollPane scrollPane;
    private ChipViewBehaviorBase<T> behavior;

    public JFXChipViewSkin(JFXChipView<T> jFXChipView) {
        super(jFXChipView);
        this.control = jFXChipView;
        this.behavior = new ChipViewBehaviorBase<T>(jFXChipView);
        this.root = new CustomFlowPane();
        this.root.getStyleClass().add((Object)"chips-pane");
        this.setupEditor();
        this.scrollPane = new ScrollPane((Node)this.root){

            public void requestFocus() {
                if (JFXChipViewSkin.this.getSkinnable() != null) {
                    ((JFXChipView)JFXChipViewSkin.this.getSkinnable()).requestFocus();
                }
            }
        };
        this.scrollPane.setFitToWidth(true);
        this.getChildren().add((Object)this.scrollPane);
        this.autoCompletePopup = (ChipsAutoComplete)((JFXChipView)this.getSkinnable()).getAutoCompletePopup();
        this.autoCompletePopup.setSelectionHandler(jFXAutoCompleteEvent -> {
            Object t2 = jFXAutoCompleteEvent.getObject();
            if (((JFXChipView)this.getSkinnable()).getSelectionHandler() != null) {
                t2 = ((JFXChipView)this.getSkinnable()).getSelectionHandler().apply(t2);
            }
            ((JFXChipView)this.getSkinnable()).getChips().add(t2);
            this.editor.clear();
        });
        this.autoCompletePopup.setShift(this.root.getVgap() * 2.0);
        this.root.vgapProperty().addListener(observable -> this.autoCompletePopup.setShift(this.root.getVgap() * 2.0));
        for (Object e2 : jFXChipView.getChips()) {
            this.createChip(e2);
        }
        jFXChipView.getChips().addListener((ListChangeListener)new WeakListChangeListener(this.chipsChangeListeners));
    }

    protected void layoutChildren(double d2, double d3, double d4, double d5) {
        this.scrollPane.resizeRelocate(d2, d3, d4, d5);
    }

    private void setupEditor() {
        this.editor = new FakeFocusTextArea();
        this.editor.setManaged(false);
        this.editor.getStyleClass().add((Object)"editor");
        this.editor.setWrapText(true);
        this.editor.addEventFilter(KeyEvent.KEY_RELEASED, keyEvent -> {
            if (keyEvent.getCode() != KeyCode.ENTER) {
                ((JFXChipView)this.getSkinnable()).pseudoClassStateChanged(PSEUDO_CLASS_ERROR, false);
            }
        });
        this.editor.addEventFilter(KeyEvent.KEY_PRESSED, keyEvent -> {
            switch (keyEvent.getCode()) {
                case ENTER: {
                    if (!this.editor.getText().trim().isEmpty()) {
                        try {
                            StringConverter<T> stringConverter = this.control.getConverter();
                            Object object = stringConverter.fromString(this.editor.getText());
                            if (object != null) {
                                ((JFXChipView)this.getSkinnable()).getChips().add(object);
                            }
                            this.editor.clear();
                            this.autoCompletePopup.hide();
                        }
                        catch (Exception exception) {
                            ((JFXChipView)this.getSkinnable()).pseudoClassStateChanged(PSEUDO_CLASS_ERROR, true);
                        }
                    }
                    keyEvent.consume();
                    break;
                }
                case TAB: {
                    if (this.editor.getText().trim().isEmpty()) {
                        if (keyEvent.isShiftDown()) {
                            this.behavior.traverse((Node)this.getSkinnable(), Direction.PREVIOUS);
                        } else {
                            this.behavior.traverse((Node)this.editor, Direction.NEXT);
                        }
                    }
                    keyEvent.consume();
                    break;
                }
                case BACK_SPACE: {
                    ObservableList observableList = ((JFXChipView)this.getSkinnable()).getChips();
                    int n2 = observableList.size();
                    if (n2 <= 0 || !this.editor.getText().isEmpty()) break;
                    observableList.remove(n2 - 1);
                    if (!this.autoCompletePopup.isShowing()) break;
                    this.autoCompletePopup.hide();
                    break;
                }
                case SPACE: {
                    if (!keyEvent.isControlDown() || this.autoCompletePopup.getFilteredSuggestions().isEmpty()) break;
                    this.autoCompletePopup.show((Node)this.editor);
                }
            }
        });
        this.editor.textProperty().addListener(observable -> {
            this.requiredWidth = this.editor.snappedLeftInset() + this.computeTextContentWidth((TextInputControl)this.editor) + this.editor.snappedRightInset() + 13.0;
            if (this.availableWidth < this.requiredWidth && !this.editorOnNewLine && !this.moveToNewLine) {
                this.moveToNewLine = true;
                this.root.requestLayout();
            } else if (this.availableWidth > this.requiredWidth && this.editorOnNewLine && this.moveToNewLine) {
                this.moveToNewLine = false;
                this.root.requestLayout();
            }
            this.autoCompletePopup.filter(object -> ((JFXChipView)this.getSkinnable()).getPredicate().test(object, this.editor.getText()));
            if (this.autoCompletePopup.getFilteredSuggestions().isEmpty()) {
                this.autoCompletePopup.hide();
            } else {
                this.autoCompletePopup.show((Node)this.editor);
            }
        });
        this.editor.promptTextProperty().bind((ObservableValue)this.control.promptTextProperty());
        this.root.getChildren().add((Object)this.editor);
        this.control.focusedProperty().addListener((observableValue, bl2, bl3) -> {
            if (this.editor != null) {
                this.editor.setFakeFocus((boolean)bl3);
            }
        });
        this.control.addEventFilter(KeyEvent.ANY, keyEvent -> {
            if (this.editor != null) {
                if (keyEvent.getTarget().equals((Object)this.editor)) {
                    return;
                }
                if (keyEvent.getTarget().equals(this.control)) {
                    switch (keyEvent.getCode()) {
                        case ESCAPE: 
                        case F10: {
                            break;
                        }
                        default: {
                            this.editor.fireEvent((Event)keyEvent.copyFor((Object)this.editor, (EventTarget)this.editor));
                            keyEvent.consume();
                        }
                    }
                }
            }
        });
    }

    private void createChip(T t2) {
        JFXChip jFXChip = null;
        try {
            jFXChip = ((JFXChipView)this.getSkinnable()).getChipFactory() != null ? ((JFXChipView)this.getSkinnable()).getChipFactory().apply((JFXChipView)this.getSkinnable(), (JFXChipView)((Object)t2)) : new JFXDefaultChip<T>((JFXChipView)this.getSkinnable(), t2);
        }
        catch (Exception exception) {
            throw new RuntimeException("can't create chip for item '" + t2 + "' make sure to override the string converter and return null if text input is not valid.", exception);
        }
        int n2 = this.root.getChildren().size();
        this.root.getChildren().add(n2 - 1, jFXChip);
    }

    private double computeTextContentWidth(TextInputControl textInputControl) {
        Text text = new Text(textInputControl.getText());
        text.setFont(textInputControl.getFont());
        text.applyCss();
        return text.getLayoutBounds().getWidth();
    }

    public void dispose() {
        super.dispose();
        if (this.behavior != null) {
            this.behavior.dispose();
        }
    }

    static final class ChipViewBehaviorBase<T>
    extends BehaviorBase<JFXChipView<T>> {
        public ChipViewBehaviorBase(JFXChipView<T> jFXChipView) {
            super(jFXChipView);
        }

        public InputMap<JFXChipView<T>> getInputMap() {
            return new InputMap((Node)((JFXChipView)this.getNode()));
        }

        public void traverse(Node node, Direction direction) {
            FocusTraversalInputMap.traverse((Node)node, (Direction)direction);
        }
    }

    final class FakeFocusTextArea
    extends TextArea {
        FakeFocusTextArea() {
        }

        public void requestFocus() {
            if (JFXChipViewSkin.this.getSkinnable() != null) {
                ((JFXChipView)JFXChipViewSkin.this.getSkinnable()).requestFocus();
            }
        }

        public void setFakeFocus(boolean bl2) {
            this.setFocused(bl2);
        }

        public Object queryAccessibleAttribute(AccessibleAttribute accessibleAttribute, Object ... objectArray) {
            switch (accessibleAttribute) {
                case FOCUS_ITEM: {
                    return JFXChipViewSkin.this.getSkinnable();
                }
            }
            return super.queryAccessibleAttribute(accessibleAttribute, objectArray);
        }
    }

    public static class ChipsAutoComplete<T>
    extends JFXAutoCompletePopup<T> {
        private double shift = 0.0;
        private Text text;

        public ChipsAutoComplete() {
            this.getStyleClass().add((Object)"jfx-chips-popup");
        }

        void setShift(double d2) {
            this.shift = d2;
        }

        @Override
        public void show(Node node) {
            if (this.text == null) {
                this.text = (Text)node.lookup(".text");
            }
            node = this.text;
            if (!this.isShowing()) {
                if (node.getScene() == null || node.getScene().getWindow() == null) {
                    throw new IllegalStateException("Can not show popup. The node must be attached to a scene/window.");
                }
                Window window = node.getScene().getWindow();
                this.show(window, window.getX() + node.localToScene(0.0, 0.0).getX() + node.getScene().getX(), window.getY() + node.localToScene(0.0, 0.0).getY() + node.getScene().getY() + node.getLayoutBounds().getHeight() + this.shift);
                ((JFXAutoCompletePopupSkin)this.getSkin()).animate();
            } else {
                Window window = node.getScene().getWindow();
                this.show(window, window.getX() + node.localToScene(0.0, 0.0).getX() + node.getScene().getX(), window.getY() + node.localToScene(0.0, 0.0).getY() + node.getScene().getY() + node.getLayoutBounds().getHeight() + this.shift);
            }
        }
    }

    private class CustomFlowPane
    extends FlowPane {
        double initOffset = 8.0;

        private CustomFlowPane() {
            this.addEventHandler(MouseEvent.MOUSE_CLICKED, mouseEvent -> this.ensureVisible((Node)JFXChipViewSkin.this.editor));
        }

        private void ensureVisible(Node node) {
            double d2 = JFXChipViewSkin.this.scrollPane.getContent().getBoundsInLocal().getHeight();
            double d3 = node.getBoundsInParent().getMaxY();
            JFXChipViewSkin.this.scrollPane.setVvalue(d3 / d2);
            if (((JFXChipView)JFXChipViewSkin.this.getSkinnable()).isFocused()) {
                node.requestFocus();
            }
        }

        protected void layoutChildren() {
            super.layoutChildren();
            this.updateEditorPosition();
        }

        protected double computePrefHeight(double d2) {
            JFXChipViewSkin.this.editor.setManaged(true);
            double d3 = super.computePrefHeight(d2);
            JFXChipViewSkin.this.editor.setManaged(false);
            return d3;
        }

        private VPos getRowVAlignmentInternal() {
            VPos vPos = this.getRowValignment();
            return vPos == null ? VPos.CENTER : vPos;
        }

        private HPos getColumnHAlignmentInternal() {
            HPos hPos = this.getColumnHalignment();
            return hPos == null ? HPos.LEFT : hPos;
        }

        public void updateEditorPosition() {
            Insets insets = this.getInsets();
            double d2 = this.getWidth();
            double d3 = this.getHeight();
            double d4 = insets.getTop();
            double d5 = insets.getLeft();
            double d6 = insets.getBottom();
            double d7 = insets.getRight();
            double d8 = d2 - d5 - d7;
            double d9 = d3 - d4 - d6;
            double d10 = d7 + this.initOffset;
            double d11 = JFXChipViewSkin.this.editor.snappedTopInset() + JFXChipViewSkin.this.editor.snappedBottomInset();
            List list = this.getManagedChildren();
            int n2 = list.size();
            if (n2 > 0) {
                Region region = (Region)list.get(n2 - 1);
                double d12 = region.getHeight() + region.getLayoutY();
                JFXChipViewSkin.this.availableWidth = d8 - region.getBoundsInParent().getMaxX();
                double d13 = JFXChipViewSkin.this.editor.getMinWidth();
                d13 = d13 < 0.0 ? 100.0 : d13;
                d13 = Math.max(d13, JFXChipViewSkin.this.requiredWidth);
                if (JFXChipViewSkin.this.availableWidth > JFXChipViewSkin.this.requiredWidth) {
                    JFXChipViewSkin.this.moveToNewLine = false;
                }
                if (JFXChipViewSkin.this.availableWidth < d13 || JFXChipViewSkin.this.moveToNewLine) {
                    this.layoutInArea((Node)JFXChipViewSkin.this.editor, d10, d12 + JFXChipViewSkin.this.root.getVgap(), d8 - this.initOffset, JFXChipViewSkin.this.editor.prefHeight(-1.0), 0.0, this.getColumnHAlignmentInternal(), VPos.TOP);
                    JFXChipViewSkin.this.editorOnNewLine = true;
                    this.ensureVisible((Node)JFXChipViewSkin.this.editor);
                } else {
                    this.layoutInArea((Node)JFXChipViewSkin.this.editor, region.getBoundsInParent().getMaxX() + JFXChipViewSkin.this.root.getHgap(), region.getLayoutY(), JFXChipViewSkin.this.availableWidth - JFXChipViewSkin.this.root.getHgap(), region.getHeight() + d11, 0.0, this.getColumnHAlignmentInternal(), this.getRowVAlignmentInternal());
                    JFXChipViewSkin.this.editorOnNewLine = false;
                }
            } else {
                this.layoutInArea((Node)JFXChipViewSkin.this.editor, d10, d4, d8 - this.initOffset, JFXChipViewSkin.this.editor.prefHeight(-1.0), 0.0, this.getColumnHAlignmentInternal(), VPos.TOP);
                JFXChipViewSkin.this.editorOnNewLine = true;
                this.ensureVisible((Node)JFXChipViewSkin.this.editor);
            }
        }
    }
}

