/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.controls.cells.editors.base;

import com.jfoenix.controls.cells.editors.base.EditorNodeBuilder;
import com.jfoenix.controls.cells.editors.base.GenericEditableTableCell;
import java.util.function.Consumer;
import javafx.scene.input.MouseEvent;

public class OnPressedEditableTableCell<S, T>
extends GenericEditableTableCell<S, T> {
    public OnPressedEditableTableCell() {
        this.init();
    }

    public OnPressedEditableTableCell(EditorNodeBuilder editorNodeBuilder) {
        super(editorNodeBuilder);
        this.init();
    }

    public OnPressedEditableTableCell(EditorNodeBuilder editorNodeBuilder, Consumer<Exception> consumer) {
        super(editorNodeBuilder, consumer);
        this.init();
    }

    private void init() {
        this.addEventFilter(MouseEvent.MOUSE_PRESSED, mouseEvent -> {
            OnPressedEditableTableCell onPressedEditableTableCell;
            if (this.getTableView().getEditingCell() != null && !this.isEditing() && (onPressedEditableTableCell = (OnPressedEditableTableCell)((Object)((Object)this.getTableView().getProperties().remove(OnPressedEditableTableCell.class)))) != null) {
                onPressedEditableTableCell.commitHelper(true);
            }
        });
        this.addEventFilter(MouseEvent.MOUSE_RELEASED, mouseEvent -> {
            if (!this.isEmpty() && this.isEditable() && !this.isEditing() && this.getTableColumn().isEditable()) {
                this.getTableView().edit(this.getIndex(), this.getTableColumn());
            }
        });
    }

    @Override
    public void startEdit() {
        super.startEdit();
        if (this.isEditing()) {
            this.getTableView().getProperties().put(OnPressedEditableTableCell.class, (Object)this);
        }
    }

    public void commitEdit(T t2) {
        super.commitEdit(t2);
        this.getTableView().getProperties().remove(OnPressedEditableTableCell.class);
    }

    @Override
    public void cancelEdit() {
        super.cancelEdit();
        this.getTableView().getProperties().remove(OnPressedEditableTableCell.class);
    }
}

