/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.controls;

import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.util.Duration;

public class JFXTogglePane
extends StackPane {
    private Timeline toggleAnimation = null;
    private ObjectProperty<Control> toggleNode = new SimpleObjectProperty();
    private ObjectProperty<Node> contentNode = new SimpleObjectProperty();
    private DoubleProperty scalingFactor = new SimpleDoubleProperty(2.4);

    public JFXTogglePane() {
        this.clipProperty().addListener((observableValue, node, node2) -> {
            if (node2 != null && this.getToggleNode() != null) {
                Control control = this.getToggleNode();
                node2.layoutXProperty().bind((ObservableValue)Bindings.createDoubleBinding(() -> JFXTogglePane.lambda$new$0((Region)control), (Observable[])new Observable[]{control.widthProperty(), control.layoutXProperty()}));
                node2.layoutYProperty().bind((ObservableValue)Bindings.createDoubleBinding(() -> JFXTogglePane.lambda$new$1((Region)control), (Observable[])new Observable[]{control.heightProperty(), control.layoutYProperty()}));
            }
        });
        this.widthProperty().addListener((observableValue, number, number2) -> this.updateToggleAnimation());
        this.heightProperty().addListener((observableValue, number, number2) -> this.updateToggleAnimation());
        this.toggleNode.addListener((observableValue2, control, control2) -> {
            if (control2 != null && this.getClip() != null) {
                this.getClip().layoutXProperty().unbind();
                this.getClip().layoutYProperty().unbind();
                this.getClip().layoutXProperty().bind((ObservableValue)Bindings.createDoubleBinding(() -> control2.getLayoutX() + control2.getWidth() / 2.0, (Observable[])new Observable[]{control2.widthProperty(), control2.layoutXProperty()}));
                this.getClip().layoutYProperty().bind((ObservableValue)Bindings.createDoubleBinding(() -> control2.getLayoutY() + control2.getHeight() / 2.0, (Observable[])new Observable[]{control2.heightProperty(), control2.layoutYProperty()}));
            }
            this.updateToggleAnimation();
            control2.widthProperty().addListener((observableValue, number, number2) -> this.updateToggleAnimation());
            control2.heightProperty().addListener((observableValue, number, number2) -> this.updateToggleAnimation());
            control2.setOnMouseClicked(mouseEvent -> this.togglePane());
        });
    }

    public void togglePane() {
        if (this.toggleAnimation == null) {
            this.updateToggleAnimation();
        }
        this.getClip().scaleXProperty().unbind();
        this.getClip().scaleYProperty().unbind();
        this.toggleAnimation.setRate(this.toggleAnimation.getRate() * -1.0);
        if (this.toggleAnimation.getCurrentTime().equals((Object)Duration.millis((double)0.0)) && this.toggleAnimation.getRate() == -1.0) {
            this.toggleAnimation.playFrom(Duration.millis((double)510.0));
        } else {
            this.toggleAnimation.play();
        }
    }

    private void updateToggleAnimation() {
        if (this.getContentNode() == null) {
            return;
        }
        double d2 = this.getWidth() / this.getClip().getLayoutBounds().getWidth();
        double d3 = this.getHeight() / this.getClip().getLayoutBounds().getHeight();
        double d4 = Math.max(d2, d3) * this.getScalingFactor();
        double d5 = this.toggleAnimation == null ? -1.0 : this.toggleAnimation.getRate();
        this.toggleAnimation = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)0.0), new KeyValue[]{new KeyValue((WritableValue)this.getClip().scaleXProperty(), (Object)1, Interpolator.EASE_BOTH)}), new KeyFrame(Duration.millis((double)0.0), new KeyValue[]{new KeyValue((WritableValue)this.getClip().scaleYProperty(), (Object)1, Interpolator.EASE_BOTH)}), new KeyFrame(Duration.millis((double)0.0), new KeyValue[]{new KeyValue((WritableValue)this.getContentNode().opacityProperty(), (Object)0, Interpolator.EASE_BOTH)}), new KeyFrame(Duration.millis((double)350.0), new KeyValue[]{new KeyValue((WritableValue)this.getClip().scaleXProperty(), (Object)d4, Interpolator.EASE_BOTH)}), new KeyFrame(Duration.millis((double)350.0), new KeyValue[]{new KeyValue((WritableValue)this.getClip().scaleYProperty(), (Object)d4, Interpolator.EASE_BOTH)}), new KeyFrame(Duration.millis((double)370.0), new KeyValue[]{new KeyValue((WritableValue)this.getContentNode().opacityProperty(), (Object)0, Interpolator.EASE_BOTH)}), new KeyFrame(Duration.millis((double)510.0), new KeyValue[]{new KeyValue((WritableValue)this.getContentNode().opacityProperty(), (Object)1, Interpolator.EASE_BOTH)})});
        this.toggleAnimation.setOnFinished(actionEvent -> {
            if (this.toggleAnimation.getRate() == 1.0) {
                this.getClip().scaleXProperty().bind((ObservableValue)Bindings.createDoubleBinding(() -> {
                    double d2 = this.getWidth() / this.getClip().getLayoutBounds().getWidth();
                    double d3 = this.getHeight() / this.getClip().getLayoutBounds().getHeight();
                    return Math.max(d2, d3) * this.getScalingFactor();
                }, (Observable[])new Observable[]{this.widthProperty(), this.heightProperty()}));
                this.getClip().scaleYProperty().bind((ObservableValue)Bindings.createDoubleBinding(() -> {
                    double d2 = this.getWidth() / this.getClip().getLayoutBounds().getWidth();
                    double d3 = this.getHeight() / this.getClip().getLayoutBounds().getHeight();
                    return Math.max(d2, d3) * this.getScalingFactor();
                }, (Observable[])new Observable[]{this.widthProperty(), this.heightProperty()}));
            }
        });
        this.toggleAnimation.setRate(d5);
    }

    public final ObjectProperty<Control> toggleNodeProperty() {
        return this.toggleNode;
    }

    public final Control getToggleNode() {
        return (Control)this.toggleNodeProperty().get();
    }

    public final void setToggleNode(Control control) {
        this.toggleNodeProperty().set((Object)control);
    }

    public final ObjectProperty<Node> contentNodeProperty() {
        return this.contentNode;
    }

    public final Node getContentNode() {
        return (Node)this.contentNodeProperty().get();
    }

    public final void setContentNode(Node node) {
        this.contentNodeProperty().set((Object)node);
        node.setOpacity(0.0);
    }

    public final DoubleProperty scalingFactorProperty() {
        return this.scalingFactor;
    }

    public final double getScalingFactor() {
        return this.scalingFactorProperty().get();
    }

    public final void setScalingFactor(double d2) {
        this.scalingFactorProperty().set(d2);
    }

    private static /* synthetic */ Double lambda$new$1(Region region) throws Exception {
        return region.getLayoutY() + region.getHeight() / 2.0;
    }

    private static /* synthetic */ Double lambda$new$0(Region region) throws Exception {
        return region.getLayoutX() + region.getWidth() / 2.0;
    }
}

