/*
 * Decompiled with CFR 0.152.
 */
package com.github.scribejava.core.services;

import com.github.scribejava.core.exceptions.OAuthSignatureException;
import com.github.scribejava.core.services.SignatureService;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;

public class RSASha1SignatureService
implements SignatureService {
    private static final String METHOD = "RSA-SHA1";
    private static final String RSA_SHA1 = "SHA1withRSA";
    private static final String UTF8 = "UTF-8";
    private final PrivateKey privateKey;

    public RSASha1SignatureService(PrivateKey privateKey) {
        this.privateKey = privateKey;
    }

    @Override
    public String getSignature(String string, String string2, String string3) {
        try {
            Signature signature = Signature.getInstance(RSA_SHA1);
            signature.initSign(this.privateKey);
            signature.update(string.getBytes(UTF8));
            return BASE_64_ENCODER.encodeToString(signature.sign());
        }
        catch (UnsupportedEncodingException | RuntimeException | InvalidKeyException | NoSuchAlgorithmException | SignatureException exception) {
            throw new OAuthSignatureException(string, exception);
        }
    }

    @Override
    public String getSignatureMethod() {
        return METHOD;
    }
}

